#!/bin/bash
###############################################################################
# (c) Copyright Hewlett-Packard Development Company, L.P., 2006
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of version 2 the GNU General Public License as
#   published by the Free Software Foundation.
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
###############################################################################
#
# PURPOSE:
# Test the ability to filter based on a filesystem watch, including
# for events generated by a hard link or symlink to the watched location.
# Test kernel handling for open() of an existing file both with and without the
# O_CREAT flag.

source filter_functions.bash || exit 2

# setup
watch=$tmp1

event_obj=$(get_event_obj $1)
[[ $event_obj != $watch ]] && prepend_cleanup "rm -f $event_obj"

auditctl -a exit,always -S open -F key=$watch -F path=$watch
prepend_cleanup "auditctl -d exit,always -S open -F key=$watch -F path=$watch"

# test open with O_CREAT|O_RDONLY; verify audit record
log_mark=$(stat -c %s $audit_log)
do_open $event_obj rdcr

augrok --seek=$log_mark type==SYSCALL key==$watch \
    || exit_fail "Expected record not found for open O_CREAT|O_RDONLY"

# test open with O_RDWR; verify audit record
log_mark=$(stat -c %s $audit_log)
do_open $event_obj rdwr

augrok --seek=$log_mark type==SYSCALL key==$watch \
    || exit_fail "Expected record not found for open O_RDWR"

exit_pass
