; C Library
;
; Copyright (C) 2025 Kestrel Institute (http://www.kestrel.edu)
; Copyright (C) 2025 Kestrel Technology LLC (http://kestreltechnology.com)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (www.alessandrocoglio.info)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "C")

(include-book "../representation/integer-operations")

(include-book "pointed-integers")
(include-book "arrays")
(include-book "conditional-expressions")
(include-book "let-designations")
(include-book "pointer-types")
(include-book "defstruct-doc")
(include-book "defstruct")
(include-book "defobject-doc")
(include-book "defobject")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defxdoc+ atc-shallow-embedding
  :parents (atc-implementation)
  :short "Shallow embedding of C in ACL2 for ATC."
  :long
  (xdoc::topstring
   (xdoc::p
    "We are in the process of moving this shallow embedding
     from the @('atc') subdirectory to the @('representation') subdirectory.
     See the documentation in @(see representation) for details.")
   (xdoc::p
    "The ACL2 representation of C constructs,
     which ATC recognizes and translates to C,
     constitutes a shallow embedding of C in ACL2.
     In contrast, the "
    (xdoc::seetopic "abstract-syntax" "abstract syntax")
    ", "
    (xdoc::seetopic "static-semantics" "static semantics")
    ", and "
    (xdoc::seetopic "dynamic-semantics" "dynamic semantics")
    " constitute a deep embedding of C in ACL2.
     The two are separate but related of course,
     via the theorems generated by ATC,
     which are in fact more general than ATC in a way,
     because they are applicable to code lifting besides code generation.")
   (xdoc::p
    "The file where this XDOC topic appears
     can be included by tools, such as APT transformations,
     that need to operate on the ACL2 representations of the C constructs,
     without having to include all of ATC."))
  :order-subtopics t)
