/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingBuildInfo;
import android.databinding.annotationprocessor.BuildInfoUtil;
import android.databinding.annotationprocessor.ProcessBindable;
import android.databinding.annotationprocessor.ProcessExpressions;
import android.databinding.annotationprocessor.ProcessMethodAdapters;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.writer.AnnotationJavaFileWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"android.databinding.BindingAdapter", "android.databinding.Untaggable", "android.databinding.BindingMethods", "android.databinding.BindingConversion", "android.databinding.BindingBuildInfo"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ProcessDataBinding
extends AbstractProcessor {
    private List<ProcessingStep> mProcessingSteps;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        BindingBuildInfo buildInfo;
        if (this.mProcessingSteps == null) {
            this.initProcessingSteps();
        }
        if ((buildInfo = BuildInfoUtil.load(roundEnv)) == null) {
            return false;
        }
        boolean done = true;
        for (ProcessingStep step : this.mProcessingSteps) {
            done = step.runStep(roundEnv, this.processingEnv, buildInfo) && done;
        }
        if (roundEnv.processingOver()) {
            for (ProcessingStep step : this.mProcessingSteps) {
                step.onProcessingOver(roundEnv, this.processingEnv, buildInfo);
            }
        }
        return done;
    }

    private void initProcessingSteps() {
        ProcessBindable processBindable = new ProcessBindable();
        this.mProcessingSteps = Arrays.asList(new ProcessMethodAdapters(), new ProcessExpressions(processBindable), processBindable);
        AnnotationJavaFileWriter javaFileWriter = new AnnotationJavaFileWriter(this.processingEnv);
        for (ProcessingStep step : this.mProcessingSteps) {
            step.mJavaFileWriter = javaFileWriter;
        }
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ModelAnalyzer.setProcessingEnvironment(processingEnv);
    }

    public static abstract class ProcessingStep {
        private boolean mDone;
        private JavaFileWriter mJavaFileWriter;

        protected JavaFileWriter getWriter() {
            return this.mJavaFileWriter;
        }

        private boolean runStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
            if (this.mDone) {
                return true;
            }
            this.mDone = this.onHandleStep(roundEnvironment, processingEnvironment, buildInfo);
            return this.mDone;
        }

        public abstract boolean onHandleStep(RoundEnvironment var1, ProcessingEnvironment var2, BindingBuildInfo var3);

        public abstract void onProcessingOver(RoundEnvironment var1, ProcessingEnvironment var2, BindingBuildInfo var3);
    }
}

