#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("places marks to select text to copy to the clipboard")

    def run(self):
        if not self.env["runtime"]["CursorManager"].is_review_mode():
            self.env["runtime"]["OutputManager"].present_text(
                _("no review cursor"), interrupt=True
            )
            return

        # If in table mode, set header row instead of regular mark
        if self.env["runtime"]["TableManager"].is_table_mode():
            success = self.env["runtime"]["TableManager"].set_header_row_from_cursor()
            if success:
                self.env["runtime"]["OutputManager"].present_text(
                    _("header row set"), sound_icon="PlaceStartMark", interrupt=True
                )
            else:
                self.env["runtime"]["OutputManager"].present_text(
                    _("could not set header row"), interrupt=True
                )
            return

        # Regular mark functionality
        curr_mark = self.env["runtime"]["CursorManager"].set_mark()
        if curr_mark == 1:
            self.env["runtime"]["OutputManager"].present_text(
                _("set mark"), sound_icon="PlaceStartMark", interrupt=True
            )
        elif curr_mark == 2:
            self.env["runtime"]["OutputManager"].present_text(
                _("set mark"), sound_icon="PlaceEndMark", interrupt=True
            )

    def set_callback(self, callback):
        pass
