package Business::EDI::CodeList::PriceSpecificationCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {5387;}
my $usage       = 'B';

# 5387  Price specification code                                [B]
# Desc: Code identifying pricing specification.
# Repr: an..3

my %code_hash = (
'AAA' => [ 'Reference price',
    'Code identifying a reference price.' ],
'AAB' => [ 'Price includes tax',
    'Code specifying that the price is inclusive of tax.' ],
'AAC' => [ 'Buyer suggested retail price',
    'The suggested retail price as suggested or determined by the party purchasing the goods.' ],
'AAD' => [ 'Ocean charges rate',
    'The charges imposed by the ocean transportation industry above and beyond the basic freight.' ],
'AAE' => [ 'Not subject to fluctuation',
    'Not subject to escalation or adjustment.' ],
'AAF' => [ 'Subject to escalation',
    'Subject to increase or development by successive stages.' ],
'AAG' => [ 'Subject to price adjustment',
    'Code specifying that the price is subject to adjustment.' ],
'AAH' => [ 'Subject to escalation and price adjustment',
    'Subject to increase or development by successive stages and price adjustment.' ],
'AAI' => [ 'Fluctuation conditions not specified',
    'Code specifying that the fluctuation conditions are not identified.' ],
'AAJ' => [ 'All in price',
    'Firm price for specified work.' ],
'AAK' => [ 'New price',
    'A price valid from an effective date/time/period.' ],
'AAL' => [ 'Old price',
    'A price valid prior to an effective date/time/period of a new price.' ],
'AAM' => [ 'Per week',
    'To indicate that the given price applies per week.' ],
'AAN' => [ 'Price on application',
    'Price can be obtained on request from seller.' ],
'AAO' => [ 'Unpacked price',
    'The price given is the price of the item without packaging.' ],
'AAP' => [ 'Trade price',
    'Discount price available to all customers except the retail customer.' ],
'AAQ' => [ 'Firm price',
    'Price which will remain unchanged for a given time period.' ],
'AAR' => [ 'Material share of item price',
    'The per unit cost of referenced material based on a given quotation for that material.' ],
'AAS' => [ 'Labour share of item price',
    'The labour component of the per-unit item price.' ],
'AAT' => [ 'Transport share of item price',
    'The transport component of the per-unit item price.' ],
'AAU' => [ 'Packing share of item price',
    'The packing component of the per-unit item price.' ],
'AAV' => [ 'Tooling share of item price',
    'The tooling component of the per-unit item price.' ],
'AAW' => [ 'Temporary vehicle charge',
    'The component of a price charged for providing a temporary vehicle.' ],
'AAX' => [ 'Price component due to interest',
    'This is the component of the price which is charged due to interest.' ],
'AAY' => [ 'Price component due to management services',
    'This is the component of the price which is charged due to management services rendered.' ],
'AAZ' => [ 'Price component due to maintenance',
    'This is the component of the price which is charged due to maintenance.' ],
'ABA' => [ 'Individual buyer price',
    'A price which is available to an individual buyer as opposed to an institutional buyer.' ],
'ABB' => [ 'Group buying price',
    'A price which is available to a buying group.' ],
'ABC' => [ 'Group member buying price',
    'A special price given to a member of a buying group.' ],
'ABD' => [ 'Pre-payment price',
    'A special price if pre-payment is made for the article ordered.' ],
'ABE' => [ 'Retail price - excluding taxes',
    'Retail price not including any applicable taxes.' ],
'ABF' => [ 'Suggested retail price - excluding taxes',
    'Suggested retail price not including any applicable taxes.' ],
'ABG' => [ 'Agreed minimum price',
    'The minimum price agreed between trading partners.' ],
'ABH' => [ 'Statutory minimum retail price',
    'The legal minimum retail price.' ],
'ABI' => [ 'Cost reimbursement price',
    'A code to indicate that the price represents the reimbursement of the actual costs incurred.' ],
'ABJ' => [ 'Market price',
    'A code to indicate that the given price is applicable under normal competitive conditions.' ],
'ABK' => [ 'Open tender price',
    'A code to indicate that the price mentioned has been submitted in the context of an open tender.' ],
'ABL' => [ 'Base price',
    'The base price of a product or service.' ],
'ABM' => [ 'Base price difference',
    'The difference in price against a base price.' ],
'ABN' => [ 'Adjustable price prior to acceptance',
    'A price which can be adjusted due to economic conditions between the date of offer and the date of acceptance.' ],
'ABO' => [ 'Revisable price after acceptance',
    'A price which can be revised due to economic conditions between the date of acceptance of the order and the date of delivery.' ],
'ABP' => [ 'Provisional ceiling price',
    'A provisional price which cannot be exceeded.' ],
'ABQ' => [ 'Adjustable provisional ceiling price',
    'A provisional price which cannot be exceeded but which can be adjusted due to economic conditions between the date of offer and the date of acceptance.' ],
'ABR' => [ 'Revisable provisional ceiling price',
    'A provisional price which cannot be exceeded but is revisable due to economic conditions between the date of acceptance of the order through to the date of delivery.' ],
'ABS' => [ 'Revisable provisional price',
    'A provisional price which is revisable due to economic conditions between the date of acceptance of the order and the date of delivery.' ],
'ABT' => [ 'Adjustable provisional price',
    'A provisional price which is adjustable due to economic conditions between the date of offer and the date of acceptance.' ],
'ABU' => [ 'Area price',
    'Price connected to a geographical area.' ],
'ABV' => [ 'Area system price',
    'A basis price applied to a geographic area.' ],
'ABW' => [ 'Special balance regulation price',
    'The price applicable to the power generated as a result of a special balance regulation.' ],
'ABX' => [ 'Balance regulation price',
    'The price applicable to the power generated as a result of a balance regulation.' ],
'ABY' => [ 'Upward balance regulation price',
    'The price applicable to the power generated as a result of an upward balance regulation.' ],
'ABZ' => [ 'Downward balance regulation price',
    'The price applicable to the power generated as a result of a downward balance regulation.' ],
'AI' => [ 'Active ingredient',
    'Code specifying that price is based on the active ingredient.' ],
'ALT' => [ 'Alternate price',
    'A substitute cost.' ],
'AP' => [ 'Advice price',
    'Code specifying an advice price.' ],
'BR' => [ 'Broker price',
    'Code specifying a broker price.' ],
'CAT' => [ 'Catalogue price',
    'Price per unit of quantity of a product as specified in a catalogue.' ],
'CDV' => [ 'Current domestic value',
    "The present worth of a thing which comes from one's homeland, in terms of money or goods." ],
'CON' => [ 'Contract price',
    'Price per unit of quantity of a product/service as agreed in a contract between parties.' ],
'CP' => [ 'Current price',
    'Price at time of transaction, but subject to future change.' ],
'CU' => [ 'Consumer unit',
    'Code specifying that the price is based on consumer unit.' ],
'CUP' => [ 'Confirmed unit price',
    'The value of a single item that proves to be correct.' ],
'CUS' => [ 'Declared customs unit value',
    'A clearly known duty on a single item which is imposed by law.' ],
'DAP' => [ 'Dealer adjusted price',
    'The necessary or desirable changes that the sales agency makes with respect to the value of the product.' ],
'DIS' => [ 'Distributor price',
    'The cost associated with the agency that markets goods.' ],
'DPR' => [ 'Discount price',
    'A reduction from the usual list value.' ],
'DR' => [ 'Dealer price',
    'Code specifying a dealer price.' ],
'DSC' => [ 'Discount amount allowed',
    'A certain price up to which one is able to make reductions from the usual list value.' ],
'EC' => [ 'ECSC price',
    'Price registered at European Commission Steel and Carbon office (DG III).' ],
'ES' => [ 'Estimated price',
    'Code specifying an estimated price.' ],
'EUP' => [ 'Expected unit price',
    'The anticipated value of a single item.' ],
'FCR' => [ 'Freight/charge rate',
    'The price that is either a freight rate or a rate on which freight charges are calculated.' ],
'GRP' => [ 'Gross unit price',
    'Unit price to which allowances and charges apply.' ],
'INV' => [ 'Invoice price',
    'Price per unit of quantity of a product as specified on an invoice.' ],
'LBL' => [ 'Labelling price',
    "Retail price of the buyer that should be printed by the producer on the article's label. The labelling price is not necessary the effective retail price." ],
'MAX' => [ 'Maximum order quantity price',
    'The greatest amount of goods or services which one can buy to receive a certain value.' ],
'MIN' => [ 'Minimum order quantity price',
    'The least amount of goods or services that one can buy to receive a certain value.' ],
'MNR' => [ 'Minimum release quantity price',
    'The least amount of an order one can place in order to receive a certain value.' ],
'MSR' => [ "Manufacturer's suggested retail",
    'Price that reflects "Sales to other manufacturers" or "Sales for resale".' ],
'MXR' => [ 'Maximum release quantity price',
    'The greatest amount of an order that one can place in order to receive a certain value.' ],
'NE' => [ 'Not-to-exceed price',
    'Code specifying a price that cannot be increased.' ],
'NQT' => [ 'No quote',
    'No price available.' ],
'NTP' => [ 'Net unit price',
    'Unit price to which no allowances and charges apply.' ],
'NW' => [ 'Net weight',
    'Code specifying a net weight price.' ],
'OFR' => [ 'Ocean freight rate',
    'The price per pricing unit of ocean transportation services for moving cargo from one location to another.' ],
'PAQ' => [ 'Price break quantity(s)',
    'Numerical amounts of goods or services which are associated with different sums of money. As the amount goes up, the price per individual item decreases.' ],
'PBQ' => [ 'Unit price beginning quantity',
    'The starting amount at which you can place a value on a single item.' ],
'PPD' => [ 'Prepaid freight charges',
    'The cost of shipping is paid before the goods are shipped.' ],
'PPR' => [ 'Provisional price',
    'Price per unit of quantity of a product as provisionally agreed.' ],
'PRO' => [ "Producer's price",
    'The value that the maker of a good places on an item.' ],
'PRP' => [ 'Promotional price',
    'The value that is placed on an item that is being developed. The idea is to sell this product for less than one normally would, and make up for it by selling a larger quantity.' ],
'PW' => [ 'Gross weight',
    'Code specifying a gross weight price.' ],
'QTE' => [ 'Quote price',
    'Price per unit of quantity of a product as specified in a quote.' ],
'RES' => [ 'Resale price',
    'Price per unit of quantity of a product to be used for resale.' ],
'RTP' => [ 'Retail price',
    'Price per unit of quantity of a product to be used for retail.' ],
'SHD' => [ 'Ship and debit',
    'To transport goods and be owed money by the customer for the services performed.' ],
'SRP' => [ 'Suggested retail price',
    'Price per unit of quantity of a product suggested for retail.' ],
'SW' => [ 'Gross weight without wooden pallets',
    'Used in steel industry.' ],
'TB' => [ 'To be negotiated',
    'Code specifying that the price has to be negotiated.' ],
'TRF' => [ 'Transfer',
    'To carry or remove from one place, situation, or person to another.' ],
'TU' => [ 'Traded unit',
    'Code specifying a traded unit price.' ],
'TW' => [ 'Theoretical weight',
    'Code specifying a price based on a theoretical weight.' ],
'WH' => [ 'Wholesale price',
    'Code specifying a wholesale price.' ],
);
sub get_codes { return \%code_hash; }

1;
