/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui;

import gr.zeus.ui.JMessage;
import gr.zeus.util.CurrentDateHelper;
import gr.zeus.util.GUIUtils;
import gr.zeus.util.IOHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class JConsolePane
extends JPanel {
    private static JConsolePane s_consolePane = null;
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Color FG_COLOR = Color.WHITE;
    private static final Color BG_COLOR;
    private static final Color SLT_COLOR;
    private static final Color SL_COLOR;
    private static final Font TEXT_FONT;
    private final PrintStream m_stdoutPS = new PrintStream(new JTextAreaOutStream(new ByteArrayOutputStream()));
    private final PrintStream m_stderrPS = new PrintStream(new JTextAreaOutStream(new ByteArrayOutputStream()));
    private final JFileChooser m_fileChooser = new JFileChooser();
    private String m_confimTitle = ResourceBundle.getBundle("gr/zeus/res/jconsole").getString("confimTitle");
    private String m_confimMessage = ResourceBundle.getBundle("gr/zeus/res/jconsole").getString("confimMessage");
    private String m_messagesFilename = "messages.txt";
    private String m_traceFilename = "trace.log";
    private boolean m_appendFirstTime = false;
    private boolean m_autoSave = false;
    private int m_maxChars = -1;
    private int m_numFlushes = 0;
    private static final int BUF_SIZE = 4096;
    private final StringBuilder m_consoleText = new StringBuilder(4096);
    private JButton btn_clear;
    private JButton btn_close;
    private JButton btn_save;
    private JPanel button_panel;
    private JTextArea ta_messages;

    private JConsolePane() throws InterruptedException, InvocationTargetException {
        GUIUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.initComponents();
                JConsolePane.this.ta_messages.setForeground(FG_COLOR);
                JConsolePane.this.ta_messages.setBackground(BG_COLOR);
                JConsolePane.this.ta_messages.setSelectedTextColor(SLT_COLOR);
                JConsolePane.this.ta_messages.setSelectionColor(SL_COLOR);
                JConsolePane.this.ta_messages.setFont(TEXT_FONT);
                JConsolePane.this.m_fileChooser.setDialogType(1);
                JConsolePane.this.m_fileChooser.setFileSelectionMode(0);
                JConsolePane.this.m_fileChooser.setMultiSelectionEnabled(false);
                JConsolePane.this.m_fileChooser.setAcceptAllFileFilterUsed(true);
                JConsolePane.this.m_fileChooser.setControlButtonsAreShown(true);
            }
        });
        this.hideConsole();
    }

    public static synchronized JConsolePane getConsolePane() {
        if (s_consolePane == null) {
            try {
                s_consolePane = new JConsolePane();
            }
            catch (Exception ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        return s_consolePane;
    }

    public synchronized void startConsole() {
        System.setOut(this.m_stdoutPS);
        System.setErr(this.m_stderrPS);
    }

    public synchronized void stopConsole() {
        System.setOut(STDOUT);
        System.setErr(STDERR);
    }

    public void showConsole() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.setVisible(true);
            }
        });
    }

    public void hideConsole() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.setVisible(false);
            }
        });
    }

    public void showControlButtons() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.button_panel.setVisible(true);
            }
        });
    }

    public void hideControlButtons() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.button_panel.setVisible(false);
            }
        });
    }

    public synchronized void clearBufferMessages() {
        this.m_consoleText.delete(0, this.m_consoleText.length());
        this.m_consoleText.ensureCapacity(4096);
    }

    public void clearScreenMessages() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.ta_messages.setText("");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpConsole(String filename, boolean append) throws IOException {
        String txt = this.createTimestamp();
        JConsolePane jConsolePane = this;
        synchronized (jConsolePane) {
            txt = txt + this.m_consoleText.toString();
        }
        IOHelper.saveTxtFile(filename, txt, append);
    }

    public void destroyConsole() {
        this.stopConsole();
        this.hideConsole();
        this.clearScreenMessages();
        this.clearBufferMessages();
    }

    public void updateLNF() {
        final JConsolePane THIS = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.updateComponentTreeUI(THIS);
                SwingUtilities.updateComponentTreeUI(JConsolePane.this.m_fileChooser);
            }
        });
    }

    public String getConfimTitle() {
        return this.m_confimTitle;
    }

    public void setConfimTitle(String s) {
        this.m_confimTitle = s;
    }

    public String getConfimMessage() {
        return this.m_confimMessage;
    }

    public void setConfimMessage(String s) {
        this.m_confimMessage = s;
    }

    public String getMessagesFilename() {
        return this.m_messagesFilename;
    }

    public void setMessagesFilename(String s) {
        this.m_messagesFilename = s;
    }

    public String getTraceFilename() {
        return this.m_traceFilename;
    }

    public void setTraceFilename(String s) {
        this.m_traceFilename = s;
    }

    public boolean getAppendFirstTime() {
        return this.m_appendFirstTime;
    }

    public void setAppendFirstTime(boolean b) {
        this.m_appendFirstTime = b;
    }

    public boolean getAutoSave() {
        return this.m_autoSave;
    }

    public void setAutoSave(boolean b) {
        this.m_autoSave = b;
    }

    public int getMaxChars() {
        return this.m_maxChars;
    }

    public void setMaxChars(int i) {
        this.m_maxChars = i;
    }

    public Color getForegroundColor() {
        return this.ta_messages.getForeground();
    }

    public void setForegroundColor(final Color c) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.ta_messages.setForeground(c);
            }
        });
    }

    public Color getBackgroundColor() {
        return this.ta_messages.getBackground();
    }

    public void setBackgroundColor(final Color c) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.ta_messages.setBackground(c);
            }
        });
    }

    public Color getSelectedTextColor() {
        return this.ta_messages.getSelectedTextColor();
    }

    public void setSelectedTextColor(final Color c) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.ta_messages.setSelectedTextColor(c);
            }
        });
    }

    public Color getSelectionColor() {
        return this.ta_messages.getSelectionColor();
    }

    public void setSelectionColor(final Color c) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.ta_messages.setSelectionColor(c);
            }
        });
    }

    public String getClearButtonText() {
        return this.btn_clear.getText();
    }

    public void setClearButtonText(final String s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.btn_clear.setText(s);
            }
        });
    }

    public String getSaveButtonText() {
        return this.btn_save.getText();
    }

    public void setSaveButtonText(final String s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.btn_save.setText(s);
            }
        });
    }

    public String getCloseButtonText() {
        return this.btn_close.getText();
    }

    public void setCloseButtonText(final String s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.btn_close.setText(s);
            }
        });
    }

    public String getFilechooserTitle() {
        return this.m_fileChooser.getDialogTitle();
    }

    public void setFilechooserTitle(final String s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.m_fileChooser.setDialogTitle(s);
            }
        });
    }

    public String getFilechooserApproveButtonText() {
        return this.m_fileChooser.getApproveButtonText();
    }

    public void setFilechooserApproveButtonText(final String s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.m_fileChooser.setApproveButtonText(s);
            }
        });
    }

    public Font getTextFont() {
        return this.ta_messages.getFont();
    }

    public void setTextFont(final Font f) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JConsolePane.this.ta_messages.setFont(f);
            }
        });
    }

    private void initComponents() {
        this.button_panel = new JPanel();
        this.btn_clear = new JButton();
        this.btn_save = new JButton();
        this.btn_close = new JButton();
        JScrollPane text_scrollpane = new JScrollPane();
        this.ta_messages = new JTextArea();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.button_panel.setPreferredSize(new Dimension(150, 33));
        this.button_panel.setLayout(new FlowLayout(2));
        ResourceBundle bundle = ResourceBundle.getBundle("gr/zeus/res/jconsole");
        this.btn_clear.setText(bundle.getString("clearMsg"));
        this.btn_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePane.this.btn_clearActionPerformed(evt);
            }
        });
        this.button_panel.add(this.btn_clear);
        this.btn_save.setText(bundle.getString("saveMsg"));
        this.btn_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePane.this.btn_saveActionPerformed(evt);
            }
        });
        this.button_panel.add(this.btn_save);
        this.btn_close.setText(bundle.getString("closeMsg"));
        this.btn_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePane.this.btn_closeActionPerformed(evt);
            }
        });
        this.button_panel.add(this.btn_close);
        this.add((Component)this.button_panel, "South");
        text_scrollpane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ta_messages.setColumns(40);
        this.ta_messages.setEditable(false);
        this.ta_messages.setRows(20);
        text_scrollpane.setViewportView(this.ta_messages);
        this.add((Component)text_scrollpane, "Center");
    }

    private void btn_closeActionPerformed(ActionEvent evt) {
        this.do_btn_close();
    }

    private void btn_saveActionPerformed(ActionEvent evt) {
        this.do_btn_save();
    }

    private void btn_clearActionPerformed(ActionEvent evt) {
        this.do_btn_clear();
    }

    private void do_btn_close() {
        this.hideConsole();
    }

    private void do_btn_clear() {
        this.clearScreenMessages();
    }

    private void do_btn_save() {
        this.m_fileChooser.setSelectedFile(new File(this.m_messagesFilename));
        int returnVal = this.m_fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            int res;
            File f = this.m_fileChooser.getSelectedFile();
            if (f.exists() && (res = JOptionPane.showConfirmDialog(this, this.m_confimMessage, this.m_confimTitle, 0, 3)) != 0) {
                return;
            }
            try {
                IOHelper.saveTxtFile(f, this.ta_messages.getText(), false);
            }
            catch (IOException ex) {
                String msg = ResourceBundle.getBundle("gr/zeus/res/jconsole").getString("saveErrorMsg");
                System.err.println(msg + " " + ex.getMessage());
                JMessage.showErrorMessage(null, msg, ex);
            }
        }
    }

    private String createTimestamp() {
        String timestamp = ResourceBundle.getBundle("gr/zeus/res/jconsole").getString("timestampMessage") + " " + String.valueOf(CurrentDateHelper.getCurrentDay()) + "/" + String.valueOf(CurrentDateHelper.getCurrentMonth()) + "/" + String.valueOf(CurrentDateHelper.getCurrentYear()) + " " + String.valueOf(CurrentDateHelper.getCurrentHour()) + ":" + String.valueOf(CurrentDateHelper.getCurrentMinutes()) + ":" + String.valueOf(CurrentDateHelper.getCurrentSeconds() + "\r\n\r\n");
        return timestamp;
    }

    static {
        SLT_COLOR = BG_COLOR = Color.BLACK;
        SL_COLOR = FG_COLOR;
        TEXT_FONT = new Font("Courier", 0, 12);
    }

    private final class JTextAreaOutStream
    extends FilterOutputStream {
        public JTextAreaOutStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            String s = new String(b);
            JConsolePane.this.m_consoleText.append(s);
            this.appendMessage(s);
            this.flushTextArea();
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            String s = new String(b, off, len);
            JConsolePane.this.m_consoleText.append(s);
            this.appendMessage(s);
            this.flushTextArea();
        }

        private void appendMessage(final String s) throws IOException {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JConsolePane.this.ta_messages.append(s);
                }
            });
            if (JConsolePane.this.m_autoSave) {
                boolean append = true;
                if (JConsolePane.this.m_numFlushes == 0 && !JConsolePane.this.m_appendFirstTime) {
                    append = false;
                }
                IOHelper.saveTxtFile(JConsolePane.this.m_traceFilename, s, append);
                JConsolePane.this.m_numFlushes++;
            }
        }

        private void flushTextArea() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int len = JConsolePane.this.ta_messages.getText().length();
                    JConsolePane.this.ta_messages.setCaretPosition(len);
                    if (JConsolePane.this.m_maxChars > 0 && len > JConsolePane.this.m_maxChars) {
                        JConsolePane.this.ta_messages.setText("");
                    }
                }
            });
        }
    }
}

