require 'rails_helper'

RSpec.describe Kiwi::Preference, type: :model do
  let(:preference) { build(:kiwi_preference) }

  describe '#containerconfig_xml' do
    let(:expected_xml) do
      <<-XML.strip_heredoc
  <containerconfig name="my_container" type_containerconfig_tag="latest"/>
      XML
    end

    subject { preference.containerconfig_xml }

    it { expect(subject).to eq(expected_xml) }
  end
end
