/*
 * Copyright (c) 2015-2021 The strace developers.
 * All rights reserved.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#define HANDLER(syscall) &OsSyscallExceptionHandler::syscall

[0] = { 2, HANDLER(syscall_default_handler), "io_setup" },
    [1] = { 1, HANDLER(syscall_default_handler), "io_destroy" },
    [2] = { 3, HANDLER(syscall_default_handler), "io_submit" },
    [3] = { 3, HANDLER(syscall_default_handler), "io_cancel" },
    [4] = { 5, HANDLER(syscall_default_handler), "io_getevents" },
    [5] = { 5, HANDLER(syscall_default_handler), "setxattr" },
    [6] = { 5, HANDLER(syscall_default_handler), "lsetxattr" },
    [7] = { 5, HANDLER(syscall_default_handler), "fsetxattr" },
    [8] = { 4, HANDLER(syscall_default_handler), "getxattr" },
    [9] = { 4, HANDLER(syscall_default_handler), "lgetxattr" },
    [10] = { 4, HANDLER(syscall_default_handler), "fgetxattr" },
    [11] = { 3, HANDLER(syscall_default_handler), "listxattr" },
    [12] = { 3, HANDLER(syscall_default_handler), "llistxattr" },
    [13] = { 3, HANDLER(syscall_default_handler), "flistxattr" },
    [14] = { 2, HANDLER(syscall_default_handler), "removexattr" },
    [15] = { 2, HANDLER(syscall_default_handler), "lremovexattr" },
    [16] = { 2, HANDLER(syscall_default_handler), "fremovexattr" },
    [17] = { 2, HANDLER(syscall_default_handler), "getcwd" },
    [18] = { 3, HANDLER(syscall_default_handler), "lookup_dcookie" },
    [19] = { 2, HANDLER(syscall_default_handler), "eventfd2" },
    [20] = { 1, HANDLER(syscall_default_handler), "epoll_create1" },
    [21] = { 4, HANDLER(syscall_default_handler), "epoll_ctl" },
    [22] = { 6, HANDLER(syscall_default_handler), "epoll_pwait" },
    [23] = { 1, HANDLER(syscall_default_handler), "dup" },
    [24] = { 3, HANDLER(syscall_default_handler), "dup3" },
    [25] = { 3, HANDLER(syscall_default_handler), "fcntl" },
    [26] = { 1, HANDLER(syscall_default_handler), "inotify_init1" },
    [27] = { 3, HANDLER(syscall_default_handler), "inotify_add_watch" },
    [28] = { 2, HANDLER(syscall_default_handler), "inotify_rm_watch" },
    [29] = { 3, HANDLER(syscall_default_handler), "ioctl" },
    [30] = { 3, HANDLER(syscall_default_handler), "ioprio_set" },
    [31] = { 2, HANDLER(syscall_default_handler), "ioprio_get" },
    [32] = { 2, HANDLER(syscall_default_handler), "flock" },
    [33] = { 4, HANDLER(syscall_default_handler), "mknodat" },
    [34] = { 3, HANDLER(syscall_default_handler), "mkdirat" },
    [35] = { 3, HANDLER(syscall_default_handler), "unlinkat" },
    [36] = { 3, HANDLER(syscall_default_handler), "symlinkat" },
    [37] = { 5, HANDLER(syscall_default_handler), "linkat" },
    [38] = { 4, HANDLER(syscall_default_handler), "renameat" },
    [39] = { 2, HANDLER(syscall_default_handler), "umount2" },
    [40] = { 5, HANDLER(syscall_default_handler), "mount" },
    [41] = { 2, HANDLER(syscall_default_handler), "pivot_root" },
    [42] = { 3, HANDLER(syscall_default_handler), "nfsservctl" },
    [43] = { 2, HANDLER(syscall_default_handler), "statfs" },
    [44] = { 2, HANDLER(syscall_default_handler), "fstatfs" },
    [45] = { 2, HANDLER(syscall_default_handler), "truncate" },
    [46] = { 2, HANDLER(do_sys_ftruncate), "ftruncate" },
    [47] = { 4, HANDLER(syscall_default_handler), "fallocate" },
    [48] = { 3, HANDLER(syscall_default_handler), "faccessat" },
    [49] = { 1, HANDLER(syscall_default_handler), "chdir" },
    [50] = { 1, HANDLER(syscall_default_handler), "fchdir" },
    [51] = { 1, HANDLER(syscall_default_handler), "chroot" },
    [52] = { 2, HANDLER(syscall_default_handler), "fchmod" },
    [53] = { 3, HANDLER(syscall_default_handler), "fchmodat" },
    [54] = { 5, HANDLER(syscall_default_handler), "fchownat" },
    [55] = { 3, HANDLER(syscall_default_handler), "fchown" },
    [56] = { 4, HANDLER(do_sys_openat), "openat" }, [57] = { 1, HANDLER(do_sys_close), "close" },
    [58] = { 0, HANDLER(syscall_default_handler), "vhangup" },
    [59] = { 2, HANDLER(syscall_default_handler), "pipe2" },
    [60] = { 4, HANDLER(syscall_default_handler), "quotactl" },
    [61] = { 3, HANDLER(syscall_default_handler), "getdents64" },
    [62] = { 3, HANDLER(syscall_default_handler), "lseek" },
    [63] = { 3, HANDLER(do_sys_read), "read" }, [64] = { 3, HANDLER(do_sys_write), "write" },
    [65] = { 3, HANDLER(do_sys_readv), "readv" }, [66] = { 3, HANDLER(do_sys_writev), "writev" },
    [67] = { 4, HANDLER(syscall_default_handler), "pread64" },
    [68] = { 4, HANDLER(syscall_default_handler), "pwrite64" },
    [69] = { 4, HANDLER(syscall_default_handler), "preadv" },
    [70] = { 4, HANDLER(syscall_default_handler), "pwritev" },
    [71] = { 4, HANDLER(syscall_default_handler), "sendfile" },
    [72] = { 6, HANDLER(syscall_default_handler), "pselect6" },
    [73] = { 5, HANDLER(syscall_default_handler), "ppoll" },
    [74] = { 4, HANDLER(syscall_default_handler), "signalfd4" },
    [75] = { 4, HANDLER(syscall_default_handler), "vmsplice" },
    [76] = { 6, HANDLER(syscall_default_handler), "splice" },
    [77] = { 4, HANDLER(syscall_default_handler), "tee" },
    [78] = { 4, HANDLER(syscall_default_handler), "readlinkat" },
    [79] = { 4, HANDLER(syscall_default_handler), "newfstatat" },
    [80] = { 2, HANDLER(syscall_default_handler), "fstat" },
    [81] = { 0, HANDLER(syscall_default_handler), "sync" },
    [82] = { 1, HANDLER(syscall_default_handler), "fsync" },
    [83] = { 1, HANDLER(syscall_default_handler), "fdatasync" },
    [84] = { 4, HANDLER(syscall_default_handler), "sync_file_range" },
    [85] = { 2, HANDLER(syscall_default_handler), "timerfd_create" },
    [86] = { 4, HANDLER(syscall_default_handler), "timerfd_settime" },
    [87] = { 2, HANDLER(syscall_default_handler), "timerfd_gettime" },
    [88] = { 4, HANDLER(syscall_default_handler), "utimensat" },
    [89] = { 1, HANDLER(syscall_default_handler), "acct" },
    [90] = { 2, HANDLER(syscall_default_handler), "capget" },
    [91] = { 2, HANDLER(syscall_default_handler), "capset" },
    [92] = { 1, HANDLER(syscall_default_handler), "personality" },
    [93] = { 1, HANDLER(do_sys_exit), "exit" },
    [94] = { 1, HANDLER(syscall_default_handler), "exit_group" },
    [95] = { 5, HANDLER(syscall_default_handler), "waitid" },
    [96] = { 1, HANDLER(syscall_default_handler), "set_tid_address" },
    [97] = { 1, HANDLER(syscall_default_handler), "unshare" },
    [98] = { 6, HANDLER(syscall_default_handler), "futex" },
    [99] = { 2, HANDLER(syscall_default_handler), "set_robust_list" },
    [100] = { 3, HANDLER(syscall_default_handler), "get_robust_list" },
    [101] = { 2, HANDLER(syscall_default_handler), "nanosleep" },
    [102] = { 2, HANDLER(syscall_default_handler), "getitimer" },
    [103] = { 3, HANDLER(syscall_default_handler), "setitimer" },
    [104] = { 4, HANDLER(syscall_default_handler), "kexec_load" },
    [105] = { 3, HANDLER(syscall_default_handler), "init_module" },
    [106] = { 2, HANDLER(syscall_default_handler), "delete_module" },
    [107] = { 3, HANDLER(syscall_default_handler), "timer_create" },
    [108] = { 2, HANDLER(syscall_default_handler), "timer_gettime" },
    [109] = { 1, HANDLER(syscall_default_handler), "timer_getoverrun" },
    [110] = { 4, HANDLER(syscall_default_handler), "timer_settime" },
    [111] = { 1, HANDLER(syscall_default_handler), "timer_delete" },
    [112] = { 2, HANDLER(syscall_default_handler), "clock_settime" },
    [113] = { 2, HANDLER(syscall_default_handler), "clock_gettime" },
    [114] = { 2, HANDLER(syscall_default_handler), "clock_getres" },
    [115] = { 4, HANDLER(syscall_default_handler), "clock_nanosleep" },
    [116] = { 3, HANDLER(syscall_default_handler), "syslog" },
    [117] = { 4, HANDLER(syscall_default_handler), "ptrace" },
    [118] = { 2, HANDLER(syscall_default_handler), "sched_setparam" },
    [119] = { 3, HANDLER(syscall_default_handler), "sched_setscheduler" },
    [120] = { 1, HANDLER(syscall_default_handler), "sched_getscheduler" },
    [121] = { 2, HANDLER(syscall_default_handler), "sched_getparam" },
    [122] = { 3, HANDLER(syscall_default_handler), "sched_setaffinity" },
    [123] = { 3, HANDLER(syscall_default_handler), "sched_getaffinity" },
    [124] = { 0, HANDLER(syscall_default_handler), "sched_yield" },
    [125] = { 1, HANDLER(syscall_default_handler), "sched_get_priority_max" },
    [126] = { 1, HANDLER(syscall_default_handler), "sched_get_priority_min" },
    [127] = { 2, HANDLER(syscall_default_handler), "sched_rr_get_interval" },
    [128] = { 0, HANDLER(syscall_default_handler), "restart_syscall" },
    [129] = { 2, HANDLER(syscall_default_handler), "kill" },
    [130] = { 2, HANDLER(syscall_default_handler), "tkill" },
    [131] = { 3, HANDLER(syscall_default_handler), "tgkill" },
    [132] = { 2, HANDLER(syscall_default_handler), "sigaltstack" },
    [133] = { 2, HANDLER(syscall_default_handler), "rt_sigsuspend" },
    [134] = { 4, HANDLER(syscall_default_handler), "rt_sigaction" },
    [135] = { 4, HANDLER(syscall_default_handler), "rt_sigprocmask" },
    [136] = { 2, HANDLER(syscall_default_handler), "rt_sigpending" },
    [137] = { 4, HANDLER(syscall_default_handler), "rt_sigtimedwait" },
    [138] = { 3, HANDLER(syscall_default_handler), "rt_sigqueueinfo" },
    [139] = { 0, HANDLER(syscall_default_handler), "rt_sigreturn" },
    [140] = { 3, HANDLER(syscall_default_handler), "setpriority" },
    [141] = { 2, HANDLER(syscall_default_handler), "getpriority" },
    [142] = { 4, HANDLER(syscall_default_handler), "reboot" },
    [143] = { 2, HANDLER(syscall_default_handler), "setregid" },
    [144] = { 1, HANDLER(syscall_default_handler), "setgid" },
    [145] = { 2, HANDLER(syscall_default_handler), "setreuid" },
    [146] = { 1, HANDLER(syscall_default_handler), "setuid" },
    [147] = { 3, HANDLER(syscall_default_handler), "setresuid" },
    [148] = { 3, HANDLER(syscall_default_handler), "getresuid" },
    [149] = { 3, HANDLER(syscall_default_handler), "setresgid" },
    [150] = { 3, HANDLER(syscall_default_handler), "getresgid" },
    [151] = { 1, HANDLER(syscall_default_handler), "setfsuid" },
    [152] = { 1, HANDLER(syscall_default_handler), "setfsgid" },
    [153] = { 1, HANDLER(syscall_default_handler), "times" },
    [154] = { 2, HANDLER(syscall_default_handler), "setpgid" },
    [155] = { 1, HANDLER(syscall_default_handler), "getpgid" },
    [156] = { 1, HANDLER(syscall_default_handler), "getsid" },
    [157] = { 0, HANDLER(syscall_default_handler), "setsid" },
    [158] = { 2, HANDLER(syscall_default_handler), "getgroups" },
    [159] = { 2, HANDLER(syscall_default_handler), "setgroups" },
    [160] = { 1, HANDLER(syscall_default_handler), "uname" },
    [161] = { 2, HANDLER(syscall_default_handler), "sethostname" },
    [162] = { 2, HANDLER(syscall_default_handler), "setdomainname" },
    [163] = { 2, HANDLER(syscall_default_handler), "getrlimit" },
    [164] = { 2, HANDLER(syscall_default_handler), "setrlimit" },
    [165] = { 2, HANDLER(syscall_default_handler), "getrusage" },
    [166] = { 1, HANDLER(syscall_default_handler), "umask" },
    [167] = { 5, HANDLER(syscall_default_handler), "prctl" },
    [168] = { 3, HANDLER(syscall_default_handler), "getcpu" },
    [169] = { 2, HANDLER(syscall_default_handler), "gettimeofday" },
    [170] = { 2, HANDLER(syscall_default_handler), "settimeofday" },
    [171] = { 1, HANDLER(syscall_default_handler), "adjtimex" },
    [172] = { 0, HANDLER(syscall_default_handler), "getpid" },
    [173] = { 0, HANDLER(syscall_default_handler), "getppid" },
    [174] = { 0, HANDLER(syscall_default_handler), "getuid" },
    [175] = { 0, HANDLER(syscall_default_handler), "geteuid" },
    [176] = { 0, HANDLER(syscall_default_handler), "getgid" },
    [177] = { 0, HANDLER(syscall_default_handler), "getegid" },
    [178] = { 0, HANDLER(syscall_default_handler), "gettid" },
    [179] = { 1, HANDLER(syscall_default_handler), "sysinfo" },
    [180] = { 4, HANDLER(syscall_default_handler), "mq_open" },
    [181] = { 1, HANDLER(syscall_default_handler), "mq_unlink" },
    [182] = { 5, HANDLER(syscall_default_handler), "mq_timedsend" },
    [183] = { 5, HANDLER(syscall_default_handler), "mq_timedreceive" },
    [184] = { 2, HANDLER(syscall_default_handler), "mq_notify" },
    [185] = { 3, HANDLER(syscall_default_handler), "mq_getsetattr" },
    [186] = { 2, HANDLER(syscall_default_handler), "msgget" },
    [187] = { 3, HANDLER(syscall_default_handler), "msgctl" },
    [188] = { 5, HANDLER(syscall_default_handler), "msgrcv" },
    [189] = { 4, HANDLER(syscall_default_handler), "msgsnd" },
    [190] = { 3, HANDLER(syscall_default_handler), "semget" },
    [191] = { 4, HANDLER(syscall_default_handler), "semctl" },
    [192] = { 4, HANDLER(syscall_default_handler), "semtimedop" },
    [193] = { 3, HANDLER(syscall_default_handler), "semop" },
    [194] = { 3, HANDLER(syscall_default_handler), "shmget" },
    [195] = { 3, HANDLER(syscall_default_handler), "shmctl" },
    [196] = { 3, HANDLER(syscall_default_handler), "shmat" },
    [197] = { 1, HANDLER(syscall_default_handler), "shmdt" },
    [198] = { 3, HANDLER(syscall_default_handler), "socket" },
    [199] = { 4, HANDLER(syscall_default_handler), "socketpair" },
    [200] = { 3, HANDLER(syscall_default_handler), "bind" },
    [201] = { 2, HANDLER(syscall_default_handler), "listen" },
    [202] = { 3, HANDLER(syscall_default_handler), "accept" },
    [203] = { 3, HANDLER(syscall_default_handler), "connect" },
    [204] = { 3, HANDLER(syscall_default_handler), "getsockname" },
    [205] = { 3, HANDLER(syscall_default_handler), "getpeername" },
    [206] = { 6, HANDLER(syscall_default_handler), "sendto" },
    [207] = { 6, HANDLER(syscall_default_handler), "recvfrom" },
    [208] = { 5, HANDLER(syscall_default_handler), "setsockopt" },
    [209] = { 5, HANDLER(syscall_default_handler), "getsockopt" },
    [210] = { 2, HANDLER(syscall_default_handler), "shutdown" },
    [211] = { 3, HANDLER(syscall_default_handler), "sendmsg" },
    [212] = { 3, HANDLER(syscall_default_handler), "recvmsg" },
    [213] = { 3, HANDLER(syscall_default_handler), "readahead" },
    [214] = { 1, HANDLER(do_sys_brk), "brk" },
    [215] = { 2, HANDLER(syscall_default_handler), "munmap" },
    [216] = { 5, HANDLER(syscall_default_handler), "mremap" },
    [217] = { 5, HANDLER(syscall_default_handler), "add_key" },
    [218] = { 4, HANDLER(syscall_default_handler), "request_key" },
    [219] = { 5, HANDLER(syscall_default_handler), "keyctl" },
    [220] = { 5, HANDLER(syscall_default_handler), "clone" },
    [221] = { 3, HANDLER(syscall_default_handler), "execve" },
    [222] = { 6, HANDLER(do_sys_mmap), "mmap" },
    [223] = { 4, HANDLER(syscall_default_handler), "fadvise64" },
    [224] = { 2, HANDLER(syscall_default_handler), "swapon" },
    [225] = { 1, HANDLER(syscall_default_handler), "swapoff" },
    [226] = { 3, HANDLER(syscall_default_handler), "mprotect" },
    [227] = { 3, HANDLER(syscall_default_handler), "msync" },
    [228] = { 2, HANDLER(syscall_default_handler), "mlock" },
    [229] = { 2, HANDLER(syscall_default_handler), "munlock" },
    [230] = { 1, HANDLER(syscall_default_handler), "mlockall" },
    [231] = { 0, HANDLER(syscall_default_handler), "munlockall" },
    [232] = { 3, HANDLER(syscall_default_handler), "mincore" },
    [233] = { 3, HANDLER(syscall_default_handler), "madvise" },
    [234] = { 5, HANDLER(syscall_default_handler), "remap_file_pages" },
    [235] = { 6, HANDLER(syscall_default_handler), "mbind" },
    [236] = { 5, HANDLER(syscall_default_handler), "get_mempolicy" },
    [237] = { 3, HANDLER(syscall_default_handler), "set_mempolicy" },
    [238] = { 4, HANDLER(syscall_default_handler), "migrate_pages" },
    [239] = { 6, HANDLER(syscall_default_handler), "move_pages" },
    [240] = { 4, HANDLER(syscall_default_handler), "rt_tgsigqueueinfo" },
    [241] = { 5, HANDLER(syscall_default_handler), "perf_event_open" },
    [242] = { 4, HANDLER(syscall_default_handler), "accept4" },
    [243] = { 5, HANDLER(syscall_default_handler), "recvmmsg" },
// this array has to be contiguous because C++.

#undef HANDLER
