/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.annotation.ThreadSafeAction;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.WindowDriver;
import org.fest.swing.driver.WindowLikeContainerLocations;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;

public class FrameDriver
extends WindowDriver {
    public FrameDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void iconify(Frame frame) {
        this.moveMouseIgnoringAnyError(frame, FrameDriver.iconifyInfo(frame));
        this.robot.waitForIdle();
        this.updateFrameExtendedState(frame, 1);
    }

    @RunsInEDT
    private static Point iconifyInfo(final Frame frame) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(frame);
                return WindowLikeContainerLocations.iconifyLocationOf(frame);
            }
        });
    }

    @RunsInEDT
    public void deiconify(Frame frame) {
        FrameDriver.assertIsEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void normalize(Frame frame) {
        FrameDriver.assertIsEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void maximize(Frame frame) {
        this.moveMouseIgnoringAnyError(frame, FrameDriver.maximizeInfo(frame));
        if (!FrameDriver.supportsMaximize(Toolkit.getDefaultToolkit())) {
            throw ActionFailedException.actionFailure("Platform does not support maximizing frames");
        }
        this.updateFrameExtendedState(frame, 6);
    }

    @RunsInEDT
    private static Point maximizeInfo(final Frame frame) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(frame);
                return WindowLikeContainerLocations.maximizeLocationOf(frame);
            }
        });
    }

    @ThreadSafeAction
    private void updateFrameExtendedState(Frame frame, int state) {
        frame.setExtendedState(state);
    }

    private static boolean supportsMaximize(Toolkit toolkit) {
        return toolkit.isFrameStateSupported(6);
    }
}

