/*
 * Data used in double-precision erfc(x) function.
 *
 * Copyright (c) 2019-2024, Arm Limited.
 * SPDX-License-Identifier: MIT OR Apache-2.0 WITH LLVM-exception
 */

#include "math_config.h"

/* Lookup table used in vector erfc.
   For each possible rounded input r (multiples of 1/128), between
   r = 0.0 and r = ~27.0 (3488 values):
   - the first entry __v_erfc_data.tab.erfc contains the values of erfc(r),
   - the second entry __v_erfc_data.tab.scale contains the values of
   2/sqrt(pi)*exp(-r^2). Both values may go into subnormal range, therefore
   they are scaled by a large enough value 2^128 (fits in 8bit).  */
const struct v_erfc_data __v_erfc_data = {
  .tab = { { 0x1p128, 0x1.20dd750429b6dp128 },
	   { 0x1.fb7c9030853b3p127, 0x1.20d8f1975c85dp128 },
	   { 0x1.f6f9447be0743p127, 0x1.20cb67bd452c7p128 },
	   { 0x1.f27640f9853d9p127, 0x1.20b4d8bac36c1p128 },
	   { 0x1.edf3a9ba22dadp127, 0x1.209546ad13ccfp128 },
	   { 0x1.e971a2c4436aep127, 0x1.206cb4897b148p128 },
	   { 0x1.e4f05010eca8cp127, 0x1.203b261cd0053p128 },
	   { 0x1.e06fd58842c7ep127, 0x1.2000a00ae3804p128 },
	   { 0x1.dbf056fe2df35p127, 0x1.1fbd27cdc72d3p128 },
	   { 0x1.d771f82f02f4ep127, 0x1.1f70c3b4f2cc8p128 },
	   { 0x1.d2f4dcbc2f894p127, 0x1.1f1b7ae44867fp128 },
	   { 0x1.ce792828eae5cp127, 0x1.1ebd5552f795bp128 },
	   { 0x1.c9fefdd6eaf19p127, 0x1.1e565bca400d4p128 },
	   { 0x1.c58681031eb6ap127, 0x1.1de697e413d29p128 },
	   { 0x1.c10fd4c26e896p127, 0x1.1d6e14099944ap128 },
	   { 0x1.bc9b1bfe82687p127, 0x1.1cecdb718d61cp128 },
	   { 0x1.b82879728f11ep127, 0x1.1c62fa1e869b6p128 },
	   { 0x1.b3b80fa82a4bbp127, 0x1.1bd07cdd189acp128 },
	   { 0x1.af4a00f426daap127, 0x1.1b357141d95d5p128 },
	   { 0x1.aade6f7378a0ep127, 0x1.1a91e5a748165p128 },
	   { 0x1.a6757d08215d8p127, 0x1.19e5e92b964abp128 },
	   { 0x1.a20f4b5626818p127, 0x1.19318bae53a04p128 },
	   { 0x1.9dabfbc090901p127, 0x1.1874ddcdfce24p128 },
	   { 0x1.994baf66747adp127, 0x1.17aff0e56ec1p128 },
	   { 0x1.94ee8720076b6p127, 0x1.16e2d7093cd8cp128 },
	   { 0x1.9094a37bbd66ep127, 0x1.160da304ed92fp128 },
	   { 0x1.8c3e24bb73372p127, 0x1.153068581b781p128 },
	   { 0x1.87eb2ad1a4032p127, 0x1.144b3b337c90cp128 },
	   { 0x1.839bd55eaafc8p127, 0x1.135e3075d076bp128 },
	   { 0x1.7f5043ae11862p127, 0x1.12695da8b5bdep128 },
	   { 0x1.7b0894b3ea35cp127, 0x1.116cd8fd67618p128 },
	   { 0x1.76c4e70a390e7p127, 0x1.1068b94962e5ep128 },
	   { 0x1.728558ee694fcp127, 0x1.0f5d1602f7e41p128 },
	   { 0x1.6e4a083ed132fp127, 0x1.0e4a073dc1b91p128 },
	   { 0x1.6a13127843ec1p127, 0x1.0d2fa5a70c168p128 },
	   { 0x1.65e094b3b2413p127, 0x1.0c0e0a8223359p128 },
	   { 0x1.61b2aba3da093p127, 0x1.0ae54fa490723p128 },
	   { 0x1.5d89739304dcfp127, 0x1.09b58f724416bp128 },
	   { 0x1.59650860d6469p127, 0x1.087ee4d9ad247p128 },
	   { 0x1.5545858029b39p127, 0x1.07416b4fbfe7cp128 },
	   { 0x1.512b05f5006e1p127, 0x1.05fd3ecbec298p128 },
	   { 0x1.4d15a4527fdc7p127, 0x1.04b27bc403d3p128 },
	   { 0x1.49057ab900447p127, 0x1.03613f2812dafp128 },
	   { 0x1.44faa2d42c4ap127, 0x1.0209a65e29545p128 },
	   { 0x1.40f535d93160ep127, 0x1.00abcf3e187a9p128 },
	   { 0x1.3cf54c850162p127, 0x1.fe8fb01a47307p127 },
	   { 0x1.38faff1aa574ap127, 0x1.fbbbbef34b4b2p127 },
	   { 0x1.35066561a275dp127, 0x1.f8dc092d58ff8p127 },
	   { 0x1.311796a46f064p127, 0x1.f5f0cdaf15313p127 },
	   { 0x1.2d2ea9aefb636p127, 0x1.f2fa4c16c0019p127 },
	   { 0x1.294bb4cd4b2bdp127, 0x1.eff8c4b1375dbp127 },
	   { 0x1.256ecdca212ccp127, 0x1.ecec7870ebca8p127 },
	   { 0x1.219809edbd524p127, 0x1.e9d5a8e4c934ep127 },
	   { 0x1.1dc77dfcacd02p127, 0x1.e6b4982f158b9p127 },
	   { 0x1.19fd3e36ac96ap127, 0x1.e38988fc46e72p127 },
	   { 0x1.16395e559e218p127, 0x1.e054be79d3042p127 },
	   { 0x1.127bf18c8eadcp127, 0x1.dd167c4cf9d2ap127 },
	   { 0x1.0ec50a86d0dd4p127, 0x1.d9cf06898cdafp127 },
	   { 0x1.0b14bb6728cd8p127, 0x1.d67ea1a8b5368p127 },
	   { 0x1.076b15c70aa28p127, 0x1.d325927fb9d89p127 },
	   { 0x1.03c82ab5eb831p127, 0x1.cfc41e36c7df9p127 },
	   { 0x1.002c0ab8a5018p127, 0x1.cc5a8a3fbea4p127 },
	   { 0x1.f92d8b91d5cc7p126, 0x1.c8e91c4d01368p127 },
	   { 0x1.f210d6a9a6a31p126, 0x1.c5701a484ef9dp127 },
	   { 0x1.eb02147ce245cp126, 0x1.c1efca49a5011p127 },
	   { 0x1.e40161b701275p126, 0x1.be68728e29d5ep127 },
	   { 0x1.dd0ed9ea4bdd6p126, 0x1.bada596f25436p127 },
	   { 0x1.d62a978f7c957p126, 0x1.b745c55905bf8p127 },
	   { 0x1.cf54b4058455fp126, 0x1.b3aafcc27502ep127 },
	   { 0x1.c88d479173ccep126, 0x1.b00a46237d5bep127 },
	   { 0x1.c1d4695e87644p126, 0x1.ac63e7ecc1411p127 },
	   { 0x1.bb2a2f7e5652p126, 0x1.a8b8287ec6a09p127 },
	   { 0x1.b48eaee924501p126, 0x1.a5074e215762p127 },
	   { 0x1.ae01fb7e55a66p126, 0x1.a1519efaf889ep127 },
	   { 0x1.a78428050527ep126, 0x1.9d97610879642p127 },
	   { 0x1.a115462cbbc17p126, 0x1.99d8da149c13fp127 },
	   { 0x1.9ab5668e4930ap126, 0x1.96164fafd8de3p127 },
	   { 0x1.946498acbd766p126, 0x1.925007283d7aap127 },
	   { 0x1.8e22eaf68291ep126, 0x1.8e86458169af8p127 },
	   { 0x1.87f06ac6960c4p126, 0x1.8ab94f6caa71dp127 },
	   { 0x1.81cd2465e1d96p126, 0x1.86e9694134b9ep127 },
	   { 0x1.7bb9230cb40b4p126, 0x1.8316d6f48133dp127 },
	   { 0x1.75b470e454d35p126, 0x1.7f41dc12c9e89p127 },
	   { 0x1.6fbf1708ba47cp126, 0x1.7b6abbb7aaf19p127 },
	   { 0x1.69d91d8a595dap126, 0x1.7791b886e7403p127 },
	   { 0x1.64028b7013867p126, 0x1.73b714a552763p127 },
	   { 0x1.5e3b66b9405a9p126, 0x1.6fdb11b1e0c34p127 },
	   { 0x1.5883b45fd2b63p126, 0x1.6bfdf0beddaf5p127 },
	   { 0x1.52db785a98acap126, 0x1.681ff24b4ab04p127 },
	   { 0x1.4d42b59f95afap126, 0x1.6441563c665d4p127 },
	   { 0x1.47b96e267647ap126, 0x1.60625bd75d07bp127 },
	   { 0x1.423fa2eb1cb59p126, 0x1.5c8341bb23767p127 },
	   { 0x1.3cd553f045d45p126, 0x1.58a445da7c74cp127 },
	   { 0x1.377a8042458d1p126, 0x1.54c5a57629dbp127 },
	   { 0x1.322f25f9da2fdp126, 0x1.50e79d1749ac9p127 },
	   { 0x1.2cf3423f15fdfp126, 0x1.4d0a6889dfd9fp127 },
	   { 0x1.27c6d14c5e341p126, 0x1.492e42d78d2c5p127 },
	   { 0x1.22a9ce717edcbp126, 0x1.4553664273d24p127 },
	   { 0x1.1d9c3416d2b4bp126, 0x1.417a0c4049fdp127 },
	   { 0x1.189dfbc07e69p126, 0x1.3da26d759aef5p127 },
	   { 0x1.13af1e11be721p126, 0x1.39ccc1b136d5ap127 },
	   { 0x1.0ecf92d046d22p126, 0x1.35f93fe7d1b3dp127 },
	   { 0x1.09ff50e7b3f93p126, 0x1.32281e2fd1a92p127 },
	   { 0x1.053e4e6d0c10bp126, 0x1.2e5991bd4cbfcp127 },
	   { 0x1.008c80a24ff1p126, 0x1.2a8dcede3673bp127 },
	   { 0x1.f7d3b7f436013p125, 0x1.26c508f6bd0ffp127 },
	   { 0x1.eeaca836a27ccp125, 0x1.22ff727dd6f7bp127 },
	   { 0x1.e5a3b7c9b56dap125, 0x1.1f3d3cf9ffe5ap127 },
	   { 0x1.dcb8cae2d747fp125, 0x1.1b7e98fe26217p127 },
	   { 0x1.d3ebc436b0f26p125, 0x1.17c3b626c7a12p127 },
	   { 0x1.cb3c8500ea349p125, 0x1.140cc3173f007p127 },
	   { 0x1.c2aaed0bfcfeep125, 0x1.1059ed7740313p127 },
	   { 0x1.ba36dab91c0e9p125, 0x1.0cab61f084b93p127 },
	   { 0x1.b1e02b082b72p125, 0x1.09014c2ca74dap127 },
	   { 0x1.a9a6b99fc973bp125, 0x1.055bd6d32e8d7p127 },
	   { 0x1.a18a60d56673ep125, 0x1.01bb2b87c6968p127 },
	   { 0x1.998af9b56a3aep125, 0x1.fc3ee5d1524bp126 },
	   { 0x1.91a85c0b65519p125, 0x1.f511a91a67d2ap126 },
	   { 0x1.89e25e6a4cef9p125, 0x1.edeeee0959518p126 },
	   { 0x1.8238d634c0127p125, 0x1.e6d6ffaa65a25p126 },
	   { 0x1.7aab97a554544p125, 0x1.dfca26f5bbf88p126 },
	   { 0x1.733a75d6e91b8p125, 0x1.d8c8aace11e63p126 },
	   { 0x1.6be542ccffc2fp125, 0x1.d1d2cfff91594p126 },
	   { 0x1.64abcf7c175b4p125, 0x1.cae8d93f1d7b7p126 },
	   { 0x1.5d8debd20aacep125, 0x1.c40b0729ed548p126 },
	   { 0x1.568b66be6f268p125, 0x1.bd3998457afdbp126 },
	   { 0x1.4fa40e3af3674p125, 0x1.b674c8ffc6283p126 },
	   { 0x1.48d7af53bc19fp125, 0x1.afbcd3afe8ab6p126 },
	   { 0x1.4226162fbddd5p125, 0x1.a911f096fbc26p126 },
	   { 0x1.3b8f0e1912f7p125, 0x1.a27455e14c93cp126 },
	   { 0x1.351261854b991p125, 0x1.9be437a7de946p126 },
	   { 0x1.2eafda1db784ap125, 0x1.9561c7f23a47bp126 },
	   { 0x1.286740c7a7dabp125, 0x1.8eed36b886d93p126 },
	   { 0x1.22385daca7f47p125, 0x1.8886b1e5ecfd1p126 },
	   { 0x1.1c22f842ac1f2p125, 0x1.822e655b417e7p126 },
	   { 0x1.1626d7543522p125, 0x1.7be47af1f5d89p126 },
	   { 0x1.1043c1086777dp125, 0x1.75a91a7f4d2edp126 },
	   { 0x1.0a797aeb152f2p125, 0x1.6f7c69d7d3ef8p126 },
	   { 0x1.04c7c9f4b969p125, 0x1.695e8cd31867ep126 },
	   { 0x1.fe5ce524c8ee5p124, 0x1.634fa54fa285fp126 },
	   { 0x1.f35a715b2f3e1p124, 0x1.5d4fd33729015p126 },
	   { 0x1.e887bf681f218p124, 0x1.575f3483021c3p126 },
	   { 0x1.dde4553ef94dep124, 0x1.517de540ce2a3p126 },
	   { 0x1.d36fb7fa50177p124, 0x1.4babff975a04cp126 },
	   { 0x1.c9296beb09cf1p124, 0x1.45e99bcbb7915p126 },
	   { 0x1.bf10f4a759889p124, 0x1.4036d0468a7a2p126 },
	   { 0x1.b525d5198cb1cp124, 0x1.3a93b1998736cp126 },
	   { 0x1.ab678f8eabedbp124, 0x1.35005285227f1p126 },
	   { 0x1.a1d5a5c4edb96p124, 0x1.2f7cc3fe6f423p126 },
	   { 0x1.986f98f9f96c8p124, 0x1.2a09153529381p126 },
	   { 0x1.8f34e9f8f93a6p124, 0x1.24a55399ea239p126 },
	   { 0x1.8625192879e39p124, 0x1.1f518ae487dc8p126 },
	   { 0x1.7d3fa69816db5p124, 0x1.1a0dc51a9934dp126 },
	   { 0x1.7484120df1b01p124, 0x1.14da0a961fd14p126 },
	   { 0x1.6bf1db13f3983p124, 0x1.0fb6620c550afp126 },
	   { 0x1.63888104d811ap124, 0x1.0aa2d09497f2bp126 },
	   { 0x1.5b478318ff939p124, 0x1.059f59af7a906p126 },
	   { 0x1.532e6073095f2p124, 0x1.00abff4dec7a3p126 },
	   { 0x1.4b3c982c338c7p124, 0x1.f79183b101c5bp125 },
	   { 0x1.4371a960807f8p124, 0x1.edeb406d9c825p125 },
	   { 0x1.3bcd133aa0ffcp124, 0x1.e4652fadcb6b2p125 },
	   { 0x1.344e54ffa23b9p124, 0x1.daff4969c0b04p125 },
	   { 0x1.2cf4ee1a5f0fcp124, 0x1.d1b982c50137p125 },
	   { 0x1.25c05e26b3f99p124, 0x1.c893ce1dcbef7p125 },
	   { 0x1.1eb024fc75285p124, 0x1.bf8e1b1ca2279p125 },
	   { 0x1.17c3c2ba26319p124, 0x1.b6a856c3ed54fp125 },
	   { 0x1.10fab7cf72f94p124, 0x1.ade26b7fbed95p125 },
	   { 0x1.0a548507696cp124, 0x1.a53c4135a6526p125 },
	   { 0x1.03d0ab9273b94p124, 0x1.9cb5bd549b111p125 },
	   { 0x1.fadd5a20258d3p123, 0x1.944ec2e4f563p125 },
	   { 0x1.ee5c1730b147cp123, 0x1.8c07329874652p125 },
	   { 0x1.e21c938a45a83p123, 0x1.83deeada4d25ap125 },
	   { 0x1.d61dd57628999p123, 0x1.7bd5c7df3fe9cp125 },
	   { 0x1.ca5ee4649e31fp123, 0x1.73eba3b5b07b7p125 },
	   { 0x1.bedec8fddb34p123, 0x1.6c205655be72p125 },
	   { 0x1.b39c8d3276d8ap123, 0x1.6473b5b15a7a1p125 },
	   { 0x1.a8973c4b5c03ep123, 0x1.5ce595c455b0ap125 },
	   { 0x1.9dcde2f93a207p123, 0x1.5575c8a468362p125 },
	   { 0x1.933f8f6375f2cp123, 0x1.4e241e912c305p125 },
	   { 0x1.88eb51369acb9p123, 0x1.46f066040a832p125 },
	   { 0x1.7ed039b24c96bp123, 0x1.3fda6bc016994p125 },
	   { 0x1.74ed5bb6bb581p123, 0x1.38e1fae1d6a9dp125 },
	   { 0x1.6b41cbd198bc8p123, 0x1.3206dceef5f87p125 },
	   { 0x1.61cca04a90795p123, 0x1.2b48d9e5dea1cp125 },
	   { 0x1.588cf12f4446bp123, 0x1.24a7b84d38971p125 },
	   { 0x1.4f81d85ecc55bp123, 0x1.1e233d434b813p125 },
	   { 0x1.46aa7194bd324p123, 0x1.17bb2c8d41535p125 },
	   { 0x1.3e05da73b4159p123, 0x1.116f48a6476ccp125 },
	   { 0x1.3593328f6abbep123, 0x1.0b3f52ce8c383p125 },
	   { 0x1.2d519b7653e1ep123, 0x1.052b0b1a174eap125 },
	   { 0x1.254038bac19d6p123, 0x1.fe6460fef468p124 },
	   { 0x1.1d5e2ffb96d4p123, 0x1.f2a901ccafb37p124 },
	   { 0x1.15aaa8ec85205p123, 0x1.e723726b824a9p124 },
	   { 0x1.0e24cd5dd8846p123, 0x1.dbd32ac4c99bp124 },
	   { 0x1.06cbc943d255ap123, 0x1.d0b7a0f921e7cp124 },
	   { 0x1.ff3d957b29b39p122, 0x1.c5d0497c09e74p124 },
	   { 0x1.f13a043742333p122, 0x1.bb1c972f23e5p124 },
	   { 0x1.e38b43cbd0f0fp122, 0x1.b09bfb7d11a84p124 },
	   { 0x1.d62fbdc2e756bp122, 0x1.a64de673e8837p124 },
	   { 0x1.c925e02b41668p122, 0x1.9c31c6df3b1b8p124 },
	   { 0x1.bc6c1da1f3121p122, 0x1.92470a61b6965p124 },
	   { 0x1.b000ed5b4a626p122, 0x1.888d1d8e510a3p124 },
	   { 0x1.a3e2cb2ae9edbp122, 0x1.7f036c0107294p124 },
	   { 0x1.9810378b1f299p122, 0x1.75a96077274bap124 },
	   { 0x1.8c87b7a37834fp122, 0x1.6c7e64e7281cbp124 },
	   { 0x1.8147d54e9cc33p122, 0x1.6381e2980956bp124 },
	   { 0x1.764f1f1f6ddeap122, 0x1.5ab342383d178p124 },
	   { 0x1.6b9c28657041ap122, 0x1.5211ebf41880bp124 },
	   { 0x1.612d893085125p122, 0x1.499d478bca735p124 },
	   { 0x1.5701de53f4d2ep122, 0x1.4154bc68d75c3p124 },
	   { 0x1.4d17c968d062bp122, 0x1.3937b1b31925ap124 },
	   { 0x1.436df0cfabf1dp122, 0x1.31458e6542847p124 },
	   { 0x1.3a02ffb1b7ceep122, 0x1.297db960e4f63p124 },
	   { 0x1.30d5a6013afc5p122, 0x1.21df9981f8e53p124 },
	   { 0x1.27e49879737d3p122, 0x1.1a6a95b1e786fp124 },
	   { 0x1.1f2e909de04d2p122, 0x1.131e14fa1625dp124 },
	   { 0x1.16b24cb8f8f92p122, 0x1.0bf97e95f2a64p124 },
	   { 0x1.0e6e8fda56cf7p122, 0x1.04fc3a0481321p124 },
	   { 0x1.066221d4539d8p122, 0x1.fc4b5e32d6259p123 },
	   { 0x1.fd179e7243e3cp121, 0x1.eeea8c1b1db94p123 },
	   { 0x1.edd4d2aec5adbp121, 0x1.e1d4cf1e2450ap123 },
	   { 0x1.def98c6c79efap121, 0x1.d508f9a1ea64fp123 },
	   { 0x1.d0838121f2418p121, 0x1.c885df3451a07p123 },
	   { 0x1.c2706fa45005ep121, 0x1.bc4a54a84e834p123 },
	   { 0x1.b4be201caa4b4p121, 0x1.b055303221015p123 },
	   { 0x1.a76a63fc95c79p121, 0x1.a4a549829587ep123 },
	   { 0x1.9a7315f1d6a55p121, 0x1.993979e14fffep123 },
	   { 0x1.8dd619d943ca1p121, 0x1.8e109c4622913p123 },
	   { 0x1.81915cb0e3323p121, 0x1.83298d717210ep123 },
	   { 0x1.75a2d48946eb1p121, 0x1.78832c03aa2b1p123 },
	   { 0x1.6a08807632262p121, 0x1.6e1c5893c380bp123 },
	   { 0x1.5ec0687e8dcb2p121, 0x1.63f3f5c4de13bp123 },
	   { 0x1.53c89d8bb3ddbp121, 0x1.5a08e85af27ep123 },
	   { 0x1.491f395818f54p121, 0x1.505a174e9c929p123 },
	   { 0x1.3ec25e5d5af12p121, 0x1.46e66be00224p123 },
	   { 0x1.34b037c1bbfc5p121, 0x1.3dacd1a8d8ccep123 },
	   { 0x1.2ae6f94510dd8p121, 0x1.34ac36ad8dafep123 },
	   { 0x1.2164df2d29765p121, 0x1.2be38b6d92415p123 },
	   { 0x1.18282e31ba3e8p121, 0x1.2351c2f2d1449p123 },
	   { 0x1.0f2f3367cd6aap121, 0x1.1af5d2e04f3f6p123 },
	   { 0x1.0678442cc256fp121, 0x1.12ceb37ff9bc3p123 },
	   { 0x1.fc037c21c3622p120, 0x1.0adb5fcfa8c75p123 },
	   { 0x1.eb940d8319831p120, 0x1.031ad58d56279p123 },
	   { 0x1.db9f17e61c31p120, 0x1.f7182a851bca2p122 },
	   { 0x1.cc218694238a2p120, 0x1.e85c449e377f3p122 },
	   { 0x1.bd18548996419p120, 0x1.da0005e5f28dfp122 },
	   { 0x1.ae808c479c371p120, 0x1.cc0180af00a8bp122 },
	   { 0x1.a05747a543aa7p120, 0x1.be5ecd2fcb5f9p122 },
	   { 0x1.9299afa0246a6p120, 0x1.b1160991ff737p122 },
	   { 0x1.8544fc2c8c1dap120, 0x1.a4255a00b9f03p122 },
	   { 0x1.785674053e8b9p120, 0x1.978ae8b55ce1bp122 },
	   { 0x1.6bcb6c7ad4854p120, 0x1.8b44e6031383ep122 },
	   { 0x1.5fa14942c3d54p120, 0x1.7f5188610ddc8p122 },
	   { 0x1.53d57c461a5a7p120, 0x1.73af0c737bb45p122 },
	   { 0x1.4865856ff632ap120, 0x1.685bb5134ef13p122 },
	   { 0x1.3d4ef27bc49a6p120, 0x1.5d55cb54cd53ap122 },
	   { 0x1.328f5ec350e67p120, 0x1.529b9e8cf9a1ep122 },
	   { 0x1.2824730cacbb4p120, 0x1.482b8455dc491p122 },
	   { 0x1.1e0be557fa673p120, 0x1.3e03d891b37dep122 },
	   { 0x1.144378ad22027p120, 0x1.3422fd6d12e2bp122 },
	   { 0x1.0ac8fce979b96p120, 0x1.2a875b5ffab56p122 },
	   { 0x1.019a4e8d69649p120, 0x1.212f612dee7fbp122 },
	   { 0x1.f16aad1422a55p119, 0x1.181983e5133ddp122 },
	   { 0x1.e030141df7d25p119, 0x1.0f443edc5ce49p122 },
	   { 0x1.cf80d4afc3019p119, 0x1.06ae13b0d3255p122 },
	   { 0x1.bf5908f50b4ap119, 0x1.fcab1483ea7fcp121 },
	   { 0x1.afb4e269693dfp119, 0x1.ec72615a894c4p121 },
	   { 0x1.a090a974cfebep119, 0x1.dcaf3691fc448p121 },
	   { 0x1.91e8bd0830a74p119, 0x1.cd5ec93c12432p121 },
	   { 0x1.83b9923a85f7bp119, 0x1.be7e5ac24963bp121 },
	   { 0x1.75ffb3e6519ap119, 0x1.b00b38d6b3575p121 },
	   { 0x1.68b7c2479902dp119, 0x1.a202bd6372dcep121 },
	   { 0x1.5bde729a6b60fp119, 0x1.94624e78e0fafp121 },
	   { 0x1.4f708eb9fba63p119, 0x1.87275e3a6869ep121 },
	   { 0x1.436af4c058acbp119, 0x1.7a4f6aca256cbp121 },
	   { 0x1.37ca96a6cd1d4p119, 0x1.6dd7fe335823p121 },
	   { 0x1.2c8c79e6f04a3p119, 0x1.61beae53b72b7p121 },
	   { 0x1.21adb71c70c75p119, 0x1.56011cc3b036dp121 },
	   { 0x1.172b79a7a1181p119, 0x1.4a9cf6bda3f4cp121 },
	   { 0x1.0d02ff50ce651p119, 0x1.3f8ff5042a88ep121 },
	   { 0x1.033197ec68c0ep119, 0x1.34d7dbc76d7e5p121 },
	   { 0x1.f3694a0008381p118, 0x1.2a727a89a3f14p121 },
	   { 0x1.e11332d0714c5p118, 0x1.205dac02bd6b9p121 },
	   { 0x1.cf5bf1fed1e7p118, 0x1.1697560347b26p121 },
	   { 0x1.be3eb08ae7c2p118, 0x1.0d1d69569b82dp121 },
	   { 0x1.adb6b810af9e2p118, 0x1.03ede1a45bfeep121 },
	   { 0x1.9dbf721b98dfap118, 0x1.f60d8aa2a88f2p120 },
	   { 0x1.8e54677bb0151p118, 0x1.e4cc4abf7d065p120 },
	   { 0x1.7f713f9cc9784p118, 0x1.d4143a9dfe965p120 },
	   { 0x1.7111bfdfb3cep118, 0x1.c3e1a5f5c077cp120 },
	   { 0x1.6331caf57b5dbp118, 0x1.b430ecf4a83a8p120 },
	   { 0x1.55cd603cc415p118, 0x1.a4fe83fb9db25p120 },
	   { 0x1.48e09b21414bfp118, 0x1.9646f35a76624p120 },
	   { 0x1.3c67b27d50fe7p118, 0x1.8806d70b2fc36p120 },
	   { 0x1.305ef7fdbfb95p118, 0x1.7a3ade6c8b3e5p120 },
	   { 0x1.24c2d787b9e37p118, 0x1.6cdfcbfc1e263p120 },
	   { 0x1.198fd6a0ee7bdp118, 0x1.5ff2750fe782p120 },
	   { 0x1.0ec293d9e6d85p118, 0x1.536fc18f7ce5cp120 },
	   { 0x1.0457c63a9669p118, 0x1.4754abacdf1dcp120 },
	   { 0x1.f49879624a021p117, 0x1.3b9e3f9d06e3fp120 },
	   { 0x1.e139bb05eb49ep117, 0x1.30499b503957fp120 },
	   { 0x1.ce8d4b7fd6c7p117, 0x1.2553ee2a336bfp120 },
	   { 0x1.bc8d516fda8bap117, 0x1.1aba78ba3af89p120 },
	   { 0x1.ab341ee553e25p117, 0x1.107a8c7323a6ep120 },
	   { 0x1.9a7c305336484p117, 0x1.06918b6355624p120 },
	   { 0x1.8a602b88919cp117, 0x1.f9f9cfd9c3035p119 },
	   { 0x1.7adadead962edp117, 0x1.e77448fb66bb9p119 },
	   { 0x1.6be73f45149fbp117, 0x1.d58da68fd117p119 },
	   { 0x1.5d80693276a6dp117, 0x1.c4412bf4b8f0bp119 },
	   { 0x1.4fa19dc42d409p117, 0x1.b38a3af2e55b4p119 },
	   { 0x1.424642c28ff75p117, 0x1.a3645330550ffp119 },
	   { 0x1.3569e18328604p117, 0x1.93cb11a30d765p119 },
	   { 0x1.29082600643fdp117, 0x1.84ba3004a50dp119 },
	   { 0x1.1d1cddf5a82dep117, 0x1.762d84469c18fp119 },
	   { 0x1.11a3f7ffbbfeap117, 0x1.6821000795a03p119 },
	   { 0x1.069982c189a9ep117, 0x1.5a90b00981d93p119 },
	   { 0x1.f7f3581a4dc2cp116, 0x1.4d78bba8ca5fdp119 },
	   { 0x1.e381802242163p116, 0x1.40d564548fad7p119 },
	   { 0x1.cfd6511405b2dp116, 0x1.34a305080681fp119 },
	   { 0x1.bcead7f01492fp116, 0x1.28de11c5031ebp119 },
	   { 0x1.aab859b20ac9ep116, 0x1.1d83170fbf6fbp119 },
	   { 0x1.993851cc9779ap116, 0x1.128eb96be8798p119 },
	   { 0x1.886470ad946a7p116, 0x1.07fdb4dafea5fp119 },
	   { 0x1.78369a4a2cbd6p116, 0x1.fb99b8b8279e1p118 },
	   { 0x1.68a8e4b2fc8c2p116, 0x1.e7f232d9e263p118 },
	   { 0x1.59b596b012aaap116, 0x1.d4fed7195d7e8p118 },
	   { 0x1.4b572664bd2dcp116, 0x1.c2b9cf7f893bfp118 },
	   { 0x1.3d8837fb08d1dp116, 0x1.b11d702b3deb2p118 },
	   { 0x1.30439c56dadf6p116, 0x1.a024365f771bdp118 },
	   { 0x1.23844fd08cb93p116, 0x1.8fc8c794b03b5p118 },
	   { 0x1.174578f6efd5dp116, 0x1.8005f08d6f1efp118 },
	   { 0x1.0b826758a086bp116, 0x1.70d6a46e07ddap118 },
	   { 0x1.003692548d98bp116, 0x1.6235fbd7a4345p118 },
	   { 0x1.eabb2fe335196p115, 0x1.541f340697987p118 },
	   { 0x1.d5e6777a83c2ap115, 0x1.468dadf4080abp118 },
	   { 0x1.c1e6cb6239574p115, 0x1.397ced7af2b15p118 },
	   { 0x1.aeb4423e690e7p115, 0x1.2ce898809244ep118 },
	   { 0x1.9c47374a0974ep115, 0x1.20cc76202c5fbp118 },
	   { 0x1.8a98484a1e8d3p115, 0x1.15246dda49d47p118 },
	   { 0x1.79a0538dd4fc7p115, 0x1.09ec86c75d497p118 },
	   { 0x1.695875fb574ap115, 0x1.fe41cd9bb4eeep117 },
	   { 0x1.59ba0929261c5p115, 0x1.e97ba3b77f306p117 },
	   { 0x1.4abea183bc47p115, 0x1.d57f524723822p117 },
	   { 0x1.3c600c7f477c5p115, 0x1.c245d4b99847ap117 },
	   { 0x1.2e984ed53e777p115, 0x1.afc85e0f82e12p117 },
	   { 0x1.2161a2cd9d894p115, 0x1.9e005769dbc1dp117 },
	   { 0x1.14b67693928cfp115, 0x1.8ce75e9f6f8ap117 },
	   { 0x1.08916a956172p115, 0x1.7c7744d9378f7p117 },
	   { 0x1.f9da9fde95755p114, 0x1.6caa0d3582fe9p117 },
	   { 0x1.e38a4dc27b11bp114, 0x1.5d79eb71e893bp117 },
	   { 0x1.ce283a9e3e33p114, 0x1.4ee1429bf7ccp117 },
	   { 0x1.b9ab1a96e3b3ep114, 0x1.40daa3c89f5b6p117 },
	   { 0x1.a609f7584d32bp114, 0x1.3360ccd23db3ap117 },
	   { 0x1.933c2d52c56c9p114, 0x1.266ea71d4f71ap117 },
	   { 0x1.8139690c0d187p114, 0x1.19ff4663ae9dfp117 },
	   { 0x1.6ff9a4837fa43p114, 0x1.0e0de78654d1ep117 },
	   { 0x1.5f7524a8e81a2p114, 0x1.0295ef6591848p117 },
	   { 0x1.4fa476e59f668p114, 0x1.ef25d37f49fe1p116 },
	   { 0x1.40806eb78e353p114, 0x1.da01102b5f851p116 },
	   { 0x1.3202235dada5p114, 0x1.c5b5412dcafadp116 },
	   { 0x1.2422ed95a3235p114, 0x1.b23a5a23e421p116 },
	   { 0x1.16dc656a14df6p114, 0x1.9f8893d8fd1c1p116 },
	   { 0x1.0a2860115569cp114, 0x1.8d986a4187285p116 },
	   { 0x1.fc01dbb80c841p113, 0x1.7c629a822bc9ep116 },
	   { 0x1.e4c0b066a497p113, 0x1.6be02102b352p116 },
	   { 0x1.ce823f4cc4badp113, 0x1.5c0a378c90bcap116 },
	   { 0x1.b93bf40d5eccbp113, 0x1.4cda5374ea275p116 },
	   { 0x1.a4e3a125adc76p113, 0x1.3e4a23d1f4703p116 },
	   { 0x1.916f7c5f2f764p113, 0x1.30538fbb77ecdp116 },
	   { 0x1.7ed61b5d3db0ap113, 0x1.22f0b496539bep116 },
	   { 0x1.6d0e7045988cbp113, 0x1.161be46ad3b5p116 },
	   { 0x1.5c0fc68335b0cp113, 0x1.09cfa445b00ffp116 },
	   { 0x1.4bd1bfa2aba3dp113, 0x1.fc0d55470cf51p115 },
	   { 0x1.3c4c504792bf8p113, 0x1.e577bbcd49935p115 },
	   { 0x1.2d77bd3a382bcp113, 0x1.cfd4a5adec5cp115 },
	   { 0x1.1f4c988d02149p113, 0x1.bb1a9657ce465p115 },
	   { 0x1.11c3bed8e716ap113, 0x1.a740684026555p115 },
	   { 0x1.04d654905dadp113, 0x1.943d4a1d1ed39p115 },
	   { 0x1.f0fb86d056745p112, 0x1.8208bc334a6a5p115 },
	   { 0x1.d9676faafa27fp112, 0x1.709a8db59f25cp115 },
	   { 0x1.c2e43d417197bp112, 0x1.5feada379d8b7p115 },
	   { 0x1.ad664518e771bp112, 0x1.4ff207314a102p115 },
	   { 0x1.98e25420092dap112, 0x1.40a8c1949f75ep115 },
	   { 0x1.854daa4a49b0fp112, 0x1.3207fb7420eb9p115 },
	   { 0x1.729df6503422ap112, 0x1.2408e9ba3327fp115 },
	   { 0x1.60c95193c542dp112, 0x1.16a501f0e42cap115 },
	   { 0x1.4fc63c27c71aep112, 0x1.09d5f819c9e29p115 },
	   { 0x1.3f8b98f93052ap112, 0x1.fb2b792b40a22p114 },
	   { 0x1.3010aa198de78p112, 0x1.e3bcf436a1a95p114 },
	   { 0x1.214d0d298365p112, 0x1.cd55277c18d05p114 },
	   { 0x1.1338b7e273194p112, 0x1.b7e94604479dcp114 },
	   { 0x1.05cbf4be650abp112, 0x1.a36eec00926ddp114 },
	   { 0x1.f1febf7a916aap111, 0x1.8fdc1b2dcf7b9p114 },
	   { 0x1.d997c68d65936p111, 0x1.7d2737527c3f9p114 },
	   { 0x1.c2556a4e7a90fp111, 0x1.6b4702d7d5849p114 },
	   { 0x1.ac2aa7516ade4p111, 0x1.5a329b7d30748p114 },
	   { 0x1.970b05888fda2p111, 0x1.49e17724f4d41p114 },
	   { 0x1.82ea92dbc1a27p111, 0x1.3a4b60ba9aa4ep114 },
	   { 0x1.6fbdddeff308fp111, 0x1.2b6875310f785p114 },
	   { 0x1.5d79f11e27f6bp111, 0x1.1d312098e9dbap114 },
	   { 0x1.4c144d984e1b8p111, 0x1.0f9e1b4dd36dfp114 },
	   { 0x1.3b82e6ba892a4p111, 0x1.02a8673a94692p114 },
	   { 0x1.2bbc1d878d272p111, 0x1.ec929a665b449p113 },
	   { 0x1.1cb6bc4eaa678p111, 0x1.d4f4b4c8e09edp113 },
	   { 0x1.0e69f27a37df3p111, 0x1.be6abbb10a5aap113 },
	   { 0x1.00cd508511266p111, 0x1.a8e8cc1fadef6p113 },
	   { 0x1.e7b1882bccac5p110, 0x1.94637d5bacfdbp113 },
	   { 0x1.cf09287e48bb9p110, 0x1.80cfdc72220cfp113 },
	   { 0x1.b792bbc489b04p110, 0x1.6e2367dc27f95p113 },
	   { 0x1.a140206ab945p110, 0x1.5c540b4936fd2p113 },
	   { 0x1.8c03d2d39119bp110, 0x1.4b581b8d170fcp113 },
	   { 0x1.77d0e6e5bed21p110, 0x1.3b2652b06c2b2p113 },
	   { 0x1.649b01d73110ap110, 0x1.2bb5cc22e5db6p113 },
	   { 0x1.525654343aad2p110, 0x1.1cfe010e2052dp113 },
	   { 0x1.40f79420887c7p110, 0x1.0ef6c4c84a0fep113 },
	   { 0x1.3073f7cff4a85p110, 0x1.01984165a5f36p113 },
	   { 0x1.20c1303550f0ep110, 0x1.e9b5e8d00ce77p112 },
	   { 0x1.11d563e54f40ep110, 0x1.d16f5716c6c1ap112 },
	   { 0x1.03a72a2bbdc06p110, 0x1.ba4f035d60e03p112 },
	   { 0x1.ec5b0ca2b20f5p109, 0x1.a447b7b03f045p112 },
	   { 0x1.d2bfc6210880ap109, 0x1.8f4ccca7fc90dp112 },
	   { 0x1.ba6c1c6e87c4p109, 0x1.7b5223dac7336p112 },
	   { 0x1.a35068e9c89cfp109, 0x1.684c227fcacefp112 },
	   { 0x1.8d5dbaa383b98p109, 0x1.562fac4329b48p112 },
	   { 0x1.7885ce9f67cdbp109, 0x1.44f21e49054f2p112 },
	   { 0x1.64bb0863504ddp109, 0x1.34894a5e24657p112 },
	   { 0x1.51f06ad20e4c3p109, 0x1.24eb7254ccf83p112 },
	   { 0x1.4019914f0b53ap109, 0x1.160f438c70913p112 },
	   { 0x1.2f2aa92823e8p109, 0x1.07ebd2a2d2844p112 },
	   { 0x1.1f186b432c98bp109, 0x1.f4f12e9ab070ap111 },
	   { 0x1.0fd8160ca94ap109, 0x1.db5ad0b27805cp111 },
	   { 0x1.015f67a552924p109, 0x1.c304efa2c6f4ep111 },
	   { 0x1.e749309831666p108, 0x1.abe09e9144b5ep111 },
	   { 0x1.cd3caa04cdd1bp108, 0x1.95df988e76644p111 },
	   { 0x1.b48774d0f8e45p108, 0x1.80f439b4ee04bp111 },
	   { 0x1.9d189f9f85cbfp108, 0x1.6d11788a69c64p111 },
	   { 0x1.86e0050236315p108, 0x1.5a2adfa0b4bc4p111 },
	   { 0x1.71ce426a561d3p108, 0x1.4834877429b8fp111 },
	   { 0x1.5dd4af79906a9p108, 0x1.37231085c7d9ap111 },
	   { 0x1.4ae555af52cdfp108, 0x1.26eb9daed6f7ep111 },
	   { 0x1.38f2e86f38216p108, 0x1.1783ceac2891p111 },
	   { 0x1.27f0bd5d0e6b1p108, 0x1.08e1badf0fcedp111 },
	   { 0x1.17d2c50b2bfafp108, 0x1.f5f7d88472604p110 },
	   { 0x1.088d83f7e4069p108, 0x1.db92b5212fb8dp110 },
	   { 0x1.f42c17ae0ebf6p107, 0x1.c282cd3957edap110 },
	   { 0x1.d8c3ea48f2889p107, 0x1.aab7abace48dcp110 },
	   { 0x1.beceb1f9f5b3dp107, 0x1.94219bfcb4928p110 },
	   { 0x1.a6399674d366bp107, 0x1.7eb1a2075864ep110 },
	   { 0x1.8ef2a9a18d857p107, 0x1.6a597219a93dap110 },
	   { 0x1.78e8dcd2e6bfdp107, 0x1.570b69502f313p110 },
	   { 0x1.640bf6745325ep107, 0x1.44ba864670882p110 },
	   { 0x1.504c882a97424p107, 0x1.335a62115bce2p110 },
	   { 0x1.3d9be56279ee9p107, 0x1.22df298214423p110 },
	   { 0x1.2bec1a4917edbp107, 0x1.133d96ae7e0ddp110 },
	   { 0x1.1b2fe32991d5cp107, 0x1.046aeabcfcdecp110 },
	   { 0x1.0b5aa42bf5054p107, 0x1.ecb9cfe1d8642p109 },
	   { 0x1.f8c0c2e2ce8dep106, 0x1.d21397ead99cbp109 },
	   { 0x1.dc6b6f1384e18p106, 0x1.b8d094c86d374p109 },
	   { 0x1.c19fa87de37fbp106, 0x1.a0df0f0c626dcp109 },
	   { 0x1.a848df650bea7p106, 0x1.8a2e269750a39p109 },
	   { 0x1.90538b942ea7cp106, 0x1.74adc8f4064d3p109 },
	   { 0x1.79ad1fce5b3d8p106, 0x1.604ea819f007cp109 },
	   { 0x1.6443fdcf0c327p106, 0x1.4d0231928c6f9p109 },
	   { 0x1.50076ad55cc39p106, 0x1.3aba85fe22e2p109 },
	   { 0x1.3ce784b411931p106, 0x1.296a70f414053p109 },
	   { 0x1.2ad53760d7287p106, 0x1.1905613b3abf2p109 },
	   { 0x1.19c232fd50b88p106, 0x1.097f6156f32c5p109 },
	   { 0x1.09a0e254c75ep106, 0x1.f59a20caf6695p108 },
	   { 0x1.f4c8c392fb944p105, 0x1.d9c73698fb1dcp108 },
	   { 0x1.d800ed59bd026p105, 0x1.bf716c6168baep108 },
	   { 0x1.bcd30dfbd611bp105, 0x1.a6852c6b58392p108 },
	   { 0x1.a32923130213fp105, 0x1.8eefd70594a89p108 },
	   { 0x1.8aee4cd06ec1bp105, 0x1.789fb715aae95p108 },
	   { 0x1.740ebfab80eb4p105, 0x1.6383f726a8e04p108 },
	   { 0x1.5e77b6bbd2127p105, 0x1.4f8c96f26a26ap108 },
	   { 0x1.4a1766b6e5e8ap105, 0x1.3caa61607f92p108 },
	   { 0x1.36dcf18a6465cp105, 0x1.2acee2f5ecdb8p108 },
	   { 0x1.24b85a8bf0124p105, 0x1.19ec60b1242edp108 },
	   { 0x1.139a7b37f8475p105, 0x1.09f5cf4dd2877p108 },
	   { 0x1.0374f8792ca97p105, 0x1.f5bd95d8730d8p107 },
	   { 0x1.e87470e4f4246p104, 0x1.d9371e2ff7c35p107 },
	   { 0x1.cbbab18b73217p104, 0x1.be41de54d155ap107 },
	   { 0x1.b0a44aa2f067ep104, 0x1.a4c89e08ef4f3p107 },
	   { 0x1.971a1ec0f40c7p104, 0x1.8cb738399b12cp107 },
	   { 0x1.7f064a8ba8323p104, 0x1.75fa8dbc84becp107 },
	   { 0x1.685414c16188ep104, 0x1.608078a70dcbcp107 },
	   { 0x1.52efdf060cd2p104, 0x1.4c37c0394d094p107 },
	   { 0x1.3ec7176d784b5p104, 0x1.39100d5687bfep107 },
	   { 0x1.2bc82ab9d2302p104, 0x1.26f9df8519bd7p107 },
	   { 0x1.19e277461404p104, 0x1.15e6827001f18p107 },
	   { 0x1.090640946d2d5p104, 0x1.05c803e4831c1p107 },
	   { 0x1.f24946f22d5aep103, 0x1.ed22548cffd35p106 },
	   { 0x1.d45f15b49b35ep103, 0x1.d06ad6ecdf971p106 },
	   { 0x1.b83349fd05191p103, 0x1.b551c847fbc96p106 },
	   { 0x1.9dacb2c432ef4p103, 0x1.9bc09f112b494p106 },
	   { 0x1.84b37e1cbf8ebp103, 0x1.83a1ff0aa239dp106 },
	   { 0x1.6d3126d74b6ccp103, 0x1.6ce1aa3fd7bddp106 },
	   { 0x1.5710631158bffp103, 0x1.576c72b514859p106 },
	   { 0x1.423d13a3b73e1p103, 0x1.43302cc4a0da8p106 },
	   { 0x1.2ea43465e3995p103, 0x1.301ba221dc9bbp106 },
	   { 0x1.1c33cd3c37addp103, 0x1.1e1e857adc568p106 },
	   { 0x1.0adae3e73c2b5p103, 0x1.0d2966b1746f7p106 },
	   { 0x1.f512dd15b73b7p102, 0x1.fa5b4f49cc6b2p105 },
	   { 0x1.d6608dc942687p102, 0x1.dc3ae30b55c16p105 },
	   { 0x1.b9823c51276e1p102, 0x1.bfd7555a3bd68p105 },
	   { 0x1.9e5ce2f93dd76p102, 0x1.a517d9e61628ap105 },
	   { 0x1.84d6fe15b6b93p102, 0x1.8be4f8f6c951fp105 },
	   { 0x1.6cd87746bc76bp102, 0x1.74287ded49339p105 },
	   { 0x1.564a91cd221fp102, 0x1.5dcd669f2cd34p105 },
	   { 0x1.4117d7e2c667dp102, 0x1.48bfd38302871p105 },
	   { 0x1.2d2c0909ebeb9p102, 0x1.34ecf8a3c124ap105 },
	   { 0x1.1a7409475f2f9p102, 0x1.22430f521cbcfp105 },
	   { 0x1.08ddd13bd35e7p102, 0x1.10b1488aeb235p105 },
	   { 0x1.f0b0be22d18e8p101, 0x1.0027c00a263a6p105 },
	   { 0x1.d1a75065a8c74p101, 0x1.e12ee004efc37p104 },
	   { 0x1.b48117843c1c7p101, 0x1.c3e44ae32b16bp104 },
	   { 0x1.99218b8ac7f8ep101, 0x1.a854ea14102a8p104 },
	   { 0x1.7f6dc6010b4adp101, 0x1.8e6761569f45dp104 },
	   { 0x1.674c6ae60d852p101, 0x1.7603bac345f65p104 },
	   { 0x1.50a592e3c968ep101, 0x1.5f1353cdad001p104 },
	   { 0x1.3b62b6aafb0c8p101, 0x1.4980cb3c80949p104 },
	   { 0x1.276e9b681072fp101, 0x1.3537f00b6ad4dp104 },
	   { 0x1.14b54042f445bp101, 0x1.2225b12bffc68p104 },
	   { 0x1.0323ccdc1a3dcp101, 0x1.10380e1adb7e9p104 },
	   { 0x1.e5510173b9a5p100, 0x1.febc107d5efaap103 },
	   { 0x1.c6654733b86adp100, 0x1.df0f2a0ee6947p103 },
	   { 0x1.a964ed354f984p100, 0x1.c14b2188bcee4p103 },
	   { 0x1.8e324c651b064p100, 0x1.a553644f7f07dp103 },
	   { 0x1.74b179d1eba81p100, 0x1.8b0cfce0579ep103 },
	   { 0x1.5cc82d9070d95p100, 0x1.725e7c5dd20f7p103 },
	   { 0x1.465daafca8b1dp100, 0x1.5b2fe547a134p103 },
	   { 0x1.315aaa46df48ep100, 0x1.456a974e92e93p103 },
	   { 0x1.1da9433aebbcfp100, 0x1.30f93c3699078p103 },
	   { 0x1.0b34d93135fcp100, 0x1.1dc7b5b978cf8p103 },
	   { 0x1.f3d41033c44ccp99, 0x1.0bc30c5d52f15p103 },
	   { 0x1.d36d25268cd2bp99, 0x1.f5b2be65a0c7fp102 },
	   { 0x1.b512a1fb1d8fcp99, 0x1.d5f3a8dea7357p102 },
	   { 0x1.98a442fc4fc15p99, 0x1.b82915b03515bp102 },
	   { 0x1.7e03b1cc6d738p99, 0x1.9c3517e789488p102 },
	   { 0x1.651468e010b8ap99, 0x1.81fb7df06136ep102 },
	   { 0x1.4dbb989001d84p99, 0x1.6961b8d641d06p102 },
	   { 0x1.37e00dac4e8b5p99, 0x1.524ec4d916caep102 },
	   { 0x1.236a197bf0b9ap99, 0x1.3cab1343d18d1p102 },
	   { 0x1.10437b1569d7ep99, 0x1.2860757487a01p102 },
	   { 0x1.fcae93fb7323cp98, 0x1.155a09065d4f7p102 },
	   { 0x1.db23c3f816f92p98, 0x1.0384250e4c9fcp102 },
	   { 0x1.bbc1a022c14d4p98, 0x1.e59890b926c78p101 },
	   { 0x1.9e658108af2ep98, 0x1.c642116a8a9e3p101 },
	   { 0x1.82eedbe410407p98, 0x1.a8e405e651ab6p101 },
	   { 0x1.693f22ab61ce9p98, 0x1.8d5f98114f872p101 },
	   { 0x1.5139a5f3661fbp98, 0x1.7397c5a66e307p101 },
	   { 0x1.3ac3788a1b429p98, 0x1.5b71456c5a4c4p101 },
	   { 0x1.25c354b26cb4ep98, 0x1.44d26de513197p101 },
	   { 0x1.122182e9a270fp98, 0x1.2fa31d6371537p101 },
	   { 0x1.ff8f84418d51p97, 0x1.1bcca373b7b43p101 },
	   { 0x1.dd4262aac53e8p97, 0x1.0939ab853339fp101 },
	   { 0x1.bd3474ec16ca5p97, 0x1.efac5187b2863p100 },
	   { 0x1.9f40fd0082b72p97, 0x1.cf1e86235d0e7p100 },
	   { 0x1.8345858c4438dp97, 0x1.b0a68a2128babp100 },
	   { 0x1.6921be96b86b1p97, 0x1.9423165bc4444p100 },
	   { 0x1.50b75c536f927p97, 0x1.7974e743dea3dp100 },
	   { 0x1.39e9f7dcbe479p97, 0x1.607e9eacd105p100 },
	   { 0x1.249ef1c3be817p97, 0x1.4924a74dec729p100 },
	   { 0x1.10bd565b35393p97, 0x1.334d19e0c216p100 },
	   { 0x1.fc5b8748842b2p96, 0x1.1edfa3c5f5ccap100 },
	   { 0x1.d9b4a18a38642p96, 0x1.0bc56f1b54701p100 },
	   { 0x1.b95cede6d524bp96, 0x1.f3d2185e047d9p99 },
	   { 0x1.9b2df77a02225p96, 0x1.d26cb87945e87p99 },
	   { 0x1.7f03b935e8e3ap96, 0x1.b334fac4b9f99p99 },
	   { 0x1.64bc777824f0ep96, 0x1.96076f7918d1cp99 },
	   { 0x1.4c389be9acb83p96, 0x1.7ac2d72fc2c63p99 },
	   { 0x1.355a9387de78cp96, 0x1.614801550319ep99 },
	   { 0x1.2006aeb6bc768p96, 0x1.4979ac8b28927p99 },
	   { 0x1.0c23033e2a376p96, 0x1.333c68e2d0548p99 },
	   { 0x1.f32ea02b55d23p95, 0x1.1e767bce37dd7p99 },
	   { 0x1.d099c5c770f5ap95, 0x1.0b0fc5b6d05ap99 },
	   { 0x1.b05cfe2e99435p95, 0x1.f1e3523b41d7dp98 },
	   { 0x1.92508d0743fc9p95, 0x1.d00de6608effep98 },
	   { 0x1.764f46cf19f9cp95, 0x1.b0778b7b3301bp98 },
	   { 0x1.5c36679625a01p95, 0x1.92fb04ec0f6cfp98 },
	   { 0x1.43e56c3e340a7p95, 0x1.77756ec9f78fap98 },
	   { 0x1.2d3dee1869201p95, 0x1.5dc61922d5a06p98 },
	   { 0x1.182380bd2f494p95, 0x1.45ce65699ff6dp98 },
	   { 0x1.047b91fcb6491p95, 0x1.2f71a5f15997p98 },
	   { 0x1.e45a9790460c1p94, 0x1.1a94ff571654fp98 },
	   { 0x1.c242efeaca76p94, 0x1.071f4bbea09ecp98 },
	   { 0x1.a284cb82c31cep94, 0x1.e9f1ff8ddd774p97 },
	   { 0x1.84f7a1eb7f7f3p94, 0x1.c818223a202c7p97 },
	   { 0x1.697595326d7dcp94, 0x1.a887bd2b4404dp97 },
	   { 0x1.4fdb462549af1p94, 0x1.8b1a336c5eb6bp97 },
	   { 0x1.3807ab51436a8p94, 0x1.6fab63324088ap97 },
	   { 0x1.21dbea9108398p94, 0x1.56197e30205bap97 },
	   { 0x1.0d3b35021d695p94, 0x1.3e44e45301b92p97 },
	   { 0x1.f4154a787cc1bp93, 0x1.281000bfe4c3fp97 },
	   { 0x1.d0623f4f4a28fp93, 0x1.135f28f2d50b4p97 },
	   { 0x1.af2e69a26261p93, 0x1.00187dded5975p97 },
	   { 0x1.904e0b3aa82a3p93, 0x1.dc479de0ef001p96 },
	   { 0x1.73985278fa30ep93, 0x1.bad4fdad3caa1p96 },
	   { 0x1.58e7298af87d9p93, 0x1.9baed3ed27ab8p96 },
	   { 0x1.401708b7e64c6p93, 0x1.7ead9ce4285bbp96 },
	   { 0x1.2906cb94eb40dp93, 0x1.63ac6b4edc88ep96 },
	   { 0x1.139788f2dd663p93, 0x1.4a88be2a6390cp96 },
	   { 0x1.ff58dab4f2a79p92, 0x1.332259185f1ap96 },
	   { 0x1.da552fdd03043p92, 0x1.1d5b1f3793044p96 },
	   { 0x1.b7f1f31b571b6p92, 0x1.0916f04b6e18bp96 },
	   { 0x1.98006c2117e39p92, 0x1.ec77101de6926p95 },
	   { 0x1.7a550f03b145bp92, 0x1.c960bf23153ep95 },
	   { 0x1.5ec74662c5961p92, 0x1.a8bd20fc65ef7p95 },
	   { 0x1.453141082302ap92, 0x1.8a61745ec7d1dp95 },
	   { 0x1.2d6fc2c9e8bcp92, 0x1.6e25d0e756261p95 },
	   { 0x1.1761f87a6dc3dp92, 0x1.53e4f7d1666cbp95 },
	   { 0x1.02e94eb4ac8a5p92, 0x1.3b7c27a7ddb0ep95 },
	   { 0x1.dfd296adef82ap91, 0x1.24caf2c32af14p95 },
	   { 0x1.bc8ed301215ebp91, 0x1.0fb3186804d0fp95 },
	   { 0x1.9bd5efd2c0f15p91, 0x1.f830c0bb41fd7p94 },
	   { 0x1.7d79f2db2d4a5p91, 0x1.d3c0f1a91c846p94 },
	   { 0x1.61500f5293f06p91, 0x1.b1e5acf351d87p94 },
	   { 0x1.47306f04df3d6p91, 0x1.92712d259ce66p94 },
	   { 0x1.2ef5ff0323b28p91, 0x1.7538c60a04476p94 },
	   { 0x1.187e3fb74914dp91, 0x1.5a14b04b47879p94 },
	   { 0x1.03a918225a966p91, 0x1.40dfd87456f4cp94 },
	   { 0x1.e0b15822be4ep90, 0x1.2977b1172b9d5p94 },
	   { 0x1.bce26a2fb7176p90, 0x1.13bc07e891491p94 },
	   { 0x1.9bb1bc445c3c6p90, 0x1.ff1dbb4300811p93 },
	   { 0x1.7cef42e9a617dp90, 0x1.d9a880f306bd8p93 },
	   { 0x1.606e51e0a4963p90, 0x1.b6e45220b55ep93 },
	   { 0x1.460560e841d79p90, 0x1.96a0b33f2c4dap93 },
	   { 0x1.2d8dd47a40ad8p90, 0x1.78b07e9e924acp93 },
	   { 0x1.16e3ca3d4393fp90, 0x1.5ce9ab1670dd2p93 },
	   { 0x1.01e5e8edda47bp90, 0x1.4325167006bbp93 },
	   { 0x1.dcea670907819p89, 0x1.2b3e53538ff3fp93 },
	   { 0x1.b8e9bec48816dp89, 0x1.15137a7f44864p93 },
	   { 0x1.97945aa1c9c35p89, 0x1.0084ff125639dp93 },
	   { 0x1.78b88a4e7107bp89, 0x1.daeb0b7311ec7p92 },
	   { 0x1.5c2827c986b62p89, 0x1.b7937d1c40c53p92 },
	   { 0x1.41b858361b0fep89, 0x1.96d082f59ab06p92 },
	   { 0x1.294150fb19119p89, 0x1.7872d9fa10aadp92 },
	   { 0x1.129e20e732adcp89, 0x1.5c4e8e37bc7dp92 },
	   { 0x1.fb58fa290d436p88, 0x1.423ac0df49a4p92 },
	   { 0x1.d499229819bc6p88, 0x1.2a117230ad284p92 },
	   { 0x1.b0c1a759f7739p88, 0x1.13af4f04f9998p92 },
	   { 0x1.8f9bb6c075486p88, 0x1.fde703724e56p91 },
	   { 0x1.70f4744735c2bp88, 0x1.d77f0c82e7641p91 },
	   { 0x1.549cb0f7ef8e2p88, 0x1.b3ee02611d7ddp91 },
	   { 0x1.3a68a8c1234e1p88, 0x1.92ff33023d5bdp91 },
	   { 0x1.222fc469e8b8cp88, 0x1.7481a9e69f53fp91 },
	   { 0x1.0bcc5fd30f1ddp88, 0x1.5847eda620959p91 },
	   { 0x1.ee3728761897bp87, 0x1.3e27c1fcc74bdp91 },
	   { 0x1.c7fa0c7e3bac7p87, 0x1.25f9ee0b923dcp91 },
	   { 0x1.a4a56eb132a54p87, 0x1.0f9a0686532p91 },
	   { 0x1.8401b5336a8ap87, 0x1.f5cc7718082bp90 },
	   { 0x1.65db58e2358c1p87, 0x1.cf7e53d6a2ca5p90 },
	   { 0x1.4a029a7ea7cd1p87, 0x1.ac0f5f3229372p90 },
	   { 0x1.304b3d1961171p87, 0x1.8b498644847eap90 },
	   { 0x1.188c45630dc53p87, 0x1.6cfa9bcca59dcp90 },
	   { 0x1.029fbd8b92835p87, 0x1.50f411d4fd2cdp90 },
	   { 0x1.dcc4fabf32f1cp86, 0x1.370ab8327af5ep90 },
	   { 0x1.b767ecb334a7ep86, 0x1.1f167f88c6b6ep90 },
	   { 0x1.94ec06c0ff29fp86, 0x1.08f24085d4597p90 },
	   { 0x1.751977e5803d3p86, 0x1.e8f70e181d61ap89 },
	   { 0x1.57bc950253825p86, 0x1.c324c20e337dcp89 },
	   { 0x1.3ca58b816a87fp86, 0x1.a03261574b54ep89 },
	   { 0x1.23a8197d2607ep86, 0x1.7fe903cdf5855p89 },
	   { 0x1.0c9b4b0a6a16fp86, 0x1.6215c58da345p89 },
	   { 0x1.eeb27891d2bb3p85, 0x1.46897d4b69fc6p89 },
	   { 0x1.c77dbfc848866p85, 0x1.2d1877d731b7bp89 },
	   { 0x1.a357936adf17bp85, 0x1.159a386b11517p89 },
	   { 0x1.8203fa7992554p85, 0x1.ffd27ae9393cep88 },
	   { 0x1.634b7f56b0a5cp85, 0x1.d7c593130dd0bp88 },
	   { 0x1.46fada7e6a5fep85, 0x1.b2cd607c79bcfp88 },
	   { 0x1.2ce2a3690576bp85, 0x1.90ae4d3405651p88 },
	   { 0x1.14d707280e6cfp85, 0x1.71312dd1759e2p88 },
	   { 0x1.fd5f08ad2b29ap84, 0x1.5422ef5d8949dp88 },
	   { 0x1.d48d57f7718b7p84, 0x1.39544b0ecc957p88 },
	   { 0x1.aef3ce0add578p84, 0x1.20997f73e73ddp88 },
	   { 0x1.8c52800f939c8p84, 0x1.09ca0eaacd277p88 },
	   { 0x1.6c6e61e57bf9bp84, 0x1.e9810295890ecp87 },
	   { 0x1.4f10e8ebc44a9p84, 0x1.c2b45b5aa4a1dp87 },
	   { 0x1.3407b59d72a5bp84, 0x1.9eee068fa7596p87 },
	   { 0x1.1b2443858c0a1p84, 0x1.7df2b399c10a8p87 },
	   { 0x1.043b9f1621ff3p84, 0x1.5f8b87a31bd85p87 },
	   { 0x1.de4c41eb96b45p83, 0x1.4385c96e9a2d9p87 },
	   { 0x1.b77e5cbd5d147p83, 0x1.29b2933ef4cbcp87 },
	   { 0x1.93c9fc62bfb11p83, 0x1.11e68a6378f8ap87 },
	   { 0x1.72f0c4c8e9bffp83, 0x1.f7f338086a86bp86 },
	   { 0x1.54b92affb11afp83, 0x1.cf8d7d9ce040ap86 },
	   { 0x1.38ee17b150182p83, 0x1.aa577251ae485p86 },
	   { 0x1.1f5e908f70e0cp83, 0x1.8811d739efb5fp86 },
	   { 0x1.07dd6833bb38p83, 0x1.68823e52970bep86 },
	   { 0x1.e481e7f6ac4bcp82, 0x1.4b72ae68e8b4cp86 },
	   { 0x1.bcc58edad5559p82, 0x1.30b14dbe876bcp86 },
	   { 0x1.983ee9896d582p82, 0x1.181012ef8661p86 },
	   { 0x1.76aca47764427p82, 0x1.01647ba798745p86 },
	   { 0x1.57d287836bd3dp82, 0x1.d90e917701675p85 },
	   { 0x1.3b79118c097a1p82, 0x1.b2a87e86d0c8ap85 },
	   { 0x1.216d1b97279a9p82, 0x1.8f53dcb377293p85 },
	   { 0x1.097f82fc04025p82, 0x1.6ed2f2515e933p85 },
	   { 0x1.e709b415656dp81, 0x1.50ecc9ed47f19p85 },
	   { 0x1.beaa3d6c15504p81, 0x1.356cd5ce7799ep85 },
	   { 0x1.9996ed9b83967p81, 0x1.1c229a587ab78p85 },
	   { 0x1.778be2bd9795bp81, 0x1.04e15ecc7f3f6p85 },
	   { 0x1.584a99af8a842p81, 0x1.deffc7e6a6017p84 },
	   { 0x1.3b99832cbefddp81, 0x1.b7b040832f31p84 },
	   { 0x1.2143a112d0466p81, 0x1.938e021f36d76p84 },
	   { 0x1.09182b326b229p81, 0x1.7258610b3b233p84 },
	   { 0x1.e5d47637f5db5p80, 0x1.53d3bfc82a909p84 },
	   { 0x1.bd20fcc3b76d7p80, 0x1.37c92babdc2fdp84 },
	   { 0x1.97c9dda748fc7p80, 0x1.1e06010120f6ap84 },
	   { 0x1.7589207e91ad1p80, 0x1.065b9616170d4p84 },
	   { 0x1.561e669aa7fdbp80, 0x1.e13dd96b3753bp83 },
	   { 0x1.394e7a2ac9fc7p80, 0x1.b950d32467392p83 },
	   { 0x1.1ee2e61eccc99p80, 0x1.94a72263259a5p83 },
	   { 0x1.06a996198f06fp80, 0x1.72fd93e036cdcp83 },
	   { 0x1.e0e8fbad2703ep79, 0x1.54164576929abp83 },
	   { 0x1.b8328ee330ae9p79, 0x1.37b83c521fe96p83 },
	   { 0x1.92e21013a767p79, 0x1.1daf033182e96p83 },
	   { 0x1.70aff489136ebp79, 0x1.05ca50205d26ap83 },
	   { 0x1.515a7c77fab48p79, 0x1.dfbb6235639fap82 },
	   { 0x1.34a53ce0bbb6fp79, 0x1.b7807e294781fp82 },
	   { 0x1.1a58b2b09fdcbp79, 0x1.9298add70a734p82 },
	   { 0x1.0241de6c31e5bp79, 0x1.70beaf9c7ffb6p82 },
	   { 0x1.d863cf753825cp78, 0x1.51b2cd6709222p82 },
	   { 0x1.affb906d0ae09p78, 0x1.353a6cf7f7fffp82 },
	   { 0x1.8afbf9e9520c2p78, 0x1.1b1fa8cbe84a7p82 },
	   { 0x1.691c7c768becep78, 0x1.0330f0fd69921p82 },
	   { 0x1.4a1a79df39cdep78, 0x1.da81670f96f9bp81 },
	   { 0x1.2db8ca9009091p78, 0x1.b24a16b4d09aap81 },
	   { 0x1.13bf4cb384e4ap78, 0x1.8d6eeb6efdbd6p81 },
	   { 0x1.f7f4f88751db4p77, 0x1.6ba91ac734786p81 },
	   { 0x1.cc7626bced452p77, 0x1.4cb7966770ab5p81 },
	   { 0x1.a4ab6470c1c5cp77, 0x1.305e9721d0981p81 },
	   { 0x1.80451c2811052p77, 0x1.1667311fff70ap81 },
	   { 0x1.5efa4d64f59f6p77, 0x1.fd3de10d62855p80 },
	   { 0x1.40880373ed74p77, 0x1.d1aefbcd48d0cp80 },
	   { 0x1.24b0d7368076ep77, 0x1.a9cc93c25aca9p80 },
	   { 0x1.0b3c7b0d960fp77, 0x1.85487ee3ea735p80 },
	   { 0x1.e7eea02e4ed88p76, 0x1.63daf8b4b1e0cp80 },
	   { 0x1.bd6408059b696p76, 0x1.45421e69a6ca1p80 },
	   { 0x1.96826d9e90341p76, 0x1.294175802d99ap80 },
	   { 0x1.72fa4fa12d516p76, 0x1.0fa17bf41068fp80 },
	   { 0x1.5282d2d5803fep76, 0x1.f05e82aae2bb9p79 },
	   { 0x1.34d935f1be064p76, 0x1.c578101b29058p79 },
	   { 0x1.19c050c56d0d7p76, 0x1.9e39dc5dd2f7cp79 },
	   { 0x1.01001dd9c7ccep76, 0x1.7a553a728bbf2p79 },
	   { 0x1.d4ca9b634ecbap75, 0x1.5982008db1304p79 },
	   { 0x1.ab81c5c80cf39p75, 0x1.3b7e00422e51bp79 },
	   { 0x1.85cfacb7477f2p75, 0x1.200c898d9ee3ep79 },
	   { 0x1.6365862923eb9p75, 0x1.06f5f7eb65a56p79 },
	   { 0x1.43fb317b5dc37p75, 0x1.e00e9148a1d25p78 },
	   { 0x1.274ea96044bd7p75, 0x1.b623734024e92p78 },
	   { 0x1.0d23817479c67p75, 0x1.8fd4e01891bf8p78 },
	   { 0x1.ea84dd159259p74, 0x1.6cd44c7470d89p78 },
	   { 0x1.bef1b1a12823ep74, 0x1.4cd9c04158cd7p78 },
	   { 0x1.9730edfda64acp74, 0x1.2fa34bf5c8344p78 },
	   { 0x1.72ede3b7eaa25p74, 0x1.14f4890ff2461p78 },
	   { 0x1.51db1ec3a3087p74, 0x1.f92c49dfa4df5p77 },
	   { 0x1.33b1c9d1576ecp74, 0x1.ccaaea71ab0dfp77 },
	   { 0x1.18311f8a03acap74, 0x1.a40829f001197p77 },
	   { 0x1.fe3bcf4629feap73, 0x1.7eef13b59e96cp77 },
	   { 0x1.d083fda665164p73, 0x1.5d11e1a252bf5p77 },
	   { 0x1.a6d7d18831888p73, 0x1.3e296303b2297p77 },
	   { 0x1.80dcd6603df1bp73, 0x1.21f47009f43cep77 },
	   { 0x1.5e4062d5b6a4ep73, 0x1.083768c5e4542p77 },
	   { 0x1.3eb6ef47c2758p73, 0x1.e1777d831265fp76 },
	   { 0x1.21fb7a81c5444p73, 0x1.b69f10b0191b5p76 },
	   { 0x1.07cefb734d68bp73, 0x1.8f8a3a05b5b53p76 },
	   { 0x1.dfefbdb19ac7ep72, 0x1.6be573c40c8e7p76 },
	   { 0x1.b4831fb12344p72, 0x1.4b645ba991fdbp76 },
	   { 0x1.8cf81557d20b6p72, 0x1.2dc119095729fp76 },
	   { 0x1.68f6f0feb4755p72, 0x1.12bbcfa4d62dep76 },
	   { 0x1.482fa78c40635p72, 0x1.f4343c7d504b9p75 },
	   { 0x1.2a59289a484fbp72, 0x1.c74d4fe1e0e8bp75 },
	   { 0x1.0f30c4d0be5cp72, 0x1.9e614ecbf4af6p75 },
	   { 0x1.ecf3428c48d4fp71, 0x1.791716475420cp75 },
	   { 0x1.bff86d9ec8499p71, 0x1.571d34563050ap75 },
	   { 0x1.970bb87f4ae14p71, 0x1.3829407a207d8p75 },
	   { 0x1.71d0b55b79b86p71, 0x1.1bf74244aed5ap75 },
	   { 0x1.4ff315d036fbdp71, 0x1.024924c7520d1p75 },
	   { 0x1.3125f6a3d257p71, 0x1.d5cc6ba567f29p74 },
	   { 0x1.15233ae8815f2p71, 0x1.ab3560167ccaap74 },
	   { 0x1.f755ea760487dp70, 0x1.846e9dda7a163p74 },
	   { 0x1.c905bbd9ab5a6p70, 0x1.6121d7db32bddp74 },
	   { 0x1.9eebaa0589b4ep70, 0x1.410047ead6894p74 },
	   { 0x1.78a6de0f41b89p70, 0x1.23c2090cdde78p74 },
	   { 0x1.55df1790f2f61p70, 0x1.09257fca001cp74 },
	   { 0x1.3643ec463a3cfp70, 0x1.e1dd9ec677783p73 },
	   { 0x1.198c18435598dp70, 0x1.b5ceb5a13221bp73 },
	   { 0x1.fee9bab9f4e14p69, 0x1.8dbaa11de2037p73 },
	   { 0x1.cf82e0eb6196bp69, 0x1.694680a9a3ee6p73 },
	   { 0x1.a474e7029a919p69, 0x1.481f73b3778e8p73 },
	   { 0x1.7d5af6513e2bep69, 0x1.29f9e7d8fd094p73 },
	   { 0x1.59d93e1d8f57dp69, 0x1.0e90f64b5b103p73 },
	   { 0x1.399c279e4699ap69, 0x1.eb4b9e47b58c9p72 },
	   { 0x1.1c579bbca6885p69, 0x1.bdfe62f60dd7p72 },
	   { 0x1.01c659160612dp69, 0x1.94d1de5c4576fp72 },
	   { 0x1.d352b1ae2694p68, 0x1.6f66f6ab90c3cp72 },
	   { 0x1.a78e8252c204dp68, 0x1.4d67050b31c2ap72 },
	   { 0x1.7fd7c80f3410ep68, 0x1.2e8318008cf89p72 },
	   { 0x1.5bcf92cc55d86p68, 0x1.1273463a1589bp72 },
	   { 0x1.3b1f876b10da7p68, 0x1.f1ec20afad0e2p71 },
	   { 0x1.1d791bb1324a1p68, 0x1.c39fa0d4a5a2bp71 },
	   { 0x1.0294e37abcee8p68, 0x1.99946bf7e02a1p71 },
	   { 0x1.d463db5fa3c13p67, 0x1.73679b24aeb9bp71 },
	   { 0x1.a82a5f4047a5bp67, 0x1.50bf2558ab78fp71 },
	   { 0x1.8011fb05fe09p67, 0x1.314916abfa1eap71 },
	   { 0x1.5bb91decf8a58p67, 0x1.14bad9006f53bp71 },
	   { 0x1.3ac71ce35c1d3p67, 0x1.f5a1196b5bb2ep70 },
	   { 0x1.1ceb656955c59p67, 0x1.c698e001f6d3p70 },
	   { 0x1.01dcc2acf7755p67, 0x1.9beca74b0f147p70 },
	   { 0x1.d2b166911c178p66, 0x1.753637caac6d9p70 },
	   { 0x1.a6459c5b11342p66, 0x1.5218993857afcp70 },
	   { 0x1.7e086accc805dp66, 0x1.323f3f19cff3ep70 },
	   { 0x1.59962aef547b3p66, 0x1.155d47fdb9c94p70 },
	   { 0x1.3894608650edep66, 0x1.f6599b70323cap69 },
	   { 0x1.1ab0e4d284f44p66, 0x1.c6dc8a4bb3ba6p69 },
	   { 0x1.ff4248ebb8299p65, 0x1.9bcfd83a431e9p69 },
	   { 0x1.ce42dd8e4fa23p65, 0x1.74ca889bbacd5p69 },
	   { 0x1.a1e8aa1400997p65, 0x1.516d33e26c04p69 },
	   { 0x1.79c430435a7fcp65, 0x1.31612a7ef535fp69 },
	   { 0x1.557046eb39249p65, 0x1.1457ab75c2489p69 },
	   { 0x1.349127b59b217p65, 0x1.f41259c9550cp68 },
	   { 0x1.16d392dff5104p65, 0x1.c46969ca99a2ep68 },
	   { 0x1.f7d80dc993f2fp64, 0x1.993e82b76e726p68 },
	   { 0x1.c72c149cb214bp64, 0x1.72267ac1b25ap68 },
	   { 0x1.9b270c24cc8fap64, 0x1.4ec0062aeeb78p68 },
	   { 0x1.73585df7b6643p64, 0x1.2eb2d18a2081bp68 },
	   { 0x1.4f59f9910367ep64, 0x1.11aeb0b11d1a1p68 },
	   { 0x1.2ecf5b7f6abe3p64, 0x1.eed5c0bbf1061p67 },
	   { 0x1.1164ab45aa235p64, 0x1.bf4ab21b4f3fp67 },
	   { 0x1.ed9bdbc6f1b0ap63, 0x1.944462d4d5991p67 },
	   { 0x1.bd8c96533b39bp63, 0x1.6d561de54f6a1p67 },
	   { 0x1.921ec84d5860ep63, 0x1.4a1d472804fc8p67 },
	   { 0x1.6ae172414cebap63, 0x1.2a406e25fcb44p67 },
	   { 0x1.476e3b661be8cp63, 0x1.0d6e7662dda9dp67 },
	   { 0x1.276873924f0b4p63, 0x1.e6bba6770e22dp66 },
	   { 0x1.0a7c2c9322f59p63, 0x1.b797ab2ba22d2p66 },
	   { 0x1.e0bad18c4e37dp62, 0x1.8cf813910fdcdp66 },
	   { 0x1.b18eba0be4d24p62, 0x1.666f488db6e0ap66 },
	   { 0x1.86f7884e1caadp62, 0x1.4399f7770045fp66 },
	   { 0x1.608484d592328p62, 0x1.241e1ebbbf4ecp66 },
	   { 0x1.3dcfaee52a8f5p62, 0x1.07aa30ce6a5ap66 },
	   { 0x1.1e7cbac093f27p62, 0x1.dbe8969a24c6fp65 },
	   { 0x1.023827dc88ed9p62, 0x1.ad7301258d788p65 },
	   { 0x1.d16cd999791c3p61, 0x1.837a640fa9d3dp65 },
	   { 0x1.a3666de0788bp61, 0x1.5d90f358d61f6p65 },
	   { 0x1.79e17816df1e8p61, 0x1.3b5342f7be9cp65 },
	   { 0x1.546e385224d1p61, 0x1.1c674ecd152d3p65 },
	   { 0x1.32a7a483e977bp61, 0x1.007b997a0b531p65 },
	   { 0x1.1432649c86c4dp61, 0x1.ce8cc007a6432p64 },
	   { 0x1.f177ce0bd5836p60, 0x1.a109c0bccbc39p64 },
	   { 0x1.bff3166bc36eep60, 0x1.77f5624913c3ap64 },
	   { 0x1.934fc0975fb3p60, 0x1.52e251d5d3b1fp64 },
	   { 0x1.6b13ebb9a5ad4p60, 0x1.316da780bc4d9p64 },
	   { 0x1.46d17a80cc174p60, 0x1.133deb1d3526p64 },
	   { 0x1.2624f3a0a887p60, 0x1.f00460b24acf8p63 },
	   { 0x1.08b47d7733cb6p60, 0x1.bee2903d584f9p63 },
	   { 0x1.dc5de496b181p59, 0x1.92920a7c80e26p63 },
	   { 0x1.ac9615b3c9fd7p59, 0x1.6a9b25345c773p63 },
	   { 0x1.818d3a356669ep59, 0x1.4691b26b9c82fp63 },
	   { 0x1.5acbdab2ed713p59, 0x1.2613e9610f6d1p63 },
	   { 0x1.37e61fd4c0fep59, 0x1.08c969adf0beap63 },
	   { 0x1.187ab3d71db11p59, 0x1.dcc4ac4f59be5p62 },
	   { 0x1.f8637ea4e52acp58, 0x1.ad2d0a9a18288p62 },
	   { 0x1.c577fd709b099p58, 0x1.82498a7cc94b9p62 },
	   { 0x1.97a3dc62119c8p58, 0x1.5ba462dee8a02p62 },
	   { 0x1.6e66137bb7ccap58, 0x1.38d330d8806ap62 },
	   { 0x1.494a3f6a9a70ep58, 0x1.1975e0627306cp62 },
	   { 0x1.27e767bb79ea2p58, 0x1.fa6b5ee8f3088p61 },
	   { 0x1.09dee32687729p58, 0x1.c78892308bd9p61 },
	   { 0x1.ddb6ae2f39381p57, 0x1.99b5ec6741cb3p61 },
	   { 0x1.ad1f9fba4b2abp57, 0x1.7073c400e10dcp61 },
	   { 0x1.816dde4c11ca3p57, 0x1.4b4ee0b3a84d6p61 },
	   { 0x1.5a245d5e5289cp57, 0x1.29df4862ac231p61 },
	   { 0x1.36d26a686daafp57, 0x1.0bc7294e0cbafp61 },
	   { 0x1.171277cbbce9cp57, 0x1.e163bd8df864p60 },
	   { 0x1.f5120b45c00e6p56, 0x1.b0a61bce91993p60 },
	   { 0x1.c1c74b30d0bbp56, 0x1.84cbb00f925fp60 },
	   { 0x1.93b02e5cf0324p56, 0x1.5d5841ce6cb73p60 },
	   { 0x1.6a46f43f3118cp56, 0x1.39dbcd485dd07p60 },
	   { 0x1.45132973bb79bp56, 0x1.19f153b38a108p60 },
	   { 0x1.23a85891dc72bp56, 0x1.fa7b9159fc471p59 },
	   { 0x1.05a4dba466c4ep56, 0x1.c6de3429e31fap59 },
	   { 0x1.d561964307dc4p55, 0x1.98769faac8a1bp59 },
	   { 0x1.a4fa0f13737e8p55, 0x1.6ebf82977acfp59 },
	   { 0x1.7984b636ad1bep55, 0x1.4940bc89fa5aap59 },
	   { 0x1.5281628cb373ap55, 0x1.278e135bcf0a4p59 },
	   { 0x1.2f7cc38bc628dp55, 0x1.0946088b6f8edp59 },
	   { 0x1.100f1aef8eaf5p55, 0x1.dc21972b9e9f4p58 },
	   { 0x1.e7b62ce66acdep54, 0x1.ab3e8cfada51ap58 },
	   { 0x1.b5198cf325114p54, 0x1.7f5483f729c27p58 },
	   { 0x1.87b15da6677afp54, 0x1.57e33e2b1c6dap58 },
	   { 0x1.5ef5de2e68985p54, 0x1.3477480d89e25p58 },
	   { 0x1.3a6d00852a688p54, 0x1.14a8b54629fb2p58 },
	   { 0x1.19a90b14f53afp54, 0x1.f033fa073d52p57 },
	   { 0x1.f88eba04114cbp53, 0x1.bcede5acc0d4p57 },
	   { 0x1.c3dea36b87937p53, 0x1.8ee7b29d0b081p57 },
	   { 0x1.94a28136fa731p53, 0x1.659917bbb6632p57 },
	   { 0x1.6a4b2c9663fa1p53, 0x1.40877b79cd868p57 },
	   { 0x1.44580945b8452p53, 0x1.1f44979177348p57 },
	   { 0x1.22558f1aa9f03p53, 0x1.016d3f035816p57 },
	   { 0x1.03dbf8db89298p53, 0x1.cd508600d0ba8p56 },
	   { 0x1.d11c2965639f6p52, 0x1.9d4ae77a21604p56 },
	   { 0x1.a03065db54a4bp52, 0x1.723974e9529d8p56 },
	   { 0x1.745e6013d8cf3p52, 0x1.4b9a944f57915p56 },
	   { 0x1.4d1f2eb8531p52, 0x1.28f9c9b769ee3p56 },
	   { 0x1.29f9b7c4f56dfp52, 0x1.09ee66b6e99e9p56 },
	   { 0x1.0a814a1dfc5edp52, 0x1.dc34b6999ff72p55 },
	   { 0x1.dca8b63e38fa9p51, 0x1.aa5249b4cca57p55 },
	   { 0x1.aa36c9242f8bcp51, 0x1.7d9db080918bap55 },
	   { 0x1.7d0fbfa6c3c19p51, 0x1.558e88e8945efp55 },
	   { 0x1.54a6b679dd96fp51, 0x1.31aa564e92066p55 },
	   { 0x1.307d4e71272d7p51, 0x1.11831a9c3763dp55 },
	   { 0x1.1022313b11381p51, 0x1.e96c265c21fbfp54 },
	   { 0x1.e65f78e13edcdp50, 0x1.b5d52c19374fep54 },
	   { 0x1.b2959e487c93fp50, 0x1.87a2188252d5fp54 },
	   { 0x1.84436cf62b6f8p50, 0x1.5e440cc8caaf9p54 },
	   { 0x1.5ad66c67f3f63p50, 0x1.393ad199301dep54 },
	   { 0x1.35cb549c616ebp50, 0x1.18135a0647102p54 },
	   { 0x1.14ac7e9322a1ap50, 0x1.f4ccd98eab06bp53 },
	   { 0x1.ee20fae75a2c5p49, 0x1.bfaedff2748c1p53 },
	   { 0x1.b931b883c77f2p49, 0x1.9026a7e3c9538p53 },
	   { 0x1.89e1f8e1d4be6p49, 0x1.659f3419269eep53 },
	   { 0x1.5f9a24050e89fp49, 0x1.3f92e9472ca4cp53 },
	   { 0x1.39d2746cbe57fp49, 0x1.1d89fb6602df9p53 },
	   { 0x1.18115431b6c4ap49, 0x1.fe32077e095c4p52 },
	   { 0x1.f3d3ca19edf64p48, 0x1.c7bf775863df5p52 },
	   { 0x1.bdf55dd9bdcep48, 0x1.970fb0b5580dcp52 },
	   { 0x1.8dd8e25d2255dp48, 0x1.6b88087e4af9fp52 },
	   { 0x1.62e225ebca19p48, 0x1.449de67f2c6b2p52 },
	   { 0x1.3c855ef212badp48, 0x1.21d51dc348d4dp52 },
	   { 0x1.1a4576cd5cddcp48, 0x1.02be7023a443ep52 },
	   { 0x1.f765035c713d8p47, 0x1.cdec7155697e1p51 },
	   { 0x1.c0d0bdeb46ae2p47, 0x1.9c4671c1a6e3cp51 },
	   { 0x1.901afbd3819bep47, 0x1.6feb0af26f865p51 },
	   { 0x1.64a386137b955p47, 0x1.484b1e63b3be4p51 },
	   { 0x1.3ddb15521ce49p47, 0x1.24e68a1458bd7p51 },
	   { 0x1.1b418ba2217c6p47, 0x1.054a9a7c2f05ap51 },
	   { 0x1.f8c8bad8e2a2p46, 0x1.d2214ad33ca5ep50 },
	   { 0x1.c1ba4950b8f4fp46, 0x1.9fb9933adac68p50 },
	   { 0x1.90a0b40dd690cp46, 0x1.72b99eccc462ep50 },
	   { 0x1.64d860502b279p46, 0x1.4a8e4dbe3539cp50 },
	   { 0x1.3dcf1aadc099dp46, 0x1.26b4018ef81f7p50 },
	   { 0x1.1b02414a73357p46, 0x1.06b4fe82cc6aep50 },
	   { 0x1.f7fa3e4bec2aep45, 0x1.d44feffb34893p49 },
	   { 0x1.c0aee6d6b1406p45, 0x1.a15d86bb23572p49 },
	   { 0x1.8f684065398bfp45, 0x1.73ea5ac0d71a9p49 },
	   { 0x1.637ff9397e989p45, 0x1.4b5fdd0f567fap49 },
	   { 0x1.3c618d3c706ebp45, 0x1.2737769828878p49 },
	   { 0x1.1988625955723p45, 0x1.06f8da87263cep49 },
	   { 0x1.f4fc2f6d50e41p44, 0x1.d4710a9e149edp48 },
	   { 0x1.bdb204ff1cda3p44, 0x1.a12cc7b1bf616p48 },
	   { 0x1.8c75a6fa17116p44, 0x1.73793d6253bd7p48 },
	   { 0x1.609ec277b8703p44, 0x1.4abd0af44c7f8p48 },
	   { 0x1.399725d96eb63p44, 0x1.266f2e981ccfbp48 },
	   { 0x1.16d8d1241b86bp44, 0x1.06154a07d21a2p48 },
	   { 0x1.efd875a51d28dp43, 0x1.d2842b40e25fp47 },
	   { 0x1.b8cd873c4de72p43, 0x1.9f27fa465d061p47 },
	   { 0x1.87d2a89e5ac65p43, 0x1.7167c3937ded9p47 },
	   { 0x1.5c3e42539c769p43, 0x1.48a7fb96552cap47 },
	   { 0x1.35791e04cd29fp43, 0x1.245dcbaa25b1bp47 },
	   { 0x1.12fc6cdafd10dp43, 0x1.040d4ab2de626p47 },
	   { 0x1.e8a0077a1ed47p42, 0x1.ce8fcb8dadc2cp46 },
	   { 0x1.b2118f75a4eb7p42, 0x1.9b55e7c11d9e6p46 },
	   { 0x1.818e8b1c2616fp42, 0x1.6dbce02ec5c77p46 },
	   { 0x1.566cdf4525ebp42, 0x1.4527acab6dfebp46 },
	   { 0x1.3014fd204bc71p42, 0x1.210a3ddcb4706p46 },
	   { 0x1.0dffe0bfc0c74p42, 0x1.00e7aba6527c9p46 },
	   { 0x1.df6a8d5e14f11p41, 0x1.c8a12a152d814p45 },
	   { 0x1.a9942579915cdp41, 0x1.95c35893651c9p45 },
	   { 0x1.79bdc576e403ap41, 0x1.6884d52cc9914p45 },
	   { 0x1.4f3d9114d799bp41, 0x1.4047ce663f641p45 },
	   { 0x1.297c4e6eb62fcp41, 0x1.1c7f9c74f3e7cp45 },
	   { 0x1.07f35ef1a4fcp41, 0x1.f95dcee779f74p44 },
	   { 0x1.d455e0a3b0d94p40, 0x1.c0cc007cc808ep44 },
	   { 0x1.9f70bf04a77cep40, 0x1.8e82cd2a6133cp44 },
	   { 0x1.707990a8defefp40, 0x1.61d0ef76712e4p44 },
	   { 0x1.46c779ebb14aep40, 0x1.3a1882865d26ep44 },
	   { 0x1.21c4420bc9879p40, 0x1.16cce86450b2p44 },
	   { 0x1.00ea48df1e7fbp40, 0x1.eee1d41e1e516p43 },
	   { 0x1.c7856a7693627p39, 0x1.b72a1658393d4p43 },
	   { 0x1.93c7abef59a2cp39, 0x1.85ac17b553c4fp43 },
	   { 0x1.65df602b1e0ffp39, 0x1.59b72775450f3p43 },
	   { 0x1.3d256a5ee461dp39, 0x1.32ae03812fcp43 },
	   { 0x1.19053bac5f645p39, 0x1.1004b9cd4bae6p43 },
	   { 0x1.f1f58fe66e142p38, 0x1.e27d88d5289bfp42 },
	   { 0x1.b9216793da422p38, 0x1.abdab3fb224cep42 },
	   { 0x1.86bd6adace04ep38, 0x1.7b5bd9f52a89ep42 },
	   { 0x1.5a104640aeb74p38, 0x1.5051a941eb13p42 },
	   { 0x1.32755417b50ddp38, 0x1.2a20366f6a0dep42 },
	   { 0x1.0f5a5274f5c45p38, 0x1.083cdb1163405p42 },
	   { 0x1.e07ab300dc4b9p37, 0x1.d458a013d18b4p41 },
	   { 0x1.a956163a49613p37, 0x1.9f01f97b2e043p41 },
	   { 0x1.7879eb52380edp37, 0x1.6fb2eaf7d8102p41 },
	   { 0x1.4d30488394e18p37, 0x1.45be480207b14p41 },
	   { 0x1.26d7af2869fc5p37, 0x1.208a2b041836ep41 },
	   { 0x1.04e0c593552f5p37, 0x1.ff1ba8cbc9c8dp40 },
	   { 0x1.cd98a274acae3p36, 0x1.c49f8a8ec4aebp40 },
	   { 0x1.9852d44d7528bp36, 0x1.90c81ede57558p40 },
	   { 0x1.6927c2c3e497p36, 0x1.62d5a948b6358p40 },
	   { 0x1.3f65a98c177c9p36, 0x1.3a1de0952fd2bp40 },
	   { 0x1.1a6ed66936eeap36, 0x1.16098d4b94692p40 },
	   { 0x1.f36ed3084aa81p35, 0x1.ec24d6a8bc072p39 },
	   { 0x1.b986ab7ebdd54p35, 0x1.b3828ebcc128bp39 },
	   { 0x1.864933f3c0573p35, 0x1.8158a3038115ep39 },
	   { 0x1.58f359f0c4e8fp35, 0x1.54eb3e9a3e72bp39 },
	   { 0x1.30d82cb8a968cp35, 0x1.2d93b0174f61ap39 },
	   { 0x1.0d5e5f59de7c1p35, 0x1.0abe0d45fd5c2p39 },
	   { 0x1.dbfc240ab5f81p34, 0x1.d7ce33a39bd89p38 },
	   { 0x1.a47db588b15cfp34, 0x1.a134d30d655e4p38 },
	   { 0x1.736c0d0a31187p34, 0x1.70e16f315ef4p38 },
	   { 0x1.480a1879e8f57p34, 0x1.461cda38e2783p38 },
	   { 0x1.21b0591ce1cfdp34, 0x1.2044a2faebb7bp38 },
	   { 0x1.ff94e3fca1752p33, 0x1.fd91813f8cc8cp37 },
	   { 0x1.c3a9f9558ffap33, 0x1.c2530177987fep37 },
	   { 0x1.8eb738c76b2f2p33, 0x1.8deb61106f334p37 },
	   { 0x1.5fee91a43fef1p33, 0x1.5f91f55e86346p37 },
	   { 0x1.3699940a6a811p33, 0x1.3694e7b13691bp37 },
	   { 0x1.1216c07263dep33, 0x1.1256a18de488bp37 },
	   { 0x1.e3ae49fef5535p32, 0x1.e49705a5ebd5fp36 },
	   { 0x1.aab87fb8e4441p32, 0x1.abefb3186e784p36 },
	   { 0x1.786c3dca158c4p32, 0x1.79dc285401b7dp36 },
	   { 0x1.4c036b7451223p32, 0x1.4d9a4f359ba1ep36 },
	   { 0x1.24cec8453db03p32, 0x1.267e46fd85893p36 },
	   { 0x1.02334e92993b9p32, 0x1.03efdea0a0506p36 },
	   { 0x1.c74fc41217dfbp31, 0x1.cad0afbb569b1p35 },
	   { 0x1.9166837399532p31, 0x1.94e0d5e7a8744p35 },
	   { 0x1.61d46c11dd916p31, 0x1.653d077d9eefp35 },
	   { 0x1.37dbe7711fcd4p31, 0x1.3b2a639494566p35 },
	   { 0x1.12d55c1e73c65p31, 0x1.16038b4af0a0ep35 },
	   { 0x1.e4594b115943bp30, 0x1.ea6c598920c48p34 },
	   { 0x1.aabdabdb93484p30, 0x1.b081aaf25ade1p34 },
	   { 0x1.77f073eb945dfp30, 0x1.7d62079a4e4a6p34 },
	   { 0x1.4b252d0bc8bebp30, 0x1.5042e1a8664edp34 },
	   { 0x1.23a7345c57ccap30, 0x1.287117d29a9e6p34 },
	   { 0x1.00d6f8a57f06ep30, 0x1.054e44f8ee735p34 },
	   { 0x1.c44f136cf3bd8p29, 0x1.cc9cbc5fe04a8p33 },
	   { 0x1.8e38df2790b7ap29, 0x1.95eb2cb828067p33 },
	   { 0x1.5e8f828661e21p29, 0x1.65acfefcd0029p33 },
	   { 0x1.3490e7e2bc31cp29, 0x1.3b20c56ad84f5p33 },
	   { 0x1.0f91b7ff9bb2ap29, 0x1.159b917beb87ap33 },
	   { 0x1.ddf56913a541ep28, 0x1.e90cb5cac7057p32 },
	   { 0x1.a48cc1b8a7bc7p28, 0x1.aeb7659e5f7efp32 },
	   { 0x1.71fde01e2ca8cp28, 0x1.7b4b752e86e5fp32 },
	   { 0x1.4578e0b906b32p28, 0x1.4df8ace15322ep32 },
	   { 0x1.1e4659a2a2156p28, 0x1.26072a17961ap32 },
	   { 0x1.f788fc218597bp27, 0x1.02d48c75e7d9bp32 },
	   { 0x1.bac92daac0b9dp27, 0x1.c7a2ecd5f05ap31 },
	   { 0x1.85518c3484796p27, 0x1.90feaede7f2aep31 },
	   { 0x1.56441b55bfff1p27, 0x1.60dcef1cedc3ap31 },
	   { 0x1.2cdd203ab43a1p27, 0x1.36787980e7387p31 },
	   { 0x1.08700c199ad4fp27, 0x1.112346e13dd7ep31 },
	   { 0x1.d0c9857c390f3p26, 0x1.e087915129a98p30 },
	   { 0x1.986a650394095p26, 0x1.a6a5096da5b7dp30 },
	   { 0x1.66d6688315ad6p26, 0x1.73aff07c7874ep30 },
	   { 0x1.3b3d55ebd8547p26, 0x1.46d572e10e216p30 },
	   { 0x1.14e7b714e7093p26, 0x1.1f5ba17e5a90bp30 },
	   { 0x1.e667d9a8bcd9ep25, 0x1.f93d0d186fbcdp29 },
	   { 0x1.ab2733e383ad8p25, 0x1.bc1b22cec72bp29 },
	   { 0x1.7712b76c8c7f6p25, 0x1.86529e9df069cp29 },
	   { 0x1.494d8e1d4fc61p25, 0x1.5702d052bf73ap29 },
	   { 0x1.2115447c6627dp25, 0x1.2d65aee08874cp29 },
	   { 0x1.fb7d503fc65c8p24, 0x1.08ccb49580d43p29 },
	   { 0x1.bd660913b938cp24, 0x1.d13c32a98512bp28 },
	   { 0x1.86db66e158524p24, 0x1.98a4bfd5a5fadp28 },
	   { 0x1.56f3ed5aa4222p24, 0x1.66e459a7794f4p28 },
	   { 0x1.2ce2265a96befp24, 0x1.3b28bbce3c1c6p28 },
	   { 0x1.07f14a8d0c116p24, 0x1.14b8b6b67144ep28 },
	   { 0x1.cf049ebedf60dp23, 0x1.e5e26dbef0e28p27 },
	   { 0x1.96129ca292f7ep23, 0x1.aa854b5c4f131p27 },
	   { 0x1.6416763f6b3bcp23, 0x1.765d329106241p27 },
	   { 0x1.3837bf030f4a8p23, 0x1.488b9479ee1c4p27 },
	   { 0x1.11b82880134f9p23, 0x1.204c8d940530bp27 },
	   { 0x1.dfe0c1b8af1f3p22, 0x1.f9e77238e0031p26 },
	   { 0x1.a49aa1651cfcap22, 0x1.bbd2c8fd7e193p26 },
	   { 0x1.709b5a3a79128p22, 0x1.85502f16a0f8dp26 },
	   { 0x1.42ffa7e9ace3fp22, 0x1.5574ceffe3945p26 },
	   { 0x1.1affd2eccd616p22, 0x1.2b72182c97af5p26 },
	   { 0x1.efd8be43ac9a9p21, 0x1.06925da53a0fcp26 },
	   { 0x1.b2564005de7e5p21, 0x1.cc6bb6d71090dp25 },
	   { 0x1.7c694cd2b4ffdp21, 0x1.93a02d0c97221p25 },
	   { 0x1.4d23fa69bd814p21, 0x1.61cb1a027e057p25 },
	   { 0x1.23b556e6e918ep21, 0x1.361358dd1f243p25 },
	   { 0x1.fecbcf04dca9p20, 0x1.0fba0d2660d89p25 },
	   { 0x1.bf29264dcdc82p20, 0x1.dc2ef387bd0ep24 },
	   { 0x1.8767d7fc43eb6p20, 0x1.a130711aadcdap24 },
	   { 0x1.568f9937abc79p20, 0x1.6d758e1ac9659p24 },
	   { 0x1.2bc67d8c20136p20, 0x1.401abca024479p24 },
	   { 0x1.064d4616b0094p20, 0x1.185819a7f8c6ap24 },
	   { 0x1.caf8458ad2a12p19, 0x1.eafc2b00a99b1p23 },
	   { 0x1.917faff93e54p19, 0x1.ade505ba61e89p23 },
	   { 0x1.5f2e79283b1cap19, 0x1.785c00b5cb27ep23 },
	   { 0x1.33220b1da4f59p19, 0x1.4973634932c1ap23 },
	   { 0x1.0c93ac678b0ccp19, 0x1.205a7d78be568p23 },
	   { 0x1.d5aa313452daep18, 0x1.f8b4440d68221p22 },
	   { 0x1.9a9b05368c88bp18, 0x1.b9a31a7b9868cp22 },
	   { 0x1.66ede7f0c2d55p18, 0x1.826756e1a42e2p22 },
	   { 0x1.39b7fc18e5891p18, 0x1.5209676e4b424p22 },
	   { 0x1.122b662569616p18, 0x1.27b019965e362p22 },
	   { 0x1.df2779ceabfc8p17, 0x1.029ce648133fdp22 },
	   { 0x1.a2a5d2945d2b7p17, 0x1.c45161cd95fe8p21 },
	   { 0x1.6dbccf848794ap17, 0x1.8b81d680cdfc5p21 },
	   { 0x1.3f79bf21caa96p17, 0x1.59ca24a7521ddp21 },
	   { 0x1.17080ae674896p17, 0x1.2e48f266999cfp21 },
	   { 0x1.e75b024885f54p16, 0x1.0838b13324d03p21 },
	   { 0x1.a98e26924c6c8p16, 0x1.cdd86b83e679dp20 },
	   { 0x1.738bf4bc8d296p16, 0x1.93977456406ddp20 },
	   { 0x1.445a6a9a273c6p16, 0x1.60a47aca18e96p20 },
	   { 0x1.1b1eabeffc3a5p16, 0x1.341669953fe1cp20 },
	   { 0x1.ee324e1fde417p15, 0x1.0d210b765b3d6p20 },
	   { 0x1.af4465e9c5668p15, 0x1.d622fa53c02cep19 },
	   { 0x1.784e3008fb46bp15, 0x1.9a961d6383ef7p19 },
	   { 0x1.484eecd2f1383p15, 0x1.66890cd0bf55fp19 },
	   { 0x1.1e65fd1ef2701p15, 0x1.390b73f2a4fbp19 },
	   { 0x1.f39dc6baaccd7p14, 0x1.114ae59581395p19 },
	   { 0x1.b3bb863d26278p14, 0x1.dd1e5296953a3p18 },
	   { 0x1.7bf89f052b591p14, 0x1.a06dfa21b6c59p18 },
	   { 0x1.4b4e35dbe0cddp14, 0x1.6b6a7a27c9005p18 },
	   { 0x1.20d6781986167p14, 0x1.3d1cca3d4f6d8p18 },
	   { 0x1.f790f6877f51ep13, 0x1.14acc164c64fep18 },
	   { 0x1.b6e93fa7299b3p13, 0x1.e2ba80b9c3a1bp17 },
	   { 0x1.7e82cde922833p13, 0x1.a511aa3827999p17 },
	   { 0x1.4d515a14a6132p13, 0x1.6f3d9139319edp17 },
	   { 0x1.226a790f97768p13, 0x1.404113d7d18e6p17 },
	   { 0x1.fa02b8ac73416p12, 0x1.173ed60fcd6fap17 },
	   { 0x1.b8c634233722p12, 0x1.e6ea95e92c624p16 },
	   { 0x1.7fe6d7fbcef2cp12, 0x1.a8767775dd309p16 },
	   { 0x1.4e53acc7531b1p12, 0x1.71f97a2983044p16 },
	   { 0x1.231e547065724p12, 0x1.42710a88aab19p16 },
	   { 0x1.faed5c4559717p11, 0x1.18fb2ded8ebb1p16 },
	   { 0x1.b94e0bfb59934p11, 0x1.e9a4d9b21386ep15 },
	   { 0x1.80217e57d8a3fp11, 0x1.aa947efe69879p15 },
	   { 0x1.4e52d23cf50bp11, 0x1.7397d8e2bd385p15 },
	   { 0x1.22f0652094ae6p11, 0x1.43a79684f6ef6p15 },
	   { 0x1.fa4eba730bf6p10, 0x1.19ddbd8138a9p15 },
	   { 0x1.b87f86a26fad7p10, 0x1.eae2ef93df996p14 },
	   { 0x1.7f323487ff94ap10, 0x1.ab66cfccafb75p14 },
	   { 0x1.4d4ec8ea8ee67p10, 0x1.7414e5b5ca43cp14 },
	   { 0x1.21e112e39bf18p10, 0x1.43e1e22ebfdb4p14 },
	   { 0x1.f8283ec45f117p9, 0x1.19e4732be2ffp14 },
	   { 0x1.b65c7f9f1fbedp9, 0x1.eaa1efb3b003ep13 },
	   { 0x1.7d1b22b6810f6p9, 0x1.aaeb7de6855e2p13 },
	   { 0x1.4b49e984886ep9, 0x1.736f7c0d13f06p13 },
	   { 0x1.1ff2d0d5a2649p9, 0x1.431f651be2ff4p13 },
	   { 0x1.f47ee1cab73ddp8, 0x1.190f3f39e9af4p13 },
	   { 0x1.b2e9e76c8d9f9p8, 0x1.e8e2722ca46cfp12 },
	   { 0x1.79e11d635b9a7p8, 0x1.a923a9d8d5019p12 },
	   { 0x1.4848ddf7dfffep8, 0x1.71a91ee04e82cp12 },
	   { 0x1.1d2a13fdd2709p8, 0x1.4161e6298ed3ap12 },
	   { 0x1.ef5b15f73200ap7, 0x1.176014201ab17p12 },
	   { 0x1.ae2fb07705cc3p7, 0x1.e5a88cbf394e4p11 },
	   { 0x1.758b92cdfdc64p7, 0x1.a6137c537bf6dp11 },
	   { 0x1.44528f79b1b51p7, 0x1.6ec5f2d1367f4p11 },
	   { 0x1.198d422be3f8cp7, 0x1.3ead7491061afp11 },
	   { 0x1.e8c8a7276c93p6, 0x1.14dadee76975ap11 },
	   { 0x1.a838b09afcf62p6, 0x1.e0fbc2ec572b9p10 },
	   { 0x1.70246e766d2f3p6, 0x1.a1c215fcd0beap10 },
	   { 0x1.3f700c0d99876p6, 0x1.6accae115453ep10 },
	   { 0x1.1524997d01ap6, 0x1.3b08582357e32p10 },
	   { 0x1.e0d68d9047f7ap5, 0x1.118577f06b2f2p10 },
	   { 0x1.a11277ca2bd3fp5, 0x1.dae6e8d292a1ep9 },
	   { 0x1.69b7f34ec048ep5, 0x1.9c3973d4c9b08p9 },
	   { 0x1.39ac6410ceb63p5, 0x1.65c67e684d1e6p9 },
	   { 0x1.0ffa110b113fp5, 0x1.367af901b137p9 },
	   { 0x1.d796b4f7aaf7fp4, 0x1.0d678c614f535p9 },
	   { 0x1.98cd1cb38dccp4, 0x1.d377f96b9fd62p8 },
	   { 0x1.62548d6675835p4, 0x1.958648bd6035p8 },
	   { 0x1.331480815e7cdp4, 0x1.5fbee5e7590f4p8 },
	   { 0x1.0a19336cc73a1p4, 0x1.310fbf558eca2p8 },
	   { 0x1.cd1db96a6c6efp3, 0x1.088a80b837328p8 },
	   { 0x1.8f7b007e1de49p3, 0x1.cabfe10b3371ap7 },
	   { 0x1.5a0a9c047e3c7p3, 0x1.8db7ccf7600f4p7 },
	   { 0x1.2bb6f2dd8e254p3, 0x1.58c38f07b7c3bp7 },
	   { 0x1.038ef3cbdc1c7p3, 0x1.2ad2ebb6268bdp7 },
	   { 0x1.c1829acfb62b3p2, 0x1.02f94d1fb1ba4p7 },
	   { 0x1.85308ad209551p2, 0x1.c0d23d3daadadp6 },
	   { 0x1.50ec3549a202dp2, 0x1.84df8496cc3aep6 },
	   { 0x1.23a3bf963c1ebp2, 0x1.50e4191e1b76cp6 },
	   { 0x1.f8d2fce0ebb41p1, 0x1.23d2690dc7344p6 },
	   { 0x1.b4de68e608347p1, 0x1.f980a88588961p5 },
	   { 0x1.7a03df8f9f479p1, 0x1.b5c5135a44acbp5 },
	   { 0x1.470ce4924af72p1, 0x1.7b10fe1f0aeaap5 },
	   { 0x1.1aec242758b4fp1, 0x1.4831de32e25bdp5 },
	   { 0x1.e9700b697ec96p0, 0x1.1c1d98f1b1f71p5 },
	   { 0x1.a74be9568f922p0, 0x1.ebda6af103d07p4 },
	   { 0x1.6e0c8fadbb05p0, 0x1.a9b07f491a273p4 },
	   { 0x1.3c8164e42f29cp0, 0x1.70618a9c019dap4 },
	   { 0x1.11a259faba91ep0, 0x1.3ebfb36da371bp4 },
	   { 0x1.d91518c2acaf6p-1, 0x1.13c51b7852ecp4 },
	   { 0x1.98e739a118b5ep-1, 0x1.dd1d36683753bp3 },
	   { 0x1.616346ca3be0ep-1, 0x1.9cae5c1f5de61p3 },
	   { 0x1.315f58c13df9cp-1, 0x1.64e7f0a95542fp3 },
	   { 0x1.07d957435b8c4p-1, 0x1.34a1a5595e9cbp3 },
	   { 0x1.c7e35cf4db634p-2, 0x1.0ada93ac2688ep3 },
	   { 0x1.89cd6ead31b71p-2, 0x1.cd680d6a376d2p2 },
	   { 0x1.542176fe1c2b2p-2, 0x1.8ed9e84be9bacp2 },
	   { 0x1.25bd00bd97eddp-2, 0x1.58bc1beb8e117p2 },
	   { 0x1.fb491e02b7c15p-3, 0x1.29ecb15514182p2 },
	   { 0x1.b5fcd30c7e1f6p-3, 0x1.017069c4b54cfp2 },
	   { 0x1.7a1c33cc1922bp-3, 0x1.bcdb33f7b88f9p1 },
	   { 0x1.46610483f2395p-3, 0x1.804f671a7a35cp1 },
	   { 0x1.19b0f23241b88p-3, 0x1.4bf6ca87a4707p1 },
	   { 0x1.e62f62b4555dcp-4, 0x1.1eb67d8a75351p1 },
	   { 0x1.a383ca9f98a0fp-4, 0x1.ef3318a5788dep0 },
	   { 0x1.69f16aeb3677p-4, 0x1.ab97c2106c4d2p0 },
	   { 0x1.383bf2b37a037p-4, 0x1.712bc1550fb6ap0 },
	   { 0x1.0d51cf5a16254p-4, 0x1.3eb13a24821e2p0 },
	   { 0x1.d08cdac87dce6p-5, 0x1.131510c1da6adp0 },
	   { 0x1.909a7c3ac6f99p-5, 0x1.dad26311e9efp-1 },
	   { 0x1.596acfa0bcc8fp-5, 0x1.99bf36c7ef068p-1 },
	   { 0x1.29cc13bfd53ap-5, 0x1.618c26c1169a6p-1 },
	   { 0x1.00b60212cf113p-5, 0x1.3104d5f799552p-1 },
	   { 0x1.ba886ae6e40ep-6, 0x1.071e8b6003b16p-1 },
	   { 0x1.7d62a282a4851p-6, 0x1.c5e5338097f6bp-2 },
	   { 0x1.48a59e9cb1eb1p-6, 0x1.87730de08c821p-2 },
	   { 0x1.1b2abc895a771p-6, 0x1.518db221cf8bap-2 },
	   { 0x1.e7e6f4c33ededp-7, 0x1.230ae74a714aap-2 },
	   { 0x1.a4480db60fe17p-7, 0x1.f5d1c58fdc6acp-3 },
	   { 0x1.69fd19aacb90ap-7, 0x1.b091a88a72f08p-3 },
	   { 0x1.37be42e1159e7p-7, 0x1.74d459ba38afep-3 },
	   { 0x1.0c707db025298p-7, 0x1.414d114bdcde1p-3 },
	   { 0x1.ce3ee3757dbe5p-8, 0x1.14dc49cbc0c3p-3 },
	   { 0x1.8df06bfb34f6dp-8, 0x1.dd13408401cdcp-4 },
	   { 0x1.568986affafc5p-8, 0x1.9afd0eca1593dp-4 },
	   { 0x1.26d009f5af049p-8, 0x1.6203633a6814ap-4 },
	   { 0x1.fb69c5d6b524ep-9, 0x1.30e632b0008c9p-4 },
	   { 0x1.b49c67cd1611fp-9, 0x1.069124dc6eaefp-4 },
	   { 0x1.77a47ec4e9fa1p-9, 0x1.c42b48d5cfe42p-5 },
	   { 0x1.43260788f0a1fp-9, 0x1.854b792c33d4ap-5 },
	   { 0x1.15f4e018a09eep-9, 0x1.4f1f511f7b2d7p-5 },
	   { 0x1.de1c72f739a49p-10, 0x1.2073f996519cp-5 },
	   { 0x1.9b25dc6d6642ep-10, 0x1.f08155c194aadp-6 },
	   { 0x1.61853cc8eddacp-10, 0x1.ab41e011814e5p-6 },
	   { 0x1.2feeed430b87bp-10, 0x1.6f9f62ec4193ap-6 },
	   { 0x1.05451535e8102p-10, 0x1.3c45d7f9e2fbp-6 },
	   { 0x1.c122bcbda7f8ep-11, 0x1.100ffa10ff0f3p-6 },
	   { 0x1.81ff0b26f3b6ap-11, 0x1.d401bee3a7787p-7 },
	   { 0x1.4bb153d2d0728p-11, 0x1.927ce5fbbe352p-7 },
	   { 0x1.1cfe80beb05a4p-11, 0x1.5a195c6e2a08ep-7 },
	   { 0x1.e9ae566e02486p-12, 0x1.2992f3c7d2ce7p-7 },
	   { 0x1.a4a3297375461p-12, 0x1.ffa47aef63bd2p-8 },
	   { 0x1.6948e77b6c537p-12, 0x1.b7ccca35ce88ep-8 },
	   { 0x1.3644eed5b1126p-12, 0x1.79ffc3cd6bc92p-8 },
	   { 0x1.0a6cd27d913d7p-12, 0x1.44d7c3dca9cc8p-8 },
	   { 0x1.c97f5c053e775p-13, 0x1.1720abf01aa9bp-8 },
	   { 0x1.88c0c973b68fcp-13, 0x1.dfa22008cf2c8p-9 },
	   { 0x1.512157ee1d8bep-13, 0x1.9c08a63df00dcp-9 },
	   { 0x1.215988e86b086p-13, 0x1.61eb258af5a93p-9 },
	   { 0x1.f09f2b684fb31p-14, 0x1.2ff68a28f7dc4p-9 },
	   { 0x1.aa222a98ba953p-14, 0x1.0506e21782262p-9 },
	   { 0x1.6d9b06046eb66p-14, 0x1.c041afe3a1ad2p-10 },
	   { 0x1.39a30e3030664p-14, 0x1.80d8271e40929p-10 },
	   { 0x1.0d05cd2b64652p-14, 0x1.4a5cc1e67b046p-10 },
	   { 0x1.cd740d2318d4dp-15, 0x1.1b8f04bdfa1bfp-10 },
	   { 0x1.8bb7603d9828p-15, 0x1.e6b65816f0ff1p-11 },
	   { 0x1.534d810db5377p-15, 0x1.a1a7ec86c94fbp-11 },
	   { 0x1.22e56de90dc1ap-15, 0x1.665a9398034f1p-11 },
	   { 0x1.f2bb06a7069e2p-16, 0x1.336f30c8d3345p-11 },
	   { 0x1.ab79b6edb04e1p-16, 0x1.07b7cbf13abf4p-11 },
	   { 0x1.6e5b33b150249p-16, 0x1.c461717dacbd8p-12 },
	   { 0x1.39f005226a7dbp-16, 0x1.83f56253c12f1p-12 },
	   { 0x1.0cfc8192e69bdp-16, 0x1.4cab82baddd6cp-12 },
	   { 0x1.cce310b024fd4p-17, 0x1.1d39d04e50424p-12 },
	   { 0x1.8acc81455f971p-17, 0x1.e9094beff3587p-13 },
	   { 0x1.522570529739fp-17, 0x1.a3308036822dbp-13 },
	   { 0x1.219685023e1bep-17, 0x1.67464f8a36affp-13 },
	   { 0x1.eff1f945e7f7bp-18, 0x1.33e2c9c277148p-13 },
	   { 0x1.a89fa515a2b44p-18, 0x1.07d0b7bb52fc7p-13 },
	   { 0x1.6b83bb4ee4348p-18, 0x1.c40cfbd11fd1p-14 },
	   { 0x1.372982e2fde1dp-18, 0x1.833ffa698fa8bp-14 },
	   { 0x1.0a51297b20ab7p-18, 0x1.4bb29dadf3acp-14 },
	   { 0x1.c7d093fb7e463p-19, 0x1.1c147957723bdp-14 },
	   { 0x1.8607006600009p-19, 0x1.e6896f5762306p-15 },
	   { 0x1.4db1c7b733812p-19, 0x1.a096cc3260668p-15 },
	   { 0x1.1d76959a6b622p-19, 0x1.64a7647d3f88ap-15 },
	   { 0x1.e858d8b3acc8p-20, 0x1.314deba7bab37p-15 },
	   { 0x1.a1a94b14e3d7fp-20, 0x1.0550e92636252p-15 },
	   { 0x1.6529df3d1cf1cp-20, 0x1.bf46cd0f972c3p-16 },
	   { 0x1.316449a955429p-20, 0x1.7ebd49fbb30eep-16 },
	   { 0x1.0517b9e1f89dep-20, 0x1.47796af08285bp-16 },
	   { 0x1.be627dddb55d7p-21, 0x1.1827a73755ec7p-16 },
	   { 0x1.7d8a7f2a8a2dp-21, 0x1.df49a10ccc568p-17 },
	   { 0x1.4613bf000c71dp-21, 0x1.99ee7037b652bp-17 },
	   { 0x1.16a45fcb7b882p-21, 0x1.5e9197017791dp-17 },
	   { 0x1.dc283bcbe780fp-22, 0x1.2bc40c543e36bp-17 },
	   { 0x1.96ca751cac37fp-22, 0x1.004b34180a4a9p-17 },
	   { 0x1.5b7cd13179ddep-22, 0x1.b632d58444fadp-18 },
	   { 0x1.28cb2cb8b4015p-22, 0x1.768f3e13d3bdcp-18 },
	   { 0x1.faedd62dabd96p-23, 0x1.401fa7657909ep-18 },
	   { 0x1.b0de982dbf111p-23, 0x1.1190d162109abp-18 },
	   { 0x1.7195b2becea19p-23, 0x1.d3803e22a78e4p-19 },
	   { 0x1.3b8387eea3f9dp-23, 0x1.8f694ad8ac632p-19 },
	   { 0x1.0d521f8291cd6p-23, 0x1.55326d6aac6fap-19 },
	   { 0x1.cbb9be9cbac1ep-24, 0x1.236e8d3a9e0e7p-19 },
	   { 0x1.8852e54d26542p-24, 0x1.f1ca221c0b98bp-20 },
	   { 0x1.4ec36b8fdf428p-24, 0x1.a914b62872bc3p-20 },
	   { 0x1.1d9d0055d11dp-24, 0x1.6af2ae42db58p-20 },
	   { 0x1.e74cb7ebdea0ap-25, 0x1.35dbe86ed95c7p-20 },
	   { 0x1.9fa735b03463ap-25, 0x1.0880cfe68041ep-20 },
	   { 0x1.627f6220ca6a9p-25, 0x1.c3847cbf78a3bp-21 },
	   { 0x1.2e4d9d8b5b22fp-25, 0x1.81550cf271bfdp-21 },
	   { 0x1.01c325e8bb3cp-25, 0x1.48cefa0aac509p-21 },
	   { 0x1.b783bc148fcefp-26, 0x1.188ab9ce5fdddp-21 },
	   { 0x1.76aa8791eba33p-26, 0x1.dea9996bf1c0fp-22 },
	   { 0x1.3f58d390caeecp-26, 0x1.984c7bb9c53ffp-22 },
	   { 0x1.10299f255a2cap-26, 0x1.5c3c6ce5f2f75p-22 },
	   { 0x1.cfd7e08a13b2p-27, 0x1.28f8faa7c3202p-22 },
	   { 0x1.8b368e0429dacp-27, 0x1.fa7304087353p-23 },
	   { 0x1.50b2501707be6p-27, 0x1.afca3c464e1d5p-23 },
	   { 0x1.1ecf2c897b782p-27, 0x1.701780b38d71ap-23 },
	   { 0x1.e891642306feep-28, 0x1.39c08dab159ep-23 },
	   { 0x1.a013c6709bdd5p-28, 0x1.0b66dac93672bp-23 },
	   { 0x1.624c9a2f2f8fcp-28, 0x1.c7bde43ebd873p-24 },
	   { 0x1.2da83d59392f5p-28, 0x1.84520ec5eb55ap-24 },
	   { 0x1.00ce3767b77a8p-28, 0x1.4ad54236cf6b4p-24 },
	   { 0x1.b5312d520a3f4p-29, 0x1.19d258cf47194p-24 },
	   { 0x1.74191dcab90bcp-29, 0x1.e015665e4efbdp-25 },
	   { 0x1.3ca855a30dad5p-29, 0x1.98dc92b26aeap-25 },
	   { 0x1.0d71d1069e44fp-29, 0x1.5c29c3e79c162p-25 },
	   { 0x1.ca7c7b61a5357p-30, 0x1.28708aaed4d7p-25 },
	   { 0x1.86083aaabaf73p-30, 0x1.f8bd2046619b5p-26 },
	   { 0x1.4bc21b880f9dep-30, 0x1.ada636f165959p-26 },
	   { 0x1.1a28183b0e32p-30, 0x1.6dafa60f704a1p-26 },
	   { 0x1.dfe23a6ad4f8bp-31, 0x1.37351629c53cp-26 },
	   { 0x1.980956bea8ccp-31, 0x1.08cff68f5874cp-26 },
	   { 0x1.5ae767663002ep-31, 0x1.c29ce58c1fc1p-27 },
	   { 0x1.26e4fd1165b76p-31, 0x1.7f5772973d16cp-27 },
	   { 0x1.f54dde2ba8f56p-32, 0x1.4612c5674eed9p-27 },
	   { 0x1.aa0af3e698b26p-32, 0x1.15539e864d70fp-27 },
	   { 0x1.6a0956d7d1b63p-32, 0x1.d7ad5cdc3741ep-28 },
	   { 0x1.339bd6e517d44p-32, 0x1.9110bc4b50f8cp-28 },
	   { 0x1.0554f0943ba8cp-32, 0x1.54fb970dbe54ep-28 },
	   { 0x1.bbfac9007ec07p-33, 0x1.21dd98bc7de87p-28 },
	   { 0x1.791862715d02fp-33, 0x1.ecc34851c9763p-29 },
	   { 0x1.403f77382e654p-33, 0x1.a2ca34863bfcbp-29 },
	   { 0x1.0feff2a4fc49p-33, 0x1.63e0d12d4d288p-29 },
	   { 0x1.cdc5de1ae8c09p-34, 0x1.2e615f0543e41p-29 },
	   { 0x1.8804761a993c4p-34, 0x1.00e4ae934cb56p-29 },
	   { 0x1.4cc23eb3b5ffap-34, 0x1.b471c42165f4ap-30 },
	   { 0x1.1a6c6c06ea18bp-34, 0x1.72b316e47cc93p-30 },
	   { 0x1.df58ab9ae4fcbp-35, 0x1.3ad1e7143aa75p-30 },
	   { 0x1.96bd0bd6c9a31p-35, 0x1.0b54bd6a9e23fp-30 },
	   { 0x1.59163428fb3a6p-35, 0x1.c5f4a785a88d1p-31 },
	   { 0x1.24be8d0138113p-35, 0x1.8162809b8dff6p-31 },
	   { 0x1.f09f3c1618809p-36, 0x1.4721b76389525p-31 },
	   { 0x1.a53148c3fc482p-36, 0x1.15a6678e0082cp-31 },
	   { 0x1.652d1d62b45e1p-36, 0x1.d73f8da963966p-32 },
	   { 0x1.2eda549c16ee8p-36, 0x1.8fdeb6a9e8ebcp-32 },
	   { 0x1.00c2a84aed164p-36, 0x1.5342fe16e83a5p-32 },
	   { 0x1.b3501c0fdbbcfp-37, 0x1.1fcdfea216d16p-32 },
	   { 0x1.70f8998ccf075p-37, 0x1.e83eb9bce31c4p-33 },
	   { 0x1.38b3a7222dd33p-37, 0x1.9e170e2dbff8cp-33 },
	   { 0x1.08fb437656229p-37, 0x1.5f27a9aa5f66p-33 },
	   { 0x1.c1085f96d9feep-38, 0x1.29bfa42bc7b76p-33 },
	   { 0x1.7c6a3cf1c9dcfp-38, 0x1.f8de2739c95a9p-34 },
	   { 0x1.423e65b2a3a8cp-38, 0x1.abfaa7d4233fap-34 },
	   { 0x1.10ef40de709bcp-38, 0x1.6ac1833360c58p-34 },
	   { 0x1.ce48f9d9e5928p-39, 0x1.336f5ff042b88p-34 },
	   { 0x1.8773adc5703cep-39, 0x1.0484d7ff5f6bdp-34 },
	   { 0x1.4b6e86a5aa9d8p-39, 0x1.b978904649f57p-35 },
	   { 0x1.189488e2e9743p-39, 0x1.760249f31a968p-35 },
	   { 0x1.db0100ef385d3p-40, 0x1.3cd13761f1731p-35 },
	   { 0x1.9206c1ae9fb29p-40, 0x1.0c569a0b1627cp-35 },
	   { 0x1.54382e8081943p-40, 0x1.c67fe1e83e91p-36 },
	   { 0x1.1fe13002859cap-40, 0x1.80dbcff1d72cfp-36 },
	   { 0x1.e71fde0c5e218p-41, 0x1.45d945dc4844dp-36 },
	   { 0x1.9c159bbc9900ap-41, 0x1.13da615eb6c5fp-36 },
	   { 0x1.5c8fc931c6d94p-41, 0x1.d2ffe78d87996p-37 },
	   { 0x1.26cb8c1920344p-41, 0x1.8b4017551e03bp-37 },
	   { 0x1.f295714275bc3p-42, 0x1.4e7bd56b77338p-37 },
	   { 0x1.a592ca70605e5p-42, 0x1.1b06621cfb60ep-37 },
	   { 0x1.646a234bddd88p-42, 0x1.dee83fc205fc8p-38 },
	   { 0x1.2d4a498c21371p-42, 0x1.9521701d324dap-38 },
	   { 0x1.fd5235020e009p-43, 0x1.56ad77d8efe38p-38 },
	   { 0x1.ae71657ff542ep-43, 0x1.21d11201bfbcfp-38 },
	   { 0x1.6bbc82f12468ap-43, 0x1.ea290040397f4p-39 },
	   { 0x1.3354802504d9ep-43, 0x1.9e7295f29cf91p-39 },
	   { 0x1.03a3b07cf84bp-43, 0x1.5e631fb2a96dbp-39 },
	   { 0x1.b6a52af7c7202p-44, 0x1.28313d62cbf4fp-39 },
	   { 0x1.727cc024d462ap-44, 0x1.f4b2d92a8da6ap-40 },
	   { 0x1.38e1c7590edafp-44, 0x1.a726cda9c5fc4p-40 },
	   { 0x1.083385f1e344cp-44, 0x1.6592390114765p-40 },
	   { 0x1.be229b5ed10ebp-45, 0x1.2e1e1bdc1cff3p-40 },
	   { 0x1.78a15c33bf0d1p-45, 0x1.fe77379b5869ap-41 },
	   { 0x1.3dea49bdca04dp-45, 0x1.af3202215009fp-41 },
	   { 0x1.0c5225e967ce3p-45, 0x1.6c30c15ee186bp-41 },
	   { 0x1.c4df14833b32ep-46, 0x1.338f646703f05p-41 },
	   { 0x1.7e2197e99732ep-46, 0x1.03b4338f71d3bp-41 },
	   { 0x1.4266d76b7e9efp-46, 0x1.b688e02001605p-42 },
	   { 0x1.0ff9aa4df55cbp-46, 0x1.72355f261c90fp-42 },
	   { 0x1.cad0ea9847218p-47, 0x1.387d609c076c8p-42 },
	   { 0x1.82f5884a3c4ffp-47, 0x1.07bcd8d61f54dp-42 },
	   { 0x1.4650f71159187p-47, 0x1.bd20f0d88c869p-43 },
	   { 0x1.1324c9f973607p-47, 0x1.77977767b819cp-43 },
	   { 0x1.cfef7f529f1bfp-48, 0x1.3ce0fee10ae91p-43 },
	   { 0x1.8716298a66d68p-48, 0x1.0b4fbeda58aa9p-43 },
	   { 0x1.49a2f582864b8p-48, 0x1.c2f0b2bc85943p-44 },
	   { 0x1.15cee56fb8f8p-48, 0x1.7c4f426570458p-44 },
	   { 0x1.d43356b5d1bc3p-49, 0x1.40b3e347db73ap-44 },
	   { 0x1.8a7d700826ce3p-49, 0x1.0e67b4f33d066p-44 },
	   { 0x1.4c57f38808af9p-49, 0x1.c7efb04c36011p-45 },
	   { 0x1.17f41219f6e6ep-49, 0x1.8055de49eb405p-45 },
	   { 0x1.d796294cc09e7p-50, 0x1.43f076e4dac86p-45 },
	   { 0x1.8d265709c8b81p-50, 0x1.11003322f9f2ap-45 },
	   { 0x1.4e6bf1c869176p-50, 0x1.cc169496c493bp-46 },
	   { 0x1.199123dce7f7cp-50, 0x1.83a55fe01c77fp-46 },
	   { 0x1.da12f38ef6065p-51, 0x1.4691f56a0b9d1p-46 },
	   { 0x1.8f0ced10d0db4p-51, 0x1.131565242338p-46 },
	   { 0x1.4fdbda9c9106cp-51, 0x1.cf5f3d25346p-47 },
	   { 0x1.1aa3b4e8f3caap-51, 0x1.8638e1112031dp-47 },
	   { 0x1.dba6023e1257ap-52, 0x1.489478d82c425p-47 },
	   { 0x1.902e5d96b5dc7p-52, 0x1.14a433d21a4e2p-47 },
	   { 0x1.50a589affacc9p-52, 0x1.d1c4c912f9acbp-48 },
	   { 0x1.1b2a2ba958505p-52, 0x1.880c8cf6ecf16p-48 },
	   { 0x1.dc4cfb90a7ce5p-53, 0x1.49f5031dc194p-48 },
	   { 0x1.9088f811b7254p-53, 0x1.15aa4ccc2f79bp-48 },
	   { 0x1.50c7d151d73dp-53, 0x1.d343a5202c7c4p-49 },
	   { 0x1.1b23bebdcda6dp-53, 0x1.891da95a3a6f5p-49 },
	   { 0x1.dc06e50abd949p-54, 0x1.4ab18582d9df2p-49 },
	   { 0x1.901c34297491p-54, 0x1.1626283914e64p-49 },
	   { 0x1.50427d64b1c7dp-54, 0x1.d3d994938f3adp-50 },
	   { 0x1.1a9076f0d2e24p-54, 0x1.896a9d7ab89b1p-50 },
	   { 0x1.dad425efa38efp-55, 0x1.4ac8e5c7c8723p-50 },
	   { 0x1.8ee8b30ca2586p-55, 0x1.16170c969f828p-50 },
	   { 0x1.4f1653e256f41p-55, 0x1.d385b6cd88b32p-51 },
	   { 0x1.19712f23cae3dp-55, 0x1.88f2f609fe4d3p-51 },
	   { 0x1.d8b686448b5afp-56, 0x1.4a3b00e506616p-51 },
	   { 0x1.8cf03de32b406p-56, 0x1.157d10888e2f3p-51 },
	   { 0x1.4d4512f22a65dp-56, 0x1.d2488978a2f74p-52 },
	   { 0x1.17c7923127a39p-56, 0x1.87b7664b4e00cp-52 },
	   { 0x1.d5b12a674c804p-57, 0x1.4908ab62a09acp-52 },
	   { 0x1.8a35c1621f2ccp-57, 0x1.14591aa0080cap-52 },
	   { 0x1.4ad16c988b007p-57, 0x1.d023e74fea7e1p-53 },
	   { 0x1.159616cbf8a0cp-57, 0x1.85b9c65443c51p-53 },
	   { 0x1.d1c88b489c5c3p-58, 0x1.4733af4601fe1p-53 },
	   { 0x1.86bd4690c0845p-58, 0x1.12acdf1c9738cp-53 },
	   { 0x1.47bf000e37ae9p-58, 0x1.cd1b037f7490bp-54 },
	   { 0x1.12dff96b26d81p-58, 0x1.82fd0e7486194p-54 },
	   { 0x1.cd026b64a0ca8p-59, 0x1.44bec79d5416cp-54 },
	   { 0x1.828be8d7b2e74p-59, 0x1.107adbae7661dp-54 },
	   { 0x1.441250d6b8cc7p-59, 0x1.c93261af2cd0dp-55 },
	   { 0x1.0fa934555eb5ap-59, 0x1.7f854fd47e7d3p-55 },
	   { 0x1.c765c89feb632p-60, 0x1.41ad99b7fc9ebp-55 },
	   { 0x1.7da7c97c8ea4bp-60, 0x1.0dc65148f57fcp-55 },
	   { 0x1.3fd0bbb47d67cp-60, 0x1.c46fcad39a071p-56 },
	   { 0x1.0bf675e9015a3p-60, 0x1.7b57aa64c1e42p-56 },
	   { 0x1.c0facb396944ap-61, 0x1.3e04ac23c3f11p-56 },
	   { 0x1.781800b4c5862p-61, 0x1.0a933c1a65e31p-56 },
	   { 0x1.3b0069a07f02dp-61, 0x1.beda3eeb5f0a2p-57 },
	   { 0x1.07cd15415698ap-61, 0x1.767a404101f5ap-57 },
	   { 0x1.b9cab20b7b4acp-62, 0x1.39c95b8dcd835p-57 },
	   { 0x1.71e48c82b190ap-62, 0x1.06e649c54a11dp-57 },
	   { 0x1.35a840f1bb9bfp-62, 0x1.b879e3daa485dp-58 },
	   { 0x1.0333055f872d1p-62, 0x1.70f426b1f5c67p-58 },
	   { 0x1.b1dfbc5f13465p-63, 0x1.3501cdad9df5bp-58 },
	   { 0x1.6b163d96b3dd9p-63, 0x1.02c4cdfc5722cp-58 },
	   { 0x1.2fcfd4e6913cap-63, 0x1.b157f19f267eap-59 },
	   { 0x1.fc5d8e0519af3p-64, 0x1.6acd55017e4e2p-59 },
	   { 0x1.a945119b38a65p-64, 0x1.2fb4e266d3e9fp-59 },
	   { 0x1.63b6a2745bde1p-64, 0x1.fc696b5025168p-60 },
	   { 0x1.297f53c6e927fp-64, 0x1.a97e9c202c067p-60 },
	   { 0x1.f18eb2ba6357fp-65, 0x1.640e915b3f3eap-60 },
	   { 0x1.a006a7219c6a4p-65, 0x1.29ea2353deb28p-60 },
	   { 0x1.5bcff1208eb99p-65, 0x1.f278f182d5ccep-61 },
	   { 0x1.22bf73da1838dp-65, 0x1.a0f8fae51588p-61 },
	   { 0x1.e60853b8b4b65p-66, 0x1.5cc15bf9dbbbbp-61 },
	   { 0x1.963124add21cp-66, 0x1.23a9b1f0c9515p-61 },
	   { 0x1.536cefa1810b4p-66, 0x1.e7c6162103b4ep-62 },
	   { 0x1.1b995f6e584afp-66, 0x1.97d2ef035140ap-62 },
	   { 0x1.d9da06644bc9dp-67, 0x1.54efd8e5e8a15p-62 },
	   { 0x1.8bd1c79049ec2p-67, 0x1.1cfc34a10ee47p-62 },
	   { 0x1.4a98db9bff0e8p-67, 0x1.dc5f9803d5324p-63 },
	   { 0x1.1416a031bacf2p-67, 0x1.8e1907994f8d3p-63 },
	   { 0x1.cd13f7b7c3414p-68, 0x1.4ca4b88f6234cp-63 },
	   { 0x1.80f645203dff7p-68, 0x1.15eac2ce52257p-63 },
	   { 0x1.415f515af2672p-68, 0x1.d054eb8db2ad5p-64 },
	   { 0x1.0c410a1d6b3cap-68, 0x1.83d8652f7235cp-64 },
	   { 0x1.bfc6c8b2d1c95p-69, 0x1.43eb1f8cfdcf1p-64 },
	   { 0x1.75acacc068ebep-69, 0x1.0e7ed05fb3af3p-64 },
	   { 0x1.37cc328e513e5p-69, 0x1.c3b617ec3cfd6p-65 },
	   { 0x1.0422a6340a512p-69, 0x1.791e9c59e2b42p-65 },
	   { 0x1.b2036a988beadp-70, 0x1.3ace8dce03fbdp-65 },
	   { 0x1.6a0349d192d1ap-70, 0x1.06c218ca5f25ap-65 },
	   { 0x1.2deb8d0dae905p-70, 0x1.b69393c895b87p-66 },
	   { 0x1.f78b3aa5bebbep-71, 0x1.6df997f6bab1bp-66 },
	   { 0x1.a3dafb67a96cfp-71, 0x1.315ac58b7d6b7p-66 },
	   { 0x1.5e0885ebd9cc3p-71, 0x1.fd7d13f78002dp-67 },
	   { 0x1.23c981e88b022p-71, 0x1.a8fe21d205ebp-67 },
	   { 0x1.e66846a73c925p-72, 0x1.62777b62fde0cp-67 },
	   { 0x1.955ea2f392221p-72, 0x1.279bb2446baf4p-67 },
	   { 0x1.51cacbb42476ep-72, 0x1.ecfc5eb955129p-68 },
	   { 0x1.19722d0b598a4p-72, 0x1.9b06ad8cbcafbp-68 },
	   { 0x1.d4f0c5733dbc9p-73, 0x1.56a684fe99fcap-68 },
	   { 0x1.869f70ffc1fcbp-73, 0x1.1d9d500e92622p-68 },
	   { 0x1.45586a9e82938p-73, 0x1.dc163a555fefbp-69 },
	   { 0x1.0ef18dbc017ffp-73, 0x1.8cbe28ca7c426p-69 },
	   { 0x1.c338d2435fb4bp-74, 0x1.4a94f1540c9eap-69 },
	   { 0x1.77ae3cb88b469p-74, 0x1.136b93820fc76p-69 },
	   { 0x1.38bf7be87e681p-74, 0x1.cadeb8c3bba05p-70 },
	   { 0x1.0453702b9a5bbp-74, 0x1.7e356a2db5e15p-70 },
	   { 0x1.b154294e891dap-75, 0x1.3e50df3387f95p-70 },
	   { 0x1.689b85dc875b1p-75, 0x1.09125281c373ap-70 },
	   { 0x1.2c0dc90fab5bap-75, 0x1.b969aedac7779p-71 },
	   { 0x1.f346b0aa94647p-76, 0x1.6f7d0d10edd84p-71 },
	   { 0x1.9f5604d9610bp-76, 0x1.31e8350b95daep-71 },
	   { 0x1.597757e14e4e8p-76, 0x1.fd3a5c3ac18bbp-72 },
	   { 0x1.1f50b401397f7p-76, 0x1.a7ca8fa24018p-72 },
	   { 0x1.ddd8dcb76e388p-77, 0x1.60a5532471804p-72 },
	   { 0x1.8d50fcdd2a012p-77, 0x1.256887c26e498p-72 },
	   { 0x1.4a512f5483d32p-77, 0x1.e82efb884fa7p-73 },
	   { 0x1.129521372a709p-77, 0x1.961449f1f5f93p-73 },
	   { 0x1.c872d91eff745p-78, 0x1.51be080b9d49dp-73 },
	   { 0x1.7b56e9895b756p-78, 0x1.18df034ba2c47p-73 },
	   { 0x1.3b37e1b01d1bdp-78, 0x1.d31877f1753bap-74 },
	   { 0x1.05e763ef1c6e1p-78, 0x1.845928aac023dp-74 },
	   { 0x1.b3291e83a6ddap-79, 0x1.42d6673958cf7p-74 },
	   { 0x1.6978c8d7d61b8p-79, 0x1.0c58552d896bdp-74 },
	   { 0x1.2c3987ce2b431p-79, 0x1.be0be95f0126ep-75 },
	   { 0x1.f2a6593b4ee39p-80, 0x1.72aab5cc51918p-75 },
	   { 0x1.9e0f0cfd57ab4p-80, 0x1.33fd04413c4e8p-75 },
	   { 0x1.57c6a75ebbd36p-80, 0x1.ffc132424c87ap-76 },
	   { 0x1.1d636b1da2b46p-80, 0x1.a91d6af35687bp-76 },
	   { 0x1.d9c6f3705063cp-81, 0x1.6119a09e14fe5p-76 },
	   { 0x1.8936d384f421ap-81, 0x1.253fb5c838ba6p-76 },
	   { 0x1.464f8c7e074fcp-81, 0x1.e7068fdcaeb4ep-77 },
	   { 0x1.0ec1f5aebc21fp-81, 0x1.945fff2eb1b17p-77 },
	   { 0x1.c14515cb6f8fp-82, 0x1.4fb5a7146299ap-77 },
	   { 0x1.74b15b6eeceb1p-82, 0x1.16ab8334ccb0ap-77 },
	   { 0x1.352169fa33216p-82, 0x1.ce965139dad89p-78 },
	   { 0x1.0060a522d6818p-82, 0x1.7fe578074e0c8p-78 },
	   { 0x1.a933ad3e37ea3p-83, 0x1.3e8d828e807b4p-78 },
	   { 0x1.608e37fe916b7p-83, 0x1.084c9533fea9dp-78 },
	   { 0x1.24490f08ca22dp-83, 0x1.b68488148e38cp-79 },
	   { 0x1.e4940102c0a26p-84, 0x1.6bbe630bdc58cp-79 },
	   { 0x1.91a40479b1837p-84, 0x1.2daed7fd23569p-79 },
	   { 0x1.4cdb9a0d20ef7p-84, 0x1.f45c523b5ec4ep-80 },
	   { 0x1.13d21ec7ce7a5p-84, 0x1.9ee3b5d440d2p-80 },
	   { 0x1.c90f21d2d475fp-85, 0x1.57f9f997e1f52p-80 },
	   { 0x1.7aa5b8d4b4359p-85, 0x1.1d262b74c69e4p-80 },
	   { 0x1.39a647b21bed6p-85, 0x1.d8b50e711660ap-81 },
	   { 0x1.03c70a0dadb1dp-85, 0x1.87c4bc616ed3dp-81 },
	   { 0x1.ae43ba1c85bb1p-86, 0x1.44a615135e868p-81 },
	   { 0x1.6446b3db12c58p-86, 0x1.0cfed72363bb7p-81 },
	   { 0x1.26f997cdc041dp-86, 0x1.bdb5f7a82d0f4p-82 },
	   { 0x1.e86218ea3e6acp-87, 0x1.7136d3b897e11p-82 },
	   { 0x1.9440cec9f5e3ap-87, 0x1.31cf2729ac24dp-82 },
	   { 0x1.4e93295651e9bp-87, 0x1.fa860b2bf75f8p-83 },
	   { 0x1.14df714b2cc27p-87, 0x1.a36fa64c5b19fp-83 },
	   { 0x1.ca3058fde005fp-88, 0x1.5b478418ed951p-83 },
	   { 0x1.7b135dc219792p-88, 0x1.1f8035d726d41p-83 },
	   { 0x1.3995999427ba7p-88, 0x1.dbf75e60682c2p-84 },
	   { 0x1.03604de581436p-88, 0x1.89f0afa1deecap-84 },
	   { 0x1.ad067d36fa2c8p-89, 0x1.4602a49df0a52p-84 },
	   { 0x1.62c6642f5d4b9p-89, 0x1.0dc2db21eaf21p-84 },
	   { 0x1.2556d7a42568ap-89, 0x1.be61355e30a98p-85 },
	   { 0x1.e5068065139bep-90, 0x1.7145a7dd1cf8cp-85 },
	   { 0x1.90efd5cd13c3p-90, 0x1.31725e0702649p-85 },
	   { 0x1.4b62e9374c452p-90, 0x1.f93e90900fd6bp-86 },
	   { 0x1.11de133cc6916p-90, 0x1.a1d0c10ff74dfp-86 },
	   { 0x1.c49bf95c5f745p-91, 0x1.597928f3e0c7p-86 },
	   { 0x1.75f56ab48bd89p-91, 0x1.1d9f316556fccp-86 },
	   { 0x1.34f00cbd8ea42p-91, 0x1.d8389849eaf01p-87 },
	   { 0x1.fe61cbe17950dp-92, 0x1.8650e1db268ebp-87 },
	   { 0x1.a589caf82618cp-92, 0x1.4293ddcb013c1p-87 },
	   { 0x1.5c1e107375834p-92, 0x1.0a90025fd130cp-87 },
	   { 0x1.1f7319c565581p-92, 0x1.b87eb911fc5efp-88 },
	   { 0x1.daa6c6af5c17fp-93, 0x1.6bea387f6b0ap-88 },
	   { 0x1.87d63120a742cp-93, 0x1.2c9c915a28ddap-88 },
	   { 0x1.436e80df031fp-93, 0x1.f094496a5e827p-89 },
	   { 0x1.0aef9bffa708dp-93, 0x1.9a19446f657ccp-89 },
	   { 0x1.b890579385cdcp-94, 0x1.52a33b4b8094cp-89 },
	   { 0x1.6b84ffdb5d885p-94, 0x1.179841589cdp-89 },
	   { 0x1.2be9773700384p-94, 0x1.cda2d93f291abp-90 },
	   { 0x1.eecef0206652cp-95, 0x1.7d0e0e7cac5bp-90 },
	   { 0x1.9821029662ccfp-95, 0x1.3a804f20fd2f4p-90 },
	   { 0x1.5097c74b3d08ep-95, 0x1.038a34010e13fp-90 },
	   { 0x1.158fcf12f6c8ep-95, 0x1.ac508371be502p-91 },
	   { 0x1.c9b60c296975dp-96, 0x1.61608ea10db83p-91 },
	   { 0x1.7958bc88e6006p-96, 0x1.2383e3bce375p-91 },
	   { 0x1.370dfa8e149d1p-96, 0x1.e0e820ef7463p-92 },
	   { 0x1.0060a594f59c7p-96, 0x1.8c9f67fa9c048p-92 },
	   { 0x1.a6925bee98d74p-97, 0x1.471203b047e85p-92 },
	   { 0x1.5c351b499632p-97, 0x1.0dae92b93887p-92 },
	   { 0x1.1ee518d278c58p-97, 0x1.bcabf2ba981bfp-93 },
	   { 0x1.d8b2f8b0b2924p-98, 0x1.6e8f25135d13fp-93 },
	   { 0x1.855f0a34582a6p-98, 0x1.2e219acb023aep-93 },
	   { 0x1.40b1881e58e3p-98, 0x1.f1fe817902cebp-94 },
	   { 0x1.0818d80634105p-98, 0x1.9a5d5233d8e13p-94 },
	   { 0x1.b2ecbb2e8d76cp-99, 0x1.521d0766f8b85p-94 },
	   { 0x1.6614d9da549fbp-99, 0x1.168c985c93c95p-94 },
	   { 0x1.26c7736a63e7fp-99, 0x1.cae6809d7d445p-95 },
	   { 0x1.e546a107b57d5p-100, 0x1.79f71edd3cb51p-95 },
	   { 0x1.8f64020effd9cp-100, 0x1.37443c37e4835p-95 },
	   { 0x1.48aa64075b15p-100, 0x1.004e8297ce819p-95 },
	   { 0x1.0e6e891142764p-100, 0x1.a60ceba01346ap-96 },
	   { 0x1.bcfa525d16889p-101, 0x1.5b71dfbe662f9p-96 },
	   { 0x1.6e0be1ed4e4ccp-101, 0x1.1dfe04c5b884ap-96 },
	   { 0x1.2d14568fa3103p-101, 0x1.d6c299b6b03dep-97 },
	   { 0x1.ef39c9c67da7p-102, 0x1.8366f8264d161p-97 },
	   { 0x1.973b86e9a718fp-102, 0x1.3ec401194be5fp-97 },
	   { 0x1.4ed55e6d4d5dfp-102, 0x1.0641ea45be131p-97 },
	   { 0x1.1345b1de4a541p-102, 0x1.af7b06dd7c2fap-98 },
	   { 0x1.c48e8cf8e20edp-103, 0x1.62e7924beab28p-98 },
	   { 0x1.73f6cd7db5a56p-103, 0x1.23e2123cac1dcp-98 },
	   { 0x1.31afb2e91937bp-103, 0x1.e00be39adba8fp-99 },
	   { 0x1.f6600b76754fcp-104, 0x1.8ab4ee2717624p-99 },
	   { 0x1.9cc2881babafp-104, 0x1.447fa5b4e25fep-99 },
	   { 0x1.5316d5b010b17p-104, 0x1.0abf02c055867p-99 },
	   { 0x1.1688993cfebe3p-104, 0x1.b67d9f35f4de8p-100 },
	   { 0x1.c98758b0a4ebap-105, 0x1.685ccfe1e2ab5p-100 },
	   { 0x1.77baf72da4868p-105, 0x1.281e65593d67p-100 },
	   { 0x1.3484c1e2418cbp-105, 0x1.e698bd1000fd2p-101 },
	   { 0x1.fa991c211034p-106, 0x1.8fc0326c87b11p-101 },
	   { 0x1.9fe006460b912p-106, 0x1.485d5ed97243ep-101 },
	   { 0x1.555b844a27ecdp-106, 0x1.0db191585c5a2p-101 },
	   { 0x1.182875c9f3984p-106, 0x1.baf50ff65044dp-102 },
	   { 0x1.cbce2423a80acp-107, 0x1.6bb8ebe73c54ap-102 },
	   { 0x1.794741d4d28c6p-107, 0x1.2a9fd1221e357p-102 },
	   { 0x1.3586a18110b0ep-107, 0x1.ea4b746dbeae3p-103 },
	   { 0x1.fbd1c1dcb3991p-108, 0x1.9271dfe5687e7p-103 },
	   { 0x1.a085cf5d6c87ep-108, 0x1.4a4b9ae2c857dp-103 },
	   { 0x1.559911f8b7812p-108, 0x1.0f0c2d578f06ap-103 },
	   { 0x1.181ddd71c27fbp-108, 0x1.bccd0201398bap-104 },
	   { 0x1.cb5889458c00ep-109, 0x1.6cec95dfef21ap-104 },
	   { 0x1.789499da6bff1p-109, 0x1.2b5ae7721763fp-104 },
	   { 0x1.34b0b5ddf82c6p-109, 0x1.eb1327842cc63p-105 },
	   { 0x1.fa04646636ebep-110, 0x1.92bda7bca05b7p-105 },
	   { 0x1.9eb0ea42d451ep-110, 0x1.4a4186866270ap-105 },
	   { 0x1.53ce6234f7db7p-110, 0x1.0ec8a57831ec5p-105 },
	   { 0x1.1668fdbb007d5p-110, 0x1.bbfd05e1b64f3p-106 },
	   { 0x1.c8289c5fd0187p-111, 0x1.6bf24d893426cp-106 },
	   { 0x1.75a62b0407aefp-111, 0x1.2a4c4fb42b862p-106 },
	   { 0x1.3206cc37b0e4ap-111, 0x1.e8ec43d273fbap-107 },
	   { 0x1.f53937c26236ep-112, 0x1.90a22ee0d506ep-107 },
	   { 0x1.9a69ad7793258p-112, 0x1.483f4fee6553cp-107 },
	   { 0x1.50039cbf56e41p-112, 0x1.0ce82f0139653p-107 },
	   { 0x1.13119a81ee824p-112, 0x1.b888d3fea2a71p-108 },
	   { 0x1.c24cdc6a6909bp-113, 0x1.68ce8cbb7eaebp-108 },
	   { 0x1.7089487e1182ep-113, 0x1.2778e05f0f826p-108 },
	   { 0x1.2d94fe2dcd5a4p-113, 0x1.e3e0a1bcb7b9p-109 },
	   { 0x1.ed85fe218f015p-114, 0x1.8c29185861611p-109 },
	   { 0x1.93c37ffa2be3p-114, 0x1.444e2559eb861p-109 },
	   { 0x1.4a49efe08b764p-114, 0x1.09735c9244f77p-109 },
	   { 0x1.0e26d33274acdp-114, 0x1.b28030446d467p-110 },
	   { 0x1.b9dfc560135fp-115, 0x1.638fa554a9791p-110 },
	   { 0x1.6955081ac80b2p-115, 0x1.22ed7a20d2031p-110 },
	   { 0x1.276f565251c73p-115, 0x1.dc07399fb9ebdp-111 },
	   { 0x1.e30d639687648p-116, 0x1.8566bbf3afdccp-111 },
	   { 0x1.8adc46e842374p-116, 0x1.3e7fef514c8f7p-111 },
	   { 0x1.42bb0eedd3fb2p-116, 0x1.0479dd0162987p-111 },
	   { 0x1.07beb0edff1b8p-116, 0x1.a9fe7272a642bp-112 },
	   { 0x1.af070915be74ep-117, 0x1.5c4d5495043b3p-112 },
	   { 0x1.602994f04daa5p-117, 0x1.1cbea64272b5fp-112 },
	   { 0x1.1fb139d7ad13p-117, 0x1.d18375dee0b86p-113 },
	   { 0x1.d5fdfa65dd70dp-118, 0x1.7c798c690caf6p-113 },
	   { 0x1.7fdb85ec65bd4p-118, 0x1.36eec953c25e3p-113 },
	   { 0x1.39787263ebbcap-118, 0x1.fc2409fc1812ep-114 },
	   { 0x1.ffeb0495cc103p-119, 0x1.9f29b80329143p-114 },
	   { 0x1.a1f276c1aeb71p-119, 0x1.5328106ecc8f8p-114 },
	   { 0x1.552f40714fe54p-119, 0x1.1507fc4d2f4bap-114 },
	   { 0x1.167c9d827337cp-119, 0x1.c484291d11ffp-115 },
	   { 0x1.c690e28b6a9bfp-120, 0x1.7189333483e3bp-115 },
	   { 0x1.72f13b97db104p-120, 0x1.2dbc3e931f24dp-115 },
	   { 0x1.2eaa616a9b21cp-120, 0x1.ecb050b3055ap-116 },
	   { 0x1.edda16b7edc87p-121, 0x1.9231c8255bcdbp-116 },
	   { 0x1.92da9c960076ap-121, 0x1.4848161f4e509p-116 },
	   { 0x1.48955baf138afp-121, 0x1.0beb55467080ap-116 },
	   { 0x1.0bf90e157d9dap-121, 0x1.b542338309321p-117 },
	   { 0x1.b5082a5d8de09p-122, 0x1.64c56b8fb3cecp-117 },
	   { 0x1.6454856772fedp-122, 0x1.231052b5f7dd6p-117 },
	   { 0x1.227ecea87251dp-122, 0x1.dadb937ed07ebp-118 },
	   { 0x1.d99724acabf71p-123, 0x1.834eb55a1d18ep-118 },
	   { 0x1.81ff31715569ap-123, 0x1.3bdc43dd8955fp-118 },
	   { 0x1.3a90e48619574p-123, 0x1.018fd4cd15479p-118 },
	   { 0x1.005296113b586p-123, 0x1.a3fee5158c03fp-119 },
	   { 0x1.a1acf8c750894p-124, 0x1.5664a8518a142p-119 },
	   { 0x1.54421936100c1p-124, 0x1.171860917e7c8p-119 },
	   { 0x1.152813e135602p-124, 0x1.c6f152728fb8fp-120 },
	   { 0x1.c375a4cba7b23p-125, 0x1.72bf4ab4db677p-120 },
	   { 0x1.6fa5568fa20f3p-125, 0x1.2e18c95c4bfb1p-120 },
	   { 0x1.2b5b13ef0805cp-125, 0x1.ec41a3d4cf576p-121 },
	   { 0x1.e77117811a7d2p-126, 0x1.91022d83bf8f5p-121 },
	   { 0x1.8ccd934db2cbp-126, 0x1.46a292659269ep-121 },
	   { 0x1.42faa33070d2ap-126, 0x1.0a05da41d6048p-121 },
	   { 0x1.06db98d7f6125p-126, 0x1.b14375f322de2p-122 },
	   { 0x1.abcdbdfcc9f7cp-127, 0x1.60c75486158bp-122 },
	   { 0x1.5c15c23fbb403p-127, 0x1.1f35bc35fb59fp-122 },
	   { 0x1.1b2fdb7cab6dfp-127, 0x1.d39954e0a9d3dp-123 },
	   { 0x1.ccb8a64624f6cp-128, 0x1.7c98ab66270f5p-123 },
	   { 0x1.76bb52e82b59ap-128, 0x1.35be6eb898758p-123 },
	   { 0x1.30c117f001ac3p-128, 0x1.f819edd38db9cp-124 },
	   { 0x1.efa0e49e3feccp-129, 0x1.9a2821242ebdp-124 },
	   { 0x1.92fa046d58d4ep-129, 0x1.4dadd528d6ea9p-124 },
	   { 0x1.479ae4e865feep-129, 0x1.0f6d9e092345cp-124 },
	   { 0x1.0a4c603089f16p-129, 0x1.b987187720ae4p-125 },
	   { 0x1.b0e03e96a5485p-130, 0x1.6711ad9310ce1p-125 },
	   { 0x1.5fc89a9e03199p-130, 0x1.23f97aea9f29fp-125 },
	   { 0x1.1dd90a3522c75p-130, 0x1.dac6b554960ffp-126 },
	   { 0x1.d07c0b8b30398p-131, 0x1.81f77dc55f2bdp-126 },
	   { 0x1.795540ea5dda7p-131, 0x1.39bb36d1a51dap-126 },
	   { 0x1.327f191dd6247p-131, 0x1.fdf7c425dfb89p-127 },
	   { 0x1.f1db008e061d6p-132, 0x1.9e6c7f42ee3ap-127 },
	   { 0x1.944b7c8850269p-132, 0x1.50bd38f4b0e14p-127 },
	   { 0x1.4846e1e475567p-132, 0x1.11954fcd9d596p-127 },
	   { 0x1.0a8512d6deebp-132, 0x1.bc7d8a23288e1p-128 },
	   { 0x1.b0b57b848dfd5p-133, 0x1.69099571fea27p-128 },
	   { 0x1.5f385601a1095p-133, 0x1.25378a982372p-128 },
	   { 0x1.1d0aee3f21eaep-133, 0x1.dc36feecfa2bap-129 },
	   { 0x1.ce9ce0f1b56b8p-134, 0x1.82a9fb7ad076bp-129 },
	   { 0x1.775af322a6fb6p-134, 0x1.39ea243c7bf71p-129 },
	   { 0x1.3084e2fb958e5p-134, 0x1.fda4af81b306ap-130 },
	   { 0x1.ee0aaff5c7275p-135, 0x1.9da7a2c5ab52cp-130 },
	   { 0x1.90b5b261712acp-135, 0x1.4fb44aa933f5cp-130 },
	   { 0x1.44f853ca3d2a1p-135, 0x1.1068e39733d5fp-130 },
	   { 0x1.07839b24e2329p-135, 0x1.ba0b385a9673fp-131 },
	   { 0x1.ab4ef712ea53cp-136, 0x1.669cb88b98bb4p-131 },
	   { 0x1.5a6a27edc2aafp-136, 0x1.22e458ff074e2p-131 },
	   { 0x1.18ccfb2383c0dp-136, 0x1.d7dccacf16bdfp-132 },
	   { 0x1.c72c7d427b5c7p-137, 0x1.7ea9a57d9c3fdp-132 },
	   { 0x1.70debd3477d7cp-137, 0x1.364981b4fcaccp-132 },
	   { 0x1.2ae4c8505c4dcp-137, 0x1.f723b60a4c45ap-133 },
	   { 0x1.e45347f37826dp-138, 0x1.97e0b5db827a8p-133 },
	   { 0x1.8859d9d834871p-138, 0x1.4a9cae44d02aap-133 },
	   { 0x1.3dcdd6f53a761p-138, 0x1.0bf347561e06fp-133 },
	   { 0x1.0163c7a1b8ce3p-138, 0x1.b246ea577dcd5p-134 },
	   { 0x1.a0de9e4d0326ap-139, 0x1.5fe1a8f2ffd47p-134 },
	   { 0x1.518a7407eb90ep-139, 0x1.1d15869af1a46p-134 },
	   { 0x1.1146574533e59p-139, 0x1.cde08f63664fdp-135 },
	   { 0x1.ba6f77161f191p-140, 0x1.761ba88bf6eedp-135 },
	   { 0x1.661c59f17faep-140, 0x1.2efafc89163c3p-135 },
	   { 0x1.21d2894bdd4c7p-140, 0x1.eab12c8aa7e5p-136 },
	   { 0x1.d50e0eba3e44dp-141, 0x1.8d4d432dee077p-136 },
	   { 0x1.7b84a5753cf1fp-141, 0x1.41a589d11cb19p-136 },
	   { 0x1.33091416396dbp-141, 0x1.045db9ec2ba81p-136 },
	   { 0x1.f0bb3ff173143p-142, 0x1.a57861242277fp-137 },
	   { 0x1.91c3cacc75aaap-142, 0x1.551681b8d361p-137 },
	   { 0x1.44ea256a84bbp-142, 0x1.140098b38820cp-137 },
	   { 0x1.06bb841410434p-142, 0x1.be9e2feb561ep-138 },
	   { 0x1.a8d98b0d5771p-143, 0x1.694e9fdcb7be5p-138 },
	   { 0x1.57755a2313bdfp-143, 0x1.24419d9ce37ffp-138 },
	   { 0x1.15a03d39bca43p-143, 0x1.d8bf1578b3aacp-139 },
	   { 0x1.c0c4e9f387792p-144, 0x1.7e4dfe2cee6a2p-139 },
	   { 0x1.6aa9b63079411p-144, 0x1.3520b0bf08a51p-139 },
	   { 0x1.250ad98a67e4fp-144, 0x1.f3daa3dd37f3ap-140 },
	   { 0x1.d9842421f4af1p-145, 0x1.94140b3abb78ep-140 },
	   { 0x1.7e859d0226582p-145, 0x1.469d2facc66f7p-140 },
	   { 0x1.34f9e5d4c96d3p-145, 0x1.07f7c6b04c092p-140 },
	   { 0x1.f314a5f5af6d7p-146, 0x1.aa9f80ec12e52p-141 },
	   { 0x1.9306ca687d568p-146, 0x1.58b5e63278412p-141 },
	   { 0x1.456b681315dafp-146, 0x1.167dcc97a0fd3p-141 },
	   { 0x1.06b98180e66fp-146, 0x1.c1ee5bab4ede7p-142 },
	   { 0x1.a82a4c036e3f3p-147, 0x1.6b69077bfc3c7p-142 },
	   { 0x1.565cda5d05a6ap-147, 0x1.257dcc5bc2717p-142 },
	   { 0x1.144d77262f022p-147, 0x1.d9fdd2296338fp-143 },
	   { 0x1.bdec7b50a66cp-148, 0x1.7eb427b4ddd71p-143 },
	   { 0x1.67cb265d8483ap-148, 0x1.34f5aee91217p-143 },
	   { 0x1.224399b226996p-148, 0x1.f2ca4dc8ff69fp-144 },
	   { 0x1.d448f86c23d12p-149, 0x1.92943634830d2p-144 },
	   { 0x1.79b2a15ae0faap-149, 0x1.44e2d8e947442p-144 },
	   { 0x1.3098d833c2dap-149, 0x1.0627b1e47c261p-144 },
	   { 0x1.eb3aa595948f3p-150, 0x1.a705784809825p-145 },
	   { 0x1.8c0f08dff4e68p-150, 0x1.554226cd542efp-145 },
	   { 0x1.3f49a8880f6adp-150, 0x1.1343e7a202e9p-145 },
	   { 0x1.015dd1c62a082p-150, 0x1.bc0384ab3550dp-146 },
	   { 0x1.9edb80143a705p-151, 0x1.660fe966c4e28p-146 },
	   { 0x1.4e52056f2dec4p-151, 0x1.20b6b60dae611p-146 },
	   { 0x1.0d62a769875ep-151, 0x1.d1893fc15ba16p-147 },
	   { 0x1.b2128dd015485p-152, 0x1.7747e31ddd25cp-147 },
	   { 0x1.5dad6d3a16694p-152, 0x1.2e7c997078049p-147 },
	   { 0x1.19a81ef58dfc6p-152, 0x1.e790d89e8e564p-148 },
	   { 0x1.c5ae1b79c4ee8p-153, 0x1.88e545d12ba57p-148 },
	   { 0x1.6d56e11abc8a7p-153, 0x1.3c919aea9787p-148 },
	   { 0x1.262a204b39df1p-153, 0x1.fe13c6f07b6aep-149 },
	   { 0x1.d9a774b67b183p-154, 0x1.9ae2b16a9550ap-149 },
	   { 0x1.7d48e51f6d6edp-154, 0x1.4af14f857334ep-149 },
	   { 0x1.32e43016e50e4p-154, 0x1.0a8564eab8ff5p-149 },
	   { 0x1.edf747f9f14f1p-155, 0x1.ad3a33350402p-150 },
	   { 0x1.8d7d80e14b91p-155, 0x1.5996d7e13f467p-150 },
	   { 0x1.3fd1708b687cbp-155, 0x1.1636f3d76858ap-150 },
	   { 0x1.014ad3fec9ec4p-155, 0x1.bfe545fce7a55p-151 },
	   { 0x1.9dee40ecc2982p-156, 0x1.687ce08618977p-151 },
	   { 0x1.4ceca2b27454p-156, 0x1.221a377d62eb4p-151 },
	   { 0x1.0bbd071377b87p-156, 0x1.d2dcd30499eb7p-152 },
	   { 0x1.ae9438e9a5c0bp-157, 0x1.779da2df7a30cp-152 },
	   { 0x1.5a30285652adp-157, 0x1.2e2a7c1fe1c5fp-152 },
	   { 0x1.164daef1c2b15p-157, 0x1.e61933d473856p-153 },
	   { 0x1.bf6806876a635p-158, 0x1.86f2e6e7e582ap-153 },
	   { 0x1.67960688424efp-158, 0x1.3a62b4892ce6ep-153 },
	   { 0x1.20f7f47f404a7p-158, 0x1.f99234ed0089ep-154 },
	   { 0x1.d061d530972c5p-159, 0x1.9676058974913p-154 },
	   { 0x1.7517e8c57f622p-159, 0x1.46bd7c1e28efp-154 },
	   { 0x1.2bb6ba79809edp-159, 0x1.069f8cb02119fp-154 },
	   { 0x1.e17962871247p-160, 0x1.a61febb6d574dp-155 },
	   { 0x1.82af24bbe81ddp-160, 0x1.53351984f5d61p-155 },
	   { 0x1.3684a09debb18p-160, 0x1.108b4faaa8971p-155 },
	   { 0x1.f2a603a977e7cp-161, 0x1.b5e91e3ee196dp-156 },
	   { 0x1.9054beadf5a51p-161, 0x1.5fc381e001854p-156 },
	   { 0x1.415c074fc9065p-161, 0x1.1a8782bc000bep-156 },
	   { 0x1.01ef55a0092e3p-161, 0x1.c5c9be5ba37d4p-157 },
	   { 0x1.9e016e74801cbp-162, 0x1.6c625c9dd5c05p-157 },
	   { 0x1.4c3713bae315dp-162, 0x1.248f08aa2a9f5p-157 },
	   { 0x1.0a8cf82738469p-162, 0x1.d5b98efc2e8d5p-158 },
	   { 0x1.abada51b7b47ep-163, 0x1.790b07dcc17ddp-158 },
	   { 0x1.570fb47030aa8p-163, 0x1.2e9c8b4dec3dep-158 },
	   { 0x1.13270ae279a57p-163, 0x1.e5affac730013p-159 },
	   { 0x1.b951931589ad6p-164, 0x1.85b69d604d483p-159 },
	   { 0x1.61dfa678e3296p-164, 0x1.38aa7fa8655e3p-159 },
	   { 0x1.1bb88966006c4p-164, 0x1.f5a41ad29abd6p-160 },
	   { 0x1.c6e52f00f28e6p-165, 0x1.925df815332e1p-160 },
	   { 0x1.6ca07adb2cabep-165, 0x1.42b32a68b6433p-160 },
	   { 0x1.243c4de072741p-165, 0x1.02c65f05a223cp-160 },
	   { 0x1.d4603cf73627ep-166, 0x1.9ef9ba1f58105p-161 },
	   { 0x1.774b9c8b0652p-166, 0x1.4cb0a4ddc2264p-161 },
	   { 0x1.2cad15ed5f00dp-166, 0x1.0ab038a2ddd17p-161 },
	   { 0x1.e1ba565f2f2dap-167, 0x1.ab82536c08c11p-162 },
	   { 0x1.81da56c03901cp-167, 0x1.569ce24f30cadp-162 },
	   { 0x1.350587b61e2e7p-167, 0x1.128ac3f80b9acp-162 },
	   { 0x1.eeeaf2386ba73p-168, 0x1.b7f008c184953p-163 },
	   { 0x1.8c45dba9ebaffp-168, 0x1.6071b5b7d5f0bp-163 },
	   { 0x1.3d40375ab2fc9p-168, 0x1.1a5112ad78884p-163 },
	   { 0x1.fbe96dd52dd2ap-169, 0x1.c43afb43abf3ap-164 },
	   { 0x1.96874b77050b3p-169, 0x1.6a28d7dab475p-164 },
	   { 0x1.4557ac9b8a4ffp-169, 0x1.21fe234726979p-164 },
	   { 0x1.04568afbad70bp-169, 0x1.d05b30647f5b6p-165 },
	   { 0x1.a097bba9c5bbap-170, 0x1.73bbedaae952fp-165 },
	   { 0x1.4d4668bc3c638p-170, 0x1.298ce64edbc52p-165 },
	   { 0x1.0a969821c25d4p-170, 0x1.dc489a35fd89p-166 },
	   { 0x1.aa703eac27071p-171, 0x1.7d248efdebaf1p-166 },
	   { 0x1.5506ec96ce1d8p-171, 0x1.30f843b6c62b7p-166 },
	   { 0x1.10b0827e1c59fp-171, 0x1.e7fb2011e1175p-167 },
	   { 0x1.b409eb99c2287p-172, 0x1.865c4d7ebd336p-167 },
	   { 0x1.5c93bed6568e9p-172, 0x1.383b206d0bb99p-167 },
	   { 0x1.169ff47b694c6p-172, 0x1.f36aa78ac249dp-168 },
	   { 0x1.bd5de633517f7p-173, 0x1.8f5cbbd7e3bd9p-168 },
	   { 0x1.63e7724f64774p-173, 0x1.3f5064180659dp-168 },
	   { 0x1.1c60a3dd2224ep-173, 0x1.fe8f1d993bb19p-169 },
	   { 0x1.c66566ef40333p-174, 0x1.981f750955121p-169 },
	   { 0x1.6afcac6c09d1ap-174, 0x1.4632fef2669ecp-169 },
	   { 0x1.21ee56dbc8c6ap-174, 0x1.04b03ffb7174ap-169 },
	   { 0x1.cf19c31a391acp-175, 0x1.a09e23dee12dbp-170 },
	   { 0x1.71ce2ba111a68p-175, 0x1.4cddefbe00daep-170 },
	   { 0x1.2744e94597dfp-175, 0x1.09eb734c1a314p-170 },
	   { 0x1.d77474fa3c96fp-176, 0x1.a8d28a7b21f9ep-171 },
	   { 0x1.7856cde19858bp-176, 0x1.534c49c3a48ap-171 },
	   { 0x1.2c60519b06073p-176, 0x1.0ef5469afe541p-171 },
	   { 0x1.df6f23e67822ep-177, 0x1.b0b689ea896fp-172 },
	   { 0x1.7e9197060941ap-177, 0x1.59793ad60d8abp-172 },
	   { 0x1.313ca61e59763p-177, 0x1.13c9ee6b2a529p-172 },
	   { 0x1.e703ac45eb1a5p-178, 0x1.b84429b1d33d8p-173 },
	   { 0x1.8479b71b66ff2p-178, 0x1.5f60114dc317ap-173 },
	   { 0x1.35d621cd7892fp-178, 0x1.1865baa279b03p-173 },
	   { 0x1.ee2c2766d39aep-179, 0x1.bf759f4ae6481p-174 },
	   { 0x1.8a0a908fbee34p-179, 0x1.64fc41f392bcdp-174 },
	   { 0x1.3a29293d26666p-179, 0x1.1cc51b3533d1bp-174 },
	   { 0x1.f4e2f320ed2f5p-180, 0x1.c645558315ad7p-175 },
	   { 0x1.8f3fbe30bc1d8p-180, 0x1.6a496dcf4682p-175 },
	   { 0x1.3e324f4cf0981p-180, 0x1.20e4a4b8e031ep-175 },
	   { 0x1.fb22b934b993p-181, 0x1.ccadf3adb1afp-176 },
	   { 0x1.941518f17ca26p-181, 0x1.6f4367d03dbd8p-176 },
	   { 0x1.41ee59ab3f625p-181, 0x1.24c114d62226p-176 },
	   { 0x1.00733b2d2d2a7p-181, 0x1.d2aa649df6e65p-177 },
	   { 0x1.9886bd6d1085bp-182, 0x1.73e63a45afd4dp-177 },
	   { 0x1.455a452136a6p-182, 0x1.285756918be22p-177 },
	   { 0x1.0314c07978175p-182, 0x1.d835dd5ba6335p-178 },
	   { 0x1.9c91111b6c15fp-183, 0x1.782e2c1c97a81p-178 },
	   { 0x1.4873499e69a71p-183, 0x1.2ba486638ab1ep-178 },
	   { 0x1.0573c7a800f18p-183, 0x1.dd4be385e972p-179 },
	   { 0x1.a030c72f0cf33p-184, 0x1.7c17c5d99552cp-179 },
	   { 0x1.4b36ddfcc8743p-184, 0x1.2ea5f617d321fp-179 },
	   { 0x1.078e5ec28bafdp-184, 0x1.e1e853589fe15p-180 },
	   { 0x1.a362e51221b9fp-185, 0x1.7f9fd64579e1ap-180 },
	   { 0x1.4da2bb75a5c65p-185, 0x1.3159306d0abdp-180 },
	   { 0x1.0962c95c3eb5p-185, 0x1.e6076548c0765p-181 },
	   { 0x1.a624c67aa97dfp-186, 0x1.82c376c3acddfp-181 },
	   { 0x1.4fb4e0c13d49p-186, 0x1.33bbfc6dd55a6p-181 },
	   { 0x1.0aef82f484486p-186, 0x1.e9a5b32d2ef52p-182 },
	   { 0x1.a874210dbadcfp-187, 0x1.85800f4a2d262p-182 },
	   { 0x1.516b94dabb86dp-187, 0x1.35cc607ce4fd8p-182 },
	   { 0x1.0c33410fd4c56p-187, 0x1.ecc03cea2935dp-183 },
	   { 0x1.aa4f078af0321p-188, 0x1.87d359f39448ep-183 },
	   { 0x1.52c5696370c9dp-188, 0x1.3788a50e33e44p-183 },
	   { 0x1.0d2cf5025ba2dp-188, 0x1.ef546c9652b0ap-184 },
	   { 0x1.abb3ec79d594dp-189, 0x1.89bb66243bfd5p-184 },
	   { 0x1.53c13ca08d951p-189, 0x1.38ef570827673p-184 },
	   { 0x1.0ddbcd68fc943p-189, 0x1.f1601a115b514p-185 },
	   { 0x1.aca1a45423b35p-190, 0x1.8b369b3c6ec4fp-185 },
	   { 0x1.545e3b0f8838ap-190, 0x1.39ff49c7fe5e8p-185 },
	   { 0x1.0e3f374dd9d68p-190, 0x1.f2e18e05495b4p-186 },
	   { 0x1.ad1767288e013p-191, 0x1.8c43bad265564p-186 },
	   { 0x1.549be08e15927p-191, 0x1.3ab798c59d4c2p-186 },
	   { 0x1.0e56def61fbc4p-191, 0x1.f3d7844c8a592p-187 },
	   { 0x1.ad14d1b2f0b5fp-192, 0x1.8ce1e26fb8214p-187 },
	   { 0x1.5479f9137160bp-192, 0x1.3b17a8d383f04p-187 },
	   { 0x1.0e22b05782284p-192, 0x1.f4412db819edfp-188 },
	   { 0x1.ac99e5e7b9269p-193, 0x1.8d108ccedcd75p-188 },
	   { 0x1.53f8a0f98a8b8p-193, 0x1.3b1f28f8795cap-188 },
	   { 0x1.0da2d734853ffp-193, 0x1.f41e3132440dap-189 },
	   { 0x1.aba70af1767bp-194, 0x1.8ccf9296410aep-189 },
	   { 0x1.531844d58365ep-194, 0x1.3ace12e143377p-189 },
	   { 0x1.0cd7bedf59779p-194, 0x1.f36eac3bc78c2p-190 },
	   { 0x1.aa3d0ca096eedp-195, 0x1.8c1f2a8f92477p-190 },
	   { 0x1.51d9a0dfd2e93p-195, 0x1.3a24aae988ae7p-190 },
	   { 0x1.0bc211a3c2859p-195, 0x1.f23332c263066p-191 },
	   { 0x1.a85d1a4e6bedcp-196, 0x1.8affe95ac6f2ap-191 },
	   { 0x1.503dbfed30324p-196, 0x1.39237fbbcfa18p-191 },
	   { 0x1.0a62b7d92f095p-196, 0x1.f06cce511da3ep-192 },
	   { 0x1.a608c535a2ba1p-197, 0x1.8972c09d7f45cp-192 },
	   { 0x1.4e45f9fa4adffp-197, 0x1.37cb698950bdap-192 },
	   { 0x1.08bad69ed20a4p-197, 0x1.ee1cfc9be3df9p-193 },
	   { 0x1.a341fe436d2d7p-198, 0x1.8778fdb058321p-193 },
	   { 0x1.4bf3f24d273a5p-198, 0x1.361d88db2b95bp-193 },
	   { 0x1.06cbce44363ecp-198, 0x1.eb45ad695330ap-194 },
	   { 0x1.a00b13659be7cp-199, 0x1.851447ccc879bp-194 },
	   { 0x1.4949952fc2371p-199, 0x1.341b44ff4c3c6p-194 },
	   { 0x1.0497386163a39p-199, 0x1.e7e93fdecaep-195 },
	   { 0x1.9c66ac5ae65b3p-200, 0x1.82469dbf1833ep-195 },
	   { 0x1.464915486577bp-200, 0x1.31c64a141680ep-195 },
	   { 0x1.021ee5a248c7fp-200, 0x1.e40a7f340982ap-196 },
	   { 0x1.9857c70b8b2bcp-201, 0x1.7f125320f1e94p-196 },
	   { 0x1.42f4e894cc71ap-201, 0x1.2f2086b6a5cf4p-196 },
	   { 0x1.fec9b69351b7p-202, 0x1.dfac9ed4c27cep-197 },
	   { 0x1.93e1b371520a1p-202, 0x1.7b7a0d21f0262p-197 },
	   { 0x1.3f4fc50de840ap-202, 0x1.2c2c295822108p-197 },
	   { 0x1.f8d6a0e0a9508p-203, 0x1.dad335f7aacdbp-198 },
	   { 0x1.8f080f16c57cp-203, 0x1.7780bee4609a1p-198 },
	   { 0x1.3b5c9cfaada16p-203, 0x1.28eb9d3f5000ap-198 },
	   { 0x1.f269560bdbf92p-204, 0x1.d5823ab37d92ep-199 },
	   { 0x1.89cec0363502dp-204, 0x1.7329a5753ca24p-199 },
	   { 0x1.371e9af8e6ccfp-204, 0x1.2561873c1cc7ap-199 },
	   { 0x1.eb86f931c309dp-205, 0x1.cfbdfc9b64d6ep-200 },
	   { 0x1.8439f081b525ap-205, 0x1.6e7843670c8d2p-200 },
	   { 0x1.32991dc38028ep-205, 0x1.2190c2136fc76p-200 },
	   { 0x1.e434fdd743954p-206, 0x1.c98b1eed08258p-201 },
	   { 0x1.7e4e079de1a2ep-206, 0x1.69705c180d6c1p-201 },
	   { 0x1.2dcfb3be31ebdp-206, 0x1.1d7c5aaa0949p-201 },
	   { 0x1.dc7920bafc5dcp-207, 0x1.c2ee925b3e3f6p-202 },
	   { 0x1.780fa5599d558p-207, 0x1.6415eeac7f744p-202 },
	   { 0x1.28c6164ec1235p-207, 0x1.19278bf59ff34p-202 },
	   { 0x1.d459605b63623p-208, 0x1.bbed8e8100752p-203 },
	   { 0x1.71839bad6a45bp-208, 0x1.5e6d30c67b96bp-203 },
	   { 0x1.2380250c57526p-208, 0x1.1495babbc8d8ep-203 },
	   { 0x1.cbdbf53eed588p-209, 0x1.b48d8b08c37b5p-204 },
	   { 0x1.6aaee88d3a5e6p-209, 0x1.587a8905112ebp-204 },
	   { 0x1.1e01e0cda0c0ep-209, 0x1.0fca71267dd26p-204 },
	   { 0x1.c3074a0c1c67dp-210, 0x1.acd43894c1f06p-205 },
	   { 0x1.6396af97c5f7fp-210, 0x1.52428954b7c2fp-205 },
	   { 0x1.184f669e7e645p-210, 0x1.0ac95a364b406p-205 },
	   { 0x1.b9e1f37f768c9p-211, 0x1.a4c779750fb77p-206 },
	   { 0x1.5c4033ae88d94p-211, 0x1.4bc9e91b546a8p-206 },
	   { 0x1.126ceaa621095p-211, 0x1.05963d1a5105bp-206 },
	   { 0x1.b072a84d6770bp-212, 0x1.9c6d5a387a6d7p-207 },
	   { 0x1.54b0d08180ac6p-212, 0x1.45157f4a2e598p-207 },
	   { 0x1.0c5eb30658611p-212, 0x1.0034f87652744p-207 },
	   { 0x1.a6c038fdf5aedp-213, 0x1.93cc0a254a9f5p-208 },
	   { 0x1.4cedf419a9b38p-213, 0x1.3e2a3c60327aap-208 },
	   { 0x1.062912bcc23f9p-213, 0x1.f552fb3e1c70bp-209 },
	   { 0x1.9cd187cff951cp-214, 0x1.8ae9d3a6eb66fp-209 },
	   { 0x1.44fd186d008c2p-214, 0x1.370d2466d3327p-209 },
	   { 0x1.ffa0c91caab55p-215, 0x1.e9ef97aa04b46p-210 },
	   { 0x1.92ad80b12a09bp-215, 0x1.81cd14bd535bbp-210 },
	   { 0x1.3ce3bd0683046p-215, 0x1.2fc348f3a8121p-210 },
	   { 0x1.f2b20c0b002abp-216, 0x1.de47d70b3398cp-211 },
	   { 0x1.885b1157e885cp-216, 0x1.787c377ac34cdp-211 },
	   { 0x1.34a760cc47acap-216, 0x1.2851c338b22e4p-211 },
	   { 0x1.e58ea51580badp-217, 0x1.d263d33512bb6p-212 },
	   { 0x1.7de1218b19542p-217, 0x1.6efdaa9c0e45ep-212 },
	   { 0x1.2c4d7bed4d522p-217, 0x1.20bdae2cd61c6p-212 },
	   { 0x1.d83f3d3e6d15p-218, 0x1.c64ba5bdb46dep-213 },
	   { 0x1.73468ba3c29b8p-218, 0x1.6557da47246f7p-213 },
	   { 0x1.23db7a001a935p-218, 0x1.190c20d5b5808p-213 },
	   { 0x1.cacc668087b83p-219, 0x1.ba075f0192b6p-214 },
	   { 0x1.689215536317fp-219, 0x1.5b9128fb09361p-214 },
	   { 0x1.1b56b45aac06fp-219, 0x1.114228bb99133p-214 },
	   { 0x1.bd3e92f58e3aep-220, 0x1.ad9efd6e7e35p-215 },
	   { 0x1.5dca68b92a62fp-220, 0x1.51afe8bbb6b6cp-215 },
	   { 0x1.12c46cab86e91p-220, 0x1.0964c48f92b05p-215 },
	   { 0x1.af9e0c680145ap-221, 0x1.a11a652260dp-216 },
	   { 0x1.52f60dcf5b39p-221, 0x1.47ba5483b6e8fp-216 },
	   { 0x1.0a29c7db10f7p-221, 0x1.0178df0b67157p-216 },
	   { 0x1.a1f2ec5b27de2p-222, 0x1.948157e97fbd7p-217 },
	   { 0x1.481b643932becp-222, 0x1.3db68a0470a4fp-217 },
	   { 0x1.018bc93b8e2e5p-222, 0x1.f306942454ae6p-218 },
	   { 0x1.9445149305037p-223, 0x1.87db6da6dd3cap-218 },
	   { 0x1.3d409d78b6819p-223, 0x1.33aa83bd4deabp-218 },
	   { 0x1.f1de9c1ab95aap-224, 0x1.e311742f9561bp-219 },
	   { 0x1.869c2824b4b6bp-224, 0x1.7b300d303ed2cp-219 },
	   { 0x1.326bb792c8c5bp-224, 0x1.299c1370fc2d1p-219 },
	   { 0x1.e0b212b870715p-225, 0x1.d31b83aa1a53bp-220 },
	   { 0x1.78ff85165ac91p-225, 0x1.6e8665a634affp-220 },
	   { 0x1.27a27826da7a5p-225, 0x1.1f90dcff1976ep-220 },
	   { 0x1.cf9b0072f8176p-226, 0x1.c32d9c998168ap-221 },
	   { 0x1.6b763e947db08p-226, 0x1.61e5684f4d137p-221 },
	   { 0x1.1cea67fe8699cp-226, 0x1.158e51a7ac97ep-221 },
	   { 0x1.bea20cad09b1fp-227, 0x1.b350464c51c99p-222 },
	   { 0x1.5e0717c155a1cp-227, 0x1.5553c2fc66728p-222 },
	   { 0x1.1248cf18568a2p-227, 0x1.0b99abbccdbb1p-222 },
	   { 0x1.adcf760300963p-228, 0x1.a38baebfb68e4p-223 },
	   { 0x1.50b87f214792dp-228, 0x1.48d7dafad7ffep-223 },
	   { 0x1.07c2b12fe4dbap-228, 0x1.01b7eac5ea688p-223 },
	   { 0x1.9d2b0d0c4a0b1p-229, 0x1.93e7a4bb0743p-224 },
	   { 0x1.43908aa677d25p-229, 0x1.3c77c897ed254p-224 },
	   { 0x1.fab995891c153p-230, 0x1.efdba02e2ceffp-225 },
	   { 0x1.8cbc2fe600108p-230, 0x1.846b92a47c343p-225 },
	   { 0x1.3694f45c1b92fp-230, 0x1.30395337f89bbp-225 },
	   { 0x1.e6371d3dc0233p-231, 0x1.dc7fb7bbca8adp-226 },
	   { 0x1.7c89c6867890ep-231, 0x1.751e7a10e8264p-226 },
	   { 0x1.29cb17b0f706bp-231, 0x1.2421ee0211f87p-226 },
	   { 0x1.d20647a807a0cp-232, 0x1.c9649548abac7p-227 },
	   { 0x1.6c9a3fd812077p-232, 0x1.6606f00ed6d5dp-227 },
	   { 0x1.1d37ef5f490cdp-232, 0x1.1836b52067807p-227 },
	   { 0x1.be2ec88ae1479p-233, 0x1.b6922692e74d4p-228 },
	   { 0x1.5cf38f9818abfp-233, 0x1.572b1a2c0293ap-228 },
	   { 0x1.10e013ef486f7p-233, 0x1.0c7c6b93f06a1p-228 },
	   { 0x1.aab7b734b99f6p-234, 0x1.a40fcadcdd133p-229 },
	   { 0x1.4d9b2cf546b09p-234, 0x1.4890ac32b69b5p-229 },
	   { 0x1.04c7bad04b57cp-234, 0x1.00f779993bbc1p-229 },
	   { 0x1.97a78d5f1c6dbp-235, 0x1.91e450ac30542p-230 },
	   { 0x1.3e9611e8218p-235, 0x1.3a3ce69b6a143p-230 },
	   { 0x1.f1e56c0773bb7p-236, 0x1.eb57d7362f984p-231 },
	   { 0x1.850426f2df55dp-236, 0x1.8015f467ddd4p-231 },
	   { 0x1.2fe8bb3e4f4d8p-236, 0x1.2c3495adab7d8p-231 },
	   { 0x1.dac8e8a813f1fp-237, 0x1.d53ae35dbfa26p-232 },
	   { 0x1.72d2c2a7422abp-237, 0x1.6eaa5fce4af3ap-232 },
	   { 0x1.21972950f570dp-237, 0x1.1e7c114a57a33p-232 },
	   { 0x1.c44004226dc17p-238, 0x1.bf9ebf2ac34cfp-233 },
	   { 0x1.6118037139874p-238, 0x1.5da6aa3adb7a3p-233 },
	   { 0x1.13a4e15d42467p-238, 0x1.11173d5813f4dp-233 },
	   { 0x1.ae501496e23f2p-239, 0x1.aa895a750e0f6p-234 },
	   { 0x1.4fd7f2b705e64p-239, 0x1.4d0f59b16ac32p-234 },
	   { 0x1.0614ef7575b09p-239, 0x1.04098aca1b898p-234 },
	   { 0x1.98fdb1084fd1cp-240, 0x1.95ffef5a788b3p-235 },
	   { 0x1.3f16033b4da17p-240, 0x1.3ce864a4f75bbp-235 },
	   { 0x1.f1d3d20014dd3p-241, 0x1.eeabf27142ccbp-236 },
	   { 0x1.844cb59a101a9p-241, 0x1.82070510e6e91p-236 },
	   { 0x1.2ed514b22b68bp-241, 0x1.2d35346de60f3p-236 },
	   { 0x1.d84bdf7421499p-242, 0x1.d5fe3202b4d44p-237 },
	   { 0x1.7040489842ad7p-242, 0x1.6ea2738b3dbebp-237 },
	   { 0x1.1f1777f205012p-242, 0x1.1df8a8637ba9cp-237 },
	   { 0x1.bf956a62adf73p-243, 0x1.be0e1bcc5bf2bp-238 },
	   { 0x1.5cdae0381ff94p-243, 0x1.5bd567e120a1cp-238 },
	   { 0x1.0fdef3b187063p-243, 0x1.0f35198b8b7f7p-238 },
	   { 0x1.a7b2fd5556b6ap-244, 0x1.a6df243f2c6f4p-239 },
	   { 0x1.4a1e48fd99b8ep-244, 0x1.49a26968a8fd1p-239 },
	   { 0x1.012cc9c3d142ap-244, 0x1.00ec5ed2dbe3ep-239 },
	   { 0x1.90a652d08b6ecp-245, 0x1.9073f3afbdfebp-240 },
	   { 0x1.380bacb3471d9p-245, 0x1.380b5f70c487dp-240 },
	   { 0x1.e603798765b0ap-246, 0x1.e63fa380d130bp-241 },
	   { 0x1.7a705e88ab4c8p-246, 0x1.7ace6e086aab7p-241 },
	   { 0x1.26a399e180e7cp-246, 0x1.2711978a97cf7p-241 },
	   { 0x1.cabc2c3d98d7cp-247, 0x1.cba0a72ae9c08p-242 },
	   { 0x1.651157275ac6fp-247, 0x1.65efbb20adf2dp-242 },
	   { 0x1.15e60bb1a2bacp-247, 0x1.16b5cc5019368p-242 },
	   { 0x1.b08358e30e1b1p-248, 0x1.b1fca598944c3p-243 },
	   { 0x1.5088c08941b89p-248, 0x1.51d84fa353951p-243 },
	   { 0x1.05d2722aa0abep-248, 0x1.06f82c9619b9p-243 },
	   { 0x1.9757d44a0d5d1p-249, 0x1.9953a1cf16aadp-244 },
	   { 0x1.3cd5765cc7b51p-249, 0x1.3e87f66d27bbp-244 },
	   { 0x1.eccf7568ff3afp-250, 0x1.efb0c5f0312cdp-245 },
	   { 0x1.7f37a88128933p-250, 0x1.81a4d1085cfd1p-245 },
	   { 0x1.29f5b70afae6ep-250, 0x1.2bfdda4e2b20cp-245 },
	   { 0x1.cf48b1a182cb9p-251, 0x1.d2ab3b59164a6p-246 },
	   { 0x1.682022c0d8296p-251, 0x1.6aeea740e7e26p-246 },
	   { 0x1.17e72ed48d1c2p-251, 0x1.1a389017ca93cp-246 },
	   { 0x1.b30c9decefa86p-252, 0x1.b6dd2d215fccfp-247 },
	   { 0x1.520de188c8ff4p-252, 0x1.552ee415230cdp-247 },
	   { 0x1.06a7030db71fbp-252, 0x1.093620e33d9f9p-247 },
	   { 0x1.98166f02e00aap-253, 0x1.9c4336b720df7p-248 },
	   { 0x1.3cfce2d301755p-253, 0x1.40629fd47fda6p-248 },
	   { 0x1.ec63bac9af50ap-254, 0x1.f1e828f7f1e6ep-249 },
	   { 0x1.7e609b497d4bfp-254, 0x1.82d92bd0fbc5bp-249 },
	   { 0x1.28e89244647b5p-254, 0x1.2c8658b1c7fabp-249 },
	   { 0x1.cd07ee41894f6p-255, 0x1.d2def7b6139fbp-250 },
	   { 0x1.65e4eca3c47cep-255, 0x1.6a9a29142865ap-250 },
	   { 0x1.15cbd7439af48p-255, 0x1.1995fff959855p-250 },
	   { 0x1.af324889fe32ep-256, 0x1.b549f742691f7p-251 },
	   { 0x1.4e9c920d5db05p-256, 0x1.5380a4af4c2e9p-251 },
	   { 0x1.03a122e1077b7p-256, 0x1.078d07375b0bp-251 },
	   { 0x1.92d9bd168c63p-257, 0x1.9921acfd99f39p-252 },
	   { 0x1.388030ea8589cp-257, 0x1.3d867ecfb60a5p-252 },
	   { 0x1.e4c4faf832008p-258, 0x1.ecccda72dba49p-253 },
	   { 0x1.77f4a046c515ep-258, 0x1.7e5deef2de87bp-253 },
	   { 0x1.2387f5f4b712ep-258, 0x1.28a511d87ce7dp-253 },
	   { 0x1.c413282821079p-259, 0x1.cc3995b1e2c4p-254 },
	   { 0x1.5e78bc56d0fbbp-259, 0x1.64f5f80200f46p-254 },
	   { 0x1.0faba5af01355p-259, 0x1.14d5424501d7ep-254 },
	   { 0x1.a51f8a6830159p-260, 0x1.ad54bef9112dp-255 },
	   { 0x1.465b65a83bdbbp-260, 0x1.4ce07b8d50856p-255 },
	   { 0x1.f9c5589e7201fp-261, 0x1.020f8e226943ep-255 },
	   { 0x1.87dc5ad8af9ecp-261, 0x1.90123a8271991p-256 },
	   { 0x1.2f918e4d3f95cp-261, 0x1.3613b89391a8fp-256 },
	   { 0x1.d6485a170413ap-262, 0x1.e098381b76cd3p-257 },
	   { 0x1.6c3b66970be3dp-262, 0x1.7465697a54c64p-257 },
	   { 0x1.1a0fd8c3a4e6fp-262, 0x1.20858c20a1795p-257 },
	   { 0x1.b4ce217bd5e55p-263, 0x1.bf05934cfa1ccp-258 },
	   { 0x1.522e259c7017ap-263, 0x1.5a41409f84e49p-258 },
	   { 0x1.05caa9cf257c4p-263, 0x1.0c2b83023243dp-258 },
	   { 0x1.954427a430b11p-264, 0x1.9f5672cf62a4fp-259 },
	   { 0x1.39a5d07601e71p-264, 0x1.41985de8f7a14p-259 },
	   { 0x1.e56c72cc01fccp-265, 0x1.f1f5d5615d783p-260 },
	   { 0x1.7797a6e64ddc9p-265, 0x1.8179bfb69c631p-260 },
	   { 0x1.229374c83806p-265, 0x1.2a5d1d1f1ae5cp-260 },
	   { 0x1.c18d454a503aep-266, 0x1.cdd1c2bddbb9ep-261 },
	   { 0x1.5bb5b3e414ad3p-266, 0x1.655e203c78adp-261 },
	   { 0x1.0ce808921de57p-266, 0x1.1481ab5a1469ap-261 },
	   { 0x1.9fdfe587f056ap-267, 0x1.abd4ca4bd8884p-262 },
	   { 0x1.418b54bd6a895p-267, 0x1.4af20f59f283dp-262 },
	   { 0x1.f128f851039d9p-268, 0x1.fff032b2dbde7p-263 },
	   { 0x1.804c6e03f60cbp-268, 0x1.8be8c488684b4p-263 },
	   { 0x1.290596a08a94fp-268, 0x1.3223f2e5be0fp-263 },
	   { 0x1.cb1395c8187f6p-269, 0x1.d964d959533d1p-264 },
	   { 0x1.62bb1316ec5fcp-269, 0x1.6df780d5ecc43p-264 },
	   { 0x1.1211a1b47d3aep-269, 0x1.1ae2302fd4bcdp-264 },
	   { 0x1.a772150026811p-270, 0x1.b5455f4e2ce45p-265 },
	   { 0x1.47143aa78b5fep-270, 0x1.51eade2a24279p-265 },
	   { 0x1.f93996ba5e93dp-271, 0x1.051b3f15282e5p-265 },
	   { 0x1.8626f2553e204p-271, 0x1.93760037df87ap-266 },
	   { 0x1.2d4091cd12adcp-271, 0x1.37ace1ccc1a8dp-266 },
	   { 0x1.d1294db79df79p-272, 0x1.e17b7713cf17fp-267 },
	   { 0x1.6715149108678p-272, 0x1.73db39c4b278bp-267 },
	   { 0x1.1529206516167p-272, 0x1.1f27cc2724f9p-267 },
	   { 0x1.abce28a1f17f2p-273, 0x1.bb70eb3792a1cp-268 },
	   { 0x1.4a1fe3e55f964p-273, 0x1.5659e4463ddd1p-268 },
	   { 0x1.fd6eb54be7326p-274, 0x1.08462ba9624dbp-268 },
	   { 0x1.89049c51b8388p-274, 0x1.97f4ffe1284a1p-269 },
	   { 0x1.2f2b5e6789756p-274, 0x1.3ad748e88c53fp-269 },
	   { 0x1.d3aa617478594p-275, 0x1.e5e5db98318a5p-270 },
	   { 0x1.68a9e9f7b2f9ap-275, 0x1.76e6798f53e9ap-270 },
	   { 0x1.161c2a1de488ep-275, 0x1.21393590da64bp-270 },
	   { 0x1.acda38e82463bp-276, 0x1.be32dc731f12cp-271 },
	   { 0x1.4a9c33e05809ap-276, 0x1.5824d30f3fce1p-271 },
	   { 0x1.fdaf4969fc45p-277, 0x1.09660e736b8bdp-271 },
	   { 0x1.88d45a53c41c5p-277, 0x1.994b0856743cbp-272 },
	   { 0x1.2eba8f55fe897p-277, 0x1.3b9051c5e7679p-272 },
	   { 0x1.d287e1e77c85ap-278, 0x1.e689bae600601p-273 },
	   { 0x1.6770239fc87e6p-278, 0x1.77071c1633b26p-273 },
	   { 0x1.14e513c1b20dcp-278, 0x1.210a174166fcdp-273 },
	   { 0x1.aa90041143186p-279, 0x1.bd7abebe480e6p-274 },
	   { 0x1.488642c71cfa6p-279, 0x1.5740f6d4ed277p-274 },
	   { 0x1.f9f9ce5a157bbp-280, 0x1.0874302ee34fdp-274 },
	   { 0x1.85974997b931fp-280, 0x1.97701e51a6bfep-275 },
	   { 0x1.2bf0c37efc00bp-280, 0x1.39d3aac239fe2p-275 },
	   { 0x1.cdc89092e43c3p-281, 0x1.e36341a88ea0cp-276 },
	   { 0x1.636f0e2785c54p-281, 0x1.743c5e4db43f9p-276 },
	   { 0x1.118b19def65f8p-281, 0x1.1e9b8ad36fd99p-276 },
	   { 0x1.a4fd2c459c71p-282, 0x1.b94cde5e4fc3p-277 },
	   { 0x1.43ea7a73d5cfp-282, 0x1.53b3a109a94aep-277 },
	   { 0x1.f26454740b953p-283, 0x1.057635a1ed1dfp-277 },
	   { 0x1.7f60ab495565cp-283, 0x1.926f55b776f91p-278 },
	   { 0x1.26de8be09d876p-283, 0x1.35abb1f1cadefp-278 },
	   { 0x1.c5889cb51dbb9p-284, 0x1.dc853b381e5ap-279 },
	   { 0x1.5cbe6a335189cp-284, 0x1.6e96e5d005f5dp-279 },
	   { 0x1.0c22190c33c65p-284, 0x1.19fc0dba0e848p-279 },
	   { 0x1.9c42b0a7816acp-285, 0x1.b1c21d6e11086p-280 },
	   { 0x1.3ce41b9a97542p-285, 0x1.4d91f3701143cp-280 },
	   { 0x1.e71ba6efe048bp-286, 0x1.007de792cfd6ep-280 },
	   { 0x1.76552635a3b27p-286, 0x1.8a6663a0ececbp-281 },
	   { 0x1.1fa1c7f04e719p-286, 0x1.2f310e41037d6p-281 },
	   { 0x1.b9f88d1e59fb3p-287, 0x1.d2185735c5ad9p-282 },
	   { 0x1.538582347c59ep-287, 0x1.66381bdd98a02p-282 },
	   { 0x1.04c9ca3c242adp-287, 0x1.1346f1ba5a69ap-282 },
	   { 0x1.9093a8968bba5p-288, 0x1.a706fd9470fb8p-283 },
	   { 0x1.339c31e0d51b7p-288, 0x1.45000f1eec014p-283 },
	   { 0x1.d8619415342d3p-289, 0x1.f3510620184eap-284 },
	   { 0x1.6aa95f63dd017p-289, 0x1.7f84791f6fdbbp-284 },
	   { 0x1.16648113f6ec6p-289, 0x1.2689bc620188bp-284 },
	   { 0x1.ab5b65b277be7p-290, 0x1.c45998d7521aep-285 },
	   { 0x1.47f9aad3382fep-290, 0x1.5b50e4b7d6356p-285 },
	   { 0x1.f7591b1b1c875p-291, 0x1.0aa3508d5dbp-285 },
	   { 0x1.82335294ba26p-291, 0x1.9959eb6f64db6p-286 },
	   { 0x1.2848053b7dfb1p-291, 0x1.3a2fb2a16d1ccp-286 },
	   { 0x1.c68a6f5a8ef62p-292, 0x1.e23b370697cbbp-287 },
	   { 0x1.5c9ffcce7e5fdp-292, 0x1.720876851d9fbp-287 },
	   { 0x1.0b5b54d487d35p-292, 0x1.1be79c992aff6p-287 },
	   { 0x1.9a0421e5c5d71p-293, 0x1.b3980569c43a5p-288 },
	   { 0x1.3a5c4268d4e27p-293, 0x1.4e1fc4f822568p-288 },
	   { 0x1.e1fba80d34a41p-294, 0x1.0042910b94342p-288 },
	   { 0x1.7172912ec21f8p-294, 0x1.8908e30f7a1b3p-289 },
	   { 0x1.1b271db151968p-294, 0x1.2d5e5a1b8288ep-289 },
	   { 0x1.b1f9ef2d6b135p-295, 0x1.ce1b3b9ea6267p-290 },
	   { 0x1.4c872d1af92bcp-295, 0x1.623e8fb994f23p-290 },
	   { 0x1.fd87064e02a6fp-296, 0x1.0f8695160ca38p-290 },
	   { 0x1.8652a61cdcd3bp-296, 0x1.a031b186be289p-291 },
	   { 0x1.2af84a660968dp-296, 0x1.3eee8e04dc3ap-291 },
	   { 0x1.c9f07af149226p-297, 0x1.e8bd23cc416fp-292 },
	   { 0x1.5eacf76fffc0cp-297, 0x1.766e8d5583265p-292 },
	   { 0x1.0c80f3efbbf3fp-297, 0x1.1ed2fab014c43p-292 },
	   { 0x1.9b1f8ffd8f3c8p-298, 0x1.b76010ebb6c6ap-293 },
	   { 0x1.3ab5d5023fe4ap-298, 0x1.507d813502ab7p-293 },
	   { 0x1.e1c174ea2aaa6p-299, 0x1.01aa61c90eaccp-293 },
	   { 0x1.70b05029068dap-299, 0x1.8a90544ab274dp-294 },
	   { 0x1.1a1fba21de5fp-299, 0x1.2e0fb0911dd84p-294 },
	   { 0x1.afb70654af059p-300, 0x1.ce6f24739f7c7p-295 },
	   { 0x1.4a458b53b2a84p-300, 0x1.61eefc532711fp-295 },
	   { 0x1.f944d95c81983p-301, 0x1.0edb77098a96p-295 },
	   { 0x1.8272ab43f7156p-301, 0x1.9e82e04d9025fp-296 },
	   { 0x1.278886c5a4d73p-301, 0x1.3d237a2e0f859p-296 },
	   { 0x1.c3f57b512a1f2p-302, 0x1.e5385c7d0efep-297 },
	   { 0x1.598c52c5d1746p-302, 0x1.73258d0b919ebp-297 },
	   { 0x1.0828ad1da0983p-302, 0x1.1bdb57d01ceccp-297 },
	   { 0x1.93d4935512f54p-303, 0x1.b223e5e67d24ap-298 },
	   { 0x1.34a3670d3cd59p-303, 0x1.4bf43098a2ef1p-298 },
	   { 0x1.d7b67cefff216p-304, 0x1.fb93db1e39a21p-299 },
	   { 0x1.686e7356020d2p-304, 0x1.8402d3eada60ap-299 },
	   { 0x1.135e695d6d4f8p-304, 0x1.2892e3159736p-299 },
	   { 0x1.a4b6028e1ae52p-305, 0x1.c5502f868f04bp-300 },
	   { 0x1.415808da66669p-305, 0x1.5a670a5d83e0ep-300 },
	   { 0x1.ead51e60a821dp-306, 0x1.08ac71830fd4ep-300 },
	   { 0x1.76cfe88ffbfa7p-306, 0x1.9467d9d3bce7dp-301 },
	   { 0x1.1e2e61d740a91p-306, 0x1.34ea92731d6fp-301 },
	   { 0x1.b4f6c22875415p-307, 0x1.d7e402cf49a21p-302 },
	   { 0x1.4d8e03e448998p-307, 0x1.6860e96265ba8p-302 },
	   { 0x1.fd2c6816f010bp-308, 0x1.132f279000564p-302 },
	   { 0x1.8494b75728df1p-308, 0x1.a4356bd52863ep-303 },
	   { 0x1.28836b62851b4p-308, 0x1.40cac092d16a6p-303 },
	   { 0x1.c476ceb4ce0a6p-309, 0x1.e9bb8c8c45eaap-304 },
	   { 0x1.592d26553a529p-309, 0x1.75c6ad9777c96p-304 },
	   { 0x1.074be65f60432p-309, 0x1.1d3d889242361p-304 },
	   { 0x1.91a14719373e5p-310, 0x1.b34c7bf3e0108p-305 },
	   { 0x1.3248b33f78dd9p-310, 0x1.4c1bf325b5886p-305 },
	   { 0x1.d316bfa6ecf07p-311, 0x1.fab351a6d7271p-306 },
	   { 0x1.641dc398561efp-311, 0x1.827d8b273a859p-306 },
	   { 0x1.0f79d08c027e2p-311, 0x1.26c35a8453a6ep-306 },
	   { 0x1.9ddabce45ff88p-312, 0x1.c18e854f7a653p-307 },
	   { 0x1.3b6a0443345f1p-312, 0x1.56c727238c10ep-307 },
	   { 0x1.e0b830517633fp-313, 0x1.05545196af9e3p-307 },
	   { 0x1.6e4903f595976p-313, 0x1.8e6b62ae03487p-308 },
	   { 0x1.170eca4e7a4cap-313, 0x1.2facf384d3a3bp-308 },
	   { 0x1.a92756c27d93ap-314, 0x1.ceddf1e753b81p-309 },
	   { 0x1.43d40bf74392dp-314, 0x1.60b61e0028436p-309 },
	   { 0x1.ed3e286c4c0dep-315, 0x1.0cbd09b1e5e1p-309 },
	   { 0x1.77993389df313p-315, 0x1.997719e8b73a8p-310 },
	   { 0x1.1dfa945eaae99p-315, 0x1.37e77cf85ca37p-310 },
	   { 0x1.b36ec5aa0588p-316, 0x1.db1e802a6c81fp-311 },
	   { 0x1.4b749e64b35f5p-316, 0x1.69d3aa6fccfd9p-311 },
	   { 0x1.f88d823260c9ep-317, 0x1.1383f4dd09079p-311 },
	   { 0x1.7ffa0f1fabb65p-317, 0x1.a388f33976b7bp-312 },
	   { 0x1.242e12375b352p-317, 0x1.3f613589599c6p-312 },
	   { 0x1.bc9a844ffd2b5p-318, 0x1.e635a66e3ebe7p-313 },
	   { 0x1.523af73f84783p-318, 0x1.720bfb4a981d7p-313 },
	   { 0x1.0146a610e0588p-318, 0x1.199a49bcc51p-313 },
	   { 0x1.87590d6d36008p-319, 0x1.ac8ae259e160cp-314 },
	   { 0x1.299b80ea6bb7fp-319, 0x1.4609b0c4183cap-314 },
	   { 0x1.c496292aa266bp-320, 0x1.f00af26520f9dp-315 },
	   { 0x1.5817f72c95e4cp-320, 0x1.794ce31e24c7bp-315 },
	   { 0x1.059392396d038p-320, 0x1.1ef2877dbfcadp-315 },
	   { 0x1.8da5a346cbb3fp-321, 0x1.b468dc95cb829p-316 },
	   { 0x1.2e36a9eb80d32p-321, 0x1.4bd213115ac94p-316 },
	   { 0x1.cb4fb203e18ap-322, 0x1.f88862b544527p-317 },
	   { 0x1.5cfe5be9615c7p-322, 0x1.7f861b04cbe3ap-317 },
	   { 0x1.0923c6394f695p-322, 0x1.2380a7a548a2fp-317 },
	   { 0x1.92d18166ccd51p-323, 0x1.bb1122f6e5762p-318 },
	   { 0x1.31f510cb3f507p-323, 0x1.50ad48dd9b3a6p-318 },
	   { 0x1.d0b7c794af438p-324, 0x1.ff9ab8e5d6631p-319 },
	   { 0x1.60e2f23228dedp-324, 0x1.84a97f6b3e853p-319 },
	   { 0x1.0bef1906dac58p-324, 0x1.273a4b16ba84fp-319 },
	   { 0x1.96d0ca88e4fcp-325, 0x1.c07484e1da469p-320 },
	   { 0x1.34ce1af3c1b6p-325, 0x1.549037ceef1fep-320 },
	   { 0x1.d4c1f7c67dd18p-326, 0x1.0298e0fc06037p-320 },
	   { 0x1.63bcc0600e3b1p-326, 0x1.88ab45875f419p-321 },
	   { 0x1.0def17046c37ep-326, 0x1.2a16e161fa35fp-321 },
	   { 0x1.999a40ba75f42p-327, 0x1.c48699c75f345p-322 },
	   { 0x1.36bb3093bcf7fp-327, 0x1.5771e906a9978p-322 },
	   { 0x1.d764e5657aa2p-328, 0x1.04a04a1699caap-322 },
	   { 0x1.658528dc53bd5p-328, 0x1.8b822865b44e6p-323 },
	   { 0x1.0f1f1acd583cp-328, 0x1.2c0fc98ac934cp-323 },
	   { 0x1.9b2768ee2e28p-329, 0x1.c73df0b6d4334p-324 },
	   { 0x1.37b7d60833afbp-329, 0x1.594bab8ddacb1p-324 },
	   { 0x1.d89a6c43f4c1p-330, 0x1.05dee05833b3cp-324 },
	   { 0x1.663803afd90e2p-330, 0x1.8d278c9cbfc58p-325 },
	   { 0x1.0f7c5f2e4265p-330, 0x1.2d206b997c2ccp-325 },
	   { 0x1.9b74a41343d69p-331, 0x1.c89434d36542fp-326 },
	   { 0x1.37c1bd3bb9cfep-331, 0x1.5a192e33cf627p-326 },
	   { 0x1.d85fb90bdf218p-332, 0x1.0651bc0c61b2p-326 },
	   { 0x1.65d3aea4b609ep-332, 0x1.8d9799e5f2521p-327 },
	   { 0x1.0f0609e7aa674p-332, 0x1.2d464a6b30dc2p-327 },
	   { 0x1.9a813d2878f74p-333, 0x1.c88645e6c88eep-328 },
	   { 0x1.36d8ce9d2217bp-333, 0x1.59d89052b0525p-328 },
	   { 0x1.d6b5543d3c94p-334, 0x1.05f7d07f3fb02p-328 },
	   { 0x1.645913a262a36p-334, 0x1.8cd14a1185c8dp-329 },
	   { 0x1.0dbd2f003b6a5p-334, 0x1.2c810d60e767ep-329 },
	   { 0x1.984f6bfe6778p-335, 0x1.c714448c370a6p-330 },
	   { 0x1.34ff297cd534dp-335, 0x1.588a691f2cd1fp-330 },
	   { 0x1.d39f201da2255p-336, 0x1.04d1f01416963p-330 },
	   { 0x1.61cba521cabb4p-336, 0x1.8ad66d03eba59p-331 },
	   { 0x1.0ba4cc94c45b3p-336, 0x1.2ad281b8cc2ap-331 },
	   { 0x1.94e44c9a075e7p-337, 0x1.c44191b160ec2p-332 },
	   { 0x1.32391bcecdc03p-337, 0x1.5631c55b5d22cp-332 },
	   { 0x1.cf2449a3fda4bp-338, 0x1.02e2c911c7929p-332 },
	   { 0x1.5e3150cc8eda4p-338, 0x1.87aba1a7120bfp-333 },
	   { 0x1.08c1bf3c985fap-338, 0x1.283e938a586f7p-333 },
	   { 0x1.9047cb663bb8cp-339, 0x1.c014c17012593p-334 },
	   { 0x1.2e8d117dfdd44p-339, 0x1.52d41b7968429p-334 },
	   { 0x1.c94f2cb2815a8p-340, 0x1.002edb3674f27p-334 },
	   { 0x1.599268900e7bcp-340, 0x1.835843f5f0b0cp-335 },
	   { 0x1.051aaf415041dp-340, 0x1.24cb3e8b7d756p-335 },
	   { 0x1.8a84869fc8267p-341, 0x1.ba9781881c8a9p-336 },
	   { 0x1.2a037bab743e1p-341, 0x1.4e79366e7a47p-336 },
	   { 0x1.c22d2c350e306p-342, 0x1.f978cc962d426p-337 },
	   { 0x1.53f982a03a248p-342, 0x1.7de65083f0e21p-337 },
	   { 0x1.00b7f70f68972p-342, 0x1.208076f18ea3p-337 },
	   { 0x1.83a7a5a0b9d4dp-343, 0x1.b3d6740403453p-338 },
	   { 0x1.24a6b05eb3edap-343, 0x1.492b17a8d9ad4p-338 },
	   { 0x1.b9ce7efad864cp-344, 0x1.f126a42ab2a64p-339 },
	   { 0x1.4d7351162fad8p-344, 0x1.77623e1a3ca2fp-339 },
	   { 0x1.f74706d1f613cp-345, 0x1.1b680aeae0c3cp-339 },
	   { 0x1.7bc0a6e57fbc5p-345, 0x1.abe0fed214bcap-340 },
	   { 0x1.1e82c35430e3dp-345, 0x1.42f5d0cb0afebp-340 },
	   { 0x1.b045f25c98b4bp-346, 0x1.e77a20528f8f5p-341 },
	   { 0x1.460e7202036c7p-346, 0x1.6fdace394b03cp-341 },
	   { 0x1.ebd15c07c2acdp-347, 0x1.158d7d54f1681p-341 },
	   { 0x1.72e125d540295p-347, 0x1.a2c9115542385p-342 },
	   { 0x1.17a558b9c184fp-347, 0x1.3be755f8b210cp-342 },
	   { 0x1.a5a8a3f3de092p-348, 0x1.dc88f077bd369p-343 },
	   { 0x1.3ddb38ecb5b52p-348, 0x1.6760d57bb9982p-343 },
	   { 0x1.df2826b036578p-349, 0x1.0efdda755dbb3p-343 },
	   { 0x1.691c997f37f0ep-349, 0x1.98a2e123c782ep-344 },
	   { 0x1.101d72c627ff7p-349, 0x1.340f49a72211p-344 },
	   { 0x1.9a0db3d2b8dacp-350, 0x1.d06b3f65f6fdp-345 },
	   { 0x1.34eb72e63e592p-350, 0x1.5e06fcff790f4p-345 },
	   { 0x1.d166c8f34fca4p-351, 0x1.07c787991a68p-345 },
	   { 0x1.5e880d9f1fe43p-351, 0x1.8d849f54265f7p-346 },
	   { 0x1.07fb3b2ff1602p-351, 0x1.2b7ec30262d2bp-346 },
	   { 0x1.8d8df0cbffd52p-352, 0x1.c33b5a8ad639fp-347 },
	   { 0x1.2b52265317648p-352, 0x1.53e17e1a8afadp-347 },
	   { 0x1.c2aa6bd34f17bp-353, 0x1.fff41d2913dabp-348 },
	   { 0x1.5339d751ff2a1p-353, 0x1.818627da2e9e4p-348 },
	   { 0x1.fe9f93308c405p-354, 0x1.2248100f21115p-348 },
	   { 0x1.80438073219dep-354, 0x1.b515531d535ebp-349 },
	   { 0x1.21234fbc4a127p-354, 0x1.4905d9b84e0cbp-349 },
	   { 0x1.b31198aa5f8abp-355, 0x1.ef4bcc5f71a72p-350 },
	   { 0x1.474946f304456p-355, 0x1.74c0ac8d03b2bp-350 },
	   { 0x1.ec59d00f3fe38p-356, 0x1.187e74c209a91p-350 },
	   { 0x1.7249848679fa9p-356, 0x1.a6169b09c4411p-351 },
	   { 0x1.16739cec78bd4p-356, 0x1.3d8a8ccb26cd9p-351 },
	   { 0x1.a2bbd0795adeep-357, 0x1.ddb87127c2076p-352 },
	   { 0x1.3ace589cd3352p-357, 0x1.674e5d7be735cp-352 },
	   { 0x1.d949ad392f075p-358, 0x1.0e35e84d33d3fp-352 },
	   { 0x1.63bbbf78651ccp-358, 0x1.965d9f895d99cp-353 },
	   { 0x1.0b5827a3ba382p-358, 0x1.3186c3440696p-353 },
	   { 0x1.91c922f9ee4cp-359, 0x1.cb5d51a48d7d4p-354 },
	   { 0x1.2de164c74e725p-359, 0x1.594a1039f0199p-354 },
	   { 0x1.c5941f108d9d1p-360, 0x1.0382d1e479246p-354 },
	   { 0x1.54b639c219649p-360, 0x1.8609634a384ccp-355 },
	   { 0x1.ffcc62473097ap-361, 0x1.25120afe02122p-355 },
	   { 0x1.8059c757355aep-361, 0x1.b85e31314f4b4p-356 },
	   { 0x1.209ad26ca18d9p-361, 0x1.4acee7c0fcbafp-356 },
	   { 0x1.b15e18d0d2d12p-362, 0x1.f0f38c6449ad9p-357 },
	   { 0x1.4554e9983b016p-362, 0x1.753919ff4b182p-357 },
	   { 0x1.e865bf893f8f4p-363, 0x1.1844080030d76p-357 },
	   { 0x1.6e8db855aac9ap-363, 0x1.a4dede3a3eb93p-358 },
	   { 0x1.1312cc0ae5d04p-363, 0x1.3bf7fe7aa33ap-358 },
	   { 0x1.9ccc1bfbf7ecbp-364, 0x1.da5e8d4d639edp-359 },
	   { 0x1.35b35e7d0088ep-364, 0x1.640bc7176cda7p-359 },
	   { 0x1.d0a5ff60b92cfp-365, 0x1.0b342b640cc13p-359 },
	   { 0x1.5c84558f35d95p-365, 0x1.9102c47629cb9p-360 },
	   { 0x1.0560f8bafb2c7p-365, 0x1.2ce013e375d0fp-360 },
	   { 0x1.8801ce509ea26p-366, 0x1.c36f07720a932p-361 },
	   { 0x1.25ec7207b3c64p-366, 0x1.529fe13854ed9p-361 },
	   { 0x1.b8b58f7c67c36p-367, 0x1.fbf2dc269c35dp-362 },
	   { 0x1.4a5c0b3b7424dp-367, 0x1.7cec854a40ddcp-362 },
	   { 0x1.ef3874e46141bp-368, 0x1.1da13f1aaaee6p-362 },
	   { 0x1.732197e24d857p-368, 0x1.ac4c46230c45cp-363 },
	   { 0x1.1619ff0ea7ec6p-368, 0x1.4112fbeff8a1fp-363 },
	   { 0x1.a0bb46a0a2c53p-369, 0x1.e15420dda8758p-364 },
	   { 0x1.383201c8ba71ap-369, 0x1.68bd97eb5b05dp-364 },
	   { 0x1.d3b4e4b894768p-370, 0x1.0e54a78756b6bp-364 },
	   { 0x1.5e4c4aaef013p-370, 0x1.951c14f527745p-365 },
	   { 0x1.0654a030d3e7p-370, 0x1.2f8178dd14a04p-365 },
	   { 0x1.88dc03d1ca801p-371, 0x1.c6b6bf9361ee4p-366 },
	   { 0x1.2621d65152a67p-371, 0x1.5495f2949c65ep-366 },
	   { 0x1.b860981f4834ap-372, 0x1.fe24891c8ca0cp-367 },
	   { 0x1.49a0d4c97c281p-372, 0x1.7e02609a87253p-367 },
	   { 0x1.ed66ed1143993p-373, 0x1.1e064158c947bp-367 },
	   { 0x1.713a5a10cc9bp-373, 0x1.ac4304f253262p-368 },
	   { 0x1.14455cbbff469p-373, 0x1.4093bdea6e36fp-368 },
	   { 0x1.9d62205df47a6p-374, 0x1.dfe14a435c3c2p-369 },
	   { 0x1.353bfdeb15aa4p-374, 0x1.6720e3d624fdcp-369 },
	   { 0x1.ce97f23783a55p-375, 0x1.0cba8970a9d66p-369 },
	   { 0x1.59f649793ea9ap-375, 0x1.921e961b81171p-370 },
	   { 0x1.02b46c188f22dp-375, 0x1.2cd3135c626d1p-370 },
	   { 0x1.82dcfdba2d59cp-376, 0x1.c2097f7f7c953p-371 },
	   { 0x1.213830f44d648p-376, 0x1.5096e15b063dbp-371 },
	   { 0x1.b0639acae41c7p-377, 0x1.f76b39886a20dp-372 },
	   { 0x1.432d063e4cc5ap-377, 0x1.786c2636e4e2ap-372 },
	   { 0x1.e3096b161ade1p-378, 0x1.196dc712e8651p-372 },
	   { 0x1.68f1646f450ccp-378, 0x1.a4c39680abb0bp-373 },
	   { 0x1.0dad51a121c5fp-378, 0x1.3a80eb1934625p-373 },
	   { 0x1.92ed52465cf13p-379, 0x1.d6196b3830612p-374 },
	   { 0x1.2cf8cdb32b26dp-379, 0x1.5f4b3b930a91ap-374 },
	   { 0x1.c1934bb7035c1p-380, 0x1.067b3db09279ep-374 },
	   { 0x1.4fbc11c19c0b7p-380, 0x1.8832413bcb6f5p-375 },
	   { 0x1.f5613cdc1ad52p-381, 0x1.24f8b72bbd6eep-375 },
	   { 0x1.76547ab0f816ap-381, 0x1.b5a5bcacf14ddp-376 },
	   { 0x1.1770c93ef3136p-381, 0x1.46d8046ba690cp-376 },
	   { 0x1.a128a30d837ebp-382, 0x1.e8209bd7c6d4dp-377 },
	   { 0x1.375630e92b79p-382, 0x1.6c744b66f6406p-377 },
	   { 0x1.d0a93cd8add1ep-383, 0x1.1015024fefc8dp-377 },
	   { 0x1.5ab4549d6cf15p-383, 0x1.9631ba1694964p-378 },
	   { 0x1.02a8fed4a1944p-383, 0x1.2f2b3b1ae197dp-378 },
	   { 0x1.81e6d5efc2ecep-384, 0x1.c47e5b8f9de0cp-379 },
	   { 0x1.1fd54f3e20bfcp-384, 0x1.51a481761d265p-379 },
	   { 0x1.ad523512d80aep-385, 0x1.f7d2ff106229cp-380 },
	   { 0x1.4023f854f9c86p-385, 0x1.77da522f79ec5p-380 },
	   { 0x1.dd649c8fad0d5p-386, 0x1.185a192bd02b4p-380 },
	   { 0x1.63e684c4d4572p-386, 0x1.a22ed5ef67f83p-381 },
	   { 0x1.094b5ecc6e29p-386, 0x1.37d9a85948033p-381 },
	   { 0x1.8b7643330549ep-387, 0x1.d10da89b8212ap-382 },
	   { 0x1.26b65f14cd4dap-387, 0x1.5ab7d4224f7e2p-382 },
	   { 0x1.b734f53e57228p-388, 0x1.0276587fa1c2p-382 },
	   { 0x1.473b9d1931175p-388, 0x1.814bdb918424dp-383 },
	   { 0x1.e78d8c6e84fddp-389, 0x1.1f2684f2af658p-383 },
	   { 0x1.6b2a2c93cd65ap-389, 0x1.abf540fb4e1a1p-384 },
	   { 0x1.0e7a7b055d281p-389, 0x1.3eddfeeed0dd2p-384 },
	   { 0x1.92d87cacce695p-390, 0x1.db1c82f79707dp-385 },
	   { 0x1.2bf57b6e0d98dp-390, 0x1.61ea0b7eb4c3cp-385 },
	   { 0x1.bea4f9488e121p-391, 0x1.0799f1fb897d8p-385 },
	   { 0x1.4c7d8bf7bdc41p-391, 0x1.889f21fdb1d69p-386 },
	   { 0x1.eef6b8bfa9225p-392, 0x1.245c20ba28a39p-386 },
	   { 0x1.705ed2bbfd521p-392, 0x1.b3598a0d5984p-387 },
	   { 0x1.121f1b69882ebp-392, 0x1.4418fde75923ep-387 },
	   { 0x1.97ec608197c79p-393, 0x1.e27e05b6c31f9p-388 },
	   { 0x1.2f7b0edc74f1cp-393, 0x1.671af7f5d8858p-388 },
	   { 0x1.c380c41f7503p-394, 0x1.0b3d4442eda68p-388 },
	   { 0x1.4fd20f15083b3p-394, 0x1.8db341e4d4306p-389 },
	   { 0x1.f37ea8d01e9c5p-395, 0x1.27e37e3bc73c9p-389 },
	   { 0x1.736cebb19a201p-395, 0x1.b83a639f29a8p-390 },
	   { 0x1.1428c012e2c57p-395, 0x1.47730acf38edcp-390 },
	   { 0x1.9a9ae80c06018p-396, 0x1.e710d5155d028p-391 },
	   { 0x1.31371c2b63b8p-396, 0x1.6a331ab64b688p-391 },
	   { 0x1.c5b240b14f4d6p-397, 0x1.0d4fd25f7f52ep-391 },
	   { 0x1.5129ffd17a136p-397, 0x1.90712f4e38e37p-392 },
	   { 0x1.f510ba62354a5p-398, 0x1.29ac951c1e60bp-392 },
	   { 0x1.74468acd1611cp-398, 0x1.ba819d5f14678p-393 },
	   { 0x1.148e1d96c299ep-398, 0x1.48dce2dc3ecd5p-393 },
	   { 0x1.9ad7d58aaba44p-399, 0x1.e8c0193d16d55p-394 },
	   { 0x1.3121b71d77179p-399, 0x1.6b2456938b866p-394 },
	   { 0x1.c52f68dd90e64p-400, 0x1.0dc826696c76cp-394 },
	   { 0x1.507f397188496p-400, 0x1.90cc63cdbf2a2p-395 },
	   { 0x1.f3a5bdf92c388p-401, 0x1.29af3c144f8cp-395 },
	   { 0x1.72e7cbdbb95dbp-401, 0x1.ba24cc0f4c8e2p-396 },
	   { 0x1.134d638b07143p-401, 0x1.48500e815d897p-396 },
	   { 0x1.98a2111174d79p-402, 0x1.e7841c45926dp-397 },
	   { 0x1.2f3b409e1b7b6p-402, 0x1.69ea5b1b71301p-397 },
	   { 0x1.c1fa91a869695p-403, 0x1.0ca4195cda6d3p-397 },
	   { 0x1.4dd4c7d7ec9fap-403, 0x1.8ec33daf13649p-398 },
	   { 0x1.ef442d8796795p-404, 0x1.27eb66fea5e85p-398 },
	   { 0x1.6f56f0c0f22b9p-404, 0x1.b72598c77c448p-399 },
	   { 0x1.106c4a594a047p-404, 0x1.45cf12a60cb9ap-399 },
	   { 0x1.9403b0e4bd1b9p-405, 0x1.e36284e81b5ffp-400 },
	   { 0x1.2b8c63e7468c1p-405, 0x1.668ac570f2fc8p-400 },
	   { 0x1.bc22598793379p-406, 0x1.09e8e37ef2488p-400 },
	   { 0x1.4936d06178106p-406, 0x1.8a5f0c63b5c24p-401 },
	   { 0x1.e7fffb3b16a7dp-407, 0x1.2469273320bdap-401 },
	   { 0x1.69a431ed205ap-407, 0x1.b191b44e70edfp-402 },
	   { 0x1.0bf7e7cce4d07p-407, 0x1.41655d7606103p-402 },
	   { 0x1.8d11ace4d8996p-408, 0x1.dc6e2b76185d5p-403 },
	   { 0x1.2625d4b960a47p-408, 0x1.6114f58eab906p-403 },
	   { 0x1.b3c139841a735p-409, 0x1.05a2f4a403a4dp-403 },
	   { 0x1.42ba35d81be5cp-409, 0x1.83b3c9af7ee45p-404 },
	   { 0x1.ddf9fa6fc513ap-410, 0x1.1f386e3013e68p-404 },
	   { 0x1.61e943a26f542p-410, 0x1.a9826f127d04dp-405 },
	   { 0x1.06044c28d2704p-410, 0x1.3b26ef9596f74p-405 },
	   { 0x1.83eb403668f94p-411, 0x1.d2c68adc24dd3p-406 },
	   { 0x1.1f1fd15ed30fep-411, 0x1.59a199b7c8167p-406 },
	   { 0x1.a8fcbdc7eab51p-412, 0x1.ffcb2bfa5b8dap-407 },
	   { 0x1.3a7bfb4be9962p-412, 0x1.7adf828472cfdp-407 },
	   { 0x1.d15ee90987618p-413, 0x1.1870951a86a79p-407 },
	   { 0x1.584895194492p-413, 0x1.9f1bfa110cbbap-408 },
	   { 0x1.fd57d7b45b3cap-414, 0x1.332fc55367264p-408 },
	   { 0x1.78b8ffae32bfp-414, 0x1.c696d39db75f3p-409 },
	   { 0x1.16996dab0cd1ep-414, 0x1.5051f4ea04fdfp-409 },
	   { 0x1.9c046dcaa75a4p-415, 0x1.f194b2a4cb97p-410 },
	   { 0x1.30a06c462f23ep-415, 0x1.700975cbb46aap-410 },
	   { 0x1.c2662350ce7fap-416, 0x1.102fae0ec7794p-410 },
	   { 0x1.4cec5169fb931p-416, 0x1.928c588cfb6d9p-411 },
	   { 0x1.ec1db7d8e44b5p-417, 0x1.29a3060c44f3ap-411 },
	   { 0x1.6babae8929706p-417, 0x1.b814aa869e0e4p-412 },
	   { 0x1.0cb7ae5506e7ep-417, 0x1.454ee7edd0063p-412 },
	   { 0x1.8d106f7f4047ep-418, 0x1.e0e0b72e6ef2ep-413 },
	   { 0x1.255213192c405p-418, 0x1.6360f251c2f1fp-413 },
	   { 0x1.b1500fc71b69ap-419, 0x1.0699a6631f93fp-413 },
	   { 0x1.40052c8ba04b4p-419, 0x1.840a0d97bb129p-414 },
	   { 0x1.d8a3d24511c07p-420, 0x1.1eaa023d58a69p-414 },
	   { 0x1.5cfadd7b9716p-420, 0x1.a77ea01d8b821p-415 },
	   { 0x1.01a47ddad3ea8p-420, 0x1.38c7c7057a652p-415 },
	   { 0x1.7c5ff3799c35bp-421, 0x1.cdf6c504a93e5p-416 },
	   { 0x1.18c087e86a1f3p-421, 0x1.551bff88c1175p-416 },
	   { 0x1.9e64530b957f4p-422, 0x1.f7ae8590bb8p-417 },
	   { 0x1.31c908986e1a8p-422, 0x1.73d293026bc2ap-417 },
	   { 0x1.c33b25da2082ep-423, 0x1.12730a9790f69p-417 },
	   { 0x1.4ce362055227ep-423, 0x1.951a7082f394ap-418 },
	   { 0x1.eb1b0ae0a386ap-424, 0x1.2af1081b22794p-418 },
	   { 0x1.6a3779e1ff3bp-424, 0x1.b925bc48353ep-419 },
	   { 0x1.0b1f245435eeap-424, 0x1.4575deb5305a2p-419 },
	   { 0x1.89efddb97fd18p-425, 0x1.e029ff0fc8645p-420 },
	   { 0x1.227180cb0a8cap-425, 0x1.6228a92a17423p-420 },
	   { 0x1.ac39e8a7de062p-426, 0x1.05302bb5e3a1ap-420 },
	   { 0x1.3ba5b5279aa24p-426, 0x1.81331d3a2cc81p-421 },
	   { 0x1.d145ea8ff6403p-427, 0x1.1c02d69097c72p-421 },
	   { 0x1.56df011e743b9p-427, 0x1.a2c1b0ae83a64p-422 },
	   { 0x1.f94750d0f9308p-428, 0x1.34ad734ae6135p-422 },
	   { 0x1.7442e7172840ap-428, 0x1.c703bfdc748cdp-423 },
	   { 0x1.123a683e9b9d5p-428, 0x1.4f5290291de6ep-423 },
	   { 0x1.93f94a8e393e5p-429, 0x1.ee2bb5a2a447p-424 },
	   { 0x1.298449094a08p-429, 0x1.6c16f34d9525ep-424 },
	   { 0x1.b62c8f87855a8p-430, 0x1.0c379a70923bcp-424 },
	   { 0x1.42a02f59d51efp-430, 0x1.8b21b8919710fp-425 },
	   { 0x1.db09bb0ffb21fp-431, 0x1.2303a1b68b2dep-425 },
	   { 0x1.5daee76f997a8p-431, 0x1.ac9c706a79cfcp-426 },
	   { 0x1.01604a662bf4cp-431, 0x1.3b983b3f72fb5p-426 },
	   { 0x1.7ad33d50dacdp-432, 0x1.d0b33fd9b6e85p-427 },
	   { 0x1.16c1e4c8c451ap-432, 0x1.5615904c6373ap-427 },
	   { 0x1.9a32159dea0d8p-433, 0x1.f7950165d693dp-428 },
	   { 0x1.2dc48781056c9p-433, 0x1.729dc070c926ap-428 },
	   { 0x1.bbf2871addffbp-434, 0x1.10b9b38c6e833p-428 },
	   { 0x1.4684a4152d4ep-434, 0x1.9154f9f73ee5fp-429 },
	   { 0x1.e03df4eb2c204p-435, 0x1.27418ebfd96bep-429 },
	   { 0x1.6120558a89b12p-435, 0x1.b26192fa2f36ep-430 },
	   { 0x1.03a014bcb5352p-435, 0x1.3f7df7d25b3e6p-430 },
	   { 0x1.7db773a6f6623p-436, 0x1.d5ec232ba3385p-431 },
	   { 0x1.1893b9023690dp-436, 0x1.598c75ff21ea4p-431 },
	   { 0x1.9c6ba6a49465ap-437, 0x1.fc1f9e46a53e2p-432 },
	   { 0x1.2f125d64e7642p-437, 0x1.758c452444076p-432 },
	   { 0x1.bd607b51aff83p-438, 0x1.1294b791c6529p-432 },
	   { 0x1.4735d5e25dd32p-438, 0x1.939e692035be7p-433 },
	   { 0x1.e0bb7795ebab2p-439, 0x1.289cc9b3b4107p-433 },
	   { 0x1.611962fb4b008p-439, 0x1.b3e5c199dc217p-434 },
	   { 0x1.035217aa6e0adp-439, 0x1.40415be2c6028p-434 },
	   { 0x1.7cd9c096da3b3p-440, 0x1.d6871e2c76342p-435 },
	   { 0x1.17a22cd2a508fp-440, 0x1.599d2a64857abp-435 },
	   { 0x1.9a95351e8c9f1p-441, 0x1.fba952efabe51p-436 },
	   { 0x1.2d63f329a8bcbp-441, 0x1.74cc660d4897ap-436 },
	   { 0x1.ba6ba0cb47e2bp-442, 0x1.11baa6a990cd8p-436 },
	   { 0x1.44ae89d144108p-442, 0x1.91ecc31adec4ep-437 },
	   { 0x1.dc7e8d1b8f556p-443, 0x1.270b14a1f9816p-437 },
	   { 0x1.5d9a42222275cp-443, 0x1.b11d883fd3ec1p-438 },
	   { 0x1.00789e350bd1ap-443, 0x1.3ddca348b8e79p-438 },
	   { 0x1.7840aaba80c98p-444, 0x1.d27f9dd765764p-439 },
	   { 0x1.13f45ccd8c935p-444, 0x1.56472f42babf3p-439 },
	   { 0x1.94bc9a9955f26p-445, 0x1.f6359d3980ea5p-440 },
	   { 0x1.28c5f3eaf8eddp-445, 0x1.7063ccd1b83c6p-440 },
	   { 0x1.b32a3c3e46a35p-446, 0x1.0e31f012ad2b3p-440 },
	   { 0x1.3f01c91fe7f47p-446, 0x1.8c4cd2c02ec2dp-441 },
	   { 0x1.d3a718c61d154p-447, 0x1.2298481c2ca0dp-441 },
	   { 0x1.56bd3dd5a05c1p-447, 0x1.aa1de55237abcp-442 },
	   { 0x1.f65222fadfcp-448, 0x1.3861db33230bp-442 },
	   { 0x1.700eb717cfb77p-448, 0x1.c9f401331dbf6p-443 },
	   { 0x1.0da5e12700c8dp-448, 0x1.4fa3a533642f6p-443 },
	   { 0x1.8b0da54d3c71fp-449, 0x1.ebed8656f1a7bp-444 },
	   { 0x1.215aeed941b43p-449, 0x1.6873a105b43c2p-444 },
	   { 0x1.a7d28bd609e5p-450, 0x1.081521636047p-444 },
	   { 0x1.3659f3261d19p-450, 0x1.82e8d038330cap-445 },
	   { 0x1.c6770887b13f6p-451, 0x1.1b65bea6b7e6ap-445 },
	   { 0x1.4cb570f463d9dp-451, 0x1.9f1b427ce89a2p-446 },
	   { 0x1.e715dafe5cd6p-452, 0x1.2ff9fffd4f5f9p-446 },
	   { 0x1.6480ba9b1723cp-452, 0x1.bd241d06b6757p-447 },
	   { 0x1.04e575dd6f2ebp-452, 0x1.45e411382662bp-447 },
	   { 0x1.7dcff6d521467p-453, 0x1.dd1da1bc7ec85p-448 },
	   { 0x1.1759a98201ff3p-453, 0x1.5d36e9f7af39cp-448 },
	   { 0x1.98b82586ccf2dp-454, 0x1.ff233639de02ap-449 },
	   { 0x1.2af6afc0ce651p-454, 0x1.7606528b3cf28p-449 },
	   { 0x1.b54f244df93dfp-455, 0x1.11a8b54a30c34p-449 },
	   { 0x1.3fcc4e4385b18p-455, 0x1.9066e8a3084adp-450 },
	   { 0x1.d3abb2d5b9282p-456, 0x1.24e2ffedd9f78p-450 },
	   { 0x1.55eaec016b2b5p-456, 0x1.ac6e23cde6ac9p-451 },
	   { 0x1.f3e576e5bfb2cp-457, 0x1.394ff72563c26p-451 },
	   { 0x1.6d6394041cb01p-457, 0x1.ca3259bb8013ep-452 },
	   { 0x1.0b0a8012d71fbp-457, 0x1.4effb58fcce2p-452 },
	   { 0x1.8647f7f3a91dep-458, 0x1.e9cac23b8427ep-453 },
	   { 0x1.1d29e5c60946bp-458, 0x1.6602f707600f3p-453 },
	   { 0x1.a0aa72640fd47p-459, 0x1.05a7bd790a4bcp-453 },
	   { 0x1.305e23384e58ap-459, 0x1.7e6b1b23c38f4p-454 },
	   { 0x1.bc9e08de1532fp-460, 0x1.176cc55ca9b8p-454 },
	   { 0x1.44b4e89c6a35fp-460, 0x1.984a277e8539ap-455 },
	   { 0x1.da366d9d2b975p-461, 0x1.2a417253e014bp-455 },
	   { 0x1.5a3c60cb2c6b1p-461, 0x1.b3b2c9b4277c6p-456 },
	   { 0x1.f98800fc076dbp-462, 0x1.3e333559670c8p-456 },
	   { 0x1.71033226bf0afp-462, 0x1.d0b8591b88278p-457 },
	   { 0x1.0d53e944a7e18p-462, 0x1.534ff7f271b4dp-457 },
	   { 0x1.89187f3d75a14p-463, 0x1.ef6ed82d51675p-458 },
	   { 0x1.1ed5d0deddfb7p-463, 0x1.69a61d0edc9d2p-458 },
	   { 0x1.a28be72757b85p-464, 0x1.07f57aca805f1p-458 },
	   { 0x1.3154ef266983dp-464, 0x1.814481a9f253cp-459 },
	   { 0x1.bd6d859990532p-465, 0x1.1921067277b5dp-459 },
	   { 0x1.44dcd404b4fcdp-465, 0x1.9a3a7d2712f82p-460 },
	   { 0x1.d9cdf2aadd6a6p-466, 0x1.2b45137355f77p-460 },
	   { 0x1.5979672b76b96p-466, 0x1.b497e1657b91bp-461 },
	   { 0x1.f7be424410479p-467, 0x1.3e6cfcc06ed27p-461 },
	   { 0x1.6f36e7903ba4fp-467, 0x1.d06cfa865bc4ep-462 },
	   { 0x1.0ba8019bd4e86p-467, 0x1.52a47395ed2aep-462 },
	   { 0x1.8621eaa755f34p-468, 0x1.edca8e605e67ap-463 },
	   { 0x1.1c4a9efdce654p-468, 0x1.67f77ef705254p-463 },
	   { 0x1.9e475b5aaea97p-469, 0x1.0660edcde1e02p-463 },
	   { 0x1.2dd03980220acp-469, 0x1.7e727aec99554p-464 },
	   { 0x1.b7b478b8fda1cp-470, 0x1.16b24c391593bp-464 },
	   { 0x1.40424c4fd21f7p-470, 0x1.96221780dfe95p-465 },
	   { 0x1.d276d459f43c7p-471, 0x1.27e2788696d86p-465 },
	   { 0x1.53aa8c500f5dp-471, 0x1.af1357749947cp-466 },
	   { 0x1.ee9c5073f397ep-472, 0x1.39fac2bf7a531p-466 },
	   { 0x1.6812e6a2e8fcp-472, 0x1.c9538eaa71fbp-467 },
	   { 0x1.06198ecffc0ep-472, 0x1.4d04b3a802aeep-467 },
	   { 0x1.7d857ef6fe55ap-473, 0x1.e4f0604536408p-468 },
	   { 0x1.15a4dc243cc5fp-473, 0x1.610a0b4ec8401p-468 },
	   { 0x1.940cad97ee071p-474, 0x1.00fbde3ac71c6p-468 },
	   { 0x1.25f772e00c70ap-474, 0x1.7614bf61d6bfap-469 },
	   { 0x1.abb2fd3f529efp-475, 0x1.103beefa0765p-469 },
	   { 0x1.3718d87e8a0afp-475, 0x1.8c2ef94786008p-470 },
	   { 0x1.c48328a4346ebp-476, 0x1.203fa39242793p-470 },
	   { 0x1.4910b37b4de72p-476, 0x1.a36313f8e64ecp-471 },
	   { 0x1.de8817c6f33b9p-477, 0x1.310e5f6fbfd44p-471 },
	   { 0x1.5be6c950a7e6fp-477, 0x1.bbbb999bb060ap-472 },
	   { 0x1.f9ccdcf7c94fep-478, 0x1.42afa66f9fdc1p-472 },
	   { 0x1.6fa2fc442a9d3p-478, 0x1.d54340d9c375dp-473 },
	   { 0x1.0b2e58cb15f5cp-478, 0x1.552b1ae6aeaa2p-473 },
	   { 0x1.844d490056942p-479, 0x1.f004e9f45a94bp-474 },
	   { 0x1.1a217943b9ac7p-479, 0x1.68887b7750462p-474 },
	   { 0x1.99edc3fa555f4p-480, 0x1.0605cdc8a1e5ep-474 },
	   { 0x1.29c58e31af831p-480, 0x1.7ccfa0b55e3f7p-475 },
	   { 0x1.b08c96a2d341cp-481, 0x1.14b13fa04509fp-475 },
	   { 0x1.3a2063aa9bfc9p-481, 0x1.92087a96ea8f4p-476 },
	   { 0x1.c831fc61280f7p-482, 0x1.240a6edc95f53p-476 },
	   { 0x1.4b37d15842e1dp-482, 0x1.a83b0db0fa5b6p-477 },
	   { 0x1.e0e63f582488bp-483, 0x1.34170d65d2fe5p-477 },
	   { 0x1.5d11b81c3fea7p-483, 0x1.bf6f703f6c8b1p-478 },
	   { 0x1.fab1b4f400c2ep-484, 0x1.44dcd884a52dcp-478 },
	   { 0x1.6fb3ff8ccf41cp-484, 0x1.d7adc6f76430fp-479 },
	   { 0x1.0ace5d20891a2p-484, 0x1.5661968fc8c68p-479 },
	   { 0x1.8324934a763f4p-485, 0x1.f0fe41a3b588bp-480 },
	   { 0x1.18d7d8058e531p-485, 0x1.68ab147365bffp-480 },
	   { 0x1.9769602e7d2c4p-486, 0x1.05b48bc57ed71p-480 },
	   { 0x1.27797b62a04a4p-486, 0x1.7bbf2311e9661p-481 },
	   { 0x1.ac8851524d431p-487, 0x1.137b41cf9c9a4p-481 },
	   { 0x1.36b7751d5da7fp-487, 0x1.8fa3947e525d9p-482 },
	   { 0x1.c2874cefea298p-488, 0x1.21d7603b6e2ccp-482 },
	   { 0x1.4695ee8470b66p-488, 0x1.a45e3910021acp-483 },
	   { 0x1.d96c311be3eb3p-489, 0x1.30cd0207d04edp-483 },
	   { 0x1.571909f179506p-489, 0x1.b9f4dc504a668p-484 },
	   { 0x1.f13cd05945d89p-490, 0x1.40603dadb780ap-484 },
	   { 0x1.6844e0504f766p-490, 0x1.d06d41c212c13p-485 },
	   { 0x1.04ff770417c7ep-490, 0x1.509522cc01f2fp-485 },
	   { 0x1.7a1d7e8c27e5p-491, 0x1.e7cd2184183ebp-486 },
	   { 0x1.11dc1d57f7df8p-491, 0x1.616fb7b910c11p-486 },
	   { 0x1.8ca6e2e342651p-492, 0x1.000d1267395e3p-486 },
	   { 0x1.1f372812d1e14p-492, 0x1.72f3f6faafe57p-487 },
	   { 0x1.9fe4fa21e8c98p-493, 0x1.0cacf12619fe1p-487 },
	   { 0x1.2d1356c845fd1p-493, 0x1.8525cca4f244dp-488 },
	   { 0x1.b3db9cc5a58f3p-494, 0x1.19c8ed29100e2p-488 },
	   { 0x1.3b7359a6b9391p-494, 0x1.980913a0c5f1ep-489 },
	   { 0x1.c88e8c09b9bb2p-495, 0x1.2763b979d57b5p-489 },
	   { 0x1.4a59cf5958098p-495, 0x1.aba192db244fdp-490 },
	   { 0x1.de016eddfacadp-496, 0x1.357ff9fbc97f4p-490 },
	   { 0x1.59c942db45eaep-496, 0x1.bff2fa5de1e9dp-491 },
	   { 0x1.f437cec9632b8p-497, 0x1.44204156d00fcp-491 },
	   { 0x1.69c4293cefa3fp-497, 0x1.d500e0534289dp-492 },
	   { 0x1.059a8a5ce0ce7p-497, 0x1.53470ed39dd97p-492 },
	   { 0x1.7a4cdf5c8de47p-498, 0x1.eacebdf5973c2p-493 },
	   { 0x1.117e42e10afc5p-498, 0x1.62f6cc2a62dbdp-493 },
	   { 0x1.8b65a792fe14p-499, 0x1.00aff63626acfp-493 },
	   { 0x1.1dc89fe4a5f8ap-499, 0x1.7331cb44dd6ecp-494 },
	   { 0x1.9d10a7562f377p-500, 0x1.0c5bd0cbfba3p-494 },
	   { 0x1.2a7b1b1593291p-500, 0x1.83fa43f4f73d5p-495 },
	   { 0x1.af4fe4d278bf9p-501, 0x1.186c76677c8f7p-495 },
	   { 0x1.37971726a776ep-501, 0x1.955251a12574cp-496 },
	   { 0x1.c225447c48b85p-502, 0x1.24e359c6528bbp-496 },
	   { 0x1.451dde15504ecp-502, 0x1.a73bf0e7dcf7bp-497 },
	   { 0x1.d592869bae136p-503, 0x1.31c1d70a5a26cp-497 },
	   { 0x1.53109f6b70a02p-503, 0x1.b9b8fd3b82acep-498 },
	   { 0x1.e99944d35a898p-504, 0x1.3f09320694d4p-498 },
	   { 0x1.61706e7ea0b42p-504, 0x1.cccb2e7856e93p-499 },
	   { 0x1.fe3aefa4cdaa2p-505, 0x1.4cba948866255p-499 },
	   { 0x1.703e40ae0b133p-505, 0x1.e0741675f15a5p-500 },
	   { 0x1.09bc65f9b8064p-505, 0x1.5ad70c9e433d4p-500 },
	   { 0x1.7f7aeba02f7efp-506, 0x1.f4b51e95f89d5p-501 },
	   { 0x1.14a9f8443d058p-506, 0x1.695f8add0a062p-501 },
	   { 0x1.8f272381e3222p-507, 0x1.04c7c2a8ead79p-501 },
	   { 0x1.1fe6a1ccca721p-507, 0x1.7854e0a5444cfp-502 },
	   { 0x1.9f437947f2743p-508, 0x1.0f822de49bc54p-502 },
	   { 0x1.2b72bc2a1bb29p-508, 0x1.87b7be69a8c26p-503 },
	   { 0x1.afd058f4d5cb9p-509, 0x1.1a8a41a9a734p-503 },
	   { 0x1.374e8637e822fp-509, 0x1.9788b1f83908ep-504 },
	   { 0x1.c0ce07e3f5247p-510, 0x1.25e0558a5c077p-504 },
	   { 0x1.437a22e46ffc9p-510, 0x1.a7c824c7683f1p-505 },
	   { 0x1.d23ca31c0220cp-511, 0x1.3184a6ce13b46p-505 },
	   { 0x1.4ff5980398e02p-511, 0x1.b8765a48c0cf1p-506 },
	   { 0x1.e41c1da9f8a5fp-512, 0x1.3d775743f06aep-506 },
	   { 0x1.5cc0cd28b81e5p-512, 0x1.c9936e428a9d9p-507 },
	   { 0x1.f66c3f065ea05p-513, 0x1.49b86c1b194cep-507 },
	   { 0x1.69db8a882e29p-513, 0x1.db1f5331fbe71p-508 },
	   { 0x1.049650c331274p-513, 0x1.5647ccc18e717p-508 },
	   { 0x1.774577e1faf4fp-514, 0x1.ed19d0b78718cp-509 },
	   { 0x1.0e2e586d3df5cp-514, 0x1.632541cab3acp-509 },
	   { 0x1.84fe1b767669bp-515, 0x1.ff82820edeaabp-510 },
	   { 0x1.17fdd44e1dc6cp-515, 0x1.705073deb552ap-510 },
	   { 0x1.9304d9065a4b9p-516, 0x1.092c6a4a26abfp-510 },
	   { 0x1.220449767742ap-516, 0x1.7dc8eab3ed87ap-511 },
	   { 0x1.a158f0df4c356p-517, 0x1.12ce032c827cep-511 },
	   { 0x1.2c4123936432bp-517, 0x1.8b8e0c1372c25p-512 },
	   { 0x1.aff97ef6163edp-518, 0x1.1ca5926404568p-512 },
	   { 0x1.36b3b4511d82bp-518, 0x1.999f1ae9f978bp-513 },
	   { 0x1.bee57a0fbbbdcp-519, 0x1.26b285aeabdbep-513 },
	   { 0x1.415b32c89327cp-519, 0x1.a7fb366632c72p-514 },
	   { 0x1.ce1bb2fa9523ep-520, 0x1.30f431387ee69p-514 },
	   { 0x1.4c36baf8c2285p-520, 0x1.b6a15925d0c25p-515 },
	   { 0x1.dd9ad3d89a4a5p-521, 0x1.3b69cf0bd5608p-515 },
	   { 0x1.57454d4c97f21p-521, 0x1.c590587256b75p-516 },
	   { 0x1.ed615f7bfd7d2p-522, 0x1.46127e8d37ba7p-516 },
	   { 0x1.6285ce2e2e29bp-522, 0x1.d4c6e38ed7f06p-517 },
	   { 0x1.fd6db0d73348ep-523, 0x1.50ed44039bd53p-517 },
	   { 0x1.6df705a8252f7p-523, 0x1.e4438317c2a1ep-518 },
	   { 0x1.06defd40bdb09p-523, 0x1.5bf9082dc8412p-518 },
	   { 0x1.79979f15ddb0dp-524, 0x1.f4049875ce63p-519 },
	   { 0x1.0f2823287afb6p-524, 0x1.673497e5a0d03p-519 },
	   { 0x1.856628e34ac2cp-525, 0x1.02042eb28efefp-519 },
	   { 0x1.17913a85a33a7p-525, 0x1.729ea3d219a53p-520 },
	   { 0x1.9161145d0e326p-526, 0x1.0a2671c8cdbeep-520 },
	   { 0x1.20191f16dc709p-526, 0x1.7e35c0288722ep-521 },
	   { 0x1.9d86b59187f4ep-527, 0x1.12680a24c58f5p-521 },
	   { 0x1.28be97e6e9065p-527, 0x1.89f8647df9662p-522 },
	   { 0x1.a9d5434377e7bp-528, 0x1.1ac7d823a316cp-522 },
	   { 0x1.31805749922c3p-528, 0x1.95e4eba9494cap-523 },
	   { 0x1.b64ad6eec66d3p-529, 0x1.2344a7c981006p-523 },
	   { 0x1.3a5cfae5998ecp-529, 0x1.a1f993b67371dp-524 },
	   { 0x1.c2e56cdffce02p-530, 0x1.2bdd30bebc795p-524 },
	   { 0x1.43530bcc0ee3ap-530, 0x1.ae347debd307p-525 },
	   { 0x1.cfa2e45eea63dp-531, 0x1.3490165a1de5p-525 },
	   { 0x1.4c60fe9d5cbc1p-531, 0x1.ba93aee1c301fp-526 },
	   { 0x1.dc80ffece4451p-532, 0x1.3d5be7b8309a9p-526 },
	   { 0x1.558533bc564e3p-532, 0x1.c7150ead1fd0ep-527 },
	   { 0x1.e97d659702f92p-533, 0x1.463f1fe01b7dap-527 },
	   { 0x1.5ebdf78f85a03p-533, 0x1.d3b6691d169e3p-528 },
	   { 0x1.f6959f5cadd73p-534, 0x1.4f3825f642bp-528 },
	   { 0x1.680982d0eea8ap-534, 0x1.e0756e0ca137bp-529 },
	   { 0x1.01e38dd55bfc7p-534, 0x1.58454d7cf072p-529 },
	   { 0x1.7165faec70a1p-535, 0x1.ed4fb1c7fef16p-530 },
	   { 0x1.088796f5a026p-535, 0x1.6164d6a338985p-530 },
	   { 0x1.7ad1726ce2f3cp-536, 0x1.fa42ad866b6p-531 },
	   { 0x1.0f3587953aeb5p-536, 0x1.6a94eea23ecd2p-531 },
	   { 0x1.8449e977fef01p-537, 0x1.03a5dffc21d0dp-531 },
	   { 0x1.15ebef6827c9dp-537, 0x1.73d3b028fc2cfp-532 },
	   { 0x1.8dcd4e591ac76p-538, 0x1.0a3416f4dd0f1p-532 },
	   { 0x1.1ca951b79a938p-538, 0x1.7d1f23d694b62p-533 },
	   { 0x1.97597e1aad586p-539, 0x1.10ca917d13a59p-533 },
	   { 0x1.236c25d3c18a2p-539, 0x1.867540c340902p-534 },
	   { 0x1.a0ec452e85047p-540, 0x1.1767d933fa0f7p-534 },
	   { 0x1.2a32d78fe110fp-540, 0x1.8fd3ed17c059fp-535 },
	   { 0x1.aa8360248e3edp-541, 0x1.1e0a6bf884441p-535 },
	   { 0x1.30fbc7c8ab284p-541, 0x1.9938feb3469d1p-536 },
	   { 0x1.b41c7c6ff8cc6p-542, 0x1.24b0bc63cac6bp-536 },
	   { 0x1.37c54cf4ab1fcp-542, 0x1.a2a23bdfb3241p-537 },
	   { 0x1.bdb5393a7ccd2p-543, 0x1.2b59324d7fd9bp-537 },
	   { 0x1.3e8db3be9418cp-543, 0x1.ac0d5c13ef72ap-538 },
	   { 0x1.c74b284572b4cp-544, 0x1.32022b5a4d882p-538 },
	   { 0x1.45533fa93710cp-544, 0x1.b57808c42df0bp-539 },
	   { 0x1.d0dbced86364cp-545, 0x1.38a9fb93eb86p-539 },
	   { 0x1.4c142bbcdb51bp-545, 0x1.bedfde3fbf9f1p-540 },
	   { 0x1.da64a6bca7adp-546, 0x1.3f4eee0ab230dp-540 },
	   { 0x1.52ceab3daa53bp-546, 0x1.c8426c9c266d4p-541 },
	   { 0x1.e3e31f45a0a96p-547, 0x1.45ef458066425p-541 },
	   { 0x1.5980ea6ad6692p-547, 0x1.d19d38acfc932p-542 },
	   { 0x1.ed549e6504cf2p-548, 0x1.4c893d1bef1fep-542 },
	   { 0x1.60290f4619f98p-548, 0x1.daedbd083bb8ep-543 },
	   { 0x1.f6b681cab013bp-549, 0x1.531b0925a021ep-543 },
	   { 0x1.66c53a6323b06p-549, 0x1.e4316b16614afp-544 },
	   { 0x1.00031007ac3e3p-549, 0x1.59a2d7cbb3c39p-544 },
	   { 0x1.6d5387be7adf6p-550, 0x1.ed65ac2de0264p-545 },
	   { 0x1.04a064f4bdd38p-550, 0x1.601ed1ee8e719p-545 },
	   { 0x1.73d20f9b5e73bp-551, 0x1.f687e2b942e41p-546 },
	   { 0x1.0931e5b5e6c43p-551, 0x1.668d1bf455ad8p-546 },
	   { 0x1.7a3ee7681856fp-552, 0x1.ff956b675583bp-547 },
	   { 0x1.0db636a632668p-552, 0x1.6cebd6a35f863p-547 },
	   { 0x1.809822a836e1fp-553, 0x1.0445cf3250898p-547 },
	   { 0x1.122bfb19eafe7p-553, 0x1.73392002f5fc2p-548 },
	   { 0x1.86dbd3e416493p-554, 0x1.08b3e84ebc2b9p-548 },
	   { 0x1.1691d609b1ec9p-554, 0x1.79731441e1e21p-549 },
	   { 0x1.8d080d9d1c96dp-555, 0x1.0d13aa83e4b01p-549 },
	   { 0x1.1ae66ac0b0b6ap-555, 0x1.7f97cea22928bp-550 },
	   { 0x1.931ae34603f62p-556, 0x1.1163bef9eebc1p-550 },
	   { 0x1.1f285d8d6c817p-556, 0x1.85a56a6965552p-551 },
	   { 0x1.99126a3e88ca5p-557, 0x1.15a2cf3193875p-551 },
	   { 0x1.23565474c154ep-557, 0x1.8b9a03d510324p-552 },
	   { 0x1.9eecbad1cb519p-558, 0x1.19cf85b21a11fp-552 },
	   { 0x1.276ef7e686addp-558, 0x1.9173b9121e9f7p-553 },
	   { 0x1.a4a7f136af77ep-559, 0x1.1de88eb969b39p-553 },
	   { 0x1.2b70f3735b79fp-559, 0x1.9730ab373bc61p-554 },
	   { 0x1.aa422e918100dp-560, 0x1.21ec98edb9593p-554 },
	   { 0x1.2f5af68314ac2p-560, 0x1.9cceff40f1fb1p-555 },
	   { 0x1.afb999f61e5d4p-561, 0x1.25da56105b758p-555 },
	   { 0x1.332bb50b471fbp-561, 0x1.a24cdf0f0a2e7p-556 },
	   { 0x1.b50c6169e961bp-562, 0x1.29b07bb123c75p-556 },
	   { 0x1.36e1e845638bbp-562, 0x1.a7a87a6267113p-557 },
	   { 0x1.ba38bae4baa67p-563, 0x1.2d6dc3e1e1b47p-557 },
	   { 0x1.3a7c4f63d9d53p-563, 0x1.ace007da9e0c8p-558 },
	   { 0x1.bf3ce55012ad1p-564, 0x1.3110ede9680cep-558 },
	   { 0x1.3df9b045b81fcp-564, 0x1.b1f1c5f28dcc9p-559 },
	   { 0x1.c4172983c2f7ep-565, 0x1.3498bef599a58p-559 },
	   { 0x1.4158d828399aep-565, 0x1.b6dbfbfb30836p-560 },
	   { 0x1.c8c5db3f49157p-566, 0x1.380402cbf1542p-560 },
	   { 0x1.44989c55b9312p-566, 0x1.bb9cfb13e7262p-561 },
	   { 0x1.cd475a1f163eep-567, 0x1.3b518c77fb7d2p-561 },
	   { 0x1.47b7dad17cf31p-567, 0x1.c0331f1f7ac71p-562 },
	   { 0x1.d19a128cff8a4p-568, 0x1.3e8036f737914p-562 },
	   { 0x1.4ab57affd05a9p-568, 0x1.c49ccfb511d2cp-563 },
	   { 0x1.d5bc7eab14dfbp-569, 0x1.418ee5e1d890ep-563 },
	   { 0x1.4d906e49e5535p-569, 0x1.c8d8810c585d4p-564 },
	   { 0x1.d9ad27381fd3dp-570, 0x1.447c860fdcf2cp-564 },
	   { 0x1.5047b0bcf6527p-570, 0x1.cce4b4e41cdcap-565 },
	   { 0x1.dd6aa46d0f45cp-571, 0x1.47480e39f8181p-565 },
	   { 0x1.52da49a426b16p-571, 0x1.d0bffb62a59f5p-566 },
	   { 0x1.e0f39ed2991f9p-572, 0x1.49f07f95c9d66p-566 },
	   { 0x1.55474c1ca1f2bp-572, 0x1.d468f3ef07049p-567 },
	   { 0x1.e446d00e60d84p-573, 0x1.4c74e66ce3841p-567 },
	   { 0x1.578dd7a37e92bp-573, 0x1.d7de4e02c6f6fp-568 },
	   { 0x1.e76303a6f7572p-574, 0x1.4ed45aae1d60cp-568 },
	   { 0x1.59ad189ced845p-574, 0x1.db1ec9f31f5e1p-569 },
	   { 0x1.ea4717be0f8c8p-575, 0x1.510e0078c325ep-569 },
	   { 0x1.5ba448d444792p-575, 0x1.de2939b1372f7p-570 },
	   { 0x1.ecf1fdc04a7dbp-576, 0x1.532108a122ff3p-570 },
	   { 0x1.5d72aff4768dap-576, 0x1.e0fc8180b06b8p-571 },
	   { 0x1.ef62bb0a0594ap-577, 0x1.550cb12e0f1dbp-571 },
	   { 0x1.5f17a3f894e1dp-577, 0x1.e39798a3f0a89p-572 },
	   { 0x1.f19869809eb8ap-578, 0x1.56d045cee7811p-572 },
	   { 0x1.60928993f7077p-578, 0x1.e5f989fd91cadp-573 },
	   { 0x1.f392381fab056p-579, 0x1.586b2049c7737p-573 },
	   { 0x1.61e2d491b1f68p-579, 0x1.e82174a67122fp-574 },
	   { 0x1.f54f6b79a6d5fp-580, 0x1.59dca8e17880fp-574 },
	   { 0x1.6308082b0b65cp-580, 0x1.ea0e8c77dc629p-575 },
	   { 0x1.f6cf5e2bb03dcp-581, 0x1.5b2456b2d3672p-575 },
	   { 0x1.6401b7549eebbp-581, 0x1.ebc01a8965943p-576 },
	   { 0x1.f8118143e7ebp-582, 0x1.5c41b0093e8e9p-576 },
	   { 0x1.64cf8501f223bp-582, 0x1.ed357da1f18bap-577 },
	   { 0x1.f9155c9a1fbd1p-583, 0x1.5d344aaa010f1p-577 },
	   { 0x1.6571245f3d39ap-583, 0x1.ee6e2a9b9efdp-578 },
	   { 0x1.f9da8f1a8a0ccp-584, 0x1.5dfbcc1628fd2p-578 },
	   { 0x1.65e6590135ap-584, 0x1.ef69acba2f951p-579 },
	   { 0x1.fa60cf0228aadp-585, 0x1.5e97e9c2cbc7fp-579 },
	   { 0x1.662ef70ab154bp-585, 0x1.f027a5f3a7f56p-580 },
	   { 0x1.faa7ea0cc6ecbp-586, 0x1.5f0869476fb64p-580 },
	   { 0x1.664ae34801e0ep-586, 0x1.f0a7cf2ae7563p-581 },
	   { 0x1.faafc59456a8cp-587, 0x1.5f4d2082760f5p-581 },
	   { 0x1.663a133fef35p-587, 0x1.f0e9f85c03b41p-582 },
	   { 0x1.fa785ea194bf2p-588, 0x1.5f65f5b366281p-582 },
	   { 0x1.65fc8d3a43882p-588, 0x1.f0ee08ba43cd5p-583 },
	   { 0x1.fa01c9ede6a16p-589, 0x1.5f52df8b025d3p-583 },
	   { 0x1.6592683be2829p-589, 0x1.f0b3febf9cbcdp-584 },
	   { 0x1.f94c33d66f35bp-590, 0x1.5f13e53118eaap-584 },
	   { 0x1.64fbcbf86f1abp-590, 0x1.f03bf02da5a7ap-585 },
	   { 0x1.f857e040665ap-591, 0x1.5ea91e400b8afp-585 },
	   { 0x1.6438f0b98cabp-591, 0x1.ef860a0000a7ap-586 },
	   { 0x1.f7252a6ecb2bbp-592, 0x1.5e12b2b611c72p-586 },
	   { 0x1.634a1f3bd0d7ep-592, 0x1.ee92905044d53p-587 },
	   { 0x1.f5b484c995f72p-593, 0x1.5d50dadc42d9dp-587 },
	   { 0x1.622fb08184d56p-593, 0x1.ed61de2b81fc4p-588 },
	   { 0x1.f40678969b4f4p-594, 0x1.5c63df237cf4dp-588 },
	   { 0x1.60ea0d9b5d711p-594, 0x1.ebf4655983167p-589 },
	   { 0x1.f21ba5a45e2afp-595, 0x1.5b4c17f7488b1p-589 },
	   { 0x1.5f79af6759efdp-595, 0x1.ea4aae160108ap-590 },
	   { 0x1.eff4c1e71b057p-596, 0x1.5a09ed86def16p-590 },
	   { 0x1.5ddf1e460242cp-596, 0x1.e86556bc034fep-591 },
	   { 0x1.ed92990861c73p-597, 0x1.589dd784842fp-591 },
	   { 0x1.5c1af1c6454bep-597, 0x1.e6451363b8311p-592 },
	   { 0x1.eaf60be99fa59p-598, 0x1.57085cdb6c23ep-592 },
	   { 0x1.5a2dd0483fd76p-598, 0x1.e3eaad7319948p-593 },
	   { 0x1.e820101a05296p-599, 0x1.554a135c6b3d2p-593 },
	   { 0x1.58186e973c8cbp-599, 0x1.e1570321beee3p-594 },
	   { 0x1.e511af403f0e1p-600, 0x1.53639f61bab8bp-594 },
	   { 0x1.55db8f7b445c6p-600, 0x1.de8b06f0475d8p-595 },
	   { 0x1.e1cc067882b19p-601, 0x1.5155b36a1ff17p-595 },
	   { 0x1.537803429dd3dp-601, 0x1.db87bf13d1856p-596 },
	   { 0x1.de5045a77840fp-602, 0x1.4f210fabcd4fep-596 },
	   { 0x1.50eea743a03bp-602, 0x1.d84e44d6006fdp-597 },
	   { 0x1.da9faec295ac1p-603, 0x1.4cc6819f5a3a9p-597 },
	   { 0x1.4e406557456e3p-603, 0x1.d4dfc3ea1615fp-598 },
	   { 0x1.d6bb950e85a76p-604, 0x1.4a46e38335bf7p-598 },
	   { 0x1.4b6e334ceafc3p-604, 0x1.d13d79b7b4d75p-599 },
	   { 0x1.d2a55c543d97bp-605, 0x1.47a31bd7fd98ap-599 },
	   { 0x1.48791257b832ep-605, 0x1.cd68b49be13bdp-600 },
	   { 0x1.ce5e780d6c294p-606, 0x1.44dc1cd628aecp-600 },
	   { 0x1.45620e7623619p-606, 0x1.c962d320e4c77p-601 },
	   { 0x1.c9e86a88f07ffp-607, 0x1.41f2e3dd79383p-601 },
	   { 0x1.422a3dd414b5ep-607, 0x1.c52d432db963cp-602 },
	   { 0x1.c544c4080f626p-608, 0x1.3ee878deaf1c1p-602 },
	   { 0x1.3ed2c02828af5p-608, 0x1.c0c9812daaed1p-603 },
	   { 0x1.c07521d52071ep-609, 0x1.3bbdedbff743p-603 },
	   { 0x1.3b5cbe0c97302p-609, 0x1.bc391730e1bf4p-604 },
	   { 0x1.bb7b2d547171ap-610, 0x1.38745dbc97fd1p-604 },
	   { 0x1.37c9685446b6bp-610, 0x1.b77d9c068db21p-605 },
	   { 0x1.b6589b1020c3ep-611, 0x1.350cecc05d9cfp-605 },
	   { 0x1.3419f75c953bcp-611, 0x1.b298b2516cc35p-606 },
	   { 0x1.b10f29bfb2a68p-612, 0x1.3188c6bf4cd49p-606 },
	   { 0x1.304faa5c619afp-612, 0x1.ad8c07976bbcp-607 },
	   { 0x1.aba0a14c264ccp-613, 0x1.2de91f0a22435p-607 },
	   { 0x1.2c6bc6b0e1424p-613, 0x1.a859534d21642p-608 },
	   { 0x1.a60ed1d150c44p-614, 0x1.2a2f2fa027fc3p-608 },
	   { 0x1.286f9728ce321p-614, 0x1.a30255dde65bep-609 },
	   { 0x1.a05b929d439abp-615, 0x1.265c387eea954p-609 },
	   { 0x1.245c6b4e79163p-615, 0x1.9d88d7b14c6d3p-610 },
	   { 0x1.9a88c12e847c2p-616, 0x1.22717ef05792fp-610 },
	   { 0x1.203396b14a77p-616, 0x1.97eea82eb8229p-611 },
	   { 0x1.94984031d9858p-617, 0x1.1e704cd7ceb7cp-611 },
	   { 0x1.1bf6702f3caf4p-617, 0x1.92359cbfdea74p-612 },
	   { 0x1.8e8bf6806bcabp-618, 0x1.1a59effeaeef1p-612 },
	   { 0x1.17a6513ed67fap-618, 0x1.8c5f8fd2e86f6p-613 },
	   { 0x1.8865ce1efe9b6p-619, 0x1.162fb960e6361p-613 },
	   { 0x1.1344953a2bc16p-619, 0x1.866e5fdcf6e5cp-614 },
	   { 0x1.8227b33ef66f4p-620, 0x1.11f2fc7a0a0a9p-614 },
	   { 0x1.0ed298ab66e97p-620, 0x1.8063ee5dc8676p-615 },
	   { 0x1.7bd39341e60d2p-621, 0x1.0da50e937b941p-615 },
	   { 0x1.0a51b89b5ac38p-621, 0x1.7a421ee53231bp-616 },
	   { 0x1.756b5bc0538cfp-622, 0x1.0947461417eb2p-616 },
	   { 0x1.05c351e298147p-622, 0x1.740ad61b23997p-617 },
	   { 0x1.6ef0f9946142ep-623, 0x1.04daf9d1f19dp-617 },
	   { 0x1.0128c07d7eac9p-623, 0x1.6dbff8cae0f32p-618 },
	   { 0x1.686657e900799p-624, 0x1.006180668cd93p-618 },
	   { 0x1.f906bdc779cfcp-625, 0x1.67636af21f0cbp-619 },
	   { 0x1.61cd5f4e4d33cp-625, 0x1.f7b85f0c272bbp-620 },
	   { 0x1.efa90ac757637p-626, 0x1.60f70ed4a200ep-620 },
	   { 0x1.5b27f4d3aafafp-626, 0x1.ee98b6b3e4f34p-621 },
	   { 0x1.e63b1303dfbfbp-627, 0x1.5a7cc414fb8aap-621 },
	   { 0x1.5477f92833195p-627, 0x1.e566abbe94f87p-622 },
	   { 0x1.dcbf7abb88524p-628, 0x1.53f666d2fde17p-622 },
	   { 0x1.4dbf47c1fc8ap-628, 0x1.dc24dc933bf6dp-623 },
	   { 0x1.d338de3492428p-629, 0x1.4d65ced070949p-623 },
	   { 0x1.46ffb60cbd76p-629, 0x1.d2d5e0d43505p-624 },
	   { 0x1.c9a9d09a6515fp-630, 0x1.46ccce9c8cdf5p-624 },
	   { 0x1.403b12a03d499p-630, 0x1.c97c4837b573ep-625 },
	   { 0x1.c014dae645fc3p-631, 0x1.402d32c6be96dp-625 },
	   { 0x1.3973247f05596p-631, 0x1.c01a996aebdb3p-626 },
	   { 0x1.b67c7ad400b86p-632, 0x1.3988c1191e211p-626 },
	   { 0x1.32a9aa5db4bb3p-632, 0x1.b6b3510058b7ap-627 },
	   { 0x1.ace321e309c7bp-633, 0x1.32e137db0ef23p-627 },
	   { 0x1.2be059f3526f7p-633, 0x1.ad48e069f2207p-628 },
	   { 0x1.a34b346493cc3p-634, 0x1.2c384d1c64d5bp-628 },
	   { 0x1.2518df52ef492p-634, 0x1.a3ddacff96f65p-629 },
	   { 0x1.99b70897047dcp-635, 0x1.258fae0968e74p-629 },
	   { 0x1.1e54dc4edf3a3p-635, 0x1.9a740f1248851p-630 },
	   { 0x1.9028e5cf277c7p-636, 0x1.1ee8fe480d92cp-630 },
	   { 0x1.1795e7e5c7ccap-636, 0x1.910e510c93fe1p-631 },
	   { 0x1.86a303af6f699p-637, 0x1.1845d75e974c6p-631 },
	   { 0x1.10dd8db9b7b2p-637, 0x1.87aeaea087811p-632 },
	   { 0x1.7d27896d87b8ep-638, 0x1.11a7c823f5ff5p-632 },
	   { 0x1.0a2d4d917179ap-638, 0x1.7e57540380a9p-633 },
	   { 0x1.73b88d266bc5ap-639, 0x1.0b10543a01766p-633 },
	   { 0x1.03869ae409b27p-639, 0x1.750a5d3814d59p-634 },
	   { 0x1.6a58134129f18p-640, 0x1.0480f391c14fcp-634 },
	   { 0x1.f9d5b8ddde221p-641, 0x1.6bc9d56645be6p-635 },
	   { 0x1.61080de06bfbp-641, 0x1.fbf623f3bedbap-636 },
	   { 0x1.ecb6d7acd34f7p-642, 0x1.6297b642274f2p-636 },
	   { 0x1.57ca5c62d05ddp-642, 0x1.ef001d6eb49dfp-637 },
	   { 0x1.dfb32aa129cc6p-643, 0x1.5975e7810e7p-637 },
	   { 0x1.4ea0caf213789p-643, 0x1.e222785106b16p-638 },
	   { 0x1.d2cd2eb59de4cp-644, 0x1.50663e5d53392p-638 },
	   { 0x1.458d1220fa79dp-644, 0x1.d55fbee497ep-639 },
	   { 0x1.c60744f31e198p-645, 0x1.476a7d28a437bp-639 },
	   { 0x1.3c90d697e5b5dp-645, 0x1.c8ba606fb6833p-640 },
	   { 0x1.b963b20518321p-646, 0x1.3e8452ecdbe84p-640 },
	   { 0x1.33ada8cfe418fp-646, 0x1.bc34b0b8bbc6p-641 },
	   { 0x1.ace49de2283aep-647, 0x1.35b55b1b3d652p-641 },
	   { 0x1.2ae504dc15f24p-647, 0x1.afd0e79df00ebp-642 },
	   { 0x1.a08c1388db34fp-648, 0x1.2cff1d49f192cp-642 },
	   { 0x1.223852412258p-648, 0x1.a39120c175c51p-643 },
	   { 0x1.945c00d028182p-649, 0x1.24630cff92d39p-643 },
	   { 0x1.19a8e3da77fbep-649, 0x1.97775b48ec1aap-644 },
	   { 0x1.8856364b336c5p-650, 0x1.1be2898c8a8a4p-644 },
	   { 0x1.1137f7cd08642p-650, 0x1.8b8579b06ca2cp-645 },
	   { 0x1.7c7c673fe436ep-651, 0x1.137eddf1f97aep-645 },
	   { 0x1.08e6b787233bap-651, 0x1.7fbd41b078795p-646 },
	   { 0x1.70d029afc4472p-652, 0x1.0b3940d5da6fcp-646 },
	   { 0x1.00b637cd0ec0bp-652, 0x1.74205c365c73ep-647 },
	   { 0x1.6552f6729a259p-653, 0x1.0312d48405757p-647 },
	   { 0x1.f14ef1a3e4ac2p-654, 0x1.68b0556e87723p-648 },
	   { 0x1.5a06296220023p-654, 0x1.f6194df7630e5p-649 },
	   { 0x1.e176ccb941b53p-655, 0x1.5d6e9ce0425a7p-649 },
	   { 0x1.4eeb0196310cdp-655, 0x1.e64f64121563ep-650 },
	   { 0x1.d1e5afef936dap-656, 0x1.525c859a2ea9ap-650 },
	   { 0x1.4402a1b0bd9dfp-656, 0x1.d6c9b6d4d6fc5p-651 },
	   { 0x1.c29d225a230e3p-657, 0x1.477b466ee6cc1p-651 },
	   { 0x1.394e1038ce88ep-657, 0x1.c789ea0183d02p-652 },
	   { 0x1.b39e83951bdaap-658, 0x1.3ccbfa4112a58p-652 },
	   { 0x1.2ece3803d8d68p-658, 0x1.b8917a154498bp-653 },
	   { 0x1.a4eb0c6436cf4p-659, 0x1.324fa05e3adc4p-653 },
	   { 0x1.2483e8ac9d061p-659, 0x1.a9e1bcd30af1fp-654 },
	   { 0x1.9683cf6400112p-660, 0x1.28071ce79e917p-654 },
	   { 0x1.1a6fd716c7c18p-660, 0x1.9b7be1e1550cbp-655 },
	   { 0x1.8869b9cc95345p-661, 0x1.1df33948493fap-655 },
	   { 0x1.10929dfe85b79p-661, 0x1.8d60f37a227b9p-656 },
	   { 0x1.7a9d9444b613ep-662, 0x1.1414a4b7a1729p-656 },
	   { 0x1.06ecbe9338febp-662, 0x1.7f91d72bfd333p-657 },
	   { 0x1.6d2003c3fdf54p-663, 0x1.0a6bf4c7a4f95p-657 },
	   { 0x1.fafd4238f8063p-664, 0x1.720f4eaaf4bbbp-658 },
	   { 0x1.5ff18a8317f0ap-664, 0x1.00f9a5fe04069p-658 },
	   { 0x1.e8912b5139031p-665, 0x1.64d9f8b065b73p-659 },
	   { 0x1.531288f8c01c7p-665, 0x1.ef7c38ee94e41p-660 },
	   { 0x1.d695a98770e4bp-666, 0x1.57f251e86550ep-660 },
	   { 0x1.46833ee262b1p-666, 0x1.dd73492689d2p-661 },
	   { 0x1.c50b006d4e015p-667, 0x1.4b58b5eba6cc7p-661 },
	   { 0x1.3a43cc572b3d3p-667, 0x1.cbd8e7539eac7p-662 },
	   { 0x1.b3f14799b1616p-668, 0x1.3f0d6044b145dp-662 },
	   { 0x1.2e5432e458097p-668, 0x1.baad518e7426ep-663 },
	   { 0x1.a3486c40b74f1p-669, 0x1.33106d7f3cac9p-663 },
	   { 0x1.22b456b1a8db7p-669, 0x1.a9f09adee91e3p-664 },
	   { 0x1.931032d667261p-670, 0x1.2761dc408f1efp-664 },
	   { 0x1.1763ffacc46acp-670, 0x1.99a2acce5bd7fp-665 },
	   { 0x1.834838ba6fe3dp-671, 0x1.1c018e67b6eaep-665 },
	   { 0x1.0c62daba74e7cp-671, 0x1.89c349043d67ep-666 },
	   { 0x1.73eff5eb5eca5p-672, 0x1.10ef4a3481a29p-666 },
	   { 0x1.01b07aeca1f42p-672, 0x1.7a520aeb63faep-667 },
	   { 0x1.6506bebfc67bdp-673, 0x1.062abb7415c63p-667 },
	   { 0x1.ee98b577ea7cap-674, 0x1.6b4e695e9099fp-668 },
	   { 0x1.568bc5a3d72eep-674, 0x1.f766e96435041p-669 },
	   { 0x1.da6bba883d22ap-675, 0x1.5cb7b85aa6067p-669 },
	   { 0x1.487e1cd9f3e43p-675, 0x1.e311e0dabf963p-670 },
	   { 0x1.c6d89f0368fc1p-676, 0x1.4e8d2ab5187d6p-670 },
	   { 0x1.3adcb83cdccc3p-676, 0x1.cf55249e0172ap-671 },
	   { 0x1.b3ddd3216f86ep-677, 0x1.40cdd3d52967cp-671 },
	   { 0x1.2da66f0214306p-677, 0x1.bc2f50c60488ep-672 },
	   { 0x1.a1799fd5925f4p-678, 0x1.3378a96e8e29ap-672 },
	   { 0x1.20d9fd7b31257p-678, 0x1.a99ed8a2f2e6bp-673 },
	   { 0x1.8faa294857a39p-679, 0x1.268c853c2e48dp-673 },
	   { 0x1.147606d4e1ee3p-679, 0x1.97a2092e9b19dp-674 },
	   { 0x1.7e6d714d6fce7p-680, 0x1.1a0826b9b2f1ep-674 },
	   { 0x1.087916d26f37cp-680, 0x1.86370b7b69b46p-675 },
	   { 0x1.6dc159d3dbce3p-681, 0x1.0dea34dab05c3p-675 },
	   { 0x1.f9c3470942341p-682, 0x1.755be71f29feap-676 },
	   { 0x1.5da3a74ec8bc7p-682, 0x1.02313fbe40a01p-676 },
	   { 0x1.e35c1df5edf07p-683, 0x1.650e8497f58cdp-677 },
	   { 0x1.4e120315adc06p-683, 0x1.edb784bbee452p-678 },
	   { 0x1.cdb951dc67cbfp-684, 0x1.554cafa9d0c34p-678 },
	   { 0x1.3f09fdba5037ep-684, 0x1.d7d0486e476ccp-679 },
	   { 0x1.b8d760c6a3faap-685, 0x1.461419b3892c2p-679 },
	   { 0x1.308911536a23dp-685, 0x1.c2a975dad9bep-680 },
	   { 0x1.a4b2aa8c000cap-686, 0x1.37625bf981bdbp-680 },
	   { 0x1.228ca3bac6e07p-686, 0x1.ae3f97cbb25cep-681 },
	   { 0x1.914773f3bbbacp-687, 0x1.2934f9e530badp-681 },
	   { 0x1.151208bdc254ep-687, 0x1.9a8f1bb2e0d78p-682 },
	   { 0x1.7e91e9c37a26bp-688, 0x1.1b8963382a86p-682 },
	   { 0x1.0816843f2edd8p-688, 0x1.879454bd5bf1ap-683 },
	   { 0x1.6c8e23b87885fp-689, 0x1.0e5cf631ac83bp-683 },
	   { 0x1.f72e98937c4f8p-690, 0x1.754b7ed21d736p-684 },
	   { 0x1.5b38276a48eap-690, 0x1.01ad01a5b2ddp-684 },
	   { 0x1.df23162441e8bp-691, 0x1.63b0c17c2afp-685 },
	   { 0x1.4a8beb16012edp-691, 0x1.eaed8e09770edp-686 },
	   { 0x1.c804c1d0522ebp-692, 0x1.52c032be62aabp-686 },
	   { 0x1.3a855850eeeeap-692, 0x1.d36ef8a6e08fap-687 },
	   { 0x1.b1cdcc2ca0214p-693, 0x1.4275d9d00481dp-687 },
	   { 0x1.2b204ea20186ep-693, 0x1.bcd89c2310d59p-688 },
	   { 0x1.9c78595e362cep-694, 0x1.32cdb1c10f0eep-688 },
	   { 0x1.1c58a6013aaeep-694, 0x1.a724c21e93002p-689 },
	   { 0x1.87fe848fd6bffp-695, 0x1.23c3ac05a8c19p-689 },
	   { 0x1.0e2a313c94bb5p-695, 0x1.924da8624908p-690 },
	   { 0x1.745a6341bd9d3p-696, 0x1.1553b2e7eba16p-690 },
	   { 0x1.0090c041eb55fp-696, 0x1.7e4d844204d5fp-691 },
	   { 0x1.61860872f36c7p-697, 0x1.0779abdf88654p-691 },
	   { 0x1.e710449b20327p-698, 0x1.6b1e85d9cfdc3p-692 },
	   { 0x1.4f7b87a3ccd22p-698, 0x1.f462f39da55f5p-693 },
	   { 0x1.ce184ffaa0275p-699, 0x1.58badb2559681p-693 },
	   { 0x1.3e34f7b15484dp-699, 0x1.daedfe49c8a9fp-694 },
	   { 0x1.b6314a8f93441p-700, 0x1.471cb2f12adecp-694 },
	   { 0x1.2dac75898461p-700, 0x1.c28c3fc94131bp-695 },
	   { 0x1.9f52e6b0168fbp-701, 0x1.363e3fa56683p-695 },
	   { 0x1.1ddc26b854422p-701, 0x1.ab358720f461fp-696 },
	   { 0x1.8974e49b18481p-702, 0x1.2619b9e9f9276p-696 },
	   { 0x1.0ebe3bcdc6652p-702, 0x1.94e1adf5ef17ap-697 },
	   { 0x1.748f15c14a99p-703, 0x1.16a96324493c1p-697 },
	   { 0x1.004cf29d383afp-703, 0x1.7f889bf8109c7p-698 },
	   { 0x1.60995fd7916b4p-704, 0x1.07e787ce8decbp-698 },
	   { 0x1.e50530acb7a2bp-705, 0x1.6b224a16aa4ep-699 },
	   { 0x1.4d8bbfb38c98p-705, 0x1.f39d03522ee6ep-700 },
	   { 0x1.cab316f0b29dep-706, 0x1.57a6c57f8fed2p-700 },
	   { 0x1.3b5e4bf3051bbp-706, 0x1.d8b1738bdcb74p-701 },
	   { 0x1.b1987b3f62cd2p-707, 0x1.450e32693ba8dp-701 },
	   { 0x1.2a09376f26716p-707, 0x1.bf0154de94403p-702 },
	   { 0x1.99aa6a5f22416p-708, 0x1.3350cea8cd61ap-702 },
	   { 0x1.1984d37c8d151p-708, 0x1.a681c1d2f0b94p-703 },
	   { 0x1.82de1daeb9c47p-709, 0x1.2266f414ce57bp-703 },
	   { 0x1.09c991f950457p-709, 0x1.8f27fe21c9591p-704 },
	   { 0x1.6d28fdea9871ap-710, 0x1.12491ab5c17d9p-704 },
	   { 0x1.f5a00e548f085p-711, 0x1.78e979aa0c9bep-705 },
	   { 0x1.5880a5ae03598p-711, 0x1.02efdac5a4ff4p-705 },
	   { 0x1.d921d6d1c821bp-712, 0x1.63bbd32217718p-706 },
	   { 0x1.44dae3b23367bp-712, 0x1.e8a7dcff4677cp-707 },
	   { 0x1.be0a394617721p-713, 0x1.4f94da865b2a3p-707 },
	   { 0x1.322dbccd73cabp-713, 0x1.ccdc67829105bp-708 },
	   { 0x1.a44b3f5ce9c8bp-714, 0x1.3c6a934743c05p-708 },
	   { 0x1.206f6db46b93p-714, 0x1.b26f5afd4ebc9p-709 },
	   { 0x1.8bd742e227a38p-715, 0x1.2a3336386b4d7p-709 },
	   { 0x1.0f966c7fd2396p-715, 0x1.99530a15ce61ap-710 },
	   { 0x1.74a0efc06d36ep-716, 0x1.18e533433f227p-710 },
	   { 0x1.ff32d3f1c0a49p-717, 0x1.817a166d90dbdp-711 },
	   { 0x1.5e9b45aff1bep-717, 0x1.087732df4f3abp-711 },
	   { 0x1.e0dea55db81c4p-718, 0x1.6ad7728d6db01p-712 },
	   { 0x1.49b9999981d6cp-718, 0x1.f1c02ea5235f3p-713 },
	   { 0x1.c41e9fb058b1ep-719, 0x1.555e63841a093p-713 },
	   { 0x1.35ef96b0fe655p-719, 0x1.d42dfb77e321ep-714 },
	   { 0x1.a8e19002cb47fp-720, 0x1.4102823a6a0a2p-714 },
	   { 0x1.23313f4adb099p-720, 0x1.b8267dd51660dp-715 },
	   { 0x1.8f16bf19917acp-721, 0x1.2db7bc80b123ep-715 },
	   { 0x1.1172ed701cd4p-721, 0x1.9d98e007ff597p-716 },
	   { 0x1.76adf2095d808p-722, 0x1.1b7255d8af1cep-716 },
	   { 0x1.00a953345bce4p-722, 0x1.8474c5f89cf1fp-717 },
	   { 0x1.5f976a86ba7a3p-723, 0x1.0a26e7ff7c8ap-717 },
	   { 0x1.e192f5a290a0dp-724, 0x1.6caa4dc34bcc6p-718 },
	   { 0x1.49c3e6e576cf8p-724, 0x1.f394c675d5da1p-719 },
	   { 0x1.c3918d16606afp-725, 0x1.562a0ffd36fefp-719 },
	   { 0x1.3524a1ccb90cep-725, 0x1.d4a41cdb95576p-720 },
	   { 0x1.a739e0c3f00b3p-726, 0x1.40e51faa74ee4p-720 },
	   { 0x1.21ab51a49a64p-726, 0x1.b7670ded07be7p-721 },
	   { 0x1.8c781323e2b8bp-727, 0x1.2ccd09eaa341p-721 },
	   { 0x1.0f4a27c210b83p-727, 0x1.9bc980b6cd88bp-722 },
	   { 0x1.7338f3cfd4b18p-728, 0x1.19d3d560c7458p-722 },
	   { 0x1.fbe79eabbab8bp-729, 0x1.81b807901b2ddp-723 },
	   { 0x1.5b69fdd784131p-729, 0x1.07ec015b26bbfp-723 },
	   { 0x1.db36d8463b3e1p-730, 0x1.691fdebe382bep-724 },
	   { 0x1.44f955c9776f6p-730, 0x1.ee11097f70374p-725 },
	   { 0x1.bc693203fe92cp-731, 0x1.51eeeac7320bep-725 },
	   { 0x1.2fd5c7756dd24p-731, 0x1.ce39998362bf9p-726 },
	   { 0x1.9f66cc65fb2cbp-732, 0x1.3c13b67a17ff2p-726 },
	   { 0x1.1beec36eb8502p-732, 0x1.b03976c943068p-727 },
	   { 0x1.8418af0dd65edp-733, 0x1.277d70b2ebc6fp-727 },
	   { 0x1.09345c546e7cdp-733, 0x1.93f94ba2c6b6ap-728 },
	   { 0x1.6a68c4bfd764bp-734, 0x1.141be9e049453p-728 },
	   { 0x1.ef2e87ca7b717p-735, 0x1.7962a50231832p-729 },
	   { 0x1.5241d71eb6e19p-735, 0x1.01df915097b64p-729 },
	   { 0x1.ce118fc8beeeap-736, 0x1.605fee84767fp-730 },
	   { 0x1.3b8f8a28fd848p-736, 0x1.e172e498cd2fcp-731 },
	   { 0x1.aef59daa19c93p-737, 0x1.48dc6e3757e71p-731 },
	   { 0x1.263e577f574dp-737, 0x1.c1366206ca036p-732 },
	   { 0x1.91bfa9231de5cp-738, 0x1.32c440230ef3ap-732 },
	   { 0x1.123b897af1af4p-738, 0x1.a2ee0ea25a216p-733 },
	   { 0x1.7655cd85a2773p-739, 0x1.1e04519eb8f87p-733 },
	   { 0x1.feea6c3554149p-740, 0x1.867f82bdccb8fp-734 },
	   { 0x1.5c9f427a491a4p-740, 0x1.0a8a5c7678dffp-734 },
	   { 0x1.dbb4739afff2ep-741, 0x1.6bd1744d1513ep-735 },
	   { 0x1.4484548d479a3p-741, 0x1.f089c3d3d8b6fp-736 },
	   { 0x1.bab46440d8e4bp-742, 0x1.52cbafb8bc99fp-736 },
	   { 0x1.2dee5d96e696ep-742, 0x1.ce464b1286c0dp-737 },
	   { 0x1.9bcaf0aad775cp-743, 0x1.3b571085ef9dbp-737 },
	   { 0x1.18c7bd07b007fp-743, 0x1.ae2a4fedee59cp-738 },
	   { 0x1.7eda37d26ae66p-744, 0x1.255d79dbe3905p-738 },
	   { 0x1.04fbd01fd3b9ap-744, 0x1.9017432798e26p-739 },
	   { 0x1.63c5ba199716fp-745, 0x1.10c9ceee61d28p-739 },
	   { 0x1.e4edd431a7a4p-746, 0x1.73effa34f57abp-740 },
	   { 0x1.4a724e2f6eadep-746, 0x1.fb0fd6a99ec28p-741 },
	   { 0x1.c24c9890314cdp-747, 0x1.5998a4600495bp-741 },
	   { 0x1.32c615eef6a3dp-747, 0x1.d70936a92f04ap-742 },
	   { 0x1.a1f03c81340fdp-748, 0x1.40f6bfdad1f14p-742 },
	   { 0x1.1ca87340e1c39p-748, 0x1.b55b284add8c1p-743 },
	   { 0x1.83b6cbf2ba29fp-749, 0x1.29f10ece9036ep-743 },
	   { 0x1.0801fd07f7284p-749, 0x1.95e2d86ae92c8p-744 },
	   { 0x1.677ffffc31b92p-750, 0x1.146f8c6e8dc57p-744 },
	   { 0x1.e978e83ebd95dp-751, 0x1.787f26e598ebbp-745 },
	   { 0x1.4d2d2f5dd4096p-751, 0x1.005b6216a17eap-745 },
	   { 0x1.c58570e2f641dp-752, 0x1.5d10973fbab06p-746 },
	   { 0x1.34a13f272cdfap-752, 0x1.db3db8f832a58p-747 },
	   { 0x1.a4017c5ace0dep-753, 0x1.4379416dfac63p-747 },
	   { 0x1.1dc0938cfb932p-753, 0x1.b84ac1ef46255p-748 },
	   { 0x1.84c7064147f81p-754, 0x1.2b9cc2c3d6738p-748 },
	   { 0x1.087100f5e6429p-754, 0x1.97b6c5dc3637ap-749 },
	   { 0x1.67b20873fc995p-755, 0x1.15602f1227af8p-749 },
	   { 0x1.e9337a8979dap-756, 0x1.795cb2bb480b6p-750 },
	   { 0x1.4ca0667456eb8p-756, 0x1.00aa01fc8a73ep-750 },
	   { 0x1.c446a2ccade1cp-757, 0x1.5d196927cdaccp-751 },
	   { 0x1.3371d92c55c69p-757, 0x1.dac421184af19p-752 },
	   { 0x1.a1ef1650d3562p-758, 0x1.42cba823b93cbp-752 },
	   { 0x1.1c07db1df4cf6p-758, 0x1.b6e2f60b615c1p-753 },
	   { 0x1.8202debc2593cp-759, 0x1.2a53f94211ba9p-753 },
	   { 0x1.064595037ce7bp-759, 0x1.95853e0fd75adp-754 },
	   { 0x1.645a58ac6913cp-760, 0x1.13949d3b2fbd2p-754 },
	   { 0x1.e41f95cc492cep-761, 0x1.768213ee2ba9cp-755 },
	   { 0x1.48d0194e5b153p-761, 0x1.fce2f1e195a7ap-756 },
	   { 0x1.be99935f38c42p-762, 0x1.59b2d772c1b04p-756 },
	   { 0x1.2f40d4a5d287p-762, 0x1.d5a005ce1b15dp-757 },
	   { 0x1.9bc8aa74c3805p-763, 0x1.3ef3138f8ae58p-757 },
	   { 0x1.178b448b82b16p-763, 0x1.b12e626e3c8a1p-758 },
	   { 0x1.7b7f2dc7fa066p-764, 0x1.2620652c3102cp-758 },
	   { 0x1.0190106456396p-764, 0x1.8f5ecffd9c995p-759 },
	   { 0x1.5d92194746ef2p-765, 0x1.0f1a62a97a48ep-759 },
	   { 0x1.da636b2add63ap-766, 0x1.7004d0a0dd3fcp-760 },
	   { 0x1.41d8f14e2d235p-766, 0x1.f38508375a815p-761 },
	   { 0x1.b4a8e16df3a2ep-767, 0x1.52f67f4a45dbdp-761 },
	   { 0x1.282da2ee06e9fp-767, 0x1.cbf8187da97p-762 },
	   { 0x1.91bc4f0e82a1p-768, 0x1.380c6fa6ddd1bp-762 },
	   { 0x1.106c65473611bp-768, 0x1.a757e44dde4fbp-763 },
	   { 0x1.716ca73d3a1dcp-769, 0x1.1f218f165083cp-763 },
	   { 0x1.f4e737e667fe6p-770, 0x1.8571975a9ba0cp-764 },
	   { 0x1.538bdbc88035p-770, 0x1.081306aee058bp-764 },
	   { 0x1.cc4774fe05a13p-771, 0x1.661571375ee31p-765 },
	   { 0x1.37eeb586702afp-771, 0x1.e5803c9b677cp-766 },
	   { 0x1.a6be51e94d2c3p-772, 0x1.49169d29f057fp-766 },
	   { 0x1.1e6cae3cc5ce4p-772, 0x1.be144165bfdadp-767 },
	   { 0x1.841452e30c6ecp-773, 0x1.2e4b0b7596d86p-767 },
	   { 0x1.06dfcc0330324p-773, 0x1.99a8814f82396p-768 },
	   { 0x1.64157d8dbcaa1p-774, 0x1.158b4c1d7aa61p-768 },
	   { 0x1.e248fc3725278p-775, 0x1.7806fe5adc0dep-769 },
	   { 0x1.4691284199248p-775, 0x1.fd64d63539ac4p-770 },
	   { 0x1.ba32f675bcca1p-776, 0x1.58fd2560c98e3p-770 },
	   { 0x1.2b59cb5fcd07p-776, 0x1.d33b9c01b8858p-771 },
	   { 0x1.953f4278d9771p-777, 0x1.3c5b9e7be019ep-771 },
	   { 0x1.1244d4a198783p-777, 0x1.ac5a261b57bd2p-772 },
	   { 0x1.7333ac721d353p-778, 0x1.21f61f6e6a3a5p-772 },
	   { 0x1.f654f8b2c9938p-779, 0x1.8883e334bf813p-773 },
	   { 0x1.53d9d5f4e3889p-779, 0x1.09a33ffab8174p-773 },
	   { 0x1.cbcb3935e8707p-780, 0x1.678037d69a88ap-774 },
	   { 0x1.36fefd85e37f7p-780, 0x1.e678a0474dd4dp-775 },
	   { 0x1.a4a7147e53789p-781, 0x1.491a44a8cc267p-775 },
	   { 0x1.1c73c8c2f3143p-781, 0x1.bd3a60953bab8p-776 },
	   { 0x1.80a7df6e9e4abp-782, 0x1.2d20af56e98e4p-776 },
	   { 0x1.040c111171b21p-782, 0x1.9748563f2a02cp-777 },
	   { 0x1.5f9153468350dp-783, 0x1.13656dff66048p-777 },
	   { 0x1.db3d65827b6f1p-784, 0x1.7463a2ae57157p-778 },
	   { 0x1.412b4a3b0b6bbp-784, 0x1.f77b2a384d071p-779 },
	   { 0x1.b20abd232bd72p-785, 0x1.5451ae34b02aep-779 },
	   { 0x1.25417f5fe18aap-785, 0x1.cc024fa52d21ep-780 },
	   { 0x1.8c38db09c3d68p-786, 0x1.36dbe645ba702p-780 },
	   { 0x1.0ba351c6b2c44p-786, 0x1.a415d531b6e85p-781 },
	   { 0x1.69856de02317p-787, 0x1.1bcf7eeeba2f5p-781 },
	   { 0x1.e847157246bfcp-788, 0x1.7f70703ac5558p-782 },
	   { 0x1.49b2d16422141p-788, 0x1.02fd377359b1p-782 },
	   { 0x1.bd304de355d85p-789, 0x1.5dd1b0bb84b26p-783 },
	   { 0x1.2c87c2ff697dcp-789, 0x1.d87243e77ecadp-784 },
	   { 0x1.95b4456f24a66p-790, 0x1.3efdb3b369292p-784 },
	   { 0x1.11cf1a60f1d84p-790, 0x1.aeb4dc01a4631p-785 },
	   { 0x1.718a9184a8678p-791, 0x1.22bcd99dbdb06p-785 },
	   { 0x1.f2af0be1fde49p-792, 0x1.88766c06b0833p-786 },
	   { 0x1.507007917e3d9p-792, 0x1.08db80d427d79p-786 },
	   { 0x1.c5e695f15072bp-793, 0x1.65709eb54bf5ep-787 },
	   { 0x1.32266540e08c2p-793, 0x1.e253876b38acep-788 },
	   { 0x1.9cf012acb820bp-794, 0x1.45623a2f6a451p-788 },
	   { 0x1.1673fda512b46p-794, 0x1.b6f674d703273p-789 },
	   { 0x1.777d05328bd26p-795, 0x1.280eca736b4b1p-789 },
	   { 0x1.fa46d62b8e57dp-796, 0x1.8f4d804e3ad6fp-790 },
	   { 0x1.5544c8bc23e1cp-796, 0x1.0d3e50a2eecdcp-790 },
	   { 0x1.cc068b1dc8ab2p-797, 0x1.6b0c7763ce52bp-791 },
	   { 0x1.36042b906571p-797, 0x1.e979edc5b3767p-792 },
	   { 0x1.a1cbbab815b4cp-798, 0x1.49ecd657d5dd6p-792 },
	   { 0x1.197d0fe71564cp-798, 0x1.bcb59141dc715p-793 },
	   { 0x1.7b41f3bcb1869p-799, 0x1.2bad65a82bb23p-793 },
	   { 0x1.feec24eca8006p-800, 0x1.93d6de18ac6bfp-794 },
	   { 0x1.581b387627669p-800, 0x1.1011dd6dfecf6p-794 },
	   { 0x1.cf746ccaba032p-801, 0x1.6e8be31f2fe24p-795 },
	   { 0x1.380f8b864e1acp-801, 0x1.edc51c8649aaap-796 },
	   { 0x1.a4312cc2f816ap-802, 0x1.4c88f43732a1p-796 },
	   { 0x1.1adc83c96accfp-802, 0x1.bfd81ed74f1cdp-797 },
	   { 0x1.7cc835281bbf3p-803, 0x1.2d883a292df3bp-797 },
	   { 0x1.0044e6f2b903fp-803, 0x1.95fde403b5724p-798 },
	   { 0x1.58e66674c0f82p-804, 0x1.11494966870b7p-798 },
	   { 0x1.d0209514d613dp-805, 0x1.6fdef1ca550b3p-799 },
	   { 0x1.383f2f4495aedp-805, 0x1.ef217eb67d36dp-800 },
	   { 0x1.a41575f0363d6p-806, 0x1.4d2aaa5b8e28ap-800 },
	   { 0x1.1a8c12a0cae91p-806, 0x1.c04fcbf1fddd8p-801 },
	   { 0x1.7c08d08f2ccbbp-807, 0x1.2d96cdd2a30b8p-801 },
	   { 0x1.ff186c5b90604p-808, 0x1.95b8ba50a2687p-802 },
	   { 0x1.57a2b0b1c4c86p-808, 0x1.10df03cd711e3p-802 },
	   { 0x1.ce07ef98af2aep-809, 0x1.6eff939f51c8fp-803 },
	   { 0x1.36923c5eb270bp-809, 0x1.ed88d96607fb4p-804 },
	   { 0x1.a1791489717bfp-810, 0x1.4bcf1445c1d61p-804 },
	   { 0x1.188d2c2d680a3p-810, 0x1.be1a747b458c8p-805 },
	   { 0x1.7907312c7e255p-811, 0x1.2bd8dde16ba8ap-805 },
	   { 0x1.fa9e995f4c414p-812, 0x1.93089dc23e417p-806 },
	   { 0x1.5455df149c7b5p-812, 0x1.0ed4f34d6e965p-806 },
	   { 0x1.c93410e8142f8p-813, 0x1.6bf1c754a3325p-807 },
	   { 0x1.33105a5b594f7p-813, 0x1.e9027b1c5a4abp-808 },
	   { 0x1.9c67f441e11b3p-814, 0x1.487c687197597p-808 },
	   { 0x1.14e8ebae7496ep-814, 0x1.b942323a72767p-809 },
	   { 0x1.73d10c597b774p-815, 0x1.285660efb3e9ap-809 },
	   { 0x1.f330b99c7f9e7p-816, 0x1.8df9d62fb9c5ep-810 },
	   { 0x1.4f0ef77c81a6fp-816, 0x1.0b34677fe9486p-810 },
	   { 0x1.c1baedb5f2e65p-817, 0x1.66c37bb05de1ep-811 },
	   { 0x1.2dc9788ad9864p-817, 0x1.e1a30436bcde5p-812 },
	   { 0x1.94f913add4907p-818, 0x1.4341c90c553e7p-812 },
	   { 0x1.0fafd2c40ba27p-818, 0x1.b1dd0ffc5d04bp-813 },
	   { 0x1.6c7df995241d1p-819, 0x1.231f4a6757469p-813 },
	   { 0x1.e8f062cc963cep-820, 0x1.86a35930ed5e1p-814 },
	   { 0x1.47e5cbff0d92ep-820, 0x1.060dd236f49a3p-814 },
	   { 0x1.b7be34be4e18dp-821, 0x1.5f8c25cd122d7p-815 },
	   { 0x1.26d5559b935e7p-821, 0x1.d78bca82e9f37p-816 },
	   { 0x1.8b4dd6af9c05dp-822, 0x1.3c36d15093021p-816 },
	   { 0x1.08f94cfc79158p-822, 0x1.a80c62c44a65bp-817 },
	   { 0x1.632ec0e0d009cp-823, 0x1.1c4b11ed6627ap-817 },
	   { 0x1.dc0b5f2e40ea4p-824, 0x1.7d261cc2edf72p-818 },
	   { 0x1.3efa480ea698bp-824, 0x1.fef096f5252fp-819 },
	   { 0x1.ab6a5245de9e5p-825, 0x1.566c107178d1fp-819 },
	   { 0x1.1e52cde409267p-825, 0x1.cae9de8f00c0bp-820 },
	   { 0x1.7f910d0084829p-826, 0x1.337ae444bd293p-820 },
	   { 0x1.00e3012bd4171p-826, 0x1.9bfbcfe9dc1e8p-821 },
	   { 0x1.580c66bfc7cf5p-827, 0x1.13f803c0631d9p-821 },
	   { 0x1.ccba595fe34b5p-828, 0x1.71ac2109d33c9p-822 },
	   { 0x1.347383dcf4a9bp-828, 0x1.ef21caa7d80c3p-823 },
	   { 0x1.9cf52785fcd1fp-829, 0x1.4b8b6bbdb7a4fp-823 },
	   { 0x1.1466f7a4ba4b3p-829, 0x1.bbf4bcf8ca0c3p-824 },
	   { 0x1.71f5b701cb667p-830, 0x1.2934441fdae8bp-824 },
	   { 0x1.ef1fef5338f87p-831, 0x1.8de00a5d4cff3p-825 },
	   { 0x1.4b46ffc2e70ccp-831, 0x1.0a4a61359d63ap-825 },
	   { 0x1.bb3f3e667d5e5p-832, 0x1.64673b39bdd54p-826 },
	   { 0x1.287ea78b8278fp-832, 0x1.dcf3acd0cc1f4p-827 },
	   { 0x1.8c9c8347a2863p-833, 0x1.3f1926f0c2aa4p-827 },
	   { 0x1.093c166d47d9p-833, 0x1.aaecb94ca24e1p-828 },
	   { 0x1.62b5957e6b822p-834, 0x1.1d8efbbc88d6cp-828 },
	   { 0x1.da4f3c5b8c56fp-835, 0x1.7df554174928cp-829 },
	   { 0x1.3d1457a1afdaep-835, 0x1.fed6b4a9440a8p-830 },
	   { 0x1.a7e3665ffae25p-836, 0x1.558fae0fed7aap-830 },
	   { 0x1.1b4da97b89113p-836, 0x1.c8b307e047613p-831 },
	   { 0x1.7aa46b2ec675cp-837, 0x1.3149a005e5984p-831 },
	   { 0x1.fa00e080e536p-838, 0x1.9819329634547p-832 },
	   { 0x1.520f92dcad4a2p-838, 0x1.10bba52994e8ep-832 },
	   { 0x1.c3a9666328faap-839, 0x1.6c7dd2d93c0f9p-833 },
	   { 0x1.2dae795ce73b6p-839, 0x1.e70fd5d6d806dp-834 },
	   { 0x1.92f5963d343cfp-840, 0x1.45629dffe1fa7p-834 },
	   { 0x1.0d15f439254bep-840, 0x1.b2b2e959996bp-835 },
	   { 0x1.675546ac2c967p-841, 0x1.2255364dfcfd7p-835 },
	   { 0x1.dfca1ff236f02p-842, 0x1.83c6a3841fccap-836 },
	   { 0x1.4046155930cfbp-842, 0x1.02ee197efc99dp-836 },
	   { 0x1.ab8846c89a496p-843, 0x1.59bfc8bdbfffep-837 },
	   { 0x1.1d5226b496f7ep-843, 0x1.cd9f4c973304p-838 },
	   { 0x1.7cc7edd2bedd1p-844, 0x1.3420703d360eap-838 },
	   { 0x1.fc1e021531b11p-845, 0x1.9b4a6e4580455p-839 },
	   { 0x1.52f9fd29afa7bp-845, 0x1.1276cde31355ep-839 },
	   { 0x1.c439018f9e7bp-846, 0x1.6e44a0da72dedp-840 },
	   { 0x1.2d9d4a3bfacfap-846, 0x1.e8b82d35e9882p-841 },
	   { 0x1.9247c7d6b7109p-847, 0x1.4603c1a2de688p-841 },
	   { 0x1.0c3d4d5746632p-847, 0x1.b2e6fa531d555p-842 },
	   { 0x1.65add59367765p-848, 0x1.220b241172407p-842 },
	   { 0x1.dce1e8301e6efp-849, 0x1.82d28ae825549p-843 },
	   { 0x1.3dde18cb97a8dp-849, 0x1.01ea51e3f541cp-843 },
	   { 0x1.a7b31ccb0b2f4p-850, 0x1.57e3d8e31e749p-844 },
	   { 0x1.1a59798dd7aa2p-850, 0x1.ca77ce984ce61p-845 },
	   { 0x1.7843a7981f8e3p-851, 0x1.3192c63185ef2p-845 },
	   { 0x1.f55b0f3ffe463p-852, 0x1.974911a73b1a7p-846 },
	   { 0x1.4df9fe655b0fbp-852, 0x1.0f64b579273f6p-846 },
	   { 0x1.bce68ce6bcfedp-853, 0x1.69a3e1bad13dap-847 },
	   { 0x1.284bfe1cdea24p-853, 0x1.e1d6859c11527p-848 },
	   { 0x1.8a9c29acbf47dp-854, 0x1.40f425a16dca3p-848 },
	   { 0x1.06bd70b72892bp-854, 0x1.ab8633790b1e2p-849 },
	   { 0x1.5dd55c1a48477p-855, 0x1.1cb4a43b9229fp-849 },
	   { 0x1.d1bd6b173b9f2p-856, 0x1.7b25cc6523c3bp-850 },
	   { 0x1.35fc8451ff49ep-856, 0x1.f8db2dc70232bp-851 },
	   { 0x1.9c9712232f548p-857, 0x1.5014bc06e7f91p-851 },
	   { 0x1.128b47439dcd5p-857, 0x1.bf66ba3b9066cp-852 },
	   { 0x1.6d53d2be0a0b6p-858, 0x1.29c2c1dc958dbp-852 },
	   { 0x1.e6122171333dfp-859, 0x1.8c4a9d76af90fp-853 },
	   { 0x1.435229d0cc681p-859, 0x1.07ae5a7347d0bp-853 },
	   { 0x1.ae1371b74ea2dp-860, 0x1.5ed9539dfd0c9p-854 },
	   { 0x1.1e01427183001p-860, 0x1.d2c69c7599edcp-855 },
	   { 0x1.7c589442700ecp-861, 0x1.3677341a98a13p-855 },
	   { 0x1.f9be9e1d7b4e4p-862, 0x1.9cf2c5625685ep-856 },
	   { 0x1.5033c96eb757p-862, 0x1.1298aebe8af0fp-856 },
	   { 0x1.bef014f36ffa9p-863, 0x1.6d2655c8560ebp-857 },
	   { 0x1.290979be09b3bp-863, 0x1.e58166789d0bcp-858 },
	   { 0x1.8ac6ba86dcc3cp-864, 0x1.42b9e90b536b6p-858 },
	   { 0x1.064e638fb2517p-864, 0x1.acfe7e64002b1p-859 },
	   { 0x1.5c884857d8adep-865, 0x1.1d179e12ade6ep-859 },
	   { 0x1.cf0beaeb1b319p-866, 0x1.7ae01eb0f55cbp-860 },
	   { 0x1.338e29511ffcdp-866, 0x1.f772a9e0423a1p-861 },
	   { 0x1.9881a23b2ff9bp-867, 0x1.4e72e15f0f016p-861 },
	   { 0x1.0f43798c4f845p-867, 0x1.bc4e2f5a8c9afp-862 },
	   { 0x1.6836e63bd7d88p-868, 0x1.27165d875ec78p-862 },
	   { 0x1.de466f9c32fdap-869, 0x1.87eb54ae1860dp-863 },
	   { 0x1.3d79f883687bfp-869, 0x1.043b38d103ec9p-863 },
	   { 0x1.a56d48500b8a3p-870, 0x1.598a7d65e3b67p-864 },
	   { 0x1.17ac327f9b5e5p-870, 0x1.cac2d1ee89db1p-865 },
	   { 0x1.73278f241bb95p-871, 0x1.308090afcd9f3p-865 },
	   { 0x1.ec801820c3f3dp-872, 0x1.942d41e7bf2a3p-866 },
	   { 0x1.46b841565ab3ep-872, 0x1.0c34dc595f4bfp-866 },
	   { 0x1.b16ea850bfa34p-873, 0x1.63e9cb83e74b2p-867 },
	   { 0x1.1f76e44abf0ecp-873, 0x1.d83e5a3ffd7adp-868 },
	   { 0x1.7d432d7dd0ca1p-874, 0x1.39428e0fd00c5p-868 },
	   { 0x1.f99abec00b682p-875, 0x1.9f8c2eadfb109p-869 },
	   { 0x1.4f35579392d4bp-875, 0x1.13957092e7741p-869 },
	   { 0x1.bc6c19eee10e8p-876, 0x1.6d7ad6ac744f9p-870 },
	   { 0x1.2692d6adc530fp-876, 0x1.e4a41e3c393c2p-871 },
	   { 0x1.8673fad41c337p-877, 0x1.4149a31665d1ep-871 },
	   { 0x1.02bd066e6e446p-877, 0x1.a9efbad7c9909p-872 },
	   { 0x1.56dece3f159c3p-878, 0x1.1a4d14ca40e6p-872 },
	   { 0x1.c64dabfd6babdp-879, 0x1.7628f37011dc7p-873 },
	   { 0x1.2cf07ed3ac7cap-879, 0x1.efd93aae49244p-874 },
	   { 0x1.8ea5cdb1b77f8p-880, 0x1.4884565714d83p-874 },
	   { 0x1.0801f05da3babp-880, 0x1.b341347ab9d2ep-875 },
	   { 0x1.5da3ba0723cbcp-881, 0x1.204d0f497ca7dp-875 },
	   { 0x1.cefd7b19fc691p-882, 0x1.7de10a24a9be3p-876 },
	   { 0x1.3281b7ca3d771p-882, 0x1.f9c4f419d97b9p-877 },
	   { 0x1.95c663259c5d8p-883, 0x1.4ee2a6bb63f1dp-877 },
	   { 0x1.0c90568fe453bp-883, 0x1.bb6bea4d790c6p-878 },
	   { 0x1.6374ef6370a23p-884, 0x1.258802fee3a1bp-878 },
	   { 0x1.d668024e6e773p-885, 0x1.8491dcb50d65p-879 },
	   { 0x1.3739f6c74a992p-885, 0x1.012888bcf5e1bp-879 },
	   { 0x1.9bc5a2748239p-886, 0x1.5456466d99824p-880 },
	   { 0x1.105de86fb726ep-886, 0x1.c25d7813e5a28p-881 },
	   { 0x1.68453b252f9afp-887, 0x1.29f220ff323bdp-881 },
	   { 0x1.dc7c640bf856fp-888, 0x1.8a2c46b36447dp-882 },
	   { 0x1.3b0e7a2d8004dp-888, 0x1.04b5178932d9ep-882 },
	   { 0x1.a095d99893beap-889, 0x1.58d2d04dcdef9p-883 },
	   { 0x1.1361f24d04a1ep-889, 0x1.c8060b8a624d8p-884 },
	   { 0x1.6c0994513d45bp-890, 0x1.2d8154e3020f5p-884 },
	   { 0x1.e12caa0268707p-891, 0x1.8ea37661d565fp-885 },
	   { 0x1.3df6725a60cf5p-891, 0x1.078003d294269p-885 },
	   { 0x1.a42bf15180a09p-892, 0x1.5c4df6da1a5fp-886 },
	   { 0x1.15957e82800c6p-892, 0x1.cc58a0676d26ep-887 },
	   { 0x1.6eb9463d29a0dp-893, 0x1.302d6b1661efp-887 },
	   { 0x1.e46dfa81a2018p-894, 0x1.91ed1d851d1ddp-888 },
	   { 0x1.3feb236502138p-894, 0x1.0982d94421652p-888 },
	   { 0x1.a67f97b02e026p-895, 0x1.5ebfab91b4a2bp-889 },
	   { 0x1.16f37032d6085p-895, 0x1.cf4b3235443f5p-890 },
	   { 0x1.704e120e656fdp-896, 0x1.31f0304f01ddbp-890 },
	   { 0x1.e638c247f445dp-897, 0x1.940198fd0e1c2p-891 },
	   { 0x1.40e7ff18c854cp-897, 0x1.0ab8eaa8fae67p-891 },
	   { 0x1.a78b6039c7039p-898, 0x1.60223e0067b2cp-892 },
	   { 0x1.1778970df4481p-898, 0x1.d0d6e2f89dd66p-893 },
	   { 0x1.70c446e7535ccp-899, 0x1.32c589802b4bap-893 },
	   { 0x1.e688d1dc06742p-900, 0x1.94dc0e4e3bd62p-894 },
	   { 0x1.40eab69ffb357p-900, 0x1.0b1f64079cf15p-894 },
	   { 0x1.a74cd8f49285bp-901, 0x1.607271cb1c23p-895 },
	   { 0x1.1723bbb37e71p-901, 0x1.d0f815d3e30e4p-896 },
	   { 0x1.701ad03f5aba2p-902, 0x1.32ab83cb1b9aap-896 },
	   { 0x1.e55d6dd34aeb5p-903, 0x1.947a7e7d08e62p-897 },
	   { 0x1.3ff3437e5e592p-903, 0x1.0ab555a059592p-897 },
	   { 0x1.a5c493ec4b75bp-904, 0x1.5faf8b45ee11cp-898 },
	   { 0x1.15f5a46f2a8c5p-904, 0x1.cfae7d166a387p-899 },
	   { 0x1.6e533a1804da5p-905, 0x1.31a25c153692fp-899 },
	   { 0x1.e2b951ac76b4bp-906, 0x1.92ddcdd3a585ap-900 },
	   { 0x1.3e03e7aaf4a23p-906, 0x1.097bb793410b5p-900 },
	   { 0x1.a2f624fa2da41p-907, 0x1.5ddb524f58124p-901 },
	   { 0x1.13f112353b2e2p-907, 0x1.ccfd1b6b2b0d1p-902 },
	   { 0x1.6b71aaf8395acp-908, 0x1.2fac7e1ac1a55p-902 },
	   { 0x1.dea2a52e6f8d6p-909, 0x1.9009c068a7447p-903 },
	   { 0x1.3b2124c85eb7dp-909, 0x1.077566199da13p-903 },
	   { 0x1.9ee813dcc82f4p-910, 0x1.5afa0b60e30adp-904 },
	   { 0x1.111ab5ef7d9cep-910, 0x1.c8ea38207b48cp-905 },
	   { 0x1.677cd3ce598a2p-911, 0x1.2cce7b0334e93p-905 },
	   { 0x1.d922e485849dfp-912, 0x1.8c04eb792831bp-906 },
	   { 0x1.3751aaab95803p-912, 0x1.04a716678c7d9p-906 },
	   { 0x1.99a3c2eb312dfp-913, 0x1.571266fb205e7p-907 },
	   { 0x1.0d791e54efc95p-913, 0x1.c37f46c8a36cep-908 },
	   { 0x1.627dd610c1f2fp-914, 0x1.290ef7aa6784ep-908 },
	   { 0x1.d246bba093dddp-915, 0x1.86d89be61c44fp-909 },
	   { 0x1.329e3d8fc35e5p-915, 0x1.011744722e8f8p-909 },
	   { 0x1.93354aecb0f91p-916, 0x1.522d67c700dd9p-910 },
	   { 0x1.09149eae599f4p-916, 0x1.bcc8c2b79e5e6p-911 },
	   { 0x1.5c8020a89d6a7p-917, 0x1.247692feaf7c7p-911 },
	   { 0x1.ca1dd59404578p-918, 0x1.8090b25f1fb1cp-912 },
	   { 0x1.2d1194826d1d9p-918, 0x1.f99c33fa36826p-913 },
	   { 0x1.8bab4cd7bc185p-919, 0x1.4c563ff8738edp-913 },
	   { 0x1.03f72f0fa181cp-919, 0x1.b4d5ff233ee8bp-914 },
	   { 0x1.559144638d7d2p-920, 0x1.1f0fc4fe41aefp-914 },
	   { 0x1.c0baa10766979p-921, 0x1.793b75fbd2367p-915 },
	   { 0x1.26b830bbc4f33p-921, 0x1.efaa9eeaa4992p-916 },
	   { 0x1.8316ba6f8ef74p-922, 0x1.459a26ac43fcfp-916 },
	   { 0x1.fc588d5eeb3p-923, 0x1.abb8ece685efep-917 },
	   { 0x1.4dc0c0d42f863p-923, 0x1.18e6b704952c1p-917 },
	   { 0x1.b6320aea7077ap-924, 0x1.70e95e366ca95p-918 },
	   { 0x1.1fa02ebad6485p-924, 0x1.e4700e7fab75ep-919 },
	   { 0x1.798a96e59845bp-925, 0x1.3e0826243926dp-919 },
	   { 0x1.ef81624855ca5p-926, 0x1.a185d71d9ae78p-920 },
	   { 0x1.451fcaaed5e7p-926, 0x1.1209163a43d8ap-920 },
	   { 0x1.aa9b30dd7b333p-927, 0x1.67acd56555624p-921 },
	   { 0x1.17d9121b4ff43p-927, 0x1.d805487b20ec2p-922 },
	   { 0x1.6f1bb0c9eff18p-928, 0x1.35b0e3e76f72ap-922 },
	   { 0x1.e184bec96bcc5p-929, 0x1.965317fc3f8ebp-923 },
	   { 0x1.3bc10ccdff1d7p-929, 0x1.0a85e11600392p-923 },
	   { 0x1.9e0f0cdf83a76p-930, 0x1.5d99f4f4fa7a2p-924 },
	   { 0x1.0f738d3253e75p-930, 0x1.ca8538b911cc2p-925 },
	   { 0x1.63e056b37b486p-931, 0x1.2ca663e8f6c6ep-925 },
	   { 0x1.d2806afda0512p-932, 0x1.8a38c763ae5p-926 },
	   { 0x1.31b865207923bp-932, 0x1.026d30f31261ep-926 },
	   { 0x1.90a81bef15367p-933, 0x1.52c63cbe5201dp-927 },
	   { 0x1.068145905baddp-933, 0x1.bc0c903e2dd51p-928 },
	   { 0x1.57f0081c7461bp-934, 0x1.22fbc7eb40c8ep-928 },
	   { 0x1.c293abfeb81c1p-935, 0x1.7d5064d5d2e6ap-929 },
	   { 0x1.271a9ed146425p-935, 0x1.f3a001a1da12ap-930 },
	   { 0x1.8282015bfd093p-936, 0x1.474846e880b8p-930 },
	   { 0x1.fa292d1f4b615p-937, 0x1.acb96019278e3p-931 },
	   { 0x1.4b6323fa7fafcp-937, 0x1.18c50c637e437p-931 },
	   { 0x1.b1ded81f6cf48p-938, 0x1.6fb47e7243b1p-932 },
	   { 0x1.1bfd2aff12d23p-938, 0x1.e17fe4af1cdcdp-933 },
	   { 0x1.73b9288cf980bp-939, 0x1.3b3779cd081bcp-933 },
	   { 0x1.e680a6315c8f9p-940, 0x1.9caab20737c4bp-934 },
	   { 0x1.3e52969a46a03p-940, 0x1.0e16c42489121p-934 },
	   { 0x1.a082ea93d471fp-941, 0x1.618056ad2fa0dp-935 },
	   { 0x1.1075d9566cab2p-941, 0x1.ce9e247afa7efp-936 },
	   { 0x1.646a66f6fb197p-942, 0x1.2eabb9557e4c3p-936 },
	   { 0x1.d22f0f82317a8p-943, 0x1.8c0020c90fd02p-937 },
	   { 0x1.30d7883df3e07p-943, 0x1.0305d4157bdecp-937 },
	   { 0x1.8ea1187daf8b3p-944, 0x1.52cf8a69cbdeep-938 },
	   { 0x1.049a91d747c02p-944, 0x1.bb1f3a4ce848cp-939 },
	   { 0x1.54b29ff375e83p-945, 0x1.21bd19407d3a8p-939 },
	   { 0x1.bd5a7cbaf896dp-946, 0x1.7ad97206eb3e9p-940 },
	   { 0x1.230b0dec754dap-946, 0x1.ef4e6059f1fe4p-941 },
	   { 0x1.7c5a693980a4p-947, 0x1.43bdb9112e65bp-941 },
	   { 0x1.f10221f87a1cap-948, 0x1.a7278c0b2c815p-942 },
	   { 0x1.44ae6c097e3b8p-948, 0x1.148391a9b5b7p-942 },
	   { 0x1.a8288818abb4p-949, 0x1.69563388e87eep-943 },
},
};
