#!/bin/sh

# panic: proc_dtor: non-empty p_ktr
# cpuid = 1
# time = 1768834000
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0167884910
# vpanic() at vpanic+0x136/frame 0xfffffe0167884a40
# panic() at panic+0x43/frame 0xfffffe0167884aa0
# proc_dtor() at proc_dtor+0x2cb/frame 0xfffffe0167884ae0
# uma_zfree_arg() at uma_zfree_arg+0xaa/frame 0xfffffe0167884b30
# proc_reap() at proc_reap+0x5b0/frame 0xfffffe0167884b70
# proc_to_reap() at proc_to_reap+0x3be/frame 0xfffffe0167884bc0
# kern_wait6() at kern_wait6+0x1ab/frame 0xfffffe0167884c60
# sys_wait6() at sys_wait6+0x9f/frame 0xfffffe0167884e00
# amd64_syscall() at amd64_syscall+0x169/frame 0xfffffe0167884f30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe0167884f30
# --- syscall (532, FreeBSD ELF64, wait6), rip = 0x3228e1de521a, rsp = 0x3228e0f6e308, rbp = 0x3228e0f6e350 ---
# KDB: enter: panic
# [ thread pid 67906 tid 768579 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x11e6bc2(%rip)
# db> x/s version
# version: FreeBSD 16.0-CURRENT #0 main-n283239-11f954b021a1-dirty: Sun Jan 18 21:26:45 CET 2026
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db>

# Fixed by: 6bb3f208617b - main - ktrace: do not enqueue request if the process' ktrioparams are freed

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=2212d848f78d472dfeaec7a3cc9f5a31e2a44f42
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+25dabe4046a645a0566c@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static unsigned long long procid;

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  alarm(240); /* Added by pho */
  for (;;) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      sleep_ms(10);
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[3] = {0xffffffffffffffff, 0x0, 0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  //  open\$dir arguments: [
  //    file: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 30 00} (length 0x8)
  //    }
  //    flags: open_flags = 0x200 (8 bytes)
  //    mode: open_mode = 0x19c (8 bytes)
  //  ]
  //  returns fd_dir
  memcpy((void*)0x200000000040, "./file0\000", 8);
  syscall(SYS_open, /*file=*/0x200000000040ul, /*flags=O_CREAT*/ 0x200ul,
          /*mode=S_IROTH|S_IXGRP|S_IWGRP|S_IWUSR|S_IRUSR*/ 0x19cul);
  //  setreuid arguments: [
  //    ruid: uid (resource)
  //    euid: uid (resource)
  //  ]
  syscall(SYS_setreuid, /*ruid=*/0xee00, /*euid=*/0);
  //  chown arguments: [
  //    file: nil
  //    uid: uid (resource)
  //    gid: gid (resource)
  //  ]
  syscall(SYS_chown, /*file=*/0ul, /*uid=*/0, /*gid=*/0);
  //  kqueue arguments: [
  //  ]
  //  returns kqueue
  res = syscall(SYS_kqueue);
  if (res != -1)
    r[0] = res;
  //  kevent arguments: [
  //    kqueue: kqueue (resource)
  //    changelist: ptr[in, array[kevent]] {
  //      array[kevent] {
  //        kevent {
  //          ident: intptr = 0x0 (8 bytes)
  //          filter: filters = 0xfffffffffffffff9 (2 bytes)
  //          flags: evflags = 0x8009 (2 bytes)
  //          fflags: fflags = 0x8 (4 bytes)
  //          data: int64 = 0xe8c5 (8 bytes)
  //          udata: intptr = 0x0 (8 bytes)
  //          ext: array[int64] {
  //            int64 = 0x7ffffffffc (8 bytes)
  //            int64 = 0xfffffffffffffffc (8 bytes)
  //            int64 = 0x7 (8 bytes)
  //            int64 = 0x40000000000000 (8 bytes)
  //          }
  //        }
  //      }
  //    }
  //    nchanges: len = 0x1 (8 bytes)
  //    eventlist: nil
  //    nevents: len = 0x0 (8 bytes)
  //    timeout: nil
  //  ]
  *(uint64_t*)0x200000000040 = 0;
  *(uint16_t*)0x200000000048 = 0xfff9;
  *(uint16_t*)0x20000000004a = 0x8009;
  *(uint32_t*)0x20000000004c = 8;
  *(uint64_t*)0x200000000050 = 0xe8c5;
  *(uint64_t*)0x200000000058 = 0;
  *(uint64_t*)0x200000000060 = 0x7ffffffffc;
  *(uint64_t*)0x200000000068 = 0xfffffffffffffffc;
  *(uint64_t*)0x200000000070 = 7;
  *(uint64_t*)0x200000000078 = 0x40000000000000;
  syscall(SYS_kevent, /*kqueue=*/r[0], /*changelist=*/0x200000000040ul,
          /*nchanges=*/1ul, /*eventlist=*/0ul, /*nevents=*/0ul,
          /*timeout=*/0ul);
  //  extattr_delete_fd arguments: [
  //    fd: fd (resource)
  //    attrnamespace: attrnamespace_flags = 0x0 (8 bytes)
  //    attrname: ptr[in, buffer] {
  //      buffer: {27 17 2e 29 23 00} (length 0x6)
  //    }
  //  ]
  memcpy((void*)0x2000000001c0, "\'\027.)#\000", 6);
  syscall(SYS_extattr_delete_fd, /*fd=*/r[0], /*attrnamespace=*/0ul,
          /*attrname=*/0x2000000001c0ul);
  //  freebsd11_mknod arguments: [
  //    file: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 30 00} (length 0x8)
  //    }
  //    mod: mknod_mode = 0x1000 (8 bytes)
  //    dev: int32 = 0x0 (4 bytes)
  //  ]
  memcpy((void*)0x2000000000c0, "./file0\000", 8);
  syscall(SYS_freebsd11_mknod, /*file=*/0x2000000000c0ul,
          /*mod=S_IFIFO*/ 0x1000ul, /*dev=*/0);
  //  freebsd10_pipe arguments: [
  //    pipefd: nil
  //  ]
  syscall(SYS_freebsd10_pipe, /*pipefd=*/0ul);
  //  ksem_init arguments: [
  //    idp: ptr[out, semid] {
  //      semid (resource)
  //    }
  //    value: int32 = 0x0 (4 bytes)
  //  ]
  res = syscall(SYS_ksem_init, /*idp=*/0x200000000100ul, /*value=*/0);
  if (res != -1)
    r[1] = *(uint64_t*)0x200000000100;
  //  ksem_post arguments: [
  //    id: semid (resource)
  //  ]
  syscall(SYS_ksem_post, /*id=*/r[1]);
  //  openat\$bpf arguments: [
  //    fd: const = 0xffffffffffffff9c (8 bytes)
  //    file: ptr[in, buffer] {
  //      buffer: {2f 64 65 76 2f 62 70 66 00} (length 0x9)
  //    }
  //    flags: open_flags = 0x40 (8 bytes)
  //    mode: const = 0x0 (8 bytes)
  //  ]
  //  returns fd_bpf
  memcpy((void*)0x200000000040, "/dev/bpf\000", 9);
  syscall(SYS_openat, /*fd=*/0xffffffffffffff9cul, /*file=*/0x200000000040ul,
          /*flags=FASYNC*/ 0x40ul, /*mode=*/0ul);
  //  kqueue arguments: [
  //  ]
  //  returns kqueue
  res = syscall(SYS_kqueue);
  if (res != -1)
    r[2] = res;
  //  kevent arguments: [
  //    kqueue: kqueue (resource)
  //    changelist: nil
  //    nchanges: len = 0x0 (8 bytes)
  //    eventlist: nil
  //    nevents: len = 0x0 (8 bytes)
  //    timeout: nil
  //  ]
  syscall(SYS_kevent, /*kqueue=*/r[2], /*changelist=*/0ul, /*nchanges=*/0ul,
          /*eventlist=*/0ul, /*nevents=*/0ul, /*timeout=*/0ul);
  //  ktrace arguments: [
  //    path: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 30 00} (length 0x8)
  //    }
  //    ops: ktrace_ops = 0x4 (8 bytes)
  //    trpoints: ktrace_trpoints = 0x94659db2cce5c9d8 (8 bytes)
  //    pid: pid (resource)
  //  ]
  memcpy((void*)0x2000000000c0, "./file0\000", 8);
  syscall(
      SYS_ktrace, /*path=*/0x2000000000c0ul, /*ops=KTRFLAG_DESCEND*/ 4ul,
      /*trpoints=KTRFAC_INHERIT|KTRFAC_FAULTEND|KTRFAC_PROCDTOR|KTRFAC_STRUCT|KTRFAC_USER|KTRFAC_CSW|KTRFAC_GENIO|0x94659db28ce58008*/
      0x94659db2cce5c9d8ul, /*pid=*/0);
  //  rfork arguments: [
  //    flags: rfork_flags = 0x96014 (8 bytes)
  //  ]
  syscall(SYS_rfork,
          /*flags=RFLINUXTHPN|RFTSIGZMB|RFSIGSHARE|RFTHREAD|RFFDG|RFPROC*/
          0x96014ul);
  //  ktrace arguments: [
  //    path: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 30 00} (length 0x8)
  //    }
  //    ops: ktrace_ops = 0x2 (8 bytes)
  //    trpoints: ktrace_trpoints = 0x180 (8 bytes)
  //    pid: pid (resource)
  //  ]
  memcpy((void*)0x200000000000, "./file0\000", 8);
  syscall(SYS_ktrace, /*path=*/0x200000000000ul, /*ops=KTROP_CLEARFILE*/ 2ul,
          /*trpoints=KTRFAC_STRUCT|KTRFAC_USER*/ 0x180ul, /*pid=*/0);
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  for (procid = 0; procid < 4; procid++) {
    if (fork() == 0) {
      loop();
    }
  }
  sleep(1000000);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

(cd ../testcases/swap; ./swap -t 3m -i 30 -l 100 > /dev/null 2>&1) &
sleep 5

kldstat | grep -q sem && loaded=0 || { kldload sem.ko && loaded=1; }
work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
for i in `jot 30`; do
	(
		mkdir d$i
		cd d$i
		timeout 3m /tmp/$prog > /dev/null 2>&1 &
	)
done
while pgrep -q $prog; do sleep 2; done
while pkill swap; do :; done
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core $work
[ $loaded -eq 1 ] && kldunload sem.ko
exit 0
