/*-
 * Copyright (c) 1988, 1989, 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Adam de Boor.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)dir.h	8.2 (Berkeley) 4/28/95
 * $FreeBSD: stable/10/usr.bin/make/dir.h 201526 2010-01-04 18:57:22Z obrien $
 */

#ifndef dir_h_6002e3b8
#define	dir_h_6002e3b8

#include <sys/queue.h>
#include "hash.h"

struct GNode;
struct Lst;
struct Dir;

struct PathElement;
TAILQ_HEAD(Path, PathElement);

void Dir_Init(void);
void Dir_InitDot(void);
Boolean Dir_HasWildcards(const char *);
int Dir_FindHereOrAbove(char *, char *, char *, int);
int Dir_MTime(struct GNode *);
void Dir_PrintDirectories(void);

struct Dir *Path_AddDir(struct Path *, const char *);
void Path_Clear(struct Path *);
void Path_Concat(struct Path *, const struct Path *);
void Path_Duplicate(struct Path *, const struct Path *);
void Path_Expand(char *, struct Path *, struct Lst *);
char *Path_FindFile(char *, struct Path *);
char *Path_MakeFlags(const char *, const struct Path *);
void Path_Print(const struct Path *);

#endif /* dir_h_6002e3b8 */
