/*-
 * Copyright (c) 2010 Rui Paulo <rpaulo@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/stand/efi/loader/autoload.c 339161 2018-10-03 17:17:38Z kevans $");

#if defined(LOADER_FDT_SUPPORT)
#include <sys/param.h>
#include <fdt_platform.h>
#endif

#include "loader_efi.h"

int
efi_autoload(void)
{

#if defined(LOADER_FDT_SUPPORT)
	/*
	 * Setup the FDT early so that we're not loading files during bi_load.
	 * Any such loading is inherently broken since bi_load uses the space
	 * just after all currently loaded files for the data that will be
	 * passed to the kernel and newly loaded files will be positioned in
	 * that same space.
	 *
	 * We're glossing over errors here because LOADER_FDT_SUPPORT does not
	 * imply that we're on a platform where FDT is a requirement.  If we
	 * fix this, then the error handling here should be fixed accordingly.
	 */
	fdt_setup_fdtp();
#endif
	return (0);
}
