# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from django.core.urlresolvers import reverse
from django.core.urlresolvers import reverse_lazy
from django.utils.translation import ugettext_lazy as _

from horizon import exceptions
from horizon import forms

from openstack_dashboard import api
from openstack_dashboard.dashboards.admin.hypervisors.compute \
    import forms as project_forms


class EvacuateHostView(forms.ModalFormView):
    form_class = project_forms.EvacuateHostForm
    template_name = 'admin/hypervisors/compute/evacuate_host.html'
    context_object_name = 'compute_host'
    success_url = reverse_lazy("horizon:admin:hypervisors:index")

    def get_context_data(self, **kwargs):
        context = super(EvacuateHostView, self).get_context_data(**kwargs)
        context["compute_host"] = self.kwargs['compute_host']
        return context

    def get_active_compute_hosts_names(self, *args, **kwargs):
        try:
            services = api.nova.service_list(self.request,
                                             binary='nova-compute')
            return [service.host for service in services
                    if service.state == 'up']
        except Exception:
            redirect = reverse("horizon:admin:hypervisors:index")
            msg = _('Unable to retrieve compute host information.')
            exceptions.handle(self.request, msg, redirect=redirect)

    def get_initial(self):
        initial = super(EvacuateHostView, self).get_initial()
        hosts = self.get_active_compute_hosts_names()
        current_host = self.kwargs['compute_host']
        initial.update({'current_host': current_host,
                        'hosts': hosts})
        return initial
