# Copyright 2015 Brocade Communications System, Inc.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

from neutron.common import rpc as n_rpc

from neutron_vpnaas.services.vpn.common import topics
from neutron_vpnaas.services.vpn.service_drivers import base_ipsec

IPSEC = 'ipsec'
BASE_IPSEC_VERSION = '1.0'


class VyattaIPsecDriver(base_ipsec.BaseIPsecVPNDriver):

    def __init__(self, service_plugin):
        super(VyattaIPsecDriver, self).__init__(service_plugin)

    def create_rpc_conn(self):
        self.endpoints = [base_ipsec.IPsecVpnDriverCallBack(self)]
        self.conn = n_rpc.create_connection(new=True)
        self.conn.create_consumer(
            topics.BROCADE_IPSEC_DRIVER_TOPIC, self.endpoints, fanout=False)
        self.conn.consume_in_threads()
        self.agent_rpc = base_ipsec.IPsecVpnAgentApi(
            topics.BROCADE_IPSEC_AGENT_TOPIC, BASE_IPSEC_VERSION, self)
