printf-about = フォーマット文字列とそれに続く引数に基づいて出力を表示します。
printf-usage =
    printf FORMAT [ARGUMENT]...
    printf OPTION
printf-error-missing-operand = オペランドがありません
printf-warning-ignoring-excess-arguments = 過剰な引数を無視しています: '{ $arg }' から
printf-help-version = バージョン情報を表示します
printf-help-help = ヘルプ情報を表示します
printf-after-help =
    基本的な無名文字列のテンプレート:

     フォーマット文字列は少なくとも一度表示され、残りの引数がある限り繰り返されます
     出力は、フォーマット文字列内のエスケープされたリテラルを文字リテラルとして表示します
     出力は、無名フィールドを次の未使用の引数に置き換え、フィールドに従ってフォーマットします。

     エスケープされた文字シーケンスを文字リテラルに、
     および、後述する置換フィールドシーケンスを渡された引数に置き換えて表示します

     文字列を文字リテラルとしてそのまま表示します。ただし、以下の
     エスケープされた文字シーケンス、および後述の置換シーケンスは例外です。

     ### エスケープシーケンス

     以下にアルファベット順で示すエスケープシーケンスは、
    対応する文字リテラルを表示します:

     - \" 二重引用符

     - \\ バックスラッシュ

     - \\a アラート (BEL)

     - \\b バックスペース

     - \\c 入力終了 (End-of-Input)

     - \\e エスケープ

     - \\f フォームフィード

     - \\n 改行

     - \\r キャリッジリターン

     - \\t 水平タブ

     - \\v 垂直タブ

     - \\NNN 8進数値 NNN (1～3桁) で表される値を持つバイト
       256 より大きい値は処理されます

     - \\xHH 16進数値 HH (1～2桁) で表される値を持つバイト

     - \\uHHHH 16進数値 HHHH (4桁) で表される値を持つ Unicode (IEC 10646) 文字

     - \\uHHHH 16進数値 HHHH (8桁) で表される値を持つ Unicode 文字

     - %% 単一の %

     ### 置換 (SUBSTITUTIONS)

     #### 置換のクイックリファレンス (SUBSTITUTION QUICK REFERENCE)

     フィールド

     - %s: 文字列 (string)
     - %b: リテラルとしてパースされる文字列 (2番目のパラメータは最大長)

     - %c: 文字 (char) (2番目のパラメータなし)

     - %i または %d: 64ビット整数
     - %u: 64ビット符号なし整数
     - %x または %X: 16進数で表される 64ビット符号なし整数
     - %o: 8進数で表される 64ビット符号なし整数
       2番目のパラメータは最小幅（整数）です
       その幅未満の出力は、先行ゼロでパディングされます

     - %q: ARGUMENT は、非印刷文字を提案されている POSIX $'' 構文でエスケープし、
    シェル入力として再利用できる形式で表示されます。

     - %f または %F: 10進浮動小数点値
     - %e または %E: 指数表記浮動小数点値
     - %g または %G: 10進浮動小数点値と指数表記浮動小数点値のうち短い方
       2番目のパラメータは
        - 浮動小数点出力における小数点以下の最大桁数
        - 指数表記出力における有効桁数の最大数

     パラメータ化フィールド

     例:

     printf '%4.3i' 7

     最初のパラメータは 4、2番目のパラメータは 3 であり、「 007」という結果になります

     printf '%.1s' abcde

     最初のパラメータはなく、2番目のパラメータは 1 であり、「a」という結果になります

     printf '%4c' q

     最初のパラメータは 4 で、2番目のパラメータはなく、「 q」という結果になります

     フィールドの最初のパラメータは、パディングされる最小の幅を示します
     出力がこの絶対値の幅より小さい場合、
     先行スペースでパディングされます。または、引数が負の場合、
     末尾のスペースでパディングされます。デフォルトはゼロです。

     フィールドの2番目のパラメータは、出力フィールドのタイプに固有です。
     デフォルト値は、以下の完全な置換ヘルプで見つけることができます

     数値引数の特殊な接頭辞

     - 0: (例: 010) 引数を8進数として解釈します (整数出力フィールドのみ)
     - 0x: (例: 0xABC) 引数を16進数として解釈します (数値出力フィールドのみ)
     - \': (例: 'a) 引数を文字定数として解釈します

     #### 置換の使用方法 (HOW TO USE SUBSTITUTIONS)

     置換は、FORMAT 文字列に追加の引数を渡すために使用され、
    特定の形式でフォーマットされます。例:

     printf 'the letter %X comes before the letter %X' 10 11

     は、以下を表示します

     the letter A comes before the letter B

     なぜなら、置換フィールド %X は
     「整数引数を受け取り、16進数として書き出す」ことを意味するからです

     フォーマット文字列にある引数よりも多くの引数を渡すと、
    残りの置換のためにフォーマット文字列が繰り返されます

     printf 'it is %i F in %s \n' 22 Portland 25 Boston 27 New York

     は、以下を表示します

     it is 22 F in Portland
     it is 25 F in Boston
     it is 27 F in Boston

     フォーマット文字列が表示されても、
    残りの引数が置換フィールドの数よりも少ない場合、
    引数がない置換フィールドは、適切な場合、空の文字列、または数値フィールドの場合は
    値 0 にデフォルト設定されます

     #### 利用可能な置換 (AVAILABLE SUBSTITUTIONS)

     このプログラムは、GNU coreutils printf と同様に、
     POSIX C printf 仕様の修正されたサブセットを解釈します。
     置換のクイックリファレンスは以下です。

     #### 文字列の置換 (STRING SUBSTITUTIONS)

     すべての文字列フィールドには「最大幅」パラメータがあります
     %.3s は「元の入力の 3 文字以内を表示する」ことを意味します

     - %s: 文字列 (string)

     - %b: エスケープされた文字列 - この文字列は、上記のエスケープされたリテラルリストの
    すべてのエスケープされたリテラルがチェックされ、文字リテラルに変換されます。
       例: \n は改行文字に変換されます。
       %b モードに関する1つの特別なルールとして、8進数リテラルは異なる解釈をされます。
       %b で渡される引数では、8進数として解釈されるリテラルは \0NNN 形式である必要があります
       \NNN 形式である必要があります (ただし、レガシーな理由により、\NNN 形式の8進数リテラルは引き続き解釈され、
    警告はスローされませんが、コードがゼロで始まるリテラルにこれを使用すると、
    \0NNN 形式と見なされるため問題が発生します)。

     - %q: エスケープされた文字列 - ほとんどのシェルで入力として再利用できる形式の文字列。
       非印刷文字は POSIX 提案の ‘$''’ 構文でエスケープされ、
       シェルメタ文字は適切に引用符で囲まれます。
       これは、ls --quoting=shell-escape 出力と同等の形式です。

     #### 文字の置換 (CHAR SUBSTITUTIONS)

     文字フィールドには、2番目のパラメータはありません。

     - %c: 単一の文字 (a single character)

     #### 整数の置換 (INTEGER SUBSTITUTIONS)

     すべての整数フィールドには「ゼロ埋め」パラメータがあります
     %.4i は、長さが 4 桁未満の場合、
     先行ゼロでパディングされて長さが 4 桁になる整数を意味します。

     - %d または %i: 64ビット整数

     - %u: 64ビット符号なし整数

     - %x または %X: 16進数 (基数 16) で表示される 64ビット符号なし整数
       %X は %x の代わりに 'a' から 'f' に大文字を使用することを意味します

     - %o: 8進数 (基数 8) で表示される 64ビット符号なし整数

     #### 浮動小数点数の置換 (FLOATING POINT SUBSTITUTIONS)

     すべての浮動小数点フィールドには「小数点以下の最大桁数 / 有効桁数の最大数」パラメータがあります
     %.10f は、小数点以下 7 桁を持つ 10進浮動小数点数を意味します
     %.10e は、10 個の有効桁を持つ指数表記の数値を意味します
     %.10g は、10進浮動小数点数と指数表記のそれぞれで同じ動作を意味し、
    それぞれの出力の最短を提供します。

     GNU coreutils と同様に、これらの出力の小数点以下の値は、
    テキストとしてレンダリングされる前にまず double としてパースされます。
    両方の実装で、18番目の小数点以下の意味のある精度を期待しないでください。
    小数点以下の桁数に 18 以上の値を使用する場合、GNU coreutils printf とこの printf の間で
    出力に +/- 1 の変動が発生する可能性があります。

     - %f: 10進数で表示される浮動小数点値で、デフォルトでは小数点以下 6 桁に切り捨てられて表示されます。
    Coreutils printf との過去の double の動作パリティはありません。
    値は入力値を超えて推定または調整されません。

     - %e または %E: 指数表記で表示される浮動小数点値
       デフォルトで 7 個の有効桁数
       %E は仮数に大文字の E を使用することを意味します。

     - %g または %G: 10進数と指数表記のうち、最も短い形式で表示される浮動小数点値
       %f および %E とは動作が異なります。
       詳細については posix printf spec を参照してください。動作の違いの例：
       Sci Note はデフォルトで 6 個の有効桁数です
       末尾のゼロは削除されます
       切り捨てられる代わりに、最後の桁の後の桁が丸められます

     このユーティリティの浮動小数点動作に関する設計上の選択は、
    他の動作と同様に、入出力の観点から GNU coreutils の printf の動作を
    正確に再現するために選択されています。

     ### パラメータの使用 (USING PARAMETERS)

     ほとんどの置換フィールドは、% 記号とフィールド文字の間で、
    フィールドに渡すことができる最大 2 つの数値を使用してパラメータ化できます。

     1番目のパラメータは常に出力の最小幅を示し、カラム出力の作成に役立ちます。
    この最小幅の絶対値より小さい出力はすべて、
    先行スペースでパディングされます
     2番目のパラメータはドットが先行します。
     パラメータを使用する必要はありません

     ### 入力の特殊な形式 (SPECIAL FORMS OF INPUT)

     数値入力の場合、10進数に加えて次の追加の入力形式が受け入れられます:

     8進数 (整数のみ): 引数が 0 で始まる場合、
    続く文字は整数フィールドに対して 8進数 (基数 8) として解釈されます

     16進数: 引数が 0x で始まる場合、
    続く文字は任意の数値フィールドに対して 16進数 (基数 16) として解釈されます
     浮動小数点フィールドの場合、
    16進数入力の結果、精度制限 (小数点以下の入力を変換する場合) が 10^-15 になります

     文字定数: 引数が単一引用符文字で始まる場合、
    次の文字の最初のバイトは 8ビット符号なし整数として解釈されます。
    追加のバイトがある場合、それらはエラーをスローします 
    (環境変数 POSIXLY_CORRECT が設定されていない限り)
