package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// HostingEnvironmentsClient is the use these APIs to manage Azure Websites
// resources through the Azure Resource Manager. All task operations conform
// to the HTTP/1.1 protocol specification and each operation returns an
// x-ms-request-id header that can be used to obtain information about the
// request. You must make sure that requests made to these resources are
// secure. For more information, see <a
// href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
// Azure Resource Manager requests.</a>
type HostingEnvironmentsClient struct {
	ManagementClient
}

// NewHostingEnvironmentsClient creates an instance of the
// HostingEnvironmentsClient client.
func NewHostingEnvironmentsClient(subscriptionID string) HostingEnvironmentsClient {
	return NewHostingEnvironmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewHostingEnvironmentsClientWithBaseURI creates an instance of the
// HostingEnvironmentsClient client.
func NewHostingEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) HostingEnvironmentsClient {
	return HostingEnvironmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateHostingEnvironment sends the create or update hosting
// environment request. This method may poll for completion. Polling can be
// canceled by passing the cancel channel argument. The channel will be used
// to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) hostingEnvironmentEnvelope is
// properties of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironment(resourceGroupName string, name string, hostingEnvironmentEnvelope HostingEnvironment, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdateHostingEnvironmentPreparer(resourceGroupName, name, hostingEnvironmentEnvelope, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateHostingEnvironment", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateHostingEnvironmentSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateHostingEnvironment", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateHostingEnvironment", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostingEnvironmentPreparer prepares the CreateOrUpdateHostingEnvironment request.
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironmentPreparer(resourceGroupName string, name string, hostingEnvironmentEnvelope HostingEnvironment, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithJSON(hostingEnvironmentEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateHostingEnvironmentSender sends the CreateOrUpdateHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateHostingEnvironmentResponder handles the response to the CreateOrUpdateHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateOrUpdateMultiRolePool sends the create or update multi role pool
// request. This method may poll for completion. Polling can be canceled by
// passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) multiRolePoolEnvelope is
// properties of multiRole pool
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePool(resourceGroupName string, name string, multiRolePoolEnvelope WorkerPool, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdateMultiRolePoolPreparer(resourceGroupName, name, multiRolePoolEnvelope, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateMultiRolePool", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateMultiRolePoolSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateMultiRolePool", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateMultiRolePoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateMultiRolePool", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateMultiRolePoolPreparer prepares the CreateOrUpdateMultiRolePool request.
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePoolPreparer(resourceGroupName string, name string, multiRolePoolEnvelope WorkerPool, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithJSON(multiRolePoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateMultiRolePoolSender sends the CreateOrUpdateMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateMultiRolePoolResponder handles the response to the CreateOrUpdateMultiRolePool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePoolResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateOrUpdateWorkerPool sends the create or update worker pool request.
// This method may poll for completion. Polling can be canceled by passing
// the cancel channel argument. The channel will be used to cancel polling
// and any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool workerPoolEnvelope is properties of worker pool
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPool(resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPool, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdateWorkerPoolPreparer(resourceGroupName, name, workerPoolName, workerPoolEnvelope, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateWorkerPool", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateWorkerPoolSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateWorkerPool", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateWorkerPoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateWorkerPool", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateWorkerPoolPreparer prepares the CreateOrUpdateWorkerPool request.
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPoolPreparer(resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPool, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithJSON(workerPoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateWorkerPoolSender sends the CreateOrUpdateWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateWorkerPoolResponder handles the response to the CreateOrUpdateWorkerPool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPoolResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostingEnvironment sends the delete hosting environment request. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and
// any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) forceDelete is delete even if
// the hostingEnvironment (App Service Environment) contains resources
func (client HostingEnvironmentsClient) DeleteHostingEnvironment(resourceGroupName string, name string, forceDelete *bool, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.DeleteHostingEnvironmentPreparer(resourceGroupName, name, forceDelete, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "DeleteHostingEnvironment", nil, "Failure preparing request")
	}

	resp, err := client.DeleteHostingEnvironmentSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "DeleteHostingEnvironment", resp, "Failure sending request")
	}

	result, err = client.DeleteHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "DeleteHostingEnvironment", resp, "Failure responding to request")
	}

	return
}

// DeleteHostingEnvironmentPreparer prepares the DeleteHostingEnvironment request.
func (client HostingEnvironmentsClient) DeleteHostingEnvironmentPreparer(resourceGroupName string, name string, forceDelete *bool, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if forceDelete != nil {
		queryParameters["forceDelete"] = autorest.Encode("query", *forceDelete)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteHostingEnvironmentSender sends the DeleteHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) DeleteHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteHostingEnvironmentResponder handles the response to the DeleteHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) DeleteHostingEnvironmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetHostingEnvironment sends the get hosting environment request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironment(resourceGroupName string, name string) (result HostingEnvironment, err error) {
	req, err := client.GetHostingEnvironmentPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironment", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironment", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironment", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentPreparer prepares the GetHostingEnvironment request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentSender sends the GetHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentResponder handles the response to the GetHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentResponder(resp *http.Response) (result HostingEnvironment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentCapacities sends the get hosting environment
// capacities request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacities(resourceGroupName string, name string) (result StampCapacityCollection, err error) {
	req, err := client.GetHostingEnvironmentCapacitiesPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentCapacitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentCapacitiesPreparer prepares the GetHostingEnvironmentCapacities request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentCapacitiesSender sends the GetHostingEnvironmentCapacities request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentCapacitiesResponder handles the response to the GetHostingEnvironmentCapacities request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesResponder(resp *http.Response) (result StampCapacityCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentCapacitiesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesNextResults(lastResults StampCapacityCollection) (result StampCapacityCollection, err error) {
	req, err := lastResults.StampCapacityCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentCapacitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentDiagnostics sends the get hosting environment
// diagnostics request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnostics(resourceGroupName string, name string) (result ListHostingEnvironmentDiagnostics, err error) {
	req, err := client.GetHostingEnvironmentDiagnosticsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnostics", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentDiagnosticsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnostics", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentDiagnosticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnostics", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentDiagnosticsPreparer prepares the GetHostingEnvironmentDiagnostics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentDiagnosticsSender sends the GetHostingEnvironmentDiagnostics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentDiagnosticsResponder handles the response to the GetHostingEnvironmentDiagnostics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsResponder(resp *http.Response) (result ListHostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentDiagnosticsItem sends the get hosting environment
// diagnostics item request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) diagnosticsName is name of
// the diagnostics
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItem(resourceGroupName string, name string, diagnosticsName string) (result HostingEnvironmentDiagnostics, err error) {
	req, err := client.GetHostingEnvironmentDiagnosticsItemPreparer(resourceGroupName, name, diagnosticsName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnosticsItem", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentDiagnosticsItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnosticsItem", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentDiagnosticsItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnosticsItem", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentDiagnosticsItemPreparer prepares the GetHostingEnvironmentDiagnosticsItem request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItemPreparer(resourceGroupName string, name string, diagnosticsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticsName":   autorest.Encode("path", diagnosticsName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentDiagnosticsItemSender sends the GetHostingEnvironmentDiagnosticsItem request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItemSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentDiagnosticsItemResponder handles the response to the GetHostingEnvironmentDiagnosticsItem request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItemResponder(resp *http.Response) (result HostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMetricDefinitions sends the get hosting environment
// metric definitions request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitions(resourceGroupName string, name string) (result MetricDefinition, err error) {
	req, err := client.GetHostingEnvironmentMetricDefinitionsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetricDefinitions", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetricDefinitions", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentMetricDefinitionsPreparer prepares the GetHostingEnvironmentMetricDefinitions request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentMetricDefinitionsSender sends the GetHostingEnvironmentMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentMetricDefinitionsResponder handles the response to the GetHostingEnvironmentMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitionsResponder(resp *http.Response) (result MetricDefinition, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMetrics sends the get hosting environment metrics
// request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) details is include instance
// details filter is return only usages/metrics specified in the filter.
// Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
// or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetrics(resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	req, err := client.GetHostingEnvironmentMetricsPreparer(resourceGroupName, name, details, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentMetricsPreparer prepares the GetHostingEnvironmentMetrics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsPreparer(resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentMetricsSender sends the GetHostingEnvironmentMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentMetricsResponder handles the response to the GetHostingEnvironmentMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMetricsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentMultiRoleMetricDefinitions sends the get hosting
// environment multi role metric definitions request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitions(resourceGroupName string, name string) (result MetricDefinitionCollection, err error) {
	req, err := client.GetHostingEnvironmentMultiRoleMetricDefinitionsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsPreparer prepares the GetHostingEnvironmentMultiRoleMetricDefinitions request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsSender sends the GetHostingEnvironmentMultiRoleMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsResponder handles the response to the GetHostingEnvironmentMultiRoleMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsNextResults(lastResults MetricDefinitionCollection) (result MetricDefinitionCollection, err error) {
	req, err := lastResults.MetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentMultiRoleMetrics sends the get hosting environment
// multi role metrics request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) startTime is beginning time
// of metrics query endTime is end time of metrics query timeGrain is time
// granularity of metrics query details is include instance details filter is
// return only usages/metrics specified in the filter. Filter conforms to
// odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq
// 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
// '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetrics(resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	req, err := client.GetHostingEnvironmentMultiRoleMetricsPreparer(resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentMultiRoleMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentMultiRoleMetricsPreparer prepares the GetHostingEnvironmentMultiRoleMetrics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsPreparer(resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(startTime) > 0 {
		queryParameters["startTime"] = autorest.Encode("query", startTime)
	}
	if len(endTime) > 0 {
		queryParameters["endTime"] = autorest.Encode("query", endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentMultiRoleMetricsSender sends the GetHostingEnvironmentMultiRoleMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentMultiRoleMetricsResponder handles the response to the GetHostingEnvironmentMultiRoleMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMultiRoleMetricsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentMultiRoleMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentMultiRoleUsages sends the get hosting environment
// multi role usages request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsages(resourceGroupName string, name string) (result UsageCollection, err error) {
	req, err := client.GetHostingEnvironmentMultiRoleUsagesPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentMultiRoleUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentMultiRoleUsagesPreparer prepares the GetHostingEnvironmentMultiRoleUsages request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentMultiRoleUsagesSender sends the GetHostingEnvironmentMultiRoleUsages request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentMultiRoleUsagesResponder handles the response to the GetHostingEnvironmentMultiRoleUsages request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMultiRoleUsagesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesNextResults(lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.UsageCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentMultiRoleUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentOperation sends the get hosting environment operation
// request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) operationID is operation
// identifier GUID
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperation(resourceGroupName string, name string, operationID string) (result SetObject, err error) {
	req, err := client.GetHostingEnvironmentOperationPreparer(resourceGroupName, name, operationID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperation", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentOperationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperation", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentOperationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperation", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentOperationPreparer prepares the GetHostingEnvironmentOperation request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationPreparer(resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentOperationSender sends the GetHostingEnvironmentOperation request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentOperationResponder handles the response to the GetHostingEnvironmentOperation request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound, http.StatusInternalServerError),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentOperations sends the get hosting environment
// operations request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperations(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.GetHostingEnvironmentOperationsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperations", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentOperationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperations", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentOperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperations", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentOperationsPreparer prepares the GetHostingEnvironmentOperations request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentOperationsSender sends the GetHostingEnvironmentOperations request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentOperationsResponder handles the response to the GetHostingEnvironmentOperations request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironments sends the get hosting environments request.
//
// resourceGroupName is name of resource group
func (client HostingEnvironmentsClient) GetHostingEnvironments(resourceGroupName string) (result HostingEnvironmentCollection, err error) {
	req, err := client.GetHostingEnvironmentsPreparer(resourceGroupName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentsPreparer prepares the GetHostingEnvironments request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentsSender sends the GetHostingEnvironments request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentsResponder handles the response to the GetHostingEnvironments request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsResponder(resp *http.Response) (result HostingEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsNextResults(lastResults HostingEnvironmentCollection) (result HostingEnvironmentCollection, err error) {
	req, err := lastResults.HostingEnvironmentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentServerFarms sends the get hosting environment server
// farms request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarms(resourceGroupName string, name string) (result ServerFarmCollection, err error) {
	req, err := client.GetHostingEnvironmentServerFarmsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentServerFarmsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentServerFarmsPreparer prepares the GetHostingEnvironmentServerFarms request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentServerFarmsSender sends the GetHostingEnvironmentServerFarms request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentServerFarmsResponder handles the response to the GetHostingEnvironmentServerFarms request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsResponder(resp *http.Response) (result ServerFarmCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentServerFarmsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsNextResults(lastResults ServerFarmCollection) (result ServerFarmCollection, err error) {
	req, err := lastResults.ServerFarmCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentServerFarmsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentSites sends the get hosting environment sites request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) propertiesToInclude is comma
// separated list of site properties to include
func (client HostingEnvironmentsClient) GetHostingEnvironmentSites(resourceGroupName string, name string, propertiesToInclude string) (result SiteCollection, err error) {
	req, err := client.GetHostingEnvironmentSitesPreparer(resourceGroupName, name, propertiesToInclude)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentSitesPreparer prepares the GetHostingEnvironmentSites request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesPreparer(resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentSitesSender sends the GetHostingEnvironmentSites request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentSitesResponder handles the response to the GetHostingEnvironmentSites request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentSitesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesNextResults(lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.SiteCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentUsages sends the get hosting environment usages
// request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) filter is return only
// usages/metrics specified in the filter. Filter conforms to odata syntax.
// Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and
// startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z'
// and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsages(resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollection, err error) {
	req, err := client.GetHostingEnvironmentUsagesPreparer(resourceGroupName, name, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentUsagesPreparer prepares the GetHostingEnvironmentUsages request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesPreparer(resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentUsagesSender sends the GetHostingEnvironmentUsages request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentUsagesResponder handles the response to the GetHostingEnvironmentUsages request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentUsagesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesNextResults(lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.CsmUsageQuotaCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentVips sends the get hosting environment vips request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentVips(resourceGroupName string, name string) (result AddressResponse, err error) {
	req, err := client.GetHostingEnvironmentVipsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentVips", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentVipsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentVips", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentVipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentVips", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentVipsPreparer prepares the GetHostingEnvironmentVips request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentVipsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentVipsSender sends the GetHostingEnvironmentVips request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentVipsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentVipsResponder handles the response to the GetHostingEnvironmentVips request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentVipsResponder(resp *http.Response) (result AddressResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentWebHostingPlans sends the get hosting environment web
// hosting plans request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlans(resourceGroupName string, name string) (result ServerFarmCollection, err error) {
	req, err := client.GetHostingEnvironmentWebHostingPlansPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentWebHostingPlansSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentWebHostingPlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentWebHostingPlansPreparer prepares the GetHostingEnvironmentWebHostingPlans request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/webhostingplans", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentWebHostingPlansSender sends the GetHostingEnvironmentWebHostingPlans request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentWebHostingPlansResponder handles the response to the GetHostingEnvironmentWebHostingPlans request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansResponder(resp *http.Response) (result ServerFarmCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentWebHostingPlansNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansNextResults(lastResults ServerFarmCollection) (result ServerFarmCollection, err error) {
	req, err := lastResults.ServerFarmCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentWebHostingPlansSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentWebHostingPlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentWebWorkerMetricDefinitions sends the get hosting
// environment web worker metric definitions request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitions(resourceGroupName string, name string, workerPoolName string) (result MetricDefinitionCollection, err error) {
	req, err := client.GetHostingEnvironmentWebWorkerMetricDefinitionsPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsPreparer prepares the GetHostingEnvironmentWebWorkerMetricDefinitions request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsSender sends the GetHostingEnvironmentWebWorkerMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsResponder handles the response to the GetHostingEnvironmentWebWorkerMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsNextResults(lastResults MetricDefinitionCollection) (result MetricDefinitionCollection, err error) {
	req, err := lastResults.MetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentWebWorkerMetrics sends the get hosting environment web
// worker metrics request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool details is include instance details filter is return only
// usages/metrics specified in the filter. Filter conforms to odata syntax.
// Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and
// startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z'
// and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetrics(resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	req, err := client.GetHostingEnvironmentWebWorkerMetricsPreparer(resourceGroupName, name, workerPoolName, details, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentWebWorkerMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentWebWorkerMetricsPreparer prepares the GetHostingEnvironmentWebWorkerMetrics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsPreparer(resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentWebWorkerMetricsSender sends the GetHostingEnvironmentWebWorkerMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentWebWorkerMetricsResponder handles the response to the GetHostingEnvironmentWebWorkerMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentWebWorkerMetricsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentWebWorkerMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", resp, "Failure responding to next results request request")
	}

	return
}

// GetHostingEnvironmentWebWorkerUsages sends the get hosting environment web
// worker usages request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsages(resourceGroupName string, name string, workerPoolName string) (result UsageCollection, err error) {
	req, err := client.GetHostingEnvironmentWebWorkerUsagesPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", nil, "Failure preparing request")
	}

	resp, err := client.GetHostingEnvironmentWebWorkerUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", resp, "Failure sending request")
	}

	result, err = client.GetHostingEnvironmentWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentWebWorkerUsagesPreparer prepares the GetHostingEnvironmentWebWorkerUsages request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostingEnvironmentWebWorkerUsagesSender sends the GetHostingEnvironmentWebWorkerUsages request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostingEnvironmentWebWorkerUsagesResponder handles the response to the GetHostingEnvironmentWebWorkerUsages request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentWebWorkerUsagesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesNextResults(lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.UsageCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetHostingEnvironmentWebWorkerUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", resp, "Failure sending next results request request")
	}

	result, err = client.GetHostingEnvironmentWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", resp, "Failure responding to next results request request")
	}

	return
}

// GetMultiRolePool sends the get multi role pool request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetMultiRolePool(resourceGroupName string, name string) (result WorkerPool, err error) {
	req, err := client.GetMultiRolePoolPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePool", nil, "Failure preparing request")
	}

	resp, err := client.GetMultiRolePoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePool", resp, "Failure sending request")
	}

	result, err = client.GetMultiRolePoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePool", resp, "Failure responding to request")
	}

	return
}

// GetMultiRolePoolPreparer prepares the GetMultiRolePool request.
func (client HostingEnvironmentsClient) GetMultiRolePoolPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMultiRolePoolSender sends the GetMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMultiRolePoolResponder handles the response to the GetMultiRolePool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolResponder(resp *http.Response) (result WorkerPool, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePoolInstanceMetricDefinitions sends the get multi role pool
// instance metric definitions request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) instance is name of instance
// in the multiRole pool&gt;
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitions(resourceGroupName string, name string, instance string) (result SetObject, err error) {
	req, err := client.GetMultiRolePoolInstanceMetricDefinitionsPreparer(resourceGroupName, name, instance)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetricDefinitions", nil, "Failure preparing request")
	}

	resp, err := client.GetMultiRolePoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetricDefinitions", resp, "Failure sending request")
	}

	result, err = client.GetMultiRolePoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// GetMultiRolePoolInstanceMetricDefinitionsPreparer prepares the GetMultiRolePoolInstanceMetricDefinitions request.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitionsPreparer(resourceGroupName string, name string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMultiRolePoolInstanceMetricDefinitionsSender sends the GetMultiRolePoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMultiRolePoolInstanceMetricDefinitionsResponder handles the response to the GetMultiRolePoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitionsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePoolInstanceMetrics sends the get multi role pool instance
// metrics request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) instance is name of instance
// in the multiRole pool details is include instance details
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetrics(resourceGroupName string, name string, instance string, details *bool) (result SetObject, err error) {
	req, err := client.GetMultiRolePoolInstanceMetricsPreparer(resourceGroupName, name, instance, details)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetMultiRolePoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetrics", resp, "Failure sending request")
	}

	result, err = client.GetMultiRolePoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetrics", resp, "Failure responding to request")
	}

	return
}

// GetMultiRolePoolInstanceMetricsPreparer prepares the GetMultiRolePoolInstanceMetrics request.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricsPreparer(resourceGroupName string, name string, instance string, details *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMultiRolePoolInstanceMetricsSender sends the GetMultiRolePoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMultiRolePoolInstanceMetricsResponder handles the response to the GetMultiRolePoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePools sends the get multi role pools request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetMultiRolePools(resourceGroupName string, name string) (result WorkerPoolCollection, err error) {
	req, err := client.GetMultiRolePoolsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", nil, "Failure preparing request")
	}

	resp, err := client.GetMultiRolePoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", resp, "Failure sending request")
	}

	result, err = client.GetMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", resp, "Failure responding to request")
	}

	return
}

// GetMultiRolePoolsPreparer prepares the GetMultiRolePools request.
func (client HostingEnvironmentsClient) GetMultiRolePoolsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMultiRolePoolsSender sends the GetMultiRolePools request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMultiRolePoolsResponder handles the response to the GetMultiRolePools request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePoolsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetMultiRolePoolsNextResults(lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.WorkerPoolCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetMultiRolePoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", resp, "Failure sending next results request request")
	}

	result, err = client.GetMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", resp, "Failure responding to next results request request")
	}

	return
}

// GetMultiRolePoolSkus sends the get multi role pool skus request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetMultiRolePoolSkus(resourceGroupName string, name string) (result SkuInfoCollection, err error) {
	req, err := client.GetMultiRolePoolSkusPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", nil, "Failure preparing request")
	}

	resp, err := client.GetMultiRolePoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", resp, "Failure sending request")
	}

	result, err = client.GetMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", resp, "Failure responding to request")
	}

	return
}

// GetMultiRolePoolSkusPreparer prepares the GetMultiRolePoolSkus request.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMultiRolePoolSkusSender sends the GetMultiRolePoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMultiRolePoolSkusResponder handles the response to the GetMultiRolePoolSkus request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePoolSkusNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusNextResults(lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.SkuInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetMultiRolePoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", resp, "Failure sending next results request request")
	}

	result, err = client.GetMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", resp, "Failure responding to next results request request")
	}

	return
}

// GetWorkerPool sends the get worker pool request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool
func (client HostingEnvironmentsClient) GetWorkerPool(resourceGroupName string, name string, workerPoolName string) (result WorkerPool, err error) {
	req, err := client.GetWorkerPoolPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPool", nil, "Failure preparing request")
	}

	resp, err := client.GetWorkerPoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPool", resp, "Failure sending request")
	}

	result, err = client.GetWorkerPoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPool", resp, "Failure responding to request")
	}

	return
}

// GetWorkerPoolPreparer prepares the GetWorkerPool request.
func (client HostingEnvironmentsClient) GetWorkerPoolPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWorkerPoolSender sends the GetWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetWorkerPoolResponder handles the response to the GetWorkerPool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolResponder(resp *http.Response) (result WorkerPool, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPoolInstanceMetricDefinitions sends the get worker pool instance
// metric definitions request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool instance is name of instance in the worker pool
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitions(resourceGroupName string, name string, workerPoolName string, instance string) (result SetObject, err error) {
	req, err := client.GetWorkerPoolInstanceMetricDefinitionsPreparer(resourceGroupName, name, workerPoolName, instance)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetricDefinitions", nil, "Failure preparing request")
	}

	resp, err := client.GetWorkerPoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetricDefinitions", resp, "Failure sending request")
	}

	result, err = client.GetWorkerPoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// GetWorkerPoolInstanceMetricDefinitionsPreparer prepares the GetWorkerPoolInstanceMetricDefinitions request.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitionsPreparer(resourceGroupName string, name string, workerPoolName string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWorkerPoolInstanceMetricDefinitionsSender sends the GetWorkerPoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetWorkerPoolInstanceMetricDefinitionsResponder handles the response to the GetWorkerPoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitionsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPoolInstanceMetrics sends the get worker pool instance metrics
// request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool instance is name of instance in the worker pool details is
// include instance details filter is return only usages/metrics specified in
// the filter. Filter conforms to odata syntax. Example: $filter=(name.value
// eq 'Metric1' or name.value eq 'Metric2') and startTime eq
// '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain
// eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetrics(resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (result SetObject, err error) {
	req, err := client.GetWorkerPoolInstanceMetricsPreparer(resourceGroupName, name, workerPoolName, instance, details, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetWorkerPoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetrics", resp, "Failure sending request")
	}

	result, err = client.GetWorkerPoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetrics", resp, "Failure responding to request")
	}

	return
}

// GetWorkerPoolInstanceMetricsPreparer prepares the GetWorkerPoolInstanceMetrics request.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricsPreparer(resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWorkerPoolInstanceMetricsSender sends the GetWorkerPoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetWorkerPoolInstanceMetricsResponder handles the response to the GetWorkerPoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPools sends the get worker pools request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetWorkerPools(resourceGroupName string, name string) (result WorkerPoolCollection, err error) {
	req, err := client.GetWorkerPoolsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", nil, "Failure preparing request")
	}

	resp, err := client.GetWorkerPoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", resp, "Failure sending request")
	}

	result, err = client.GetWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", resp, "Failure responding to request")
	}

	return
}

// GetWorkerPoolsPreparer prepares the GetWorkerPools request.
func (client HostingEnvironmentsClient) GetWorkerPoolsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWorkerPoolsSender sends the GetWorkerPools request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetWorkerPoolsResponder handles the response to the GetWorkerPools request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPoolsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetWorkerPoolsNextResults(lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.WorkerPoolCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetWorkerPoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", resp, "Failure sending next results request request")
	}

	result, err = client.GetWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", resp, "Failure responding to next results request request")
	}

	return
}

// GetWorkerPoolSkus sends the get worker pool skus request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment) workerPoolName is name of
// worker pool
func (client HostingEnvironmentsClient) GetWorkerPoolSkus(resourceGroupName string, name string, workerPoolName string) (result SkuInfoCollection, err error) {
	req, err := client.GetWorkerPoolSkusPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", nil, "Failure preparing request")
	}

	resp, err := client.GetWorkerPoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", resp, "Failure sending request")
	}

	result, err = client.GetWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", resp, "Failure responding to request")
	}

	return
}

// GetWorkerPoolSkusPreparer prepares the GetWorkerPoolSkus request.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWorkerPoolSkusSender sends the GetWorkerPoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetWorkerPoolSkusResponder handles the response to the GetWorkerPoolSkus request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPoolSkusNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusNextResults(lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.SkuInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetWorkerPoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", resp, "Failure sending next results request request")
	}

	result, err = client.GetWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", resp, "Failure responding to next results request request")
	}

	return
}

// RebootHostingEnvironment sends the reboot hosting environment request.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) RebootHostingEnvironment(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.RebootHostingEnvironmentPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "RebootHostingEnvironment", nil, "Failure preparing request")
	}

	resp, err := client.RebootHostingEnvironmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "RebootHostingEnvironment", resp, "Failure sending request")
	}

	result, err = client.RebootHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "RebootHostingEnvironment", resp, "Failure responding to request")
	}

	return
}

// RebootHostingEnvironmentPreparer prepares the RebootHostingEnvironment request.
func (client HostingEnvironmentsClient) RebootHostingEnvironmentPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RebootHostingEnvironmentSender sends the RebootHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) RebootHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RebootHostingEnvironmentResponder handles the response to the RebootHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) RebootHostingEnvironmentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResumeHostingEnvironment sends the resume hosting environment request. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and
// any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) ResumeHostingEnvironment(resourceGroupName string, name string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.ResumeHostingEnvironmentPreparer(resourceGroupName, name, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", nil, "Failure preparing request")
	}

	resp, err := client.ResumeHostingEnvironmentSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", resp, "Failure sending request")
	}

	result, err = client.ResumeHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", resp, "Failure responding to request")
	}

	return
}

// ResumeHostingEnvironmentPreparer prepares the ResumeHostingEnvironment request.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentPreparer(resourceGroupName string, name string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ResumeHostingEnvironmentSender sends the ResumeHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ResumeHostingEnvironmentResponder handles the response to the ResumeHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ResumeHostingEnvironmentNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentNextResults(lastResults SiteCollection) (result autorest.Response, err error) {
	req, err := lastResults.SiteCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ResumeHostingEnvironmentSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", resp, "Failure sending next results request request")
	}

	result, err = client.ResumeHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", resp, "Failure responding to next results request request")
	}

	return
}

// SuspendHostingEnvironment sends the suspend hosting environment request.
// This method may poll for completion. Polling can be canceled by passing
// the cancel channel argument. The channel will be used to cancel polling
// and any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of
// hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) SuspendHostingEnvironment(resourceGroupName string, name string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.SuspendHostingEnvironmentPreparer(resourceGroupName, name, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", nil, "Failure preparing request")
	}

	resp, err := client.SuspendHostingEnvironmentSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", resp, "Failure sending request")
	}

	result, err = client.SuspendHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", resp, "Failure responding to request")
	}

	return
}

// SuspendHostingEnvironmentPreparer prepares the SuspendHostingEnvironment request.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentPreparer(resourceGroupName string, name string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SuspendHostingEnvironmentSender sends the SuspendHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SuspendHostingEnvironmentResponder handles the response to the SuspendHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SuspendHostingEnvironmentNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentNextResults(lastResults SiteCollection) (result autorest.Response, err error) {
	req, err := lastResults.SiteCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.SuspendHostingEnvironmentSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", resp, "Failure sending next results request request")
	}

	result, err = client.SuspendHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", resp, "Failure responding to next results request request")
	}

	return
}
