/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.instruct.DefiningVariable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.Param;
import net.sf.saxon.instruct.Variable;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class GlobalVariableDefinition
implements VariableDeclaration {
    private List references = new ArrayList();
    private SequenceType requiredType;
    private Expression value;
    private int fingerprint;
    private boolean isParameter;
    private String variableName;
    private int lineNumber;

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setFingerprint(int n) {
        this.fingerprint = n;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public void setValueExpression(Expression expression) {
        this.value = expression;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public int getVariableFingerprint() {
        return this.fingerprint;
    }

    public GeneralVariable compile(StaticQueryContext staticQueryContext, int n) throws XPathException {
        Object object;
        Object object2;
        DefiningVariable definingVariable;
        if (this.isParameter) {
            definingVariable = new Param();
            definingVariable.setRequiredParam(true);
        } else {
            definingVariable = new Variable();
            object2 = new RoleLocator(3, this.variableName, 0);
            object = TypeChecker.staticTypeCheck(this.value.simplify(), this.requiredType, false, (RoleLocator)object2);
            definingVariable.setSelect((Expression)object);
            int n2 = XQueryFunction.allocateSlots((Expression)object, 0);
            if (n2 > 0) {
                staticQueryContext.allocateLocalSlots(n2);
                definingVariable.setContainsLocals(true);
            }
        }
        definingVariable.setVariableFingerprint(this.fingerprint);
        definingVariable.setRequiredType(this.requiredType);
        definingVariable.setGlobal(true);
        definingVariable.setVariableName(this.variableName);
        definingVariable.setSlotNumber(n);
        definingVariable.setSourceLocation(0, this.lineNumber);
        object2 = this.references.iterator();
        while (object2.hasNext()) {
            object = (BindingReference)object2.next();
            object.setStaticType(this.requiredType, null, 0);
            object.fixup(definingVariable);
        }
        return definingVariable;
    }
}

