/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef QT_GCONFITEM_QML_WRAPPER_H
#define QT_GCONFITEM_QML_WRAPPER_H

#include <QtCore/QObject>
#include <QtCore/QVariant>

class GConfItem;

class GConfItemQmlWrapper : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString key READ getKey WRITE setKey);
    Q_PROPERTY(QVariant value READ getValue WRITE setValue NOTIFY valueChanged);
    Q_PROPERTY(QVariant entries READ getEntries NOTIFY subtreeChanged);
    Q_PROPERTY(QVariant dirs READ getDirs NOTIFY subtreeChanged);

public:
    GConfItemQmlWrapper(QObject *parent = 0);
    ~GConfItemQmlWrapper();

    // getters
    const QString getKey() const;
    const QVariant getValue() const;
    const QVariant getEntries() const;
    const QVariant getDirs() const;

    // setters
    void setKey(const QString &key);
    void setValue(const QVariant &value);

Q_SIGNALS:
    void valueChanged() const;
    void subtreeChanged() const;

private:
    GConfItem *m_item;
};

#endif // QT_GCONFITEM_QML_WRAPPER_H

