/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.cache.CacheOps;

public class CacheSimple<K, V>
implements Cache<K, V> {
    private final V[] values;
    private final K[] keys;
    private final int size;
    private int currentSize = 0;
    private BiConsumer<K, V> dropHandler = null;

    public CacheSimple(int size) {
        Object[] x = new Object[size];
        this.values = x;
        Object[] z = new Object[size];
        this.keys = z;
        this.size = size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        Arrays.fill(this.keys, null);
        this.currentSize = 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.getIfPresent(key) != null;
    }

    private final int index(K key) {
        int x = (key.hashCode() & Integer.MAX_VALUE) % this.size;
        if (this.keys[x] != null) {
            return x;
        }
        return -x - 1;
    }

    private final int decode(int x) {
        if (x >= 0) {
            return x;
        }
        return -x - 1;
    }

    @Override
    public V getIfPresent(K key) {
        int x = this.index(key);
        if (x < 0) {
            return null;
        }
        return this.values[x];
    }

    @Override
    public V getOrFill(K key, Callable<V> callable) {
        return CacheOps.getOrFillSync(this, key, callable);
    }

    @Override
    public void put(K key, V thing) {
        int x = this.index(key);
        V old = this.values[x = this.decode(x)];
        if (old != null) {
            if (old.equals(thing)) {
                return;
            }
            if (this.dropHandler != null) {
                this.dropHandler.accept(this.keys[x], old);
            }
            --this.currentSize;
        }
        this.values[x] = thing;
        if (thing == null) {
            this.keys[x] = null;
        } else {
            ++this.currentSize;
            this.keys[x] = key;
        }
    }

    @Override
    public void remove(K key) {
        this.put(key, (V)null);
    }

    @Override
    public long size() {
        return this.currentSize;
    }

    @Override
    public Iterator<K> keys() {
        Iterator<K> iter = Arrays.asList(this.keys).iterator();
        return Iter.removeNulls(iter);
    }

    @Override
    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    @Override
    public void setDropHandler(BiConsumer<K, V> dropHandler) {
        this.dropHandler = dropHandler;
    }
}

