/* Generated by re2c */
#line 1 "parse_date.db.re"
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.re,v 1.36 2006/04/09 15:03:01 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { add_warning(s, "Double timezone specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 865 "parse_date.db.re"



#line 763 "parse_date.db.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 104,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		104,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,  64,  32,  96,   0, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 192, 128, 128, 128, 
		192, 128, 128, 128, 128, 128, 192, 128, 
		128, 128, 192, 192, 192, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 29) YYFILL(29);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy2;
	case '\t':
	case ' ':	goto yy6;
	case '(':	goto yy8;
	case '+':
	case '-':	goto yy9;
	case ',':
	case '.':	goto yy10;
	case '0':	goto yy11;
	case '1':	goto yy12;
	case '2':	goto yy13;
	case '3':	goto yy14;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy15;
	case '@':	goto yy16;
	case 'A':	goto yy17;
	case 'B':
	case 'C':
	case 'G':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy19;
	case 'D':	goto yy20;
	case 'E':	goto yy21;
	case 'F':	goto yy22;
	case 'I':	goto yy23;
	case 'J':	goto yy24;
	case 'L':	goto yy25;
	case 'M':	goto yy26;
	case 'N':	goto yy27;
	case 'O':	goto yy28;
	case 'P':	goto yy29;
	case 'S':	goto yy30;
	case 'T':	goto yy31;
	case 'V':	goto yy32;
	case 'W':	goto yy33;
	case 'X':	goto yy34;
	case 'Y':	goto yy35;
	case 'a':	goto yy36;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy37;
	case 'd':	goto yy38;
	case 'e':	goto yy39;
	case 'f':	goto yy40;
	case 'j':	goto yy41;
	case 'l':	goto yy42;
	case 'm':	goto yy43;
	case 'n':	goto yy44;
	case 'o':	goto yy45;
	case 'p':	goto yy46;
	case 's':	goto yy47;
	case 't':	goto yy48;
	case 'w':	goto yy49;
	case 'y':	goto yy50;
	default:	goto yy4;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(3, *YYCURSOR);
#line 1434 "parse_date.db.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 888 "parse_date.db.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	++YYCURSOR;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1440 "parse_date.db.re"
	{
		add_error(s, "Unexpected character");
		goto std;
	}
#line 899 "parse_date.db.c"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy54;
yy7:
	YYDEBUG(7, *YYCURSOR);
#line 1429 "parse_date.db.re"
	{
		goto std;
	}
#line 915 "parse_date.db.c"
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy5;
	if (yych <= 'Z') goto yy37;
	if (yych <= '`') goto yy5;
	if (yych <= 'z') goto yy37;
	goto yy5;
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= '/') goto yy5;
	if (yych <= '1') goto yy56;
	if (yych <= '2') goto yy57;
	if (yych <= '9') goto yy58;
	goto yy5;
yy10:
	YYDEBUG(10, *YYCURSOR);
	++YYCURSOR;
	goto yy7;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy59;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy61;
	case '-':	goto yy62;
	case '.':	goto yy63;
	case '/':	goto yy64;
	case '0':	goto yy65;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy66;
	case ':':	goto yy67;
	case 'n':	goto yy84;
	case 'r':	goto yy85;
	case 's':	goto yy86;
	case 't':	goto yy87;
	default:	goto yy5;
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy88;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy62;
	case '.':	goto yy91;
	case '/':	goto yy64;
	case '0':
	case '1':
	case '2':	goto yy66;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy92;
	case ':':	goto yy93;
	case 'n':	goto yy84;
	case 'r':	goto yy85;
	case 's':	goto yy86;
	case 't':	goto yy87;
	default:	goto yy5;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy88;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy62;
	case '.':	goto yy91;
	case '/':	goto yy64;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy92;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy96;
	case ':':	goto yy93;
	case 'n':	goto yy84;
	case 'r':	goto yy85;
	case 's':	goto yy86;
	case 't':	goto yy87;
	default:	goto yy5;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy88;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy62;
	case '.':	goto yy91;
	case '/':	goto yy64;
	case '0':
	case '1':	goto yy96;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy97;
	case ':':	goto yy93;
	case 'n':	goto yy84;
	case 'r':	goto yy85;
	case 's':	goto yy86;
	case 't':	goto yy87;
	default:	goto yy5;
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy88;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy62;
	case '.':	goto yy91;
	case '/':	goto yy64;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy97;
	case ':':	goto yy93;
	case 'n':	goto yy84;
	case 'r':	goto yy85;
	case 's':	goto yy86;
	case 't':	goto yy87;
	default:	goto yy5;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy98;
	if (yych <= '/') goto yy5;
	if (yych <= '9') goto yy99;
	goto yy5;
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy102;
			if (yych >= 'A') goto yy103;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy104;
				goto yy103;
			} else {
				if (yych <= 'P') goto yy105;
				if (yych <= 'T') goto yy103;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
			} else {
				if (yych == 'g') goto yy108;
				goto yy107;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy109;
				goto yy107;
			} else {
				if (yych <= 'u') goto yy110;
				if (yych <= 'z') goto yy107;
			}
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
#line 1369 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1261 "parse_date.db.c"
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy103;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy107;
		goto yy18;
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy111;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'e') goto yy112;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'I') goto yy113;
			if (yych <= 'K') goto yy103;
			goto yy114;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy107;
			goto yy115;
		} else {
			if (yych == 'l') goto yy116;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy103;
				goto yy117;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy118;
				goto yy103;
			} else {
				if (yych <= 'O') goto yy119;
				if (yych <= 'Q') goto yy103;
				goto yy120;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy103;
				if (yych <= '`') goto yy18;
				goto yy107;
			} else {
				if (yych <= 'e') goto yy121;
				if (yych <= 'h') goto yy107;
				goto yy122;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy123;
				goto yy107;
			} else {
				if (yych <= 'r') goto yy124;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych == '/') goto yy18;
				goto yy126;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy131;
				if (yych <= 'U') goto yy103;
				goto yy132;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy132;
				goto yy103;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy133;
			if (yych <= 'T') goto yy103;
			goto yy134;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy135;
		} else {
			if (yych == 'u') goto yy136;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy137;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy103;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy138;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy139;
		} else {
			if (yych == 'I') goto yy140;
			if (yych <= 'N') goto yy103;
			goto yy141;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy142;
			goto yy107;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy143;
				goto yy107;
			} else {
				if (yych <= 'o') goto yy144;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy145;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy146;
				if (yych <= 'N') goto yy103;
				goto yy147;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych == 'e') goto yy148;
				goto yy107;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy149;
				goto yy107;
			} else {
				if (yych <= 'o') goto yy150;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy103;
			goto yy151;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'c') goto yy152;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy103;
			goto yy153;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'r') goto yy154;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy155;
				goto yy103;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy156;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy157;
				if (yych <= 'T') goto yy103;
				goto yy141;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy158;
				if (yych <= 'd') goto yy107;
				goto yy159;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy160;
				goto yy107;
			} else {
				if (yych <= 'u') goto yy144;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '0':
	case '1':	goto yy161;
	case '2':	goto yy162;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy163;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy146;
	case 'H':	goto yy164;
	case 'O':	goto yy165;
	case 'U':	goto yy166;
	case 'W':	goto yy167;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy149;
	case 'h':	goto yy168;
	case 'o':	goto yy169;
	case 'u':	goto yy170;
	case 'w':	goto yy171;
	default:	goto yy18;
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy172;
				goto yy103;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy173;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'e') goto yy174;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy131;
				goto yy103;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy175;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'e') goto yy176;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy104;
				goto yy103;
			} else {
				if (yych <= 'P') goto yy105;
				if (yych <= 'T') goto yy103;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych == 'g') goto yy104;
				goto yy103;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy105;
				goto yy103;
			} else {
				if (yych <= 'u') goto yy106;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy103;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy103;
		goto yy18;
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy111;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'e') goto yy111;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'I') goto yy113;
			if (yych <= 'K') goto yy103;
			goto yy114;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy103;
			goto yy113;
		} else {
			if (yych == 'l') goto yy114;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy103;
				goto yy117;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy118;
				goto yy103;
			} else {
				if (yych <= 'O') goto yy119;
				if (yych <= 'Q') goto yy103;
				goto yy120;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy103;
				if (yych <= '`') goto yy18;
				goto yy103;
			} else {
				if (yych <= 'e') goto yy117;
				if (yych <= 'h') goto yy103;
				goto yy118;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy119;
				goto yy103;
			} else {
				if (yych <= 'r') goto yy120;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy133;
			if (yych <= 'T') goto yy103;
			goto yy134;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy133;
		} else {
			if (yych == 'u') goto yy134;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy137;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy103;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy137;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy139;
		} else {
			if (yych == 'I') goto yy140;
			if (yych <= 'N') goto yy103;
			goto yy141;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy139;
			goto yy103;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy140;
				goto yy103;
			} else {
				if (yych <= 'o') goto yy141;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy145;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy146;
				if (yych <= 'N') goto yy103;
				goto yy147;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych == 'e') goto yy145;
				goto yy103;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy146;
				goto yy103;
			} else {
				if (yych <= 'o') goto yy147;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy103;
			goto yy151;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'c') goto yy151;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy103;
			goto yy153;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'r') goto yy153;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy155;
				goto yy103;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy156;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy157;
				if (yych <= 'T') goto yy103;
				goto yy141;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy155;
				if (yych <= 'd') goto yy103;
				goto yy156;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy157;
				goto yy103;
			} else {
				if (yych <= 'u') goto yy141;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '0':
	case '1':	goto yy161;
	case '2':	goto yy162;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy163;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy146;
	case 'H':
	case 'h':	goto yy164;
	case 'O':
	case 'o':	goto yy165;
	case 'U':
	case 'u':	goto yy166;
	case 'W':
	case 'w':	goto yy167;
	default:	goto yy18;
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy173;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'e') goto yy173;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy175;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'e') goto yy175;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy54;
yy53:
	YYDEBUG(53, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 13) {
		if (yyaccept <= 6) {
			if (yyaccept <= 3) {
				if (yyaccept <= 1) {
					if (yyaccept == 0) {
						goto yy7;
					} else {
						goto yy5;
					}
				} else {
					if (yyaccept == 2) {
						goto yy18;
					} else {
						goto yy73;
					}
				}
			} else {
				if (yyaccept <= 5) {
					if (yyaccept == 4) {
						goto yy128;
					} else {
						goto yy199;
					}
				} else {
					goto yy204;
				}
			}
		} else {
			if (yyaccept <= 10) {
				if (yyaccept <= 8) {
					if (yyaccept == 7) {
						goto yy262;
					} else {
						goto yy281;
					}
				} else {
					if (yyaccept == 9) {
						goto yy311;
					} else {
						goto yy366;
					}
				}
			} else {
				if (yyaccept <= 12) {
					if (yyaccept == 11) {
						goto yy368;
					} else {
						goto yy372;
					}
				} else {
					goto yy457;
				}
			}
		}
	} else {
		if (yyaccept <= 20) {
			if (yyaccept <= 17) {
				if (yyaccept <= 15) {
					if (yyaccept == 14) {
						goto yy491;
					} else {
						goto yy598;
					}
				} else {
					if (yyaccept == 16) {
						goto yy601;
					} else {
						goto yy640;
					}
				}
			} else {
				if (yyaccept <= 19) {
					if (yyaccept == 18) {
						goto yy683;
					} else {
						goto yy845;
					}
				} else {
					goto yy520;
				}
			}
		} else {
			if (yyaccept <= 23) {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy916;
					} else {
						goto yy978;
					}
				} else {
					goto yy983;
				}
			} else {
				if (yyaccept <= 25) {
					if (yyaccept == 24) {
						goto yy1025;
					} else {
						goto yy1072;
					}
				} else {
					goto yy1145;
				}
			}
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy177;
				if (yych <= 0x1F) goto yy53;
				goto yy177;
			} else {
				if (yych == 'D') goto yy179;
				if (yych <= 'E') goto yy53;
				goto yy180;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy71;
				if (yych <= 'L') goto yy53;
				goto yy181;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
					goto yy182;
				} else {
					if (yych <= 'T') goto yy79;
					if (yych <= 'V') goto yy53;
					goto yy81;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy83;
				if (yych <= 'c') goto yy53;
				goto yy179;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy180;
				} else {
					if (yych == 'h') goto yy71;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy181;
				if (yych <= 'r') goto yy53;
				if (yych <= 's') goto yy182;
				goto yy79;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy81;
				} else {
					if (yych == 'y') goto yy83;
					goto yy53;
				}
			}
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy18;
				goto yy178;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy58;
				} else {
					if (yych <= ':') goto yy183;
					if (yych <= 'C') goto yy18;
					goto yy178;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych <= 'G') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy178;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy178;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy178;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy18;
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy18;
				goto yy178;
			} else {
				if (yych <= '3') {
					if (yych <= '/') goto yy18;
				} else {
					if (yych <= '5') goto yy184;
					if (yych <= '9') goto yy185;
					goto yy183;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy18;
					goto yy178;
				} else {
					if (yych == 'F') goto yy178;
					goto yy18;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy178;
					goto yy18;
				} else {
					if (yych <= 'M') goto yy178;
					if (yych <= 'R') goto yy18;
					goto yy178;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy178;
				if (yych <= 'X') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy18;
					goto yy178;
				} else {
					if (yych == 'f') goto yy178;
					goto yy18;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy178;
					goto yy18;
				} else {
					if (yych <= 'm') goto yy178;
					if (yych <= 'r') goto yy18;
					goto yy178;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy18;
				}
			}
		}
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy18;
				goto yy178;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy18;
					goto yy184;
				} else {
					if (yych <= '9') goto yy185;
					if (yych <= ':') goto yy183;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy18;
				if (yych <= 'F') goto yy178;
				goto yy18;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy178;
					goto yy18;
				} else {
					if (yych <= 'M') goto yy178;
					if (yych <= 'R') goto yy18;
					goto yy178;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy178;
				if (yych <= 'X') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy18;
					goto yy178;
				} else {
					if (yych == 'f') goto yy178;
					goto yy18;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy178;
					goto yy18;
				} else {
					if (yych <= 'm') goto yy178;
					if (yych <= 'r') goto yy18;
					goto yy178;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy18;
				}
			}
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '0') goto yy188;
	if (yych <= '1') goto yy189;
	if (yych <= '9') goto yy190;
	goto yy61;
yy60:
	YYDEBUG(60, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy61:
	YYDEBUG(61, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy60;
	case '-':
	case '.':	goto yy186;
	case 'A':
	case 'a':	goto yy68;
	case 'D':
	case 'd':	goto yy69;
	case 'F':
	case 'f':	goto yy70;
	case 'H':
	case 'h':	goto yy71;
	case 'I':	goto yy72;
	case 'J':
	case 'j':	goto yy74;
	case 'M':
	case 'm':	goto yy75;
	case 'N':
	case 'n':	goto yy76;
	case 'O':
	case 'o':	goto yy77;
	case 'S':
	case 's':	goto yy78;
	case 'T':
	case 't':	goto yy79;
	case 'V':	goto yy80;
	case 'W':
	case 'w':	goto yy81;
	case 'X':	goto yy82;
	case 'Y':
	case 'y':	goto yy83;
	default:	goto yy53;
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '0') goto yy191;
	if (yych <= '1') goto yy192;
	if (yych <= '9') goto yy193;
	goto yy187;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy187;
		if (yych <= '0') goto yy198;
		goto yy200;
	} else {
		if (yych <= '5') goto yy201;
		if (yych <= '9') goto yy202;
		goto yy187;
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy203;
	case '3':	goto yy205;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy206;
	case 'A':
	case 'a':	goto yy207;
	case 'D':
	case 'd':	goto yy208;
	case 'F':
	case 'f':	goto yy209;
	case 'J':
	case 'j':	goto yy210;
	case 'M':
	case 'm':	goto yy211;
	case 'N':
	case 'n':	goto yy212;
	case 'O':
	case 'o':	goto yy213;
	case 'S':
	case 's':	goto yy214;
	default:	goto yy53;
	}
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy59;
			if (yych <= ',') goto yy61;
			goto yy62;
		} else {
			if (yych <= '.') goto yy63;
			if (yych <= '/') goto yy64;
			if (yych <= '5') goto yy215;
			goto yy216;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy67;
			if (yych == 'n') goto yy84;
			goto yy61;
		} else {
			if (yych <= 'r') goto yy85;
			if (yych <= 's') goto yy86;
			if (yych <= 't') goto yy87;
			goto yy61;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy88;
			if (yych <= ',') goto yy90;
			goto yy62;
		} else {
			if (yych <= '.') goto yy91;
			if (yych <= '/') goto yy64;
			if (yych <= '5') goto yy215;
			goto yy216;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy93;
			if (yych == 'n') goto yy84;
			goto yy90;
		} else {
			if (yych <= 'r') goto yy85;
			if (yych <= 's') goto yy86;
			if (yych <= 't') goto yy87;
			goto yy90;
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy217;
	if (yych <= '9') goto yy218;
	goto yy53;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy219;
		if (yych <= 'T') goto yy53;
		goto yy220;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy219;
		} else {
			if (yych == 'u') goto yy220;
			goto yy53;
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy221;
		if (yych <= 'D') goto yy53;
		goto yy222;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy221;
		} else {
			if (yych == 'e') goto yy222;
			goto yy53;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy223;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy224;
			if (yych <= 'Q') goto yy53;
			goto yy225;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy223;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy224;
			if (yych == 'r') goto yy225;
			goto yy53;
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy226;
	if (yych == 'o') goto yy226;
	goto yy53;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			if (yych <= '.') goto yy227;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy229;
			if (yych == 'I') goto yy231;
		} else {
			if (yych == 'W') goto yy73;
			if (yych <= 'X') goto yy232;
		}
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
#line 1164 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 2896 "parse_date.db.c"
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy233;
		if (yych <= 'T') goto yy53;
		goto yy234;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy233;
		} else {
			if (yych == 'u') goto yy234;
			goto yy53;
		}
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy235;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy236;
			if (yych <= 'N') goto yy53;
			goto yy237;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy235;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy236;
			if (yych == 'o') goto yy237;
			goto yy53;
		}
	}
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy238;
	if (yych == 'o') goto yy238;
	goto yy53;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy239;
	if (yych == 'c') goto yy239;
	goto yy53;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy241;
			if (yych <= 'T') goto yy53;
			goto yy242;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy241;
			if (yych == 'u') goto yy242;
			goto yy53;
		}
	}
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy243;
		if (yych <= 'T') goto yy53;
		goto yy244;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy243;
		} else {
			if (yych == 'u') goto yy244;
			goto yy53;
		}
	}
yy80:
	YYDEBUG(80, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy73;
			goto yy227;
		} else {
			if (yych == ' ') goto yy227;
			goto yy73;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy227;
			if (yych <= '/') goto yy73;
			goto yy229;
		} else {
			if (yych == 'I') goto yy82;
			goto yy73;
		}
	}
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy245;
	if (yych == 'e') goto yy245;
	goto yy53;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy73;
			goto yy227;
		} else {
			if (yych == ' ') goto yy227;
			goto yy73;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy227;
			if (yych <= '/') goto yy73;
			goto yy229;
		} else {
			if (yych == 'I') goto yy231;
			goto yy73;
		}
	}
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy246;
	if (yych == 'e') goto yy246;
	goto yy53;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy238;
		goto yy53;
	} else {
		if (yych <= 'd') goto yy247;
		if (yych == 'o') goto yy238;
		goto yy53;
	}
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy247;
	goto yy53;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy241;
			if (yych == 'U') goto yy242;
			goto yy53;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy240;
			if (yych <= 'd') goto yy53;
			goto yy241;
		} else {
			if (yych <= 's') goto yy53;
			if (yych <= 't') goto yy247;
			if (yych <= 'u') goto yy242;
			goto yy53;
		}
	}
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy243;
		if (yych <= 'T') goto yy53;
		goto yy244;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy248;
		} else {
			if (yych == 'u') goto yy244;
			goto yy53;
		}
	}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy90;
	if (yych <= '0') goto yy188;
	if (yych <= '1') goto yy189;
	if (yych <= '9') goto yy190;
	goto yy90;
yy89:
	YYDEBUG(89, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy90:
	YYDEBUG(90, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy89;
	case '-':
	case '.':	goto yy186;
	case 'A':
	case 'a':	goto yy94;
	case 'D':
	case 'd':	goto yy69;
	case 'F':
	case 'f':	goto yy70;
	case 'H':
	case 'h':	goto yy71;
	case 'I':	goto yy72;
	case 'J':
	case 'j':	goto yy74;
	case 'M':
	case 'm':	goto yy75;
	case 'N':
	case 'n':	goto yy76;
	case 'O':
	case 'o':	goto yy77;
	case 'P':
	case 'p':	goto yy95;
	case 'S':
	case 's':	goto yy78;
	case 'T':
	case 't':	goto yy79;
	case 'V':	goto yy80;
	case 'W':
	case 'w':	goto yy81;
	case 'X':	goto yy82;
	case 'Y':
	case 'y':	goto yy83;
	default:	goto yy53;
	}
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy187;
		if (yych <= '0') goto yy249;
		goto yy250;
	} else {
		if (yych <= '5') goto yy251;
		if (yych <= '9') goto yy252;
		goto yy187;
	}
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy59;
			if (yych <= ',') goto yy61;
			goto yy62;
		} else {
			if (yych <= '.') goto yy63;
			if (yych <= '/') goto yy253;
			if (yych <= '5') goto yy215;
			goto yy216;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy67;
			if (yych == 'n') goto yy84;
			goto yy61;
		} else {
			if (yych <= 'r') goto yy85;
			if (yych <= 's') goto yy86;
			if (yych <= 't') goto yy87;
			goto yy61;
		}
	}
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy254;
	if (yych <= '9') goto yy255;
	goto yy53;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy256;
			goto yy53;
		} else {
			if (yych <= 'M') goto yy257;
			if (yych == 'P') goto yy219;
			goto yy53;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy220;
			if (yych == 'm') goto yy257;
			goto yy53;
		} else {
			if (yych <= 'p') goto yy219;
			if (yych == 'u') goto yy220;
			goto yy53;
		}
	}
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy256;
		goto yy53;
	} else {
		if (yych <= 'M') goto yy257;
		if (yych == 'm') goto yy257;
		goto yy53;
	}
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy59;
			goto yy61;
		} else {
			if (yych <= '-') goto yy62;
			if (yych <= '.') goto yy258;
			if (yych <= '/') goto yy253;
			goto yy216;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy84;
			goto yy61;
		} else {
			if (yych <= 'r') goto yy85;
			if (yych <= 's') goto yy86;
			if (yych <= 't') goto yy87;
			goto yy61;
		}
	}
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy259;
	if (yych <= '/') goto yy178;
	if (yych <= '9') goto yy216;
	goto yy178;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy99:
	YYDEBUG(99, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(100, *YYCURSOR);
	if (yych <= '/') goto yy101;
	if (yych <= '9') goto yy99;
yy101:
	YYDEBUG(101, *YYCURSOR);
#line 925 "parse_date.db.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3296 "parse_date.db.c"
yy102:
	YYDEBUG(102, *YYCURSOR);
	++YYCURSOR;
	goto yy18;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy260;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy260;
		goto yy18;
	}
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy260;
			goto yy261;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'o') goto yy261;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy260;
			goto yy263;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'r') goto yy263;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy260;
			goto yy264;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'g') goto yy264;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy108:
	YYDEBUG(108, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy260;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'o') goto yy267;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy109:
	YYDEBUG(109, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy260;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy268;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy260;
			goto yy264;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'g') goto yy269;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy260;
			goto yy270;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'c') goto yy270;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy260;
			goto yy270;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'c') goto yy271;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy260;
			goto yy272;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'g') goto yy272;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy273;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'e') goto yy273;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy260;
			goto yy272;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'g') goto yy274;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy273;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy275;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy260;
			goto yy276;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'b') goto yy276;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'F') goto yy277;
			if (yych <= 'Q') goto yy260;
			goto yy278;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			if (yych <= 'e') goto yy260;
			goto yy277;
		} else {
			if (yych == 'r') goto yy278;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy260;
			goto yy279;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'u') goto yy279;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy260;
			goto yy280;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'i') goto yy280;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy260;
			goto yy276;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'b') goto yy282;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'E') {
				if (yych <= '@') goto yy18;
				goto yy260;
			} else {
				if (yych <= 'F') goto yy277;
				if (yych <= 'Q') goto yy260;
				goto yy278;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy260;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy266;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy283;
				goto yy266;
			} else {
				if (yych <= 'r') goto yy284;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy260;
			goto yy279;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'u') goto yy285;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy260;
			goto yy280;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'i') goto yy286;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 20) YYFILL(20);
	yych = *YYCURSOR;
yy126:
	YYDEBUG(126, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy125;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy127;
	if (yych <= '3') goto yy129;
	if (yych <= '9') goto yy130;
	goto yy53;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy288;
	if (yych <= '9') goto yy289;
	goto yy288;
yy128:
	YYDEBUG(128, *YYCURSOR);
#line 1151 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3868 "parse_date.db.c"
yy129:
	YYDEBUG(129, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy288;
	if (yych <= '1') goto yy289;
	if (yych <= '2') goto yy291;
	if (yych <= '9') goto yy292;
	goto yy288;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy288;
	if (yych <= '1') goto yy293;
	if (yych <= '2') goto yy291;
	if (yych <= '9') goto yy292;
	goto yy288;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy294;
				goto yy260;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy126;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy126;
			if (yych == ')') goto yy102;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy260;
			goto yy295;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'n') goto yy295;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'L') goto yy296;
			if (yych <= 'M') goto yy260;
			goto yy297;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			if (yych <= 'k') goto yy260;
			goto yy296;
		} else {
			if (yych == 'n') goto yy297;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy260;
			goto yy295;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy298;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'K') {
				if (yych <= '@') goto yy18;
				goto yy260;
			} else {
				if (yych <= 'L') goto yy296;
				if (yych <= 'M') goto yy260;
				goto yy297;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy260;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy266;
			}
		} else {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy299;
				goto yy266;
			} else {
				if (yych <= 'n') goto yy300;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy260;
			goto yy301;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 's') goto yy301;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy260;
			goto yy301;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 's') goto yy302;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'R') goto yy303;
			if (yych <= 'X') goto yy260;
			goto yy304;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			if (yych <= 'q') goto yy260;
			goto yy303;
		} else {
			if (yych == 'y') goto yy304;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy260;
			goto yy305;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'd') goto yy305;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy260;
			goto yy280;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'n') goto yy280;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy18;
				goto yy260;
			} else {
				if (yych <= 'R') goto yy303;
				if (yych <= 'X') goto yy260;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy260;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy266;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'r') goto yy306;
				goto yy266;
			} else {
				if (yych <= 'y') goto yy307;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy260;
			goto yy305;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy308;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy260;
			goto yy280;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy286;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy260;
			goto yy301;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'x') goto yy301;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy260;
			goto yy277;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'n') goto yy277;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'O') goto yy309;
			if (yych <= 'U') goto yy260;
			if (yych <= 'V') goto yy270;
			goto yy310;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			if (yych <= 'n') goto yy260;
			goto yy309;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy260;
				goto yy270;
			} else {
				if (yych <= 'w') goto yy310;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy260;
			goto yy301;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'x') goto yy302;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy260;
			goto yy277;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy283;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych == '/') goto yy265;
				goto yy18;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy260;
				goto yy309;
			} else {
				if (yych <= 'U') goto yy260;
				if (yych <= 'V') goto yy270;
				goto yy310;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy260;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy266;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy312;
				if (yych <= 'u') goto yy266;
				goto yy271;
			} else {
				if (yych <= 'w') goto yy313;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy260;
			goto yy314;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 't') goto yy314;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy260;
			goto yy314;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy315;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy316;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'e') goto yy316;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy316;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy317;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy260;
			goto yy318;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 't') goto yy318;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy319;
				goto yy260;
			} else {
				if (yych <= 'P') goto yy320;
				if (yych <= 'U') goto yy260;
				goto yy321;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy260;
				goto yy18;
			} else {
				if (yych == 'c') goto yy319;
				goto yy260;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy320;
				goto yy260;
			} else {
				if (yych <= 'v') goto yy321;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy260;
			goto yy277;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'x') goto yy277;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy260;
			goto yy318;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy322;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych == '/') goto yy265;
				goto yy18;
			}
		} else {
			if (yych <= 'O') {
				if (yych == 'C') goto yy319;
				goto yy260;
			} else {
				if (yych <= 'P') goto yy320;
				if (yych <= 'U') goto yy260;
				goto yy321;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy260;
				if (yych <= '^') goto yy18;
				goto yy265;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'b') goto yy266;
				goto yy323;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 'p') goto yy324;
				goto yy266;
			} else {
				if (yych <= 'v') goto yy325;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy260;
			goto yy277;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'x') goto yy283;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy67;
		goto yy53;
	} else {
		if (yych <= '9') goto yy326;
		if (yych <= ':') goto yy67;
		goto yy53;
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy67;
		goto yy53;
	} else {
		if (yych <= '3') goto yy326;
		if (yych == ':') goto yy67;
		goto yy53;
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy67;
	if (yych == ':') goto yy67;
	goto yy53;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'I') goto yy327;
			if (yych <= 'T') goto yy260;
			goto yy328;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy260;
			goto yy327;
		} else {
			if (yych == 'u') goto yy328;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'D') goto yy329;
			if (yych <= 'L') goto yy260;
			goto yy330;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			if (yych <= 'c') goto yy260;
			goto yy329;
		} else {
			if (yych == 'm') goto yy330;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy331;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'e') goto yy331;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy332;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'e') goto yy332;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy260;
			} else {
				if (yych <= 'I') goto yy327;
				if (yych <= 'T') goto yy260;
				goto yy328;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy260;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy266;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'i') goto yy333;
				goto yy266;
			} else {
				if (yych <= 'u') goto yy334;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy18;
				goto yy260;
			} else {
				if (yych <= 'D') goto yy329;
				if (yych <= 'L') goto yy260;
				goto yy330;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy260;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy266;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'd') goto yy335;
				goto yy266;
			} else {
				if (yych <= 'm') goto yy336;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy331;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy337;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy260;
			goto yy332;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy338;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy339;
				goto yy260;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy260;
			goto yy340;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 'd') goto yy340;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy260;
			goto yy340;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy341;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy260;
			goto yy342;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy260;
			if (yych <= '`') goto yy18;
			goto yy260;
		} else {
			if (yych <= 's') goto yy342;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy260;
			goto yy342;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy260;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 's') goto yy343;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy178:
	YYDEBUG(178, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy177;
				if (yych <= 0x1F) goto yy53;
				goto yy177;
			} else {
				if (yych == 'D') goto yy179;
				if (yych <= 'E') goto yy53;
				goto yy180;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy71;
				if (yych <= 'L') goto yy53;
				goto yy181;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
					goto yy182;
				} else {
					if (yych <= 'T') goto yy79;
					if (yych <= 'V') goto yy53;
					goto yy81;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy83;
				if (yych <= 'c') goto yy53;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy180;
				} else {
					if (yych == 'h') goto yy71;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy181;
				if (yych <= 'r') goto yy53;
				if (yych <= 's') goto yy182;
				goto yy79;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy81;
				} else {
					if (yych == 'y') goto yy83;
					goto yy53;
				}
			}
		}
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy221;
	if (yych == 'a') goto yy221;
	goto yy53;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy224;
		if (yych <= 'Q') goto yy53;
		goto yy225;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy224;
		} else {
			if (yych == 'r') goto yy225;
			goto yy53;
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy236;
		if (yych <= 'N') goto yy53;
		goto yy237;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy236;
		} else {
			if (yych == 'o') goto yy237;
			goto yy53;
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy344;
			if (yych <= 'T') goto yy53;
			goto yy242;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy344;
			if (yych == 'u') goto yy242;
			goto yy53;
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy345;
	if (yych <= '9') goto yy102;
	goto yy18;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy18;
				goto yy178;
			} else {
				if (yych <= '/') goto yy18;
				if (yych <= '9') goto yy185;
				if (yych <= 'C') goto yy18;
				goto yy178;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych <= 'G') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy178;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy178;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy178;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy18;
				}
			}
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy18;
				goto yy178;
			} else {
				if (yych == 'D') goto yy178;
				if (yych <= 'E') goto yy18;
				goto yy178;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy178;
				if (yych <= 'L') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'R') goto yy18;
				if (yych <= 'T') goto yy178;
				if (yych <= 'V') goto yy18;
				goto yy178;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy178;
				if (yych <= 'c') goto yy18;
				goto yy178;
			} else {
				if (yych == 'f') goto yy178;
				if (yych <= 'g') goto yy18;
				goto yy178;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy18;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy18;
				}
			}
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy187:
	YYDEBUG(187, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy186;
	case 'A':
	case 'a':	goto yy68;
	case 'D':
	case 'd':	goto yy194;
	case 'F':
	case 'f':	goto yy195;
	case 'I':	goto yy72;
	case 'J':
	case 'j':	goto yy74;
	case 'M':
	case 'm':	goto yy196;
	case 'N':
	case 'n':	goto yy76;
	case 'O':
	case 'o':	goto yy77;
	case 'S':
	case 's':	goto yy197;
	case 'V':	goto yy80;
	case 'X':	goto yy82;
	default:	goto yy53;
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy346;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy190;
	goto yy53;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy346;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy346;
	goto yy53;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy347;
		goto yy346;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy193;
		goto yy53;
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy347;
		goto yy346;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy347;
	if (yych <= '.') goto yy346;
	goto yy53;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy222;
	if (yych == 'e') goto yy222;
	goto yy53;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy223;
	if (yych == 'e') goto yy223;
	goto yy53;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy235;
	if (yych == 'a') goto yy235;
	goto yy53;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy348;
	if (yych == 'e') goto yy348;
	goto yy53;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		goto yy349;
	} else {
		if (yych <= '/') goto yy199;
		if (yych <= '9') goto yy202;
		if (yych <= ':') goto yy350;
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
#line 966 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 5489 "parse_date.db.c"
yy200:
	YYDEBUG(200, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		if (yych <= '.') goto yy349;
		goto yy199;
	} else {
		if (yych <= '2') goto yy202;
		if (yych <= '9') goto yy218;
		if (yych <= ':') goto yy350;
		goto yy199;
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		goto yy349;
	} else {
		if (yych <= '/') goto yy199;
		if (yych <= '9') goto yy218;
		if (yych <= ':') goto yy350;
		goto yy199;
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		goto yy349;
	} else {
		if (yych == ':') goto yy350;
		goto yy199;
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy351;
		} else {
			if (yych <= '9') goto yy206;
			if (yych >= 'n') goto yy352;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy352;
		} else {
			if (yych <= 's') goto yy353;
			if (yych <= 't') goto yy354;
		}
	}
yy204:
	YYDEBUG(204, *YYCURSOR);
#line 1058 "parse_date.db.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 5566 "parse_date.db.c"
yy205:
	YYDEBUG(205, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy204;
			goto yy351;
		} else {
			if (yych <= '1') goto yy206;
			if (yych <= 'm') goto yy204;
			goto yy352;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy204;
			goto yy352;
		} else {
			if (yych <= 's') goto yy353;
			if (yych <= 't') goto yy354;
			goto yy204;
		}
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy351;
		if (yych <= 'm') goto yy204;
		goto yy352;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy204;
			goto yy352;
		} else {
			if (yych <= 's') goto yy353;
			if (yych <= 't') goto yy354;
			goto yy204;
		}
	}
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy355;
		if (yych <= 'T') goto yy53;
		goto yy356;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy355;
		} else {
			if (yych == 'u') goto yy356;
			goto yy53;
		}
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy357;
	if (yych == 'e') goto yy357;
	goto yy53;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy358;
	if (yych == 'e') goto yy358;
	goto yy53;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy359;
		if (yych <= 'T') goto yy53;
		goto yy360;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy359;
		} else {
			if (yych == 'u') goto yy360;
			goto yy53;
		}
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy361;
	if (yych == 'a') goto yy361;
	goto yy53;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy362;
	if (yych == 'o') goto yy362;
	goto yy53;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy363;
	if (yych == 'c') goto yy363;
	goto yy53;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy364;
	if (yych == 'e') goto yy364;
	goto yy53;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy259;
	if (yych <= '/') goto yy178;
	if (yych <= '9') goto yy365;
	goto yy178;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy259;
	if (yych <= '/') goto yy178;
	if (yych <= '9') goto yy367;
	goto yy178;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy350;
		goto yy199;
	} else {
		if (yych <= '9') goto yy218;
		if (yych <= ':') goto yy350;
		goto yy199;
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy350;
	if (yych == ':') goto yy350;
	goto yy199;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy369;
	if (yych == 'r') goto yy369;
	goto yy53;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy370;
	if (yych == 'g') goto yy370;
	goto yy53;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy371;
	if (yych == 'y') goto yy371;
	goto yy53;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy373;
	if (yych == 'c') goto yy373;
	goto yy53;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy374;
	if (yych == 'b') goto yy374;
	goto yy53;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy375;
	if (yych == 'r') goto yy375;
	goto yy53;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy376;
	if (yych == 'i') goto yy376;
	goto yy53;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy377;
	if (yych == 'u') goto yy377;
	goto yy53;
yy227:
	YYDEBUG(227, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	YYDEBUG(228, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy227;
		if (yych <= 0x1F) goto yy53;
		goto yy227;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy53;
			goto yy227;
		} else {
			if (yych <= '/') goto yy53;
			if (yych >= ':') goto yy53;
		}
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy230;
	if (yych <= '9') goto yy378;
yy230:
	YYDEBUG(230, *YYCURSOR);
#line 1098 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 5796 "parse_date.db.c"
yy231:
	YYDEBUG(231, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy73;
			goto yy227;
		} else {
			if (yych == ' ') goto yy227;
			goto yy73;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy227;
			if (yych <= '/') goto yy73;
			goto yy229;
		} else {
			if (yych != 'I') goto yy73;
		}
	}
yy232:
	YYDEBUG(232, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy227;
		if (yych <= 0x1F) goto yy73;
		goto yy227;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy73;
			goto yy227;
		} else {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		}
	}
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy379;
	if (yych == 'n') goto yy379;
	goto yy53;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy380;
		if (yych <= 'M') goto yy53;
		goto yy381;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy380;
		} else {
			if (yych == 'n') goto yy381;
			goto yy53;
		}
	}
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy382;
		if (yych <= 'X') goto yy53;
		goto yy232;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy382;
		} else {
			if (yych == 'y') goto yy232;
			goto yy53;
		}
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy383;
	if (yych == 'n') goto yy383;
	goto yy53;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy384;
	if (yych == 'n') goto yy384;
	goto yy53;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy373;
	if (yych == 'v') goto yy373;
	goto yy53;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy385;
	if (yych == 't') goto yy385;
	goto yy53;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy386;
	if (yych == 't') goto yy386;
	goto yy53;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy387;
		if (yych <= 'O') goto yy53;
		goto yy388;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy387;
		} else {
			if (yych == 'p') goto yy388;
			goto yy53;
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy376;
	if (yych == 'n') goto yy376;
	goto yy53;
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy389;
	if (yych == 'u') goto yy389;
	goto yy53;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy390;
	if (yych == 'e') goto yy390;
	goto yy53;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy391;
		goto yy392;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy391;
		if (yych <= 'e') goto yy392;
		goto yy53;
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy377;
	if (yych == 'a') goto yy377;
	goto yy53;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy258;
		goto yy187;
	} else {
		if (yych <= '.') goto yy258;
		if (yych <= '/') goto yy253;
		goto yy187;
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy187;
			goto yy258;
		} else {
			if (yych <= ',') goto yy187;
			if (yych <= '.') goto yy258;
			goto yy253;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy187;
			goto yy389;
		} else {
			if (yych == 'u') goto yy389;
			goto yy187;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		goto yy393;
	} else {
		if (yych <= '/') goto yy199;
		if (yych <= '9') goto yy394;
		if (yych <= ':') goto yy395;
		goto yy199;
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		if (yych <= '.') goto yy393;
		goto yy199;
	} else {
		if (yych <= '2') goto yy394;
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy395;
		goto yy199;
	}
yy251:
	YYDEBUG(251, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		goto yy393;
	} else {
		if (yych <= '/') goto yy199;
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy395;
		goto yy199;
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy199;
		if (yych <= '-') goto yy346;
		goto yy393;
	} else {
		if (yych == ':') goto yy395;
		goto yy199;
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy207;
	case 'D':
	case 'd':	goto yy208;
	case 'F':
	case 'f':	goto yy209;
	case 'J':
	case 'j':	goto yy210;
	case 'M':
	case 'm':	goto yy211;
	case 'N':
	case 'n':	goto yy212;
	case 'O':
	case 'o':	goto yy213;
	case 'S':
	case 's':	goto yy214;
	default:	goto yy53;
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy395;
		goto yy199;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy395;
		goto yy199;
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy395;
	if (yych == ':') goto yy395;
	goto yy199;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy257;
	if (yych != 'm') goto yy53;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy397;
		if (yych == '\t') goto yy397;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy397;
		if (yych == '.') goto yy399;
		goto yy53;
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '0') goto yy188;
	if (yych <= '1') goto yy189;
	if (yych <= '9') goto yy190;
	goto yy187;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy400;
	case '1':	goto yy401;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy402;
	case 'A':
	case 'a':	goto yy403;
	case 'D':
	case 'd':	goto yy404;
	case 'F':
	case 'f':	goto yy405;
	case 'J':
	case 'j':	goto yy406;
	case 'M':
	case 'm':	goto yy407;
	case 'N':
	case 'n':	goto yy408;
	case 'O':
	case 'o':	goto yy409;
	case 'S':
	case 's':	goto yy410;
	default:	goto yy53;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy411;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy411;
		goto yy18;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= 'Z') goto yy411;
		if (yych <= '`') goto yy262;
		if (yych <= 'z') goto yy411;
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
#line 1321 "parse_date.db.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 6180 "parse_date.db.c"
yy263:
	YYDEBUG(263, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'I') goto yy413;
				goto yy411;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'i') goto yy413;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'U') goto yy414;
				goto yy411;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'u') goto yy414;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy415;
	goto yy53;
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy262;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy262;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '^') goto yy262;
			goto yy265;
		} else {
			if (yych <= '`') goto yy262;
			if (yych <= 'z') goto yy416;
			goto yy262;
		}
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'I') goto yy413;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'i') goto yy417;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'U') goto yy414;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'u') goto yy418;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'E') goto yy419;
				goto yy411;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'e') goto yy419;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'E') goto yy419;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'e') goto yy420;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy411;
			goto yy421;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'h') goto yy421;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy411;
			goto yy422;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'v') goto yy422;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy411;
			goto yy421;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'h') goto yy423;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy411;
			goto yy422;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'v') goto yy424;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'R') goto yy425;
				goto yy411;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'r') goto yy425;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy411;
			goto yy426;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 't') goto yy426;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy411;
			goto yy421;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 's') goto yy421;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy411;
			goto yy427;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'r') goto yy427;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy102;
		} else {
			if (yych <= '@') goto yy281;
			if (yych <= 'C') goto yy411;
			goto yy428;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy411;
			if (yych >= 'a') goto yy411;
		} else {
			if (yych <= 'd') goto yy428;
			if (yych <= 'z') goto yy411;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
#line 1336 "parse_date.db.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 6744 "parse_date.db.c"
yy282:
	YYDEBUG(282, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'R') goto yy425;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'r') goto yy429;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy411;
			goto yy426;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy430;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy411;
			goto yy421;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 's') goto yy423;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy411;
			goto yy427;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy431;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy281;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy281;
			if (yych <= 'C') goto yy411;
			goto yy428;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy281;
		} else {
			if (yych == 'd') goto yy432;
			if (yych <= 'z') goto yy416;
			goto yy281;
		}
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy288:
	YYDEBUG(288, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy287;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy128;
		if (yych <= '1') goto yy433;
		goto yy434;
	} else {
		if (yych <= '9') goto yy435;
		if (yych == 'T') goto yy290;
		goto yy128;
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych == '.') goto yy436;
		if (yych <= '/') goto yy288;
		goto yy437;
	} else {
		if (yych <= '2') goto yy438;
		if (yych <= '9') goto yy439;
		if (yych <= ':') goto yy440;
		goto yy288;
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy441;
	if (yych <= '2') goto yy442;
	if (yych <= '9') goto yy443;
	goto yy53;
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '3') goto yy444;
		if (yych <= '9') goto yy445;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '9') goto yy445;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '9') goto yy444;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy126;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy126;
			if (yych == ')') goto yy102;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'U') goto yy446;
				goto yy411;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'u') goto yy446;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'Y') goto yy447;
				goto yy411;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'y') goto yy447;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'E') goto yy447;
				goto yy411;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'e') goto yy447;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'U') goto yy446;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'u') goto yy448;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'Y') goto yy447;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'y') goto yy449;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'E') goto yy447;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'e') goto yy449;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy411;
			goto yy450;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 't') goto yy450;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy411;
			goto yy450;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy451;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'C') goto yy452;
				goto yy411;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'c') goto yy452;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy412;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy411;
			goto yy453;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'n') goto yy453;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'C') goto yy452;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'c') goto yy454;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= ',') goto yy18;
				if (yych <= '-') goto yy412;
				goto yy126;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy265;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy411;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy265;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy411;
			goto yy453;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy455;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy411;
			goto yy456;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'n') goto yy456;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= 'Z') goto yy411;
		if (yych <= '`') goto yy311;
		if (yych <= 'z') goto yy411;
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
#line 882 "parse_date.db.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7547 "parse_date.db.c"
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy411;
			goto yy456;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy458;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy311;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy311;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '^') goto yy311;
			goto yy265;
		} else {
			if (yych <= '`') goto yy311;
			if (yych <= 'z') goto yy416;
			goto yy311;
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'O') goto yy459;
				goto yy411;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'o') goto yy459;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'O') goto yy459;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 'o') goto yy460;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy411;
			goto yy461;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'v') goto yy461;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy411;
			goto yy461;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'v') goto yy462;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy281;
			goto yy102;
		} else {
			if (yych <= '@') goto yy281;
			if (yych <= 'T') goto yy411;
			goto yy463;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy281;
			goto yy411;
		} else {
			if (yych <= 'u') goto yy463;
			if (yych <= 'z') goto yy411;
			goto yy281;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy411;
			goto yy464;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'o') goto yy464;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'T') goto yy465;
				goto yy411;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy411;
			} else {
				if (yych <= 't') goto yy465;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy411;
			goto yy466;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'e') goto yy466;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy281;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy281;
			if (yych <= 'T') goto yy411;
			goto yy463;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy281;
		} else {
			if (yych == 'u') goto yy467;
			if (yych <= 'z') goto yy416;
			goto yy281;
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy411;
			goto yy464;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'o') goto yy468;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy18;
				goto yy411;
			} else {
				if (yych <= 'T') goto yy465;
				if (yych <= 'Z') goto yy411;
				goto yy18;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy416;
			} else {
				if (yych <= 't') goto yy469;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy411;
			goto yy466;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy470;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy67;
		goto yy53;
	} else {
		if (yych <= '5') goto yy471;
		if (yych == ':') goto yy67;
		goto yy53;
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= 'Q') goto yy411;
			if (yych <= 'R') goto yy472;
			goto yy450;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'r') goto yy472;
			if (yych <= 's') goto yy450;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy281;
			goto yy102;
		} else {
			if (yych <= '@') goto yy281;
			if (yych <= 'Q') goto yy411;
			goto yy473;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy281;
			goto yy411;
		} else {
			if (yych <= 'r') goto yy473;
			if (yych <= 'z') goto yy411;
			goto yy281;
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy474;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy474;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy411;
			goto yy475;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'o') goto yy475;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy281;
			goto yy102;
		} else {
			if (yych <= '@') goto yy281;
			if (yych <= 'R') goto yy411;
			goto yy476;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy281;
			goto yy411;
		} else {
			if (yych <= 's') goto yy476;
			if (yych <= 'z') goto yy411;
			goto yy281;
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy411;
			goto yy477;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'l') goto yy477;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy411;
			if (yych <= 'R') goto yy472;
			goto yy450;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy416;
				goto yy478;
			} else {
				if (yych <= 's') goto yy451;
				if (yych <= 'z') goto yy416;
				goto yy18;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy281;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy281;
			if (yych <= 'Q') goto yy411;
			goto yy473;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy281;
		} else {
			if (yych == 'r') goto yy479;
			if (yych <= 'z') goto yy416;
			goto yy281;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy474;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy480;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy411;
			goto yy475;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'o') goto yy481;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy281;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy281;
			if (yych <= 'R') goto yy411;
			goto yy476;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy281;
		} else {
			if (yych == 's') goto yy482;
			if (yych <= 'z') goto yy416;
			goto yy281;
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy411;
			goto yy477;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'l') goto yy483;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy411;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy447;
				goto yy411;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy411;
				goto yy18;
			}
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy281;
			goto yy102;
		} else {
			if (yych <= '@') goto yy281;
			if (yych <= 'M') goto yy411;
			goto yy484;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy281;
			goto yy411;
		} else {
			if (yych <= 'n') goto yy484;
			if (yych <= 'z') goto yy411;
			goto yy281;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy281;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy281;
			if (yych <= 'M') goto yy411;
			goto yy484;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy281;
		} else {
			if (yych == 'n') goto yy485;
			if (yych <= 'z') goto yy416;
			goto yy281;
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy411;
			goto yy486;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy411;
			if (yych <= '`') goto yy18;
			goto yy411;
		} else {
			if (yych <= 't') goto yy486;
			if (yych <= 'z') goto yy411;
			goto yy18;
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy411;
			goto yy486;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy411;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy487;
			if (yych <= 'z') goto yy416;
			goto yy18;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy387;
	if (yych == 'c') goto yy387;
	goto yy53;
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy102;
	goto yy18;
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy488;
	goto yy53;
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy490;
	if (yych <= '3') goto yy492;
	if (yych <= '9') goto yy493;
	goto yy53;
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy388;
	if (yych == 'p') goto yy388;
	goto yy53;
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy494;
	if (yych <= '6') goto yy495;
	if (yych <= '9') goto yy496;
	goto yy53;
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy497;
	if (yych <= '6') goto yy498;
	if (yych <= '9') goto yy499;
	goto yy53;
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy500;
	goto yy53;
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy501;
	goto yy53;
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy501;
	goto yy53;
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy501;
	goto yy53;
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy502;
	if (yych == 'r') goto yy502;
	goto yy53;
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy502;
	if (yych == 'g') goto yy502;
	goto yy53;
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy502;
	if (yych == 'c') goto yy502;
	goto yy53;
yy358:
	YYDEBUG(358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy502;
	if (yych == 'b') goto yy502;
	goto yy53;
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy502;
	if (yych == 'n') goto yy502;
	goto yy53;
yy360:
	YYDEBUG(360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy502;
		if (yych <= 'M') goto yy53;
		goto yy502;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy502;
		} else {
			if (yych == 'n') goto yy502;
			goto yy53;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy502;
		if (yych <= 'X') goto yy53;
		goto yy502;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy502;
		} else {
			if (yych == 'y') goto yy502;
			goto yy53;
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy502;
	if (yych == 'v') goto yy502;
	goto yy53;
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy502;
	if (yych == 't') goto yy502;
	goto yy53;
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy503;
	if (yych == 'p') goto yy503;
	goto yy53;
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy505;
	case '-':	goto yy506;
	case '.':	goto yy507;
	case '/':	goto yy508;
	case '0':	goto yy509;
	case '1':	goto yy510;
	case '2':	goto yy511;
	case '3':	goto yy512;
	case '4':
	case '5':	goto yy513;
	case '6':	goto yy514;
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy515;
	case 'W':	goto yy527;
	default:	goto yy366;
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
#line 992 "parse_date.db.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 8614 "parse_date.db.c"
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy505;
	case '-':	goto yy506;
	case '.':	goto yy507;
	case '/':	goto yy508;
	case '0':	goto yy529;
	case '1':	goto yy530;
	case '2':	goto yy531;
	case '3':	goto yy532;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy515;
	case 'W':	goto yy527;
	default:	goto yy368;
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
#line 1312 "parse_date.db.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 8675 "parse_date.db.c"
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'I') goto yy533;
			if (yych == 'i') goto yy533;
			goto yy73;
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'U') goto yy534;
			if (yych == 'u') goto yy534;
			goto yy73;
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy535;
	if (yych == 's') goto yy535;
yy372:
	YYDEBUG(372, *YYCURSOR);
#line 1413 "parse_date.db.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 8746 "parse_date.db.c"
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'E') goto yy536;
			if (yych == 'e') goto yy536;
			goto yy73;
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'R') goto yy537;
			if (yych == 'r') goto yy537;
			goto yy73;
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy538;
	if (yych == 't') goto yy538;
	goto yy53;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy539;
	if (yych == 'd') goto yy539;
	goto yy372;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy371;
	if (yych == 'r') goto yy371;
	goto yy53;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy230;
	if (yych <= '9') goto yy540;
	goto yy230;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'U') goto yy541;
			if (yych == 'u') goto yy541;
			goto yy73;
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'Y') goto yy232;
			if (yych == 'y') goto yy232;
			goto yy73;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'E') goto yy232;
			if (yych == 'e') goto yy232;
			goto yy73;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'C') goto yy542;
			if (yych == 'c') goto yy542;
			goto yy73;
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy535;
		if (yych <= 'T') goto yy372;
		goto yy543;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy372;
			goto yy535;
		} else {
			if (yych == 'u') goto yy543;
			goto yy372;
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy539;
		if (yych <= 'S') goto yy372;
		goto yy544;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy372;
			goto yy539;
		} else {
			if (yych == 't') goto yy544;
			goto yy372;
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'O') goto yy545;
			if (yych == 'o') goto yy545;
			goto yy73;
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy546;
	if (yych == 'u') goto yy546;
	goto yy372;
yy387:
	YYDEBUG(387, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy547;
		if (yych <= 'R') goto yy372;
		goto yy535;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy372;
			goto yy547;
		} else {
			if (yych == 's') goto yy535;
			goto yy372;
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych <= ',') goto yy73;
			goto yy227;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy229;
			goto yy73;
		} else {
			if (yych <= 'T') goto yy373;
			if (yych == 't') goto yy373;
			goto yy73;
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy548;
	if (yych == 'r') goto yy548;
	goto yy372;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy549;
	if (yych == 's') goto yy549;
	goto yy372;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy550;
	if (yych == 'n') goto yy550;
	goto yy372;
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy371;
	if (yych == 'k') goto yy371;
	goto yy53;
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy551;
	if (yych <= '6') goto yy552;
	if (yych <= '9') goto yy496;
	goto yy53;
yy394:
	YYDEBUG(394, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy553;
			if (yych <= 0x1F) goto yy199;
			goto yy553;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy199;
				goto yy346;
			} else {
				if (yych <= '.') goto yy393;
				if (yych <= '9') goto yy199;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy95;
			if (yych <= 'O') goto yy199;
			goto yy95;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy199;
				goto yy95;
			} else {
				if (yych == 'p') goto yy95;
				goto yy199;
			}
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy555;
	if (yych <= '6') goto yy556;
	if (yych <= '9') goto yy499;
	goto yy53;
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy553;
			if (yych <= 0x1F) goto yy199;
			goto yy553;
		} else {
			if (yych == '.') goto yy395;
			if (yych <= '9') goto yy199;
			goto yy395;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy95;
			if (yych <= 'O') goto yy199;
			goto yy95;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy199;
				goto yy95;
			} else {
				if (yych == 'p') goto yy95;
				goto yy199;
			}
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(398, *YYCURSOR);
#line 949 "parse_date.db.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9147 "parse_date.db.c"
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy397;
		if (yych <= 0x08) goto yy53;
		goto yy397;
	} else {
		if (yych == ' ') goto yy397;
		goto yy53;
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy557;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy402;
	goto yy53;
yy401:
	YYDEBUG(401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy557;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy557;
	goto yy53;
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy558;
		if (yych <= 'T') goto yy53;
		goto yy559;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy558;
		} else {
			if (yych == 'u') goto yy559;
			goto yy53;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy560;
	if (yych == 'e') goto yy560;
	goto yy53;
yy405:
	YYDEBUG(405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy561;
	if (yych == 'e') goto yy561;
	goto yy53;
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy562;
		if (yych <= 'T') goto yy53;
		goto yy563;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy562;
		} else {
			if (yych == 'u') goto yy563;
			goto yy53;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy564;
	if (yych == 'a') goto yy564;
	goto yy53;
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy565;
	if (yych == 'o') goto yy565;
	goto yy53;
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy566;
	if (yych == 'c') goto yy566;
	goto yy53;
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy567;
	if (yych == 'e') goto yy567;
	goto yy53;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy568;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy568;
		goto yy18;
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy126;
	if (yych <= '0') goto yy569;
	if (yych <= '2') goto yy570;
	if (yych <= '3') goto yy571;
	goto yy126;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy568;
			goto yy572;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'l') goto yy572;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy568;
			goto yy573;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 's') goto yy573;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy574;
	}
	goto yy53;
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy568;
			goto yy572;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'l') goto yy577;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy568;
			goto yy573;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 's') goto yy578;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy568;
			goto yy579;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'm') goto yy579;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy568;
			goto yy579;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'm') goto yy580;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy568;
			goto yy581;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 't') goto yy581;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy568;
			goto yy582;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'e') goto yy582;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy568;
			goto yy581;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy583;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy568;
			goto yy582;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy584;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy568;
			goto yy585;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'u') goto yy585;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy568;
			goto yy581;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'h') goto yy581;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy568;
			goto yy586;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 't') goto yy586;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy587;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy587;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy568;
			goto yy585;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'u') goto yy588;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy568;
			goto yy581;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'h') goto yy583;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy568;
			goto yy586;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy589;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy587;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy590;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '9') goto yy591;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '3') goto yy591;
		if (yych <= '9') goto yy592;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '9') goto yy592;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '2') {
		if (yych <= '/') goto yy288;
		if (yych <= '1') goto yy593;
		goto yy594;
	} else {
		if (yych <= '5') goto yy595;
		if (yych <= '9') goto yy596;
		goto yy288;
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '9') goto yy597;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '3') goto yy597;
		if (yych <= '9') goto yy599;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy128;
	} else {
		if (yych <= '9') goto yy599;
		if (yych >= ';') goto yy128;
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy600;
	if (yych <= '9') goto yy602;
	goto yy53;
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy53;
	} else {
		if (yych <= '9') goto yy443;
		if (yych <= ':') goto yy440;
		goto yy53;
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy53;
	} else {
		if (yych <= '3') goto yy443;
		if (yych == ':') goto yy440;
		goto yy53;
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy440;
	if (yych == ':') goto yy440;
	goto yy53;
yy444:
	YYDEBUG(444, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '9') goto yy603;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy128;
	if (yych <= '9') goto yy603;
	goto yy128;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy604;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy604;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy126;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy126;
			if (yych == ')') goto yy102;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy604;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy605;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy265;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy568;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy265;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy576;
				goto yy18;
			}
		}
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy606;
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy568;
	case 'D':
	case 'd':	goto yy608;
	case 'F':
	case 'f':	goto yy609;
	case 'H':
	case 'h':	goto yy610;
	case 'M':
	case 'm':	goto yy611;
	case 'S':
	case 's':	goto yy612;
	case 'T':
	case 't':	goto yy613;
	case 'W':
	case 'w':	goto yy614;
	case 'Y':
	case 'y':	goto yy615;
	default:	goto yy18;
	}
yy451:
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy606;
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy265;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':	goto yy568;
	case 'D':	goto yy608;
	case 'F':	goto yy609;
	case 'H':	goto yy610;
	case 'M':	goto yy611;
	case 'S':	goto yy612;
	case 'T':	goto yy613;
	case 'W':	goto yy614;
	case 'Y':	goto yy615;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy576;
	case 'd':	goto yy616;
	case 'f':	goto yy617;
	case 'h':	goto yy618;
	case 'm':	goto yy619;
	case 's':	goto yy620;
	case 't':	goto yy621;
	case 'w':	goto yy622;
	case 'y':	goto yy623;
	default:	goto yy18;
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy568;
			goto yy572;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'h') goto yy572;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy568;
			goto yy624;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'i') goto yy624;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy568;
			goto yy572;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'h') goto yy577;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy568;
			goto yy624;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'i') goto yy625;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= 'Z') goto yy568;
		if (yych <= '`') goto yy457;
		if (yych <= 'z') goto yy568;
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
#line 891 "parse_date.db.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 10204 "parse_date.db.c"
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy457;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy457;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '^') goto yy457;
			goto yy265;
		} else {
			if (yych <= '`') goto yy457;
			if (yych <= 'z') goto yy576;
			goto yy457;
		}
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy568;
			goto yy626;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'b') goto yy626;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy568;
			goto yy626;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'b') goto yy627;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy568;
			goto yy628;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'i') goto yy628;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy568;
			goto yy628;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'i') goto yy629;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy568;
			goto yy630;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'r') goto yy630;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy568;
			goto yy631;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'n') goto yy631;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy102;
				goto yy18;
			} else {
				if (yych <= '-') goto yy412;
				if (yych <= '.') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy126;
				goto yy18;
			} else {
				if (yych == 'E') goto yy632;
				goto yy568;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy568;
			} else {
				if (yych <= 'e') goto yy632;
				if (yych <= 'z') goto yy568;
				goto yy18;
			}
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy568;
			goto yy633;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'n') goto yy633;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy568;
			goto yy630;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy634;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy568;
			goto yy631;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy635;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy126;
			} else {
				if (yych == ' ') goto yy126;
				goto yy18;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy102;
				if (yych <= ',') goto yy18;
				goto yy412;
			} else {
				if (yych == '/') goto yy265;
				goto yy126;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy18;
				goto yy568;
			} else {
				if (yych <= 'E') goto yy632;
				if (yych <= 'Z') goto yy568;
				goto yy18;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy576;
			} else {
				if (yych <= 'e') goto yy636;
				if (yych <= 'z') goto yy576;
				goto yy18;
			}
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy568;
			goto yy633;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy637;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy638;
	goto yy53;
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy568;
			goto yy581;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'd') goto yy581;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy568;
			goto yy630;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 's') goto yy630;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy568;
			goto yy639;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'y') goto yy639;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy568;
			goto yy641;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'r') goto yy641;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy568;
			goto yy642;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'd') goto yy642;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'E') goto yy568;
			goto yy633;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'f') goto yy633;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy568;
			goto yy581;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy583;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy568;
			goto yy630;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 's') goto yy634;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy568;
			goto yy639;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'y') goto yy643;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy568;
			goto yy641;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy644;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy568;
			goto yy642;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy645;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'E') goto yy568;
			goto yy633;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'f') goto yy637;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy568;
			goto yy646;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'e') goto yy646;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy568;
			goto yy646;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy647;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy568;
			goto yy648;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy568;
			if (yych <= '`') goto yy18;
			goto yy568;
		} else {
			if (yych <= 'e') goto yy648;
			if (yych <= 'z') goto yy568;
			goto yy18;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy568;
			goto yy648;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy568;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy649;
			if (yych <= 'z') goto yy576;
			goto yy18;
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy489;
	if (yych <= '9') goto yy650;
yy489:
	YYDEBUG(489, *YYCURSOR);
#line 1112 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 10965 "parse_date.db.c"
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy651;
		if (yych >= 'n') goto yy652;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy652;
		} else {
			if (yych <= 's') goto yy653;
			if (yych <= 't') goto yy654;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
#line 1085 "parse_date.db.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 10996 "parse_date.db.c"
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy491;
			goto yy651;
		} else {
			if (yych <= '9') goto yy650;
			if (yych <= 'm') goto yy491;
			goto yy652;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy491;
			goto yy652;
		} else {
			if (yych <= 's') goto yy653;
			if (yych <= 't') goto yy654;
			goto yy491;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy650;
		if (yych <= 'm') goto yy491;
		goto yy652;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy491;
			goto yy652;
		} else {
			if (yych <= 's') goto yy653;
			if (yych <= 't') goto yy654;
			goto yy491;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy656;
	goto yy199;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy655;
		goto yy199;
	} else {
		if (yych <= '0') goto yy656;
		if (yych <= '9') goto yy650;
		goto yy199;
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy650;
	goto yy199;
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy499;
	goto yy199;
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych != '0') goto yy199;
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	goto yy199;
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy657;
	goto yy204;
yy501:
	YYDEBUG(501, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy351;
	goto yy204;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy658;
	goto yy53;
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy658;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy502;
		if (yych == 't') goto yy502;
		goto yy53;
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy505:
	YYDEBUG(505, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy504;
	case '-':
	case '.':	goto yy659;
	case 'A':
	case 'a':	goto yy516;
	case 'D':
	case 'd':	goto yy517;
	case 'F':
	case 'f':	goto yy518;
	case 'H':
	case 'h':	goto yy71;
	case 'I':	goto yy519;
	case 'J':
	case 'j':	goto yy521;
	case 'M':
	case 'm':	goto yy522;
	case 'N':
	case 'n':	goto yy523;
	case 'O':
	case 'o':	goto yy524;
	case 'S':
	case 's':	goto yy525;
	case 'T':
	case 't':	goto yy79;
	case 'V':	goto yy526;
	case 'W':
	case 'w':	goto yy81;
	case 'X':	goto yy528;
	case 'Y':
	case 'y':	goto yy83;
	default:	goto yy53;
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy661;
	case '1':	goto yy662;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy663;
	case 'A':
	case 'a':	goto yy664;
	case 'D':
	case 'd':	goto yy665;
	case 'F':
	case 'f':	goto yy666;
	case 'J':
	case 'j':	goto yy667;
	case 'M':
	case 'm':	goto yy668;
	case 'N':
	case 'n':	goto yy669;
	case 'O':
	case 'o':	goto yy670;
	case 'S':
	case 's':	goto yy671;
	default:	goto yy660;
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy660;
	if (yych <= '0') goto yy672;
	if (yych <= '2') goto yy673;
	if (yych <= '3') goto yy674;
	goto yy660;
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy679;
	if (yych <= '1') goto yy680;
	if (yych <= '9') goto yy681;
	goto yy53;
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '0') goto yy682;
	if (yych <= '9') goto yy684;
	goto yy178;
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '2') goto yy684;
	if (yych <= '9') goto yy685;
	goto yy178;
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '9') goto yy685;
	goto yy178;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '5') goto yy685;
	if (yych <= '6') goto yy686;
	if (yych <= '9') goto yy687;
	goto yy178;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '9') goto yy687;
	goto yy178;
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '0') goto yy687;
	if (yych <= '9') goto yy54;
	goto yy178;
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy688;
	if (yych <= '1') goto yy689;
	goto yy53;
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy690;
		if (yych <= 'T') goto yy53;
		goto yy691;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy690;
		} else {
			if (yych == 'u') goto yy691;
			goto yy53;
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy221;
		if (yych <= 'D') goto yy53;
		goto yy692;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy221;
		} else {
			if (yych == 'e') goto yy692;
			goto yy53;
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy693;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy224;
			if (yych <= 'Q') goto yy53;
			goto yy225;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy693;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy224;
			if (yych == 'r') goto yy225;
			goto yy53;
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy694;
	} else {
		if (yych == 'W') goto yy520;
		if (yych <= 'X') goto yy695;
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
#line 1138 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 11329 "parse_date.db.c"
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy696;
		if (yych <= 'T') goto yy53;
		goto yy697;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy696;
		} else {
			if (yych == 'u') goto yy697;
			goto yy53;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy698;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy236;
			if (yych <= 'N') goto yy53;
			goto yy237;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy698;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy236;
			if (yych == 'o') goto yy237;
			goto yy53;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy699;
	if (yych == 'o') goto yy699;
	goto yy53;
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy700;
	if (yych == 'c') goto yy700;
	goto yy53;
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy701;
			if (yych <= 'T') goto yy53;
			goto yy242;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy701;
			if (yych == 'u') goto yy242;
			goto yy53;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy528;
	goto yy520;
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy702;
		if (yych <= '4') goto yy703;
		goto yy704;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy53;
			goto yy245;
		} else {
			if (yych == 'e') goto yy245;
			goto yy53;
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy694;
	goto yy520;
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '0') goto yy705;
	if (yych <= '9') goto yy706;
	goto yy178;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '2') goto yy706;
	if (yych <= '9') goto yy707;
	goto yy178;
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '9') goto yy707;
	goto yy178;
yy532:
	YYDEBUG(532, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '5') goto yy707;
	if (yych <= '6') goto yy708;
	if (yych <= '9') goto yy54;
	goto yy178;
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy232;
	if (yych == 'l') goto yy232;
	goto yy53;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy709;
	if (yych == 's') goto yy709;
	goto yy53;
yy535:
	YYDEBUG(535, *YYCURSOR);
	++YYCURSOR;
	goto yy372;
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy545;
	if (yych == 'm') goto yy545;
	goto yy53;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy541;
	if (yych == 'u') goto yy541;
	goto yy53;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy710;
		if (yych <= 'M') goto yy53;
		goto yy711;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy710;
		} else {
			if (yych == 'n') goto yy711;
			goto yy53;
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy712;
	if (yych == 'a') goto yy712;
	goto yy53;
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy230;
	if (yych <= '9') goto yy713;
	goto yy230;
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy714;
	if (yych == 'a') goto yy714;
	goto yy53;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy232;
	if (yych == 'h') goto yy232;
	goto yy53;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy715;
	if (yych == 't') goto yy715;
	goto yy53;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy371;
	if (yych == 'h') goto yy371;
	goto yy53;
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy716;
	if (yych == 'b') goto yy716;
	goto yy53;
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy549;
	if (yych == 'r') goto yy549;
	goto yy53;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy717;
	if (yych == 'n') goto yy717;
	goto yy53;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy549;
	if (yych != 's') goto yy53;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy539;
	if (yych == 'd') goto yy539;
	goto yy53;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy548;
	if (yych == 'e') goto yy548;
	goto yy53;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy718;
	goto yy199;
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy655;
		goto yy199;
	} else {
		if (yych <= '0') goto yy718;
		if (yych <= '9') goto yy650;
		goto yy199;
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(554, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy553;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy553;
			if (yych <= '@') goto yy53;
			goto yy95;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy95;
			goto yy53;
		} else {
			if (yych <= 'a') goto yy95;
			if (yych == 'p') goto yy95;
			goto yy53;
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy719;
	goto yy199;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych == '0') goto yy719;
	goto yy199;
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy720;
	if (yych <= '3') goto yy721;
	if (yych <= '9') goto yy722;
	goto yy53;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy723;
	if (yych == 'r') goto yy723;
	goto yy53;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy723;
	if (yych == 'g') goto yy723;
	goto yy53;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy723;
	if (yych == 'c') goto yy723;
	goto yy53;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy723;
	if (yych == 'b') goto yy723;
	goto yy53;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy723;
	if (yych == 'n') goto yy723;
	goto yy53;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy723;
		if (yych <= 'M') goto yy53;
		goto yy723;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy723;
		} else {
			if (yych == 'n') goto yy723;
			goto yy53;
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy723;
		if (yych <= 'X') goto yy53;
		goto yy723;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy723;
		} else {
			if (yych == 'y') goto yy723;
			goto yy53;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy723;
	if (yych == 'v') goto yy723;
	goto yy53;
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy723;
	if (yych == 't') goto yy723;
	goto yy53;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy724;
	if (yych == 'p') goto yy724;
	goto yy53;
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy725;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy725;
		goto yy18;
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy288;
	if (yych <= '0') goto yy289;
	if (yych <= '9') goto yy726;
	goto yy288;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy288;
	if (yych <= '9') goto yy726;
	goto yy288;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy288;
	if (yych <= '1') goto yy726;
	if (yych <= '2') goto yy291;
	if (yych <= '9') goto yy292;
	goto yy288;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy126;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy126;
			if (yych == ')') goto yy102;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy725;
			goto yy727;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 't') goto yy727;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(575, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy574;
	}
	if (yych == '/') goto yy265;
	if (yych == '_') goto yy265;
	goto yy18;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy126;
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych == ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy265;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy725;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy265;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy728;
				goto yy18;
			}
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy725;
			goto yy727;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy729;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy725;
			goto yy730;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'b') goto yy730;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy725;
			goto yy730;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'b') goto yy731;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy606;
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy725;
	case 'D':
	case 'd':	goto yy732;
	case 'F':
	case 'f':	goto yy733;
	case 'H':
	case 'h':	goto yy734;
	case 'M':
	case 'm':	goto yy735;
	case 'S':
	case 's':	goto yy736;
	case 'T':
	case 't':	goto yy737;
	case 'W':
	case 'w':	goto yy738;
	case 'Y':
	case 'y':	goto yy739;
	default:	goto yy18;
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy725;
			goto yy740;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'n') goto yy740;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy606;
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy265;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':	goto yy725;
	case 'D':	goto yy732;
	case 'F':	goto yy733;
	case 'H':	goto yy734;
	case 'M':	goto yy735;
	case 'S':	goto yy736;
	case 'T':	goto yy737;
	case 'W':	goto yy738;
	case 'Y':	goto yy739;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy728;
	case 'd':	goto yy741;
	case 'f':	goto yy742;
	case 'h':	goto yy743;
	case 'm':	goto yy744;
	case 's':	goto yy745;
	case 't':	goto yy746;
	case 'w':	goto yy747;
	case 'y':	goto yy748;
	default:	goto yy18;
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy725;
			goto yy740;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy749;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy750;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy750;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy725;
			goto yy751;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'h') goto yy751;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy725;
			goto yy752;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'y') goto yy752;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy750;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy753;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy725;
			goto yy751;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'h') goto yy754;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy725;
			goto yy752;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'y') goto yy755;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
		goto yy128;
	} else {
		if (yych <= '9') goto yy756;
		if (yych <= ':') goto yy440;
		goto yy128;
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy128;
	if (yych <= '9') goto yy756;
	goto yy128;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy757;
		goto yy128;
	} else {
		if (yych <= '9') goto yy758;
		if (yych <= ':') goto yy757;
		goto yy128;
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy757;
		goto yy128;
	} else {
		if (yych <= '3') goto yy758;
		if (yych <= '9') goto yy759;
		if (yych <= ':') goto yy757;
		goto yy128;
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy757;
		goto yy128;
	} else {
		if (yych <= '9') goto yy759;
		if (yych <= ':') goto yy757;
		goto yy128;
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy757;
		goto yy128;
	} else {
		if (yych <= '9') goto yy592;
		if (yych <= ':') goto yy757;
		goto yy128;
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy440;
	} else {
		if (yych <= '9') goto yy756;
		if (yych <= ':') goto yy440;
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
#line 1125 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 12347 "parse_date.db.c"
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy598;
	if (yych <= '9') goto yy756;
	goto yy598;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy760;
	} else {
		if (yych <= '9') goto yy602;
		if (yych <= ':') goto yy760;
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
#line 1383 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 12395 "parse_date.db.c"
yy602:
	YYDEBUG(602, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy760;
	if (yych == ':') goto yy760;
	goto yy601;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy598;
	if (yych <= '9') goto yy761;
	goto yy598;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy725;
			goto yy762;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'r') goto yy762;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy725;
			goto yy762;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy763;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy607:
	YYDEBUG(607, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy606;
				if (yych <= 0x1F) goto yy53;
				goto yy606;
			} else {
				if (yych == 'D') goto yy764;
				if (yych <= 'E') goto yy53;
				goto yy765;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy766;
				if (yych <= 'L') goto yy53;
				goto yy767;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
					goto yy768;
				} else {
					if (yych <= 'T') goto yy769;
					if (yych <= 'V') goto yy53;
					goto yy770;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy771;
				if (yych <= 'c') goto yy53;
				goto yy764;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy765;
				} else {
					if (yych == 'h') goto yy766;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy767;
				if (yych <= 'r') goto yy53;
				if (yych <= 's') goto yy768;
				goto yy769;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy770;
				} else {
					if (yych == 'y') goto yy771;
					goto yy53;
				}
			}
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy772;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy772;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'O') goto yy773;
			if (yych <= 'Q') goto yy725;
			goto yy774;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			if (yych <= 'n') goto yy725;
			goto yy773;
		} else {
			if (yych == 'r') goto yy774;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy725;
			goto yy775;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'o') goto yy775;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'I') goto yy776;
			if (yych <= 'N') goto yy725;
			goto yy777;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy725;
			goto yy776;
		} else {
			if (yych == 'o') goto yy777;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'A') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy778;
		} else {
			if (yych == 'E') goto yy779;
			if (yych <= 'T') goto yy725;
			goto yy780;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy778;
			goto yy725;
		} else {
			if (yych <= 't') {
				if (yych <= 'e') goto yy779;
				goto yy725;
			} else {
				if (yych <= 'u') goto yy780;
				if (yych <= 'z') goto yy725;
				goto yy18;
			}
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'H') goto yy781;
			if (yych <= 'T') goto yy725;
			goto yy782;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			if (yych <= 'g') goto yy725;
			goto yy781;
		} else {
			if (yych == 'u') goto yy782;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy725;
			goto yy783;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'e') goto yy783;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy725;
			goto yy784;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'e') goto yy784;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy772;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy785;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'N') {
				if (yych <= '@') goto yy18;
				goto yy725;
			} else {
				if (yych <= 'O') goto yy773;
				if (yych <= 'Q') goto yy725;
				goto yy774;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy725;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy728;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'o') goto yy786;
				goto yy728;
			} else {
				if (yych <= 'r') goto yy787;
				if (yych <= 'z') goto yy728;
				goto yy18;
			}
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy725;
			goto yy775;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'o') goto yy788;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy725;
			} else {
				if (yych <= 'I') goto yy776;
				if (yych <= 'N') goto yy725;
				goto yy777;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy725;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy728;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy789;
				goto yy728;
			} else {
				if (yych <= 'o') goto yy790;
				if (yych <= 'z') goto yy728;
				goto yy18;
			}
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych == '/') goto yy265;
				goto yy18;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'A') goto yy778;
				goto yy725;
			} else {
				if (yych <= 'E') goto yy779;
				if (yych <= 'T') goto yy725;
				goto yy780;
			}
		}
	} else {
		if (yych <= 'a') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy725;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy791;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'e') goto yy792;
				goto yy728;
			} else {
				if (yych <= 'u') goto yy793;
				if (yych <= 'z') goto yy728;
				goto yy18;
			}
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych <= 'G') {
				if (yych <= '@') goto yy18;
				goto yy725;
			} else {
				if (yych <= 'H') goto yy781;
				if (yych <= 'T') goto yy725;
				goto yy782;
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy725;
				goto yy18;
			} else {
				if (yych <= '_') goto yy265;
				if (yych <= '`') goto yy18;
				goto yy728;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'h') goto yy794;
				goto yy728;
			} else {
				if (yych <= 'u') goto yy795;
				if (yych <= 'z') goto yy728;
				goto yy18;
			}
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy725;
			goto yy783;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy796;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy725;
			goto yy784;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy797;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy725;
			goto yy798;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'g') goto yy798;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy725;
			goto yy798;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'g') goto yy799;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy725;
			goto yy800;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'e') goto yy800;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy725;
			goto yy800;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy801;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy725;
			goto yy802;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'o') goto yy802;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy725;
			goto yy802;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'o') goto yy803;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy725;
			goto yy804;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'd') goto yy804;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy725;
			goto yy751;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'd') goto yy751;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy725;
			goto yy805;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'm') goto yy805;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy725;
			goto yy806;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 't') goto yy806;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy725;
			goto yy804;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy807;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy725;
			goto yy751;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy754;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy725;
			goto yy805;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'm') goto yy808;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy725;
			goto yy806;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy809;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy366;
	if (yych <= '5') goto yy810;
	if (yych <= '6') goto yy811;
	goto yy366;
yy639:
	YYDEBUG(639, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= 'Z') goto yy725;
		if (yych <= '`') goto yy640;
		if (yych <= 'z') goto yy725;
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
#line 903 "parse_date.db.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 13340 "parse_date.db.c"
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy725;
			goto yy812;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'r') goto yy812;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy813;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy813;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy640;
			goto yy102;
		} else {
			if (yych == '/') goto yy265;
			goto yy640;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '^') goto yy640;
			goto yy265;
		} else {
			if (yych <= '`') goto yy640;
			if (yych <= 'z') goto yy728;
			goto yy640;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy725;
			goto yy812;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy814;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy815;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy725;
			goto yy816;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 's') goto yy816;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy725;
			goto yy816;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 's') goto yy817;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy725;
			goto yy818;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy725;
			if (yych <= '`') goto yy18;
			goto yy725;
		} else {
			if (yych <= 'r') goto yy818;
			if (yych <= 'z') goto yy725;
			goto yy18;
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy725;
			goto yy818;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy725;
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy819;
			if (yych <= 'z') goto yy728;
			goto yy18;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy489;
	if (yych <= '9') goto yy820;
	goto yy489;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy820;
		if (yych <= 'm') goto yy491;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy491;
		} else {
			if (yych <= 's') goto yy653;
			if (yych <= 't') goto yy654;
			goto yy491;
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy821;
	goto yy53;
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy821;
	goto yy53;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy821;
	goto yy53;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy822;
	goto yy53;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy655;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy820;
	goto yy199;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy824;
	goto yy204;
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy825;
	goto yy53;
yy659:
	YYDEBUG(659, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy660:
	YYDEBUG(660, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy659;
	case 'A':
	case 'a':	goto yy516;
	case 'D':
	case 'd':	goto yy675;
	case 'F':
	case 'f':	goto yy676;
	case 'I':	goto yy519;
	case 'J':
	case 'j':	goto yy521;
	case 'M':
	case 'm':	goto yy677;
	case 'N':
	case 'n':	goto yy523;
	case 'O':
	case 'o':	goto yy524;
	case 'S':
	case 's':	goto yy678;
	case 'V':	goto yy526;
	case 'X':	goto yy528;
	default:	goto yy53;
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy826;
		goto yy53;
	} else {
		if (yych <= '0') goto yy663;
		if (yych <= '9') goto yy827;
		goto yy53;
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy826;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy827;
	goto yy53;
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy826;
	goto yy53;
yy664:
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy828;
		if (yych <= 'T') goto yy53;
		goto yy829;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy828;
		} else {
			if (yych == 'u') goto yy829;
			goto yy53;
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy830;
	if (yych == 'e') goto yy830;
	goto yy53;
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy831;
	if (yych == 'e') goto yy831;
	goto yy53;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy832;
		if (yych <= 'T') goto yy53;
		goto yy833;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy832;
		} else {
			if (yych == 'u') goto yy833;
			goto yy53;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy834;
	if (yych == 'a') goto yy834;
	goto yy53;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy835;
	if (yych == 'o') goto yy835;
	goto yy53;
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy836;
	if (yych == 'c') goto yy836;
	goto yy53;
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy837;
	if (yych == 'e') goto yy837;
	goto yy53;
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy838;
	if (yych <= '9') goto yy839;
	goto yy53;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy839;
	goto yy53;
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy839;
	if (yych <= '6') goto yy840;
	goto yy53;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy692;
	if (yych == 'e') goto yy692;
	goto yy53;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy693;
	if (yych == 'e') goto yy693;
	goto yy53;
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy698;
	if (yych == 'a') goto yy698;
	goto yy53;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy841;
	if (yych == 'e') goto yy841;
	goto yy53;
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy842;
	if (yych <= '0') goto yy681;
	if (yych <= '9') goto yy843;
	goto yy53;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy842;
	if (yych <= '2') goto yy843;
	goto yy53;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy842;
	goto yy53;
yy682:
	YYDEBUG(682, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych >= ' ') goto yy178;
			} else {
				if (yych <= '0') {
					if (yych >= '0') goto yy54;
				} else {
					if (yych <= '9') goto yy844;
					if (yych >= 'D') goto yy178;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych >= 'H') goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych >= 'M') goto yy178;
				} else {
					if (yych <= 'R') goto yy683;
					if (yych <= 'T') goto yy178;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy683;
				if (yych <= 'Y') goto yy178;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
				} else {
					if (yych != 'g') goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych >= 's') goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy178;
				} else {
					if (yych == 'y') goto yy178;
				}
			}
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
#line 1038 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 13878 "parse_date.db.c"
yy684:
	YYDEBUG(684, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy683;
				goto yy178;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy683;
					goto yy846;
				} else {
					if (yych <= '2') goto yy847;
					if (yych <= '3') goto yy848;
					goto yy844;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy683;
					goto yy178;
				} else {
					if (yych == 'F') goto yy178;
					goto yy683;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy178;
					goto yy683;
				} else {
					if (yych <= 'M') goto yy178;
					if (yych <= 'R') goto yy683;
					goto yy178;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy178;
				if (yych <= 'X') goto yy683;
				goto yy178;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy683;
					goto yy178;
				} else {
					if (yych == 'f') goto yy178;
					goto yy683;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy178;
					goto yy683;
				} else {
					if (yych <= 'm') goto yy178;
					if (yych <= 'r') goto yy683;
					goto yy178;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy683;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy683;
				}
			}
		}
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy683;
				goto yy178;
			} else {
				if (yych <= '/') goto yy683;
				if (yych <= '9') goto yy844;
				if (yych <= 'C') goto yy683;
				goto yy178;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych <= 'G') goto yy683;
				goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy683;
					goto yy178;
				} else {
					if (yych <= 'R') goto yy683;
					if (yych <= 'T') goto yy178;
					goto yy683;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy683;
				if (yych <= 'Y') goto yy178;
				goto yy683;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
					goto yy683;
				} else {
					if (yych == 'g') goto yy683;
					goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy683;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy683;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy683;
				}
			}
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy683;
				goto yy178;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy683;
					goto yy844;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy683;
					goto yy178;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych <= 'G') goto yy683;
				goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy683;
					goto yy178;
				} else {
					if (yych <= 'R') goto yy683;
					if (yych <= 'T') goto yy178;
					goto yy683;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy683;
				if (yych <= 'Y') goto yy178;
				goto yy683;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
					goto yy683;
				} else {
					if (yych == 'g') goto yy683;
					goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy683;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy683;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy683;
				}
			}
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy683;
				goto yy178;
			} else {
				if (yych == 'D') goto yy178;
				if (yych <= 'E') goto yy683;
				goto yy178;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy178;
				if (yych <= 'L') goto yy683;
				goto yy178;
			} else {
				if (yych <= 'R') goto yy683;
				if (yych <= 'T') goto yy178;
				if (yych <= 'V') goto yy683;
				goto yy178;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy178;
				if (yych <= 'c') goto yy683;
				goto yy178;
			} else {
				if (yych == 'f') goto yy178;
				if (yych <= 'g') goto yy683;
				goto yy178;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy683;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy683;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy683;
				}
			}
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy849;
	goto yy53;
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy849;
	goto yy53;
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy850;
	if (yych == 'r') goto yy850;
	goto yy53;
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy851;
	if (yych == 'g') goto yy851;
	goto yy53;
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy852;
	if (yych == 'c') goto yy852;
	goto yy53;
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy853;
	if (yych == 'b') goto yy853;
	goto yy53;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy520;
yy695:
	YYDEBUG(695, *YYCURSOR);
	++YYCURSOR;
	goto yy520;
yy696:
	YYDEBUG(696, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy854;
	if (yych == 'n') goto yy854;
	goto yy53;
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy855;
		if (yych <= 'M') goto yy53;
		goto yy856;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy855;
		} else {
			if (yych == 'n') goto yy856;
			goto yy53;
		}
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy857;
		if (yych <= 'X') goto yy53;
		goto yy695;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy857;
		} else {
			if (yych == 'y') goto yy695;
			goto yy53;
		}
	}
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy852;
	if (yych == 'v') goto yy852;
	goto yy53;
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy858;
	if (yych == 't') goto yy858;
	goto yy53;
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy387;
		if (yych <= 'O') goto yy53;
		goto yy859;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy387;
		} else {
			if (yych == 'p') goto yy859;
			goto yy53;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy860;
	goto yy53;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy860;
	goto yy53;
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy860;
	goto yy53;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '0') goto yy54;
	if (yych <= '9') goto yy844;
	goto yy178;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy178;
		if (yych <= '0') goto yy846;
		goto yy847;
	} else {
		if (yych <= '3') goto yy848;
		if (yych <= '9') goto yy844;
		goto yy178;
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '9') goto yy844;
	goto yy178;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy178;
	if (yych <= '6') goto yy844;
	if (yych <= '9') goto yy54;
	goto yy178;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy232;
	if (yych == 't') goto yy232;
	goto yy53;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy711;
	if (yych != 'n') goto yy53;
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy862;
	if (yych == 'i') goto yy862;
	goto yy53;
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy535;
	if (yych == 'y') goto yy535;
	goto yy53;
yy713:
	YYDEBUG(713, *YYCURSOR);
	++YYCURSOR;
	goto yy230;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy863;
	if (yych == 'r') goto yy863;
	goto yy53;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy371;
	if (yych == 'e') goto yy371;
	goto yy53;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy864;
	if (yych == 'e') goto yy864;
	goto yy53;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy371;
	if (yych == 'd') goto yy371;
	goto yy53;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy553;
			if (yych <= 0x1F) goto yy199;
			goto yy553;
		} else {
			if (yych == '.') goto yy655;
			if (yych <= '/') goto yy199;
			goto yy820;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy95;
			if (yych <= 'O') goto yy199;
			goto yy95;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy199;
				goto yy95;
			} else {
				if (yych == 'p') goto yy95;
				goto yy199;
			}
		}
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy553;
			goto yy199;
		} else {
			if (yych <= ' ') goto yy553;
			if (yych == '.') goto yy655;
			goto yy199;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy95;
			if (yych == 'P') goto yy95;
			goto yy199;
		} else {
			if (yych <= 'a') goto yy95;
			if (yych == 'p') goto yy95;
			goto yy199;
		}
	}
yy720:
	YYDEBUG(720, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy722;
		if (yych <= 'm') goto yy491;
		goto yy652;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy491;
			goto yy652;
		} else {
			if (yych <= 's') goto yy653;
			if (yych <= 't') goto yy654;
			goto yy491;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy491;
		if (yych <= '1') goto yy722;
		if (yych <= 'm') goto yy491;
		goto yy652;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy491;
			goto yy652;
		} else {
			if (yych <= 's') goto yy653;
			if (yych <= 't') goto yy654;
			goto yy491;
		}
	}
yy722:
	YYDEBUG(722, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy652;
		goto yy491;
	} else {
		if (yych <= 'r') goto yy652;
		if (yych <= 's') goto yy653;
		if (yych <= 't') goto yy654;
		goto yy491;
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy865;
	goto yy53;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy865;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy723;
		if (yych == 't') goto yy723;
		goto yy53;
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy102;
	goto yy18;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy866;
	case '.':	goto yy436;
	case '0':
	case '1':	goto yy437;
	case '2':	goto yy438;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy439;
	case ':':	goto yy440;
	default:	goto yy288;
	}
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy126;
		} else {
			if (yych == ' ') goto yy126;
			goto yy18;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy102;
			if (yych <= ',') goto yy18;
			goto yy126;
		} else {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		}
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy102;
		if (yych <= '.') goto yy18;
		goto yy265;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy18;
			goto yy265;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy126;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy126;
			if (yych == ')') goto yy102;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych == '/') goto yy265;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy869;
		if (yych == 'e') goto yy869;
		goto yy18;
	}
yy731:
	YYDEBUG(731, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'D') goto yy18;
			goto yy869;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy870;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy871;
		if (yych == 'a') goto yy871;
		goto yy18;
	}
yy733:
	YYDEBUG(733, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == 'O') goto yy872;
			goto yy18;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'R') goto yy873;
			if (yych <= 'n') goto yy18;
			goto yy872;
		} else {
			if (yych == 'r') goto yy873;
			goto yy18;
		}
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'O') goto yy874;
		if (yych == 'o') goto yy874;
		goto yy18;
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == 'I') goto yy875;
			goto yy18;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'O') goto yy876;
			if (yych <= 'h') goto yy18;
			goto yy875;
		} else {
			if (yych == 'o') goto yy876;
			goto yy18;
		}
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy877;
			if (yych == 'E') goto yy878;
			goto yy18;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'U') goto yy879;
			if (yych == 'a') goto yy877;
			goto yy18;
		} else {
			if (yych <= 'e') goto yy878;
			if (yych == 'u') goto yy879;
			goto yy18;
		}
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == 'H') goto yy880;
			goto yy18;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'U') goto yy881;
			if (yych <= 'g') goto yy18;
			goto yy880;
		} else {
			if (yych == 'u') goto yy881;
			goto yy18;
		}
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy882;
		if (yych == 'e') goto yy882;
		goto yy18;
	}
yy739:
	YYDEBUG(739, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy883;
		if (yych == 'e') goto yy883;
		goto yy18;
	}
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'T') goto yy884;
		if (yych == 't') goto yy884;
		goto yy18;
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy871;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy885;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy742:
	YYDEBUG(742, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych == 'O') goto yy872;
			if (yych <= 'Q') goto yy18;
			goto yy873;
		}
	} else {
		if (yych <= 'n') {
			if (yych == '_') goto yy265;
			if (yych <= '`') goto yy18;
			goto yy867;
		} else {
			if (yych <= 'q') {
				if (yych <= 'o') goto yy886;
				goto yy867;
			} else {
				if (yych <= 'r') goto yy887;
				if (yych <= 'z') goto yy867;
				goto yy18;
			}
		}
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'N') goto yy18;
			goto yy874;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'o') goto yy888;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy744:
	YYDEBUG(744, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych == 'I') goto yy875;
			if (yych <= 'N') goto yy18;
			goto yy876;
		}
	} else {
		if (yych <= 'h') {
			if (yych == '_') goto yy265;
			if (yych <= '`') goto yy18;
			goto yy867;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy889;
				goto yy867;
			} else {
				if (yych <= 'o') goto yy890;
				if (yych <= 'z') goto yy867;
				goto yy18;
			}
		}
	}
yy745:
	YYDEBUG(745, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych == '/') goto yy265;
				goto yy18;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'A') goto yy877;
				goto yy18;
			} else {
				if (yych <= 'E') goto yy878;
				if (yych <= 'T') goto yy18;
				goto yy879;
			}
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy265;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'a') goto yy891;
				goto yy867;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'e') goto yy892;
				goto yy867;
			} else {
				if (yych <= 'u') goto yy893;
				if (yych <= 'z') goto yy867;
				goto yy18;
			}
		}
	}
yy746:
	YYDEBUG(746, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy265;
		} else {
			if (yych == 'H') goto yy880;
			if (yych <= 'T') goto yy18;
			goto yy881;
		}
	} else {
		if (yych <= 'g') {
			if (yych == '_') goto yy265;
			if (yych <= '`') goto yy18;
			goto yy867;
		} else {
			if (yych <= 't') {
				if (yych <= 'h') goto yy894;
				goto yy867;
			} else {
				if (yych <= 'u') goto yy895;
				if (yych <= 'z') goto yy867;
				goto yy18;
			}
		}
	}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'D') goto yy18;
			goto yy882;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy896;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy748:
	YYDEBUG(748, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'D') goto yy18;
			goto yy883;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy897;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy749:
	YYDEBUG(749, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'S') goto yy18;
			goto yy884;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy898;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy899;
		if (yych == 'r') goto yy899;
		goto yy18;
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy607;
				if (yych <= 0x1F) goto yy18;
				goto yy607;
			} else {
				if (yych == ')') goto yy102;
				if (yych <= 'C') goto yy18;
				goto yy607;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy607;
				if (yych <= 'G') goto yy18;
				goto yy607;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy607;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy607;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy607;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy607;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy607;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy607;
				if (yych <= 'r') goto yy18;
				goto yy607;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy607;
				} else {
					if (yych == 'y') goto yy607;
					goto yy18;
				}
			}
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy102;
	goto yy281;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'Q') goto yy18;
			goto yy899;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy900;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':	goto yy607;
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy265;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy867;
	case 'd':	goto yy901;
	case 'f':	goto yy902;
	case 'h':	goto yy903;
	case 'm':	goto yy904;
	case 's':	goto yy905;
	case 't':	goto yy906;
	case 'w':	goto yy907;
	case 'y':	goto yy908;
	default:	goto yy18;
	}
yy755:
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy102;
		if (yych <= '.') goto yy281;
		goto yy265;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy281;
			goto yy265;
		} else {
			if (yych <= '`') goto yy281;
			if (yych <= 'z') goto yy867;
			goto yy281;
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy128;
	if (yych <= '9') goto yy761;
	goto yy128;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy909;
	if (yych <= '6') goto yy910;
	if (yych <= '9') goto yy602;
	goto yy53;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy757;
		goto yy128;
	} else {
		if (yych <= '9') goto yy756;
		if (yych <= ':') goto yy757;
		goto yy128;
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy128;
	} else {
		if (yych <= '9') goto yy756;
		if (yych >= ';') goto yy128;
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy911;
	if (yych <= '6') goto yy912;
	if (yych <= '9') goto yy913;
	goto yy53;
yy761:
	YYDEBUG(761, *YYCURSOR);
	++YYCURSOR;
	goto yy128;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy125;
		if (yych == 'y') goto yy125;
		goto yy18;
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'X') goto yy18;
			goto yy125;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'y') goto yy914;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy871;
	if (yych == 'a') goto yy871;
	goto yy53;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy872;
		if (yych <= 'Q') goto yy53;
		goto yy873;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy872;
		} else {
			if (yych == 'r') goto yy873;
			goto yy53;
		}
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy874;
	if (yych == 'o') goto yy874;
	goto yy53;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy875;
		if (yych <= 'N') goto yy53;
		goto yy876;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy875;
		} else {
			if (yych == 'o') goto yy876;
			goto yy53;
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy877;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy878;
			if (yych <= 'T') goto yy53;
			goto yy879;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy877;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy878;
			if (yych == 'u') goto yy879;
			goto yy53;
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy880;
		if (yych <= 'T') goto yy53;
		goto yy881;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy880;
		} else {
			if (yych == 'u') goto yy881;
			goto yy53;
		}
	}
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy882;
	if (yych == 'e') goto yy882;
	goto yy53;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy883;
	if (yych == 'e') goto yy883;
	goto yy53;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy915;
		if (yych == 'y') goto yy915;
		goto yy18;
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy917;
		if (yych == 'r') goto yy917;
		goto yy18;
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'I') goto yy918;
		if (yych == 'i') goto yy918;
		goto yy18;
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'U') goto yy919;
		if (yych == 'u') goto yy919;
		goto yy18;
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'N') goto yy920;
		if (yych == 'n') goto yy920;
		goto yy18;
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'N') goto yy921;
		if (yych == 'n') goto yy921;
		goto yy18;
	}
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'T') goto yy922;
		if (yych == 't') goto yy922;
		goto yy18;
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'C') goto yy923;
		if (yych == 'c') goto yy923;
		goto yy18;
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'N') goto yy918;
		if (yych == 'n') goto yy918;
		goto yy18;
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'U') goto yy924;
		if (yych == 'u') goto yy924;
		goto yy18;
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy925;
		if (yych == 'e') goto yy925;
		goto yy18;
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		if (yych <= 'C') goto yy18;
		goto yy926;
	} else {
		if (yych <= 'c') {
			if (yych <= 'E') goto yy927;
			goto yy18;
		} else {
			if (yych <= 'd') goto yy926;
			if (yych <= 'e') goto yy927;
			goto yy18;
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy919;
		if (yych == 'a') goto yy919;
		goto yy18;
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'X') goto yy18;
			goto yy915;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'y') goto yy928;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'Q') goto yy18;
			goto yy917;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy929;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'H') goto yy18;
			goto yy918;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'i') goto yy930;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'T') goto yy18;
			goto yy919;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'u') goto yy931;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'M') goto yy18;
			goto yy920;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy932;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'M') goto yy18;
			goto yy921;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy933;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'S') goto yy18;
			goto yy922;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 't') goto yy934;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy792:
	YYDEBUG(792, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'B') goto yy18;
			goto yy923;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'c') goto yy935;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'M') goto yy18;
			goto yy918;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'n') goto yy930;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'T') goto yy18;
			goto yy924;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'u') goto yy936;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'D') goto yy18;
			goto yy925;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'e') goto yy937;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy796:
	YYDEBUG(796, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'C') goto yy18;
			if (yych <= 'D') goto yy926;
			goto yy927;
		}
	} else {
		if (yych <= 'c') {
			if (yych == '_') goto yy265;
			if (yych <= '`') goto yy18;
			goto yy867;
		} else {
			if (yych <= 'd') goto yy938;
			if (yych <= 'e') goto yy939;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy919;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy931;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy798:
	YYDEBUG(798, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy940;
		if (yych == 'h') goto yy940;
		goto yy18;
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'G') goto yy18;
			goto yy940;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'h') goto yy941;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy125;
		if (yych == 'r') goto yy125;
		goto yy18;
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'Q') goto yy18;
			goto yy125;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'r') goto yy914;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'U') goto yy942;
		if (yych == 'u') goto yy942;
		goto yy18;
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'T') goto yy18;
			goto yy942;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'u') goto yy943;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy944;
		if (yych == 'a') goto yy944;
		goto yy18;
	}
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'B') goto yy945;
		if (yych == 'b') goto yy945;
		goto yy18;
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy606;
		if (yych == 'h') goto yy606;
		goto yy18;
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= '@') goto yy18;
			goto yy944;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy946;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'A') goto yy18;
			goto yy945;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'b') goto yy947;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'G') goto yy18;
			goto yy606;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'h') goto yy948;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy949;
	goto yy53;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy949;
	goto yy53;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'O') goto yy950;
		if (yych == 'o') goto yy950;
		goto yy18;
	}
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy951;
		if (yych == 'y') goto yy951;
		goto yy18;
	}
yy814:
	YYDEBUG(814, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'N') goto yy18;
			goto yy950;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'o') goto yy952;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'X') goto yy18;
			goto yy951;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'y') goto yy953;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy816:
	YYDEBUG(816, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy954;
		if (yych == 'd') goto yy954;
		goto yy18;
	}
yy817:
	YYDEBUG(817, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'C') goto yy18;
			goto yy954;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy955;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy956;
		if (yych == 'd') goto yy956;
		goto yy18;
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy265;
			if (yych <= 'C') goto yy18;
			goto yy956;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy265;
			goto yy18;
		} else {
			if (yych == 'd') goto yy957;
			if (yych <= 'z') goto yy867;
			goto yy18;
		}
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy489;
	if (yych <= '9') goto yy958;
	goto yy489;
yy821:
	YYDEBUG(821, *YYCURSOR);
	++YYCURSOR;
	goto yy491;
yy822:
	YYDEBUG(822, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(823, *YYCURSOR);
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy822;
	goto yy199;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy959;
	goto yy204;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy960;
	goto yy53;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy961;
	if (yych <= '3') goto yy962;
	if (yych <= '9') goto yy963;
	goto yy53;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy964;
	goto yy53;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy965;
	if (yych == 'r') goto yy965;
	goto yy53;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy966;
	if (yych == 'g') goto yy966;
	goto yy53;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy967;
	if (yych == 'c') goto yy967;
	goto yy53;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy968;
	if (yych == 'b') goto yy968;
	goto yy53;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy969;
	if (yych == 'n') goto yy969;
	goto yy53;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy970;
		if (yych <= 'M') goto yy53;
		goto yy971;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy970;
		} else {
			if (yych == 'n') goto yy971;
			goto yy53;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy972;
		if (yych <= 'X') goto yy53;
		goto yy973;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy972;
		} else {
			if (yych == 'y') goto yy973;
			goto yy53;
		}
	}
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy967;
	if (yych == 'v') goto yy967;
	goto yy53;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy974;
	if (yych == 't') goto yy974;
	goto yy53;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy975;
	if (yych == 'p') goto yy975;
	goto yy53;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy976;
	goto yy53;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy976;
	goto yy53;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '6') goto yy976;
	goto yy53;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy859;
	if (yych == 'p') goto yy859;
	goto yy53;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy977;
	if (yych <= '3') goto yy979;
	if (yych <= '9') goto yy980;
	goto yy53;
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy981;
	goto yy53;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych >= ' ') goto yy178;
			} else {
				if (yych == 'D') goto yy178;
				if (yych >= 'F') goto yy178;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy178;
				if (yych >= 'M') goto yy178;
			} else {
				if (yych <= 'R') goto yy845;
				if (yych <= 'T') goto yy178;
				if (yych >= 'W') goto yy178;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy178;
				if (yych >= 'd') goto yy178;
			} else {
				if (yych == 'f') goto yy178;
				if (yych >= 'h') goto yy178;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych >= 's') goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy178;
				} else {
					if (yych == 'y') goto yy178;
				}
			}
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
#line 1214 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 16379 "parse_date.db.c"
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy845;
				goto yy178;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy845;
					goto yy54;
				} else {
					if (yych <= '9') goto yy982;
					if (yych <= 'C') goto yy845;
					goto yy178;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych <= 'G') goto yy845;
				goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy845;
					goto yy178;
				} else {
					if (yych <= 'R') goto yy845;
					if (yych <= 'T') goto yy178;
					goto yy845;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy845;
				if (yych <= 'Y') goto yy178;
				goto yy845;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
					goto yy845;
				} else {
					if (yych == 'g') goto yy845;
					goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy845;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy845;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy845;
				}
			}
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy845;
				goto yy178;
			} else {
				if (yych <= '/') goto yy845;
				if (yych <= '9') goto yy982;
				if (yych <= 'C') goto yy845;
				goto yy178;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych <= 'G') goto yy845;
				goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy845;
					goto yy178;
				} else {
					if (yych <= 'R') goto yy845;
					if (yych <= 'T') goto yy178;
					goto yy845;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy845;
				if (yych <= 'Y') goto yy178;
				goto yy845;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
					goto yy845;
				} else {
					if (yych == 'g') goto yy845;
					goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy845;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy845;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy845;
				}
			}
		}
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy178;
				if (yych <= 0x1F) goto yy845;
				goto yy178;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy845;
					goto yy982;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy845;
					goto yy178;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy178;
				if (yych <= 'G') goto yy845;
				goto yy178;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy845;
					goto yy178;
				} else {
					if (yych <= 'R') goto yy845;
					if (yych <= 'T') goto yy178;
					goto yy845;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy845;
				if (yych <= 'Y') goto yy178;
				goto yy845;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy178;
					goto yy845;
				} else {
					if (yych == 'g') goto yy845;
					goto yy178;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy178;
				if (yych <= 'r') goto yy845;
				goto yy178;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy845;
					goto yy178;
				} else {
					if (yych == 'y') goto yy178;
					goto yy845;
				}
			}
		}
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy984;
	goto yy53;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy985;
	if (yych == 'i') goto yy985;
	goto yy520;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy986;
	if (yych == 'u') goto yy986;
	goto yy520;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy987;
	if (yych == 'e') goto yy987;
	goto yy520;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy988;
	if (yych == 'r') goto yy988;
	goto yy520;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy989;
	if (yych == 'u') goto yy989;
	goto yy520;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy695;
	if (yych == 'y') goto yy695;
	goto yy520;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy695;
	if (yych == 'e') goto yy695;
	goto yy520;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy990;
	if (yych == 'c') goto yy990;
	goto yy520;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy991;
	if (yych == 'o') goto yy991;
	goto yy520;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy852;
	if (yych == 't') goto yy852;
	goto yy520;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy861;
	if (yych <= '7') goto yy992;
yy861:
	YYDEBUG(861, *YYCURSOR);
#line 1246 "parse_date.db.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 16674 "parse_date.db.c"
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy994;
	if (yych == 'g') goto yy994;
	goto yy53;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy232;
	if (yych == 'y') goto yy232;
	goto yy53;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy232;
	if (yych == 'r') goto yy232;
	goto yy53;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy995;
	if (yych <= '2') goto yy996;
	if (yych <= '3') goto yy997;
	goto yy53;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy998;
	goto yy53;
yy867:
	YYDEBUG(867, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy868:
	YYDEBUG(868, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy265;
		goto yy53;
	} else {
		if (yych <= '_') goto yy265;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy867;
		goto yy53;
	}
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy125;
	if (yych == 'r') goto yy125;
	goto yy53;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy125;
	if (yych == 'r') goto yy914;
	goto yy868;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy915;
	if (yych == 'y') goto yy915;
	goto yy53;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy917;
	if (yych == 'r') goto yy917;
	goto yy53;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy918;
	if (yych == 'i') goto yy918;
	goto yy53;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy919;
	if (yych == 'u') goto yy919;
	goto yy53;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy920;
	if (yych == 'n') goto yy920;
	goto yy53;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy921;
	if (yych == 'n') goto yy921;
	goto yy53;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy922;
	if (yych == 't') goto yy922;
	goto yy53;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy923;
	if (yych == 'c') goto yy923;
	goto yy53;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy918;
	if (yych == 'n') goto yy918;
	goto yy53;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy924;
	if (yych == 'u') goto yy924;
	goto yy53;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy925;
	if (yych == 'e') goto yy925;
	goto yy53;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy926;
		goto yy927;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy926;
		if (yych <= 'e') goto yy927;
		goto yy53;
	}
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy919;
	if (yych == 'a') goto yy919;
	goto yy53;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy606;
	if (yych == 'h') goto yy606;
	goto yy53;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy915;
	if (yych == 'y') goto yy928;
	goto yy868;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy917;
	if (yych == 'r') goto yy929;
	goto yy868;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy918;
	if (yych == 'i') goto yy930;
	goto yy868;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy919;
	if (yych == 'u') goto yy931;
	goto yy868;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy920;
	if (yych == 'n') goto yy932;
	goto yy868;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy921;
	if (yych == 'n') goto yy933;
	goto yy868;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy922;
	if (yych == 't') goto yy934;
	goto yy868;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy923;
	if (yych == 'c') goto yy935;
	goto yy868;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy918;
	if (yych == 'n') goto yy930;
	goto yy868;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy924;
	if (yych == 'u') goto yy936;
	goto yy868;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy925;
	if (yych == 'e') goto yy937;
	goto yy868;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy868;
		if (yych <= 'D') goto yy926;
		goto yy927;
	} else {
		if (yych <= 'c') goto yy868;
		if (yych <= 'd') goto yy938;
		if (yych <= 'e') goto yy939;
		goto yy868;
	}
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy919;
	if (yych == 'a') goto yy931;
	goto yy868;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy606;
	if (yych == 'h') goto yy948;
	goto yy868;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy125;
	if (yych == 'y') goto yy125;
	goto yy53;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy125;
	if (yych == 'y') goto yy914;
	goto yy868;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy871;
	if (yych == 'a') goto yy885;
	goto yy868;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy872;
		if (yych <= 'Q') goto yy868;
		goto yy873;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy868;
			goto yy886;
		} else {
			if (yych == 'r') goto yy887;
			goto yy868;
		}
	}
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy874;
	if (yych == 'o') goto yy888;
	goto yy868;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy875;
		if (yych <= 'N') goto yy868;
		goto yy876;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy868;
			goto yy889;
		} else {
			if (yych == 'o') goto yy890;
			goto yy868;
		}
	}
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy877;
			goto yy868;
		} else {
			if (yych <= 'E') goto yy878;
			if (yych <= 'T') goto yy868;
			goto yy879;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy891;
			goto yy868;
		} else {
			if (yych <= 'e') goto yy892;
			if (yych == 'u') goto yy893;
			goto yy868;
		}
	}
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy880;
		if (yych <= 'T') goto yy868;
		goto yy881;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy868;
			goto yy894;
		} else {
			if (yych == 'u') goto yy895;
			goto yy868;
		}
	}
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy882;
	if (yych == 'e') goto yy896;
	goto yy868;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy883;
	if (yych == 'e') goto yy897;
	goto yy868;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy760;
		goto yy601;
	} else {
		if (yych <= '9') goto yy1000;
		if (yych <= ':') goto yy760;
		goto yy601;
	}
yy910:
	YYDEBUG(910, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy760;
		goto yy601;
	} else {
		if (yych <= '0') goto yy1001;
		if (yych == ':') goto yy760;
		goto yy601;
	}
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy601;
	if (yych <= '9') goto yy1001;
	goto yy601;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1001;
	goto yy601;
yy913:
	YYDEBUG(913, *YYCURSOR);
	++YYCURSOR;
	goto yy601;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy265;
		goto yy126;
	} else {
		if (yych <= '_') goto yy265;
		if (yych <= '`') goto yy126;
		if (yych <= 'z') goto yy867;
		goto yy126;
	}
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1002;
	if (yych == 's') goto yy1002;
yy916:
	YYDEBUG(916, *YYCURSOR);
#line 1352 "parse_date.db.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 17097 "parse_date.db.c"
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1003;
	if (yych == 't') goto yy1003;
	goto yy53;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy1004;
	if (yych == 'd') goto yy1004;
	goto yy916;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy915;
	if (yych == 'r') goto yy915;
	goto yy53;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1002;
		if (yych <= 'T') goto yy916;
		goto yy1005;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy916;
			goto yy1002;
		} else {
			if (yych == 'u') goto yy1005;
			goto yy916;
		}
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy1004;
		if (yych <= 'S') goto yy916;
		goto yy1006;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy916;
			goto yy1004;
		} else {
			if (yych == 't') goto yy1006;
			goto yy916;
		}
	}
yy922:
	YYDEBUG(922, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1007;
	if (yych == 'u') goto yy1007;
	goto yy916;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1008;
		if (yych <= 'R') goto yy916;
		goto yy1002;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy916;
			goto yy1008;
		} else {
			if (yych == 's') goto yy1002;
			goto yy916;
		}
	}
yy924:
	YYDEBUG(924, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1009;
	if (yych == 'r') goto yy1009;
	goto yy916;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy1010;
	if (yych == 's') goto yy1010;
	goto yy916;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy1011;
	if (yych == 'n') goto yy1011;
	goto yy916;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy915;
	if (yych == 'k') goto yy915;
	goto yy53;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy916;
			goto yy265;
		} else {
			if (yych == 'S') goto yy1002;
			goto yy916;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			goto yy867;
		} else {
			if (yych <= 's') goto yy1012;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1003;
	if (yych == 't') goto yy1013;
	goto yy868;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy916;
			goto yy265;
		} else {
			if (yych == 'D') goto yy1004;
			goto yy916;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			goto yy867;
		} else {
			if (yych <= 'd') goto yy1014;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy915;
	if (yych == 'r') goto yy928;
	goto yy868;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'R') {
			if (yych == '/') goto yy265;
			goto yy916;
		} else {
			if (yych <= 'S') goto yy1002;
			if (yych == 'U') goto yy1005;
			goto yy916;
		}
	} else {
		if (yych <= 's') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			if (yych <= 'r') goto yy867;
			goto yy1012;
		} else {
			if (yych == 'u') goto yy1015;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy933:
	YYDEBUG(933, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'C') {
			if (yych == '/') goto yy265;
			goto yy916;
		} else {
			if (yych <= 'D') goto yy1004;
			if (yych == 'T') goto yy1006;
			goto yy916;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			if (yych <= 'c') goto yy867;
			goto yy1014;
		} else {
			if (yych == 't') goto yy1016;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy934:
	YYDEBUG(934, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy916;
			goto yy265;
		} else {
			if (yych == 'U') goto yy1007;
			goto yy916;
		}
	} else {
		if (yych <= 't') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			goto yy867;
		} else {
			if (yych <= 'u') goto yy1017;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'N') {
			if (yych == '/') goto yy265;
			goto yy916;
		} else {
			if (yych <= 'O') goto yy1008;
			if (yych == 'S') goto yy1002;
			goto yy916;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			if (yych <= 'n') goto yy867;
			goto yy1018;
		} else {
			if (yych == 's') goto yy1012;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy936:
	YYDEBUG(936, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy916;
			goto yy265;
		} else {
			if (yych == 'R') goto yy1009;
			goto yy916;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			goto yy867;
		} else {
			if (yych <= 'r') goto yy1019;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy937:
	YYDEBUG(937, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy916;
			goto yy265;
		} else {
			if (yych == 'S') goto yy1010;
			goto yy916;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			goto yy867;
		} else {
			if (yych <= 's') goto yy1020;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy938:
	YYDEBUG(938, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy916;
			goto yy265;
		} else {
			if (yych == 'N') goto yy1011;
			goto yy916;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= '_') goto yy265;
			if (yych <= '`') goto yy916;
			goto yy867;
		} else {
			if (yych <= 'n') goto yy1021;
			if (yych <= 'z') goto yy867;
			goto yy916;
		}
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy915;
	if (yych == 'k') goto yy928;
	goto yy868;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1022;
	if (yych == 't') goto yy1022;
	goto yy53;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1022;
	if (yych == 't') goto yy1023;
	goto yy868;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy606;
	if (yych == 's') goto yy606;
	goto yy53;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy606;
	if (yych == 's') goto yy948;
	goto yy868;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy951;
	if (yych == 'y') goto yy951;
	goto yy53;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy869;
	if (yych == 'e') goto yy869;
	goto yy53;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy951;
	if (yych == 'y') goto yy953;
	goto yy868;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy869;
	if (yych == 'e') goto yy870;
	goto yy868;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'h') {
		if (yych <= '`') {
			if (yych <= '/') {
				if (yych <= '.') goto yy607;
				goto yy265;
			} else {
				if (yych == '_') goto yy265;
				goto yy607;
			}
		} else {
			if (yych <= 'e') {
				if (yych == 'd') goto yy901;
				goto yy867;
			} else {
				if (yych <= 'f') goto yy902;
				if (yych <= 'g') goto yy867;
				goto yy903;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy867;
				goto yy904;
			} else {
				if (yych <= 'r') goto yy867;
				if (yych <= 's') goto yy905;
				goto yy906;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'w') goto yy907;
				goto yy867;
			} else {
				if (yych <= 'y') goto yy908;
				if (yych <= 'z') goto yy867;
				goto yy607;
			}
		}
	}
yy949:
	YYDEBUG(949, *YYCURSOR);
	++YYCURSOR;
	goto yy683;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1024;
	if (yych == 'w') goto yy1024;
	goto yy53;
yy951:
	YYDEBUG(951, *YYCURSOR);
	++YYCURSOR;
	goto yy281;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1024;
	if (yych == 'w') goto yy1026;
	goto yy868;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy265;
		goto yy281;
	} else {
		if (yych <= '_') goto yy265;
		if (yych <= '`') goto yy281;
		if (yych <= 'z') goto yy867;
		goto yy281;
	}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy944;
	if (yych == 'a') goto yy944;
	goto yy53;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy944;
	if (yych == 'a') goto yy946;
	goto yy868;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1027;
	if (yych == 'a') goto yy1027;
	goto yy53;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1027;
	if (yych == 'a') goto yy1028;
	goto yy868;
yy958:
	YYDEBUG(958, *YYCURSOR);
	++YYCURSOR;
	goto yy489;
yy959:
	YYDEBUG(959, *YYCURSOR);
	++YYCURSOR;
	goto yy204;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1029;
	goto yy53;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy491;
			goto yy963;
		} else {
			if (yych == 'T') goto yy1030;
			goto yy491;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1031;
			if (yych <= 'q') goto yy491;
			goto yy1031;
		} else {
			if (yych <= 's') goto yy1032;
			if (yych <= 't') goto yy1033;
			goto yy491;
		}
	}
yy962:
	YYDEBUG(962, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy491;
		} else {
			if (yych == 'T') goto yy1030;
			goto yy491;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1031;
			if (yych <= 'q') goto yy491;
			goto yy1031;
		} else {
			if (yych <= 's') goto yy1032;
			if (yych <= 't') goto yy1033;
			goto yy491;
		}
	}
yy963:
	YYDEBUG(963, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1030;
		if (yych <= 'm') goto yy491;
		goto yy1031;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy491;
			goto yy1031;
		} else {
			if (yych <= 's') goto yy1032;
			if (yych <= 't') goto yy1033;
			goto yy491;
		}
	}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy1034;
		goto yy1035;
	} else {
		if (yych <= '3') goto yy1036;
		if (yych <= '9') goto yy963;
		goto yy53;
	}
yy965:
	YYDEBUG(965, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'I') goto yy985;
		if (yych == 'i') goto yy985;
		goto yy520;
	}
yy966:
	YYDEBUG(966, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'U') goto yy986;
		if (yych == 'u') goto yy986;
		goto yy520;
	}
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'E') goto yy987;
		if (yych == 'e') goto yy987;
		goto yy520;
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'R') goto yy988;
		if (yych == 'r') goto yy988;
		goto yy520;
	}
yy969:
	YYDEBUG(969, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'U') goto yy989;
		if (yych == 'u') goto yy989;
		goto yy520;
	}
yy970:
	YYDEBUG(970, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'Y') goto yy695;
		if (yych == 'y') goto yy695;
		goto yy520;
	}
yy971:
	YYDEBUG(971, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'E') goto yy695;
		if (yych == 'e') goto yy695;
		goto yy520;
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'C') goto yy990;
		if (yych == 'c') goto yy990;
		goto yy520;
	}
yy973:
	YYDEBUG(973, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy865;
	goto yy520;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'O') goto yy991;
		if (yych == 'o') goto yy991;
		goto yy520;
	}
yy975:
	YYDEBUG(975, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy865;
		goto yy520;
	} else {
		if (yych <= 'T') goto yy967;
		if (yych == 't') goto yy967;
		goto yy520;
	}
yy976:
	YYDEBUG(976, *YYCURSOR);
	++YYCURSOR;
	goto yy845;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy978;
		if (yych <= '9') goto yy980;
		if (yych >= 'n') goto yy1037;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1037;
		} else {
			if (yych <= 's') goto yy1038;
			if (yych <= 't') goto yy1039;
		}
	}
yy978:
	YYDEBUG(978, *YYCURSOR);
#line 1073 "parse_date.db.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 17829 "parse_date.db.c"
yy979:
	YYDEBUG(979, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy978;
		if (yych <= '1') goto yy980;
		if (yych <= 'm') goto yy978;
		goto yy1037;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy978;
			goto yy1037;
		} else {
			if (yych <= 's') goto yy1038;
			if (yych <= 't') goto yy1039;
			goto yy978;
		}
	}
yy980:
	YYDEBUG(980, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1037;
		goto yy978;
	} else {
		if (yych <= 'r') goto yy1037;
		if (yych <= 's') goto yy1038;
		if (yych <= 't') goto yy1039;
		goto yy978;
	}
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy1040;
		goto yy1041;
	} else {
		if (yych <= '3') goto yy1042;
		if (yych <= '9') goto yy980;
		goto yy53;
	}
yy982:
	YYDEBUG(982, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy177;
				if (yych >= ' ') goto yy177;
			} else {
				if (yych == 'D') goto yy179;
				if (yych >= 'F') goto yy180;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy71;
				if (yych >= 'M') goto yy181;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy182;
				} else {
					if (yych <= 'T') goto yy1043;
					if (yych >= 'W') goto yy81;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy83;
				if (yych >= 'd') goto yy179;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy180;
				} else {
					if (yych == 'h') goto yy71;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy181;
				if (yych <= 'r') goto yy983;
				if (yych <= 's') goto yy182;
				goto yy1044;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy81;
				} else {
					if (yych == 'y') goto yy83;
				}
			}
		}
	}
yy983:
	YYDEBUG(983, *YYCURSOR);
#line 1176 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 17943 "parse_date.db.c"
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1045;
	if (yych <= '2') goto yy1046;
	if (yych <= '3') goto yy1047;
	goto yy53;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy695;
	if (yych == 'l') goto yy695;
	goto yy53;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1048;
	if (yych == 's') goto yy1048;
	goto yy53;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy991;
	if (yych == 'm') goto yy991;
	goto yy53;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy989;
	if (yych != 'u') goto yy53;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1049;
	if (yych == 'a') goto yy1049;
	goto yy53;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy695;
	if (yych == 'h') goto yy695;
	goto yy53;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1050;
	if (yych == 'b') goto yy1050;
	goto yy53;
yy992:
	YYDEBUG(992, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(993, *YYCURSOR);
#line 1227 "parse_date.db.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 18015 "parse_date.db.c"
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1051;
	if (yych == 'h') goto yy1051;
	goto yy53;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy1052;
	goto yy53;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1052;
	goto yy53;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1052;
	goto yy53;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy999;
	if (yych <= '9') goto yy1054;
yy999:
	YYDEBUG(999, *YYCURSOR);
#line 1265 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 18059 "parse_date.db.c"
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1055;
			if (yych <= 0x1F) goto yy601;
			goto yy1055;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy601;
				goto yy1057;
			} else {
				if (yych == '+') goto yy1058;
				goto yy601;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy1058;
			if (yych <= '.') goto yy760;
			if (yych <= '9') goto yy601;
			goto yy760;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy601;
				goto yy1059;
			} else {
				if (yych <= '`') goto yy601;
				if (yych <= 'z') goto yy1060;
				goto yy601;
			}
		}
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1055;
			goto yy601;
		} else {
			if (yych <= ' ') goto yy1055;
			if (yych == '(') goto yy1057;
			goto yy601;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy601;
			if (yych <= '-') goto yy1058;
			goto yy601;
		} else {
			if (yych <= 'Z') goto yy1059;
			if (yych <= '`') goto yy601;
			if (yych <= 'z') goto yy1060;
			goto yy601;
		}
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	++YYCURSOR;
	goto yy916;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1061;
		if (yych <= 'M') goto yy53;
		goto yy1062;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy1061;
		} else {
			if (yych == 'n') goto yy1062;
			goto yy53;
		}
	}
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1063;
	if (yych == 'a') goto yy1063;
	goto yy53;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1064;
	if (yych == 't') goto yy1064;
	goto yy53;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy915;
	if (yych == 'h') goto yy915;
	goto yy53;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1010;
	if (yych == 'r') goto yy1010;
	goto yy53;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1065;
	if (yych == 'n') goto yy1065;
	goto yy53;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1010;
	if (yych != 's') goto yy53;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1004;
	if (yych == 'd') goto yy1004;
	goto yy53;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1009;
	if (yych == 'e') goto yy1009;
	goto yy53;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy265;
		goto yy916;
	} else {
		if (yych <= '_') goto yy265;
		if (yych <= '`') goto yy916;
		if (yych <= 'z') goto yy867;
		goto yy916;
	}
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1061;
		if (yych <= 'M') goto yy868;
		goto yy1062;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy868;
			goto yy1066;
		} else {
			if (yych == 'n') goto yy1067;
			goto yy868;
		}
	}
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1063;
	if (yych == 'a') goto yy1068;
	goto yy868;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1064;
	if (yych == 't') goto yy1069;
	goto yy868;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy915;
	if (yych == 'h') goto yy928;
	goto yy868;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1010;
	if (yych == 'r') goto yy1020;
	goto yy868;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1065;
	if (yych == 'n') goto yy1070;
	goto yy868;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1010;
	if (yych != 's') goto yy868;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1004;
	if (yych == 'd') goto yy1014;
	goto yy868;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1009;
	if (yych == 'e') goto yy1019;
	goto yy868;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	++YYCURSOR;
	goto yy640;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy265;
		goto yy640;
	} else {
		if (yych <= '_') goto yy265;
		if (yych <= '`') goto yy640;
		if (yych <= 'z') goto yy867;
		goto yy640;
	}
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	++YYCURSOR;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
#line 913 "parse_date.db.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18296 "parse_date.db.c"
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy265;
		goto yy1025;
	} else {
		if (yych <= '_') goto yy265;
		if (yych <= '`') goto yy1025;
		if (yych <= 'z') goto yy867;
		goto yy1025;
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1071;
	if (yych == 'y') goto yy1071;
	goto yy53;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1071;
	if (yych == 'y') goto yy1073;
	goto yy868;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1074;
	goto yy53;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1075;
	if (yych <= '2') goto yy1076;
	if (yych <= '9') goto yy1077;
	goto yy53;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1078;
	goto yy53;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1078;
	goto yy53;
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1078;
	goto yy53;
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy491;
			if (yych <= '0') goto yy963;
			goto yy1079;
		} else {
			if (yych == 'T') goto yy1030;
			goto yy491;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1031;
			if (yych <= 'q') goto yy491;
			goto yy1031;
		} else {
			if (yych <= 's') goto yy1032;
			if (yych <= 't') goto yy1033;
			goto yy491;
		}
	}
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy491;
			goto yy1079;
		} else {
			if (yych == 'T') goto yy1030;
			goto yy491;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1031;
			if (yych <= 'q') goto yy491;
			goto yy1031;
		} else {
			if (yych <= 's') goto yy1032;
			if (yych <= 't') goto yy1033;
			goto yy491;
		}
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy491;
			goto yy1079;
		} else {
			if (yych == 'T') goto yy1030;
			goto yy491;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1031;
			if (yych <= 'q') goto yy491;
			goto yy1031;
		} else {
			if (yych <= 's') goto yy1032;
			if (yych <= 't') goto yy1033;
			goto yy491;
		}
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1080;
	goto yy53;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1080;
	goto yy53;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1080;
	goto yy53;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '0') {
			if (yych <= '/') goto yy978;
			goto yy980;
		} else {
			if (yych <= '9') goto yy1081;
			if (yych <= 'm') goto yy978;
			goto yy1037;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy978;
			goto yy1037;
		} else {
			if (yych <= 's') goto yy1038;
			if (yych <= 't') goto yy1039;
			goto yy978;
		}
	}
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy978;
		if (yych <= '9') goto yy1081;
		if (yych <= 'm') goto yy978;
		goto yy1037;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy978;
			goto yy1037;
		} else {
			if (yych <= 's') goto yy1038;
			if (yych <= 't') goto yy1039;
			goto yy978;
		}
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy978;
		if (yych <= '1') goto yy1081;
		if (yych <= 'm') goto yy978;
		goto yy1037;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy978;
			goto yy1037;
		} else {
			if (yych <= 's') goto yy1038;
			if (yych <= 't') goto yy1039;
			goto yy978;
		}
	}
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy1082;
			goto yy1083;
		} else {
			if (yych <= '9') goto yy1084;
			if (yych <= 'G') goto yy53;
			goto yy243;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy244;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy243;
			if (yych == 'u') goto yy244;
			goto yy53;
		}
	}
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy1085;
			goto yy1086;
		} else {
			if (yych <= '9') goto yy1087;
			if (yych <= 'G') goto yy53;
			goto yy243;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy244;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy243;
			if (yych == 'u') goto yy244;
			goto yy53;
		}
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy1088;
	goto yy53;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1088;
	goto yy53;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1088;
	goto yy53;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy695;
	if (yych == 't') goto yy695;
	goto yy53;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1089;
	if (yych == 'r') goto yy1089;
	goto yy53;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1090;
	if (yych == 'e') goto yy1090;
	goto yy53;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy371;
	if (yych == 't') goto yy371;
	goto yy53;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1053, *YYCURSOR);
#line 1278 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 18601 "parse_date.db.c"
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy999;
	if (yych <= '9') goto yy1091;
	goto yy999;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	YYDEBUG(1056, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1055;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy1055;
			if (yych != '(') goto yy53;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy53;
			if (yych <= '-') goto yy1058;
			goto yy53;
		} else {
			if (yych <= 'Z') goto yy1059;
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy1060;
			goto yy53;
		}
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy1060;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy1060;
	goto yy53;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1092;
	if (yych <= '2') goto yy1093;
	if (yych <= '9') goto yy1094;
	goto yy53;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy913;
		goto yy601;
	} else {
		if (yych <= 'Z') goto yy1095;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy1096;
		goto yy601;
	}
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy913;
		goto yy601;
	} else {
		if (yych <= 'Z') goto yy1095;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy1095;
		goto yy601;
	}
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1062;
	if (yych != 'n') goto yy53;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1097;
	if (yych == 'i') goto yy1097;
	goto yy53;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1002;
	if (yych == 'y') goto yy1002;
	goto yy53;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy915;
	if (yych == 'e') goto yy915;
	goto yy53;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy915;
	if (yych == 'd') goto yy915;
	goto yy53;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1062;
	if (yych != 'n') goto yy868;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1097;
	if (yych == 'i') goto yy1098;
	goto yy868;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1002;
	if (yych == 'y') goto yy1012;
	goto yy868;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy915;
	if (yych == 'e') goto yy928;
	goto yy868;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy915;
	if (yych == 'd') goto yy928;
	goto yy868;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	++YYCURSOR;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
#line 870 "parse_date.db.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18748 "parse_date.db.c"
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy265;
		goto yy1072;
	} else {
		if (yych <= '_') goto yy265;
		if (yych <= '`') goto yy1072;
		if (yych <= 'z') goto yy867;
		goto yy1072;
	}
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1099;
	goto yy53;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1077;
	if (yych <= ':') goto yy1100;
	goto yy53;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1077;
	if (yych == ':') goto yy1100;
	goto yy53;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1100;
	goto yy53;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1030;
	goto yy491;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1101;
		if (yych <= 'm') goto yy978;
		goto yy1031;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy978;
			goto yy1031;
		} else {
			if (yych <= 's') goto yy1032;
			if (yych <= 't') goto yy1033;
			goto yy978;
		}
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	++YYCURSOR;
	goto yy978;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1080;
		if (yych <= 'm') goto yy978;
		goto yy1037;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy978;
			goto yy1037;
		} else {
			if (yych <= 's') goto yy1038;
			if (yych <= 't') goto yy1039;
			goto yy978;
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1102;
	if (yych <= '9') goto yy1084;
	if (yych <= ':') goto yy1103;
	goto yy53;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '3') goto yy1102;
		goto yy1104;
	} else {
		if (yych == ':') goto yy1103;
		goto yy53;
	}
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1104;
	if (yych == ':') goto yy1103;
	goto yy53;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1105;
	if (yych <= '9') goto yy1087;
	goto yy53;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1105;
	if (yych <= '5') goto yy1104;
	goto yy53;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1104;
	goto yy53;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1106;
	goto yy53;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy695;
	if (yych == 'y') goto yy695;
	goto yy53;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy695;
	if (yych == 'r') goto yy695;
	goto yy53;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy999;
	if (yych <= '9') goto yy1107;
	goto yy999;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy601;
	if (yych <= '9') goto yy1094;
	if (yych <= ':') goto yy1108;
	goto yy601;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy601;
		if (yych >= '4') goto yy1109;
	} else {
		if (yych <= '9') goto yy913;
		if (yych <= ':') goto yy1108;
		goto yy601;
	}
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy601;
	if (yych <= '5') goto yy1109;
	if (yych <= '9') goto yy913;
	if (yych <= ':') goto yy1108;
	goto yy601;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy913;
		goto yy601;
	} else {
		if (yych <= 'Z') goto yy1110;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy1110;
		goto yy601;
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy601;
			goto yy913;
		} else {
			if (yych == '/') goto yy1111;
			goto yy601;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1110;
			if (yych <= '^') goto yy601;
			goto yy1111;
		} else {
			if (yych <= '`') goto yy601;
			if (yych <= 'z') goto yy1112;
			goto yy601;
		}
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1113;
	if (yych == 'g') goto yy1113;
	goto yy53;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1113;
	if (yych == 'g') goto yy1114;
	goto yy868;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1115;
	if (yych <= '2') goto yy1116;
	goto yy53;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1117;
	if (yych <= '9') goto yy1118;
	goto yy53;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1119;
	if (yych <= '2') goto yy1120;
	if (yych <= '9') goto yy1077;
	goto yy53;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1121;
	if (yych <= '9') goto yy1122;
	if (yych >= ';') goto yy53;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1123;
	goto yy53;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1122;
	goto yy53;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1121;
	if (yych <= '9') goto yy1122;
	goto yy53;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1124;
	if (yych <= '2') goto yy1125;
	goto yy53;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	++YYCURSOR;
	goto yy999;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy601;
	if (yych <= '5') goto yy1109;
	if (yych <= '9') goto yy913;
	goto yy601;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy601;
	if (yych <= '9') goto yy913;
	goto yy601;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy913;
		goto yy601;
	} else {
		if (yych <= 'Z') goto yy1126;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy1126;
		goto yy601;
	}
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy1127;
	goto yy53;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy601;
			goto yy913;
		} else {
			if (yych == '/') goto yy1111;
			goto yy601;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1126;
			if (yych <= '^') goto yy601;
			goto yy1111;
		} else {
			if (yych <= '`') goto yy601;
			if (yych <= 'z') goto yy1128;
			goto yy601;
		}
	}
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1129;
	if (yych == 'h') goto yy1129;
	goto yy53;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1129;
	if (yych == 'h') goto yy1130;
	goto yy868;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1131;
	goto yy53;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1131;
	goto yy53;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1118;
	if (yych <= ':') goto yy1132;
	goto yy53;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1132;
	goto yy53;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1133;
	if (yych <= ':') goto yy1100;
	goto yy53;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1133;
	if (yych == ':') goto yy1100;
	goto yy53;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1132;
	if (yych <= '6') goto yy1134;
	if (yych >= ':') goto yy53;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1135;
	if (yych <= '6') goto yy1136;
	goto yy53;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1137;
	goto yy53;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1138;
	goto yy53;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1138;
	goto yy53;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy913;
		goto yy601;
	} else {
		if (yych <= 'Z') goto yy1139;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy1139;
		goto yy601;
	}
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy1140;
	goto yy53;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy601;
			goto yy913;
		} else {
			if (yych == '/') goto yy1111;
			goto yy601;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1139;
			if (yych <= '^') goto yy601;
			goto yy1111;
		} else {
			if (yych <= '`') goto yy601;
			if (yych <= 'z') goto yy1142;
			goto yy601;
		}
	}
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy915;
	if (yych == 't') goto yy915;
	goto yy53;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy915;
	if (yych == 't') goto yy928;
	goto yy868;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1143;
	goto yy53;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1144;
	if (yych <= '6') goto yy1146;
	if (yych <= '9') goto yy1147;
	goto yy53;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1148;
	goto yy53;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1144;
	if (yych <= '5') goto yy1135;
	if (yych <= '6') goto yy1136;
	goto yy53;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1147;
	goto yy53;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1147;
	goto yy53;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1122;
	goto yy53;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1103;
	goto yy53;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy913;
		goto yy601;
	} else {
		if (yych <= 'Z') goto yy1149;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy1149;
		goto yy601;
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yyaccept = 16;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1141, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy1111;
		goto yy601;
	} else {
		if (yych <= '_') goto yy1111;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy1140;
		goto yy601;
	}
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy601;
			goto yy913;
		} else {
			if (yych == '/') goto yy1111;
			goto yy601;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1149;
			if (yych <= '^') goto yy601;
			goto yy1111;
		} else {
			if (yych <= '`') goto yy601;
			if (yych <= 'z') goto yy1150;
			goto yy601;
		}
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1151;
	goto yy53;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1145;
	if (yych <= '9') goto yy1147;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
#line 1188 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 19362 "parse_date.db.c"
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1145;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	++YYCURSOR;
	goto yy1145;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1152;
	if (yych <= '9') goto yy1118;
	goto yy53;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy913;
	goto yy601;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy913;
		if (yych <= '.') goto yy601;
		goto yy1111;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy601;
			goto yy1111;
		} else {
			if (yych <= '`') goto yy601;
			if (yych <= 'z') goto yy1153;
			goto yy601;
		}
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1155;
	goto yy53;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1156;
	if (yych <= ':') goto yy1132;
	goto yy53;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1154, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy1111;
		goto yy53;
	} else {
		if (yych <= '_') goto yy1111;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy1153;
		goto yy53;
	}
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1157;
	goto yy53;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1158;
	goto yy53;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1159;
	if (yych <= '6') goto yy1160;
	goto yy53;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1161;
	if (yych <= '6') goto yy1162;
	if (yych <= '9') goto yy1147;
	goto yy53;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1163;
	goto yy53;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1163;
	goto yy53;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1145;
	if (yych <= '9') goto yy1164;
	goto yy1145;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1164;
	goto yy1145;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1165;
	if (yych == ' ') goto yy1165;
	goto yy53;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1167;
	goto yy1145;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(1166, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1165;
		if (yych <= 0x1F) goto yy53;
		goto yy1165;
	} else {
		if (yych <= '+') {
			if (yych <= '*') goto yy53;
			goto yy1168;
		} else {
			if (yych == '-') goto yy1168;
			goto yy53;
		}
	}
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1169;
	goto yy53;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1171;
	if (yych <= '2') goto yy1173;
	if (yych <= '9') goto yy1174;
	goto yy53;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yyaccept = 26;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(1170, *YYCURSOR);
	if (yych <= ',') {
		if (yych == '+') goto yy1175;
		goto yy1145;
	} else {
		if (yych <= '-') goto yy1175;
		if (yych <= '/') goto yy1145;
		if (yych <= '9') goto yy1169;
		goto yy1145;
	}
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1172;
	if (yych <= '9') goto yy1174;
	if (yych <= ':') goto yy1176;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
#line 1291 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 19565 "parse_date.db.c"
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1172;
		if (yych >= '4') goto yy1177;
	} else {
		if (yych <= '9') goto yy1178;
		if (yych <= ':') goto yy1176;
		goto yy1172;
	}
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1172;
	if (yych <= '5') goto yy1177;
	if (yych <= '9') goto yy1178;
	if (yych <= ':') goto yy1176;
	goto yy1172;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1179;
	if (yych <= '2') goto yy1180;
	if (yych <= '9') goto yy1181;
	goto yy53;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1172;
	if (yych <= '5') goto yy1177;
	if (yych <= '9') goto yy1178;
	goto yy1172;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1172;
	if (yych >= ':') goto yy1172;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	++YYCURSOR;
	goto yy1172;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1145;
	if (yych <= '9') goto yy1181;
	if (yych <= ':') goto yy1182;
	goto yy1145;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1145;
		if (yych >= '4') goto yy1144;
	} else {
		if (yych <= '9') goto yy1147;
		if (yych <= ':') goto yy1182;
		goto yy1145;
	}
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1145;
	if (yych <= '5') goto yy1144;
	if (yych <= '9') goto yy1147;
	if (yych >= ';') goto yy1145;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1145;
	if (yych <= '5') goto yy1144;
	if (yych <= '9') goto yy1147;
	goto yy1145;
}
#line 1444 "parse_date.db.re"

}

#define YYMAXFILL 29


timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
