/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TextOverAttrInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class AttrOverNodeInfo
extends NodeOverNodeInfo
implements Attr {
    public String getName() {
        if (this.node.getNodeKind() == 13) {
            String local = this.node.getLocalPart();
            if (local.equals("")) {
                return "xmlns";
            }
            return "xmlns:" + local;
        }
        return this.node.getDisplayName();
    }

    public String getValue() {
        return this.node.getStringValue();
    }

    public boolean hasChildNodes() {
        return true;
    }

    public Node getFirstChild() {
        return new TextOverAttrInfo(this);
    }

    public Node getLastChild() {
        return this.getFirstChild();
    }

    public NodeList getChildNodes() {
        ArrayList<Node> list = new ArrayList<Node>(1);
        list.add(this.getFirstChild());
        return new DOMNodeList(list);
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String value) throws DOMException {
        AttrOverNodeInfo.disallowUpdate();
    }

    public boolean isId() {
        ContentTypeTest idTest = new ContentTypeTest(2, (SchemaType)BuiltInAtomicType.ID, this.node.getConfiguration());
        idTest.setMatchDTDTypes(true);
        return idTest.matches(this.node);
    }

    public Element getOwnerElement() {
        if (this.node.getNodeKind() == 2 || this.node.getNodeKind() == 13) {
            return (Element)((Object)AttrOverNodeInfo.wrap(this.node.getParent()));
        }
        throw new UnsupportedOperationException("This method is defined only on attribute and namespace nodes");
    }

    public TypeInfo getSchemaTypeInfo() {
        int annotation = this.node.getTypeAnnotation();
        if (annotation == -1 || (annotation & 0x40000000) != 0) {
            return null;
        }
        return new TypeInfoImpl(this.node.getConfiguration(), this.node.getConfiguration().getSchemaType(annotation));
    }
}

