(* Strings as int arrays *)
type t = int array

let create n =
  Array.make n 0

let sub (s : t) start len =
  Array.sub s start len

let length (s : t) =
  Array.length s

let blit (src : t) srcoff dst dstoff len =
  Array.blit src srcoff dst dstoff len

let get s i =
  char_of_int (Array.get s i)

let set s i c =
  Array.set s i (int_of_char c)

let make l c =
  Array.make l (int_of_char c)

