/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.InstanceProfileListForRoleRequest;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMInstanceProfileListForRoleDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMInstanceProfileListForRoleDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof InstanceProfileListForRoleRequest) {
            InstanceProfileListForRoleRequest listRequest = (InstanceProfileListForRoleRequest)request;
            LOG.debug((Object)("Listing Instance Profiles for role: " + listRequest));
            ListInstanceProfilesForRoleRequest iipListRequest = new ListInstanceProfilesForRoleRequest();
            iipListRequest.setRoleName(listRequest.getRoleName());
            iipListRequest.setMarker(listRequest.getMarker());
            iipListRequest.setMaxItems(listRequest.getMaxItems());
            ListInstanceProfilesForRoleResult result = this.getClient().listInstanceProfilesForRole(iipListRequest);
            for (InstanceProfile prof : result.getInstanceProfiles()) {
                LOG.info((Object)prof.getArn());
            }
            LOG.info((Object)("IsTruncated: " + result.getIsTruncated()));
            if (result.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + result.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

