/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.JProgressBar;
import org.fest.assertions.Assertions;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JProgressBarIndeterminateQuery;
import org.fest.swing.driver.JProgressBarMinimumAndMaximumQuery;
import org.fest.swing.driver.JProgressBarStringQuery;
import org.fest.swing.driver.JProgressBarValueQuery;
import org.fest.swing.driver.JProgressBarWaitUntilIsDeterminate;
import org.fest.swing.driver.JProgressBarWaitUntilValueIsEqualToExpectedTask;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.Pair;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProgressBarDriver
extends JComponentDriver
implements TextDisplayDriver<JProgressBar> {
    private static final Timeout DEFAULT_TIMEOUT = Timeout.timeout(30L, TimeUnit.SECONDS);
    private static final String TEXT_PROPERTY = "string";

    public JProgressBarDriver(Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(JProgressBar progressBar, String expected) {
        TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(JProgressBar progressBar, Pattern pattern) {
        TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY)).matches(pattern);
    }

    @RunsInEDT
    public void requireValue(JProgressBar progressBar, int value) {
        Assertions.assertThat((int)JProgressBarValueQuery.valueOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "value")).isEqualTo(value);
    }

    @RunsInEDT
    public void requireIndeterminate(JProgressBar progressBar) {
        this.requireIndeterminate(progressBar, true);
    }

    @RunsInEDT
    public void requireDeterminate(JProgressBar progressBar) {
        this.requireIndeterminate(progressBar, false);
    }

    @RunsInEDT
    private void requireIndeterminate(JProgressBar progressBar, boolean indeterminate) {
        Assertions.assertThat((boolean)JProgressBarIndeterminateQuery.isIndeterminate(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "indeterminate")).isEqualTo(indeterminate);
    }

    @RunsInEDT
    public void waitUntilValueIs(JProgressBar progressBar, int value) {
        this.waitUntilValueIs(progressBar, value, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilValueIs(JProgressBar progressBar, int value, Timeout timeout) {
        this.assertIsInBetweenMinAndMax(progressBar, value);
        this.validateIsNotNull(timeout);
        JProgressBarWaitUntilValueIsEqualToExpectedTask.waitUntilValueIsEqualToExpected(progressBar, value, timeout);
    }

    @RunsInEDT
    private void assertIsInBetweenMinAndMax(JProgressBar progressBar, int value) {
        Pair<Integer, Integer> minAndMax = JProgressBarMinimumAndMaximumQuery.minimumAndMaximumOf(progressBar);
        this.assertIsInBetweenMinAndMax(value, (Integer)minAndMax.i, (Integer)minAndMax.ii);
    }

    private void assertIsInBetweenMinAndMax(int value, int min, int max) {
        if (value >= min && value <= max) {
            return;
        }
        throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Value <", value, "> should be between <[", min, ", ", max, "]>"}));
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(JProgressBar progressBar) {
        this.waitUntilIsDeterminate(progressBar, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(JProgressBar progressBar, Timeout timeout) {
        this.validateIsNotNull(timeout);
        JProgressBarWaitUntilIsDeterminate.waitUntilValueIsDeterminate(progressBar, timeout);
    }

    private void validateIsNotNull(Timeout timeout) {
        if (timeout == null) {
            throw new NullPointerException("Timeout should not be null");
        }
    }

    @Override
    @RunsInEDT
    public String textOf(JProgressBar progressBar) {
        return JProgressBarStringQuery.stringOf(progressBar);
    }
}

