/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import org.fest.reflect.core.Reflection;
import org.fest.swing.util.SystemPropertyWriter;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AWTExceptionHandlerInstaller {
    private static final SystemPropertyWriter WRITER = new SystemPropertyWriter();

    public static void installAWTExceptionHandler(Class<?> exceptionHandlerType) {
        AWTExceptionHandlerInstaller.installAWTExceptionHandler(exceptionHandlerType, WRITER);
    }

    @VisibleForTesting
    static void installAWTExceptionHandler(Class<?> exceptionHandlerType, SystemPropertyWriter writer) {
        try {
            Reflection.constructor().in(exceptionHandlerType).info();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("The exception handler type should have a default constructor");
        }
        writer.updateSystemProperty("sun.awt.exception.handler", exceptionHandlerType.getName());
    }

    private AWTExceptionHandlerInstaller() {
    }
}

