/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

public enum PolymorphicStatus {
    POLYMORPHIC,
    MONOMORPHIC,
    DISCORDANT,
    UNKNOWN;

    static final PolymorphicStatus[][] consensusTransitions;

    private static void addTransition(PolymorphicStatus s1, PolymorphicStatus s2, PolymorphicStatus result) {
        PolymorphicStatus.consensusTransitions[s1.ordinal()][s2.ordinal()] = result;
        PolymorphicStatus.consensusTransitions[s2.ordinal()][s1.ordinal()] = result;
    }

    public PolymorphicStatus makeConsensus(PolymorphicStatus otherStatus) {
        return consensusTransitions[this.ordinal()][otherStatus.ordinal()];
    }

    public boolean isPolymorphic() {
        return this == POLYMORPHIC;
    }

    public boolean isMonomorphic() {
        return this == MONOMORPHIC;
    }

    public boolean isDiscordant() {
        return this == DISCORDANT;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    static {
        consensusTransitions = new PolymorphicStatus[PolymorphicStatus.values().length][PolymorphicStatus.values().length];
        for (PolymorphicStatus s1 : PolymorphicStatus.values()) {
            for (PolymorphicStatus s2 : PolymorphicStatus.values()) {
                PolymorphicStatus.addTransition(s1, s2, DISCORDANT);
            }
        }
        for (PolymorphicStatus s : PolymorphicStatus.values()) {
            PolymorphicStatus.addTransition(s, s, s);
            PolymorphicStatus.addTransition(s, UNKNOWN, s);
        }
    }
}

