/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITMPP1
extends TiffProfileClassIT {
    public TiffProfileClassITMPP1() {
        this._profileText = "TIFF/IT-MP/P1 (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesNewSubfileType(tiffIFD, 0L)) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 0)) {
            return false;
        }
        if (!this.satisfiesOrientation(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesDotRange(tiffIFD, 0, 255)) {
            return false;
        }
        int n = tiffIFD.getImageColorIndicator();
        if (n != 0 && n != 1) {
            return false;
        }
        if (n == 1 && tiffIFD.getImageColorValue() == -1) {
            return false;
        }
        int[] nArray2 = tiffIFD.getPixelIntensityRange();
        if (nArray2 == null || nArray2.length < 2) {
            return false;
        }
        if (nArray2[0] != 0 || nArray2[1] != 255) {
            return false;
        }
        return tiffIFD.getDocumentName() == null && nisoImageMetadata.getScannerModelName() == null && tiffIFD.getPageName() == null && nisoImageMetadata.getHostComputer() == null && tiffIFD.getSite() == null && tiffIFD.getColorSequence() == null && tiffIFD.getIT8Header() == null;
    }
}

