/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileClassY
extends TiffProfile {
    public TiffProfileClassY() {
        this._profileText = "Extension YCbCr (Class Y)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getImageWidth() == -1L || nisoImageMetadata.getImageLength() == -1L || nisoImageMetadata.getStripOffsets() == null || nisoImageMetadata.getRowsPerStrip() == -1L || nisoImageMetadata.getStripByteCounts() == null || nisoImageMetadata.getXSamplingFrequency() == null || nisoImageMetadata.getYSamplingFrequency() == null || nisoImageMetadata.getReferenceBlackWhite() == null) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 3)) {
            return false;
        }
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray.length < 3 || nArray[0] != 8 || nArray[1] != 8 || nArray[2] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 5, 6})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 6)) {
            return false;
        }
        return this.satisfiesResolutionUnit(tiffIFD, new int[]{1, 2, 3});
    }
}

