      SUBROUTINE SIHEX2 (TYPE,GPT,NIP,STRSPT,ISTORE)
C
C     PHASE 2 STRESS DATA RECOVERY FOR IHEX1, IHEX2, AND IHEX3 ELEMENTS
C
C           TYPE = 1    IHEX1
C           TYPE = 2    IHEX2
C           TYPE = 3    IHEX3
C
C***********************************************************************
C
C     ARRAY ESTA CONTAINS THE FOLLOWING WHERE NGP IS THE NUMBER OF
C     GRID POINTS
C
C           ELEMENT ID
C           NGP SIL NUMBERS
C           NGP VALUES OF THE SHAPE FUNCTIONS AT THIS STRESS POINT
C           REFERENCE TEMPERATURE
C           6 THERMAL STRESS COEFFICIENTS
C           NGP 6 BY 3 MATRICES RELATING STRESS TO DISPLACEMENTS
C                 AT THIS STRESS POINT (STORED ROW-WISE)
C
C     PHIOUT STARTS AT ESTA(101)
C
C***********************************************************************
C
C
      INTEGER    TYPE        ,IESTA(1)   ,ISTRS(11)  ,STRSPT     ,
     1           SIL         ,OLDEID     ,EQEXIN     ,EXTRNL(32) ,
     2           EQU         ,IFRVEC(11) ,EJECT      ,ISHD(7)    ,
     3           TYP(4)      ,DUMMY
C
      REAL       GPT(1)      ,STRESS(10) ,SIGP(3)    ,SMAT(3,3)  ,
     1           CSIG(6)     ,FRLAST(2)
      REAL       STORE(384)  ,SIGS(126)  ,CSIGS(126)
      DIMENSION  EX20G3(567) ,EX2031(132),EX2032(127),EX2033(127),
     1           EX2034(127) ,EX2035(54)
      DIMENSION  EX8G3(243)  ,EX8G31(132),EX8G32(111)
      DIMENSION  EX20G2(168) ,EX2021(152),EX2022(16)
      DIMENSION  EX8G2(72)
      DIMENSION  EX8G4(576)  ,EX8G41(152),EX8G42(152),EX8G43(152),
     1           EX8G44(120)
      DIMENSION  EX20G4(1344),EX2041(152),EX2042(152),EX2043(152),
     1           EX2044(152) ,EX2045(152),EX2046(152),EX2047(152),
     2           EX2048(152) ,EX2049(128)
C
      COMMON /SYSTEM/ IBFSZ  ,NOUT       ,IDM(9)     ,LINE
C
      COMMON /ZZZZZZ/ Z(1)
C
      COMMON /SDR2X2/ BBB(4) ,EQEXIN
C
      COMMON /SDR2X4/ CCC(35),IVEC       ,IVECN       ,
     1                JTEMP  ,DDD(13)    ,KTYPE       ,SKIP(56)   ,
     2                ISOPL
C
      COMMON /SDR2X7/ ESTA(649)
C
      COMMON /SDR2X8/ IEND   ,DUMMY(32)  ,SIG(6)      ,
     2                STRSPX ,NGP        ,LEQX        ,
     3                NEQX   ,IPTS       ,MXLEQ       ,
     4                L      ,I          ,J           ,
     5                SIL    ,KLO        ,KHI         ,
     6                K      ,KX         ,TEMP        ,
     7                SA     ,SB         ,SC          ,
     8                SN     ,SO         ,P           ,
     9                Q      ,R          ,A           ,
     A                B      ,PHI        ,X           ,
     B                COSPHI ,S          ,T           ,
     C                V      ,DCOS(3,3)  ,RM          ,
     D                RX     ,RY         ,RZ          ,
     E                RXY    ,RYZ        ,RZX         ,
     F                ITRL(7),EQU(200)
      COMMON /SDR2X9/ NCHK   ,ISUB       ,ILD         ,
     1                FRTMEI(2)          ,TWOTOP      ,
     2                FNCHK
C     COMMON /SDRETT/ DUM(9) ,OLDEID
C
C
      EQUIVALENCE     (IESTA(1),ESTA(1)) ,(STRESS(1),ISTRS(1),ESTA(101))
C
      EQUIVALENCE     (SIGP(1), SA)      ,(SIG(1) , SX),
     1                (SIG(2) , SY)      ,(SIG(3) , SZ),
     2                (SIG(4) ,SXY)      ,(SIG(5) ,SYZ),
     3                (SIG(6) ,SZX)      ,(CSIG(1),IFRVEC(6))
C
      EQUIVALENCE     (LSUB,ISHD(1))     ,(LLD ,ISHD(2)),
     3                (FRLAST(1),ISHD(6))
      EQUIVALENCE     (EX20G3(  1),EX2031(1)),(EX20G3(133),EX2032(1)),
     1                (EX20G3(260),EX2033(1)),(EX20G3(387),EX2034(1)),
     2                (EX20G3(514),EX2035(1))
      EQUIVALENCE     (EX8G3(   1),EX8G31(1)),(EX8G3( 133),EX8G32(1))
      EQUIVALENCE     (EX20G2(  1),EX2021(1)),(EX20G2(153),EX2022(1))
      EQUIVALENCE     (EX8G4(   1),EX8G41(1)),(EX8G4( 153),EX8G42(1)),
     1                (EX8G4( 305),EX8G43(1)),(EX8G4( 457),EX8G44(1))
      EQUIVALENCE     (EX20G4(  1),EX2041(1)),(EX20G4(153),EX2042(1)),
     1                (EX20G4(305),EX2043(1)),(EX20G4(457),EX2044(1)),
     2                (EX20G4(609),EX2045(1)),(EX20G4(761),EX2046(1)),
     3                (EX20G4(913),EX2047(1)),(EX20G4(1065),EX2048(1)),
     4                (EX20G4(1217),EX2049(1))
      DATA EX8G2/
     * -.0490,  .1830,  .1830, -.6830,  .1830, -.6830, -.6830, 2.5490,
     *  .1830, -.6830, -.6830, 2.5490, -.0490,  .1830,  .1830, -.6830,
     * -.6830, 2.5490,  .1830, -.6830,  .1830, -.6830, -.0490,  .1830,
     *  .1830, -.6830, -.0490,  .1830, -.6830, 2.5490,  .1830, -.6830,
     *  .1830, -.0490, -.6830,  .1830, -.6830,  .1830, 2.5490, -.6830,
     * -.6830,  .1830, 2.5490, -.6830,  .1830, -.0490, -.6830,  .1830,
     * 2.5490, -.6830, -.6830,  .1830, -.6830,  .1830,  .1830, -.0490,
     * -.6830,  .1830,  .1830, -.0490, 2.5490, -.6830, -.6830,  .1830,
     *  .1250,  .1250,  .1250,  .1250,  .1250,  .1250,  .1250,  .1250/
      DATA EX8G31/
     *  .0066, -.0235,  .0522, -.0235,  .0835, -.1852,  .0522, -.1852,
     *  .4108, -.0235,  .0835, -.1852,  .0835, -.2963,  .6573, -.1852,
     *  .6573,-1.4580,  .0522, -.1852,  .4108, -.1852,  .6573,-1.4580,
     *  .4108,-1.4580, 3.2341,
     *  .0522, -.1852,  .4108, -.1852,  .6573,-1.4580,  .4108,-1.4580,
     * 3.2341, -.0235,  .0835, -.1852,  .0835, -.2963,  .6573, -.1852,
     *  .6573,-1.4580,  .0066, -.0235,  .0522, -.0235,  .0835, -.1852,
     *  .0522, -.1852,  .4108,
     *  .4108,-1.4580, 3.2341, -.1852,  .6573,-1.4580,  .0522, -.1852,
     *  .4108, -.1852,  .6573,-1.4580,  .0835, -.2963,  .6573, -.0235,
     *  .0835, -.1852,  .0522, -.1852,  .4108, -.0235,  .0835, -.1852,
     *  .0066, -.0235,  .0522,
     *  .0522, -.1852,  .4108, -.0235,  .0835, -.1852,  .0066, -.0235,
     *  .0522, -.1852,  .6573,-1.4580,  .0835, -.2963,  .6573, -.0235,
     *  .0835, -.1852,  .4108,-1.4580, 3.2341, -.1852,  .6573,-1.4580,
     *  .0522, -.1852,  .4108,
     *  .0522, -.0235,  .0066, -.1852,  .0835, -.0235,  .4108, -.1852,
     *  .0522, -.1852,  .0835, -.0235,  .6573, -.2963,  .0835,-1.4580,
     *  .6573, -.1852,  .4108, -.1852,  .0522,-1.4580,  .6573, -.1852/
      DATA EX8G32/
     * 3.2341,-1.4580,  .4108,
     *  .4108, -.1852,  .0522,-1.4580,  .6573, -.1852, 3.2341,-1.4580,
     *  .4108, -.1852,  .0835, -.0235,  .6573, -.2963,  .0835,-1.4580,
     *  .6573, -.1852,  .0522, -.0235,  .0066, -.1852,  .0835, -.0235,
     *  .4108, -.1852,  .0522,
     * 3.2341,-1.4580,  .4108,-1.4580,  .6573, -.1852,  .4108, -.1852,
     *  .0522,-1.4580,  .6573, -.1852,  .6573, -.2963,  .0835, -.1852,
     *  .0835, -.0235,  .4108, -.1852,  .0522, -.1852,  .0835, -.0235,
     *  .0522, -.0235,  .0066,
     *  .4108, -.1852,  .0522, -.1852,  .0835, -.0235,  .0522, -.0235,
     *  .0066,-1.4580,  .6573, -.1852,  .6573, -.2963,  .0835, -.1852,
     *  .0835, -.0235, 3.2341,-1.4580,  .4108,-1.4580,  .6573, -.1852,
     *  .4108, -.1852,  .0522,
     * -.0000,  .0000,  .0000,  .0000,  .0000,  .0000,  .0000, -.0000,
     * -.0000, 0.0000,  .0000,  .0000,  .0000, 1.0000,  .0000, -.0000,
     * -.0000, -.0000,  .0000,  .0000, -.0000, -.0000,  .0000,  .0000,
     * -.0000,  .0000,  .0000/
      DATA EX8G41/
     * -.0015,  .0052, -.0106,  .0198,  .0052, -.0183,  .0371, -.0697,
     * -.0106,  .0371, -.0754,  .1415,  .0198, -.0697,  .1415, -.2656,
     *  .0052, -.0183,  .0371, -.0697, -.0183,  .0644, -.1307,  .2452,
     *  .0371, -.1307,  .2653, -.4978, -.0697,  .2452, -.4978,  .9342,
     * -.0106,  .0371, -.0754,  .1415,  .0371, -.1307,  .2653, -.4978,
     * -.0754,  .2653, -.5386, 1.0107,  .1415, -.4978, 1.0107,-1.8966,
     *  .0198, -.0697,  .1415, -.2656, -.0697,  .2452, -.4978,  .9342,
     *  .1415, -.4978, 1.0107,-1.8966, -.2656,  .9342,-1.8966, 3.5591,
     *  .0198, -.0697,  .1415, -.2656, -.0697,  .2452, -.4978,  .9342,
     *  .1415, -.4978, 1.0107,-1.8966, -.2656,  .9342,-1.8966, 3.5591,
     * -.0106,  .0371, -.0754,  .1415,  .0371, -.1307,  .2653, -.4978,
     * -.0754,  .2653, -.5386, 1.0107,  .1415, -.4978, 1.0107,-1.8966,
     *  .0052, -.0183,  .0371, -.0697, -.0183,  .0644, -.1307,  .2452,
     *  .0371, -.1307,  .2653, -.4978, -.0697,  .2452, -.4978,  .9342,
     * -.0015,  .0052, -.0106,  .0198,  .0052, -.0183,  .0371, -.0697,
     * -.0106,  .0371, -.0754,  .1415,  .0198, -.0697,  .1415, -.2656,
     * -.2656,  .9342,-1.8966, 3.5591,  .1415, -.4978, 1.0107,-1.8966,
     * -.0697,  .2452, -.4978,  .9342,  .0198, -.0697,  .1415, -.2656,
     *  .1415, -.4978, 1.0107,-1.8966, -.0754,  .2653, -.5386, 1.0107/
      DATA EX8G42/
     *  .0371, -.1307,  .2653, -.4978, -.0106,  .0371, -.0754,  .1415,
     * -.0697,  .2452, -.4978,  .9342,  .0371, -.1307,  .2653, -.4978,
     * -.0183,  .0644, -.1307,  .2452,  .0052, -.0183,  .0371, -.0697,
     *  .0198, -.0697,  .1415, -.2656, -.0106,  .0371, -.0754,  .1415,
     *  .0052, -.0183,  .0371, -.0697, -.0015,  .0052, -.0106,  .0198,
     *  .0198, -.0697,  .1415, -.2656, -.0106,  .0371, -.0754,  .1415,
     *  .0052, -.0183,  .0371, -.0697, -.0015,  .0052, -.0106,  .0198,
     * -.0697,  .2452, -.4978,  .9342,  .0371, -.1307,  .2653, -.4978,
     * -.0183,  .0644, -.1307,  .2452,  .0052, -.0183,  .0371, -.0697,
     *  .1415, -.4978, 1.0107,-1.8966, -.0754,  .2653, -.5386, 1.0107,
     *  .0371, -.1307,  .2653, -.4978, -.0106,  .0371, -.0754,  .1415,
     * -.2656,  .9342,-1.8966, 3.5591,  .1415, -.4978, 1.0107,-1.8966,
     * -.0697,  .2452, -.4978,  .9342,  .0198, -.0697,  .1415, -.2656,
     *  .0198, -.0106,  .0052, -.0015, -.0697,  .0371, -.0183,  .0052,
     *  .1415, -.0754,  .0371, -.0106, -.2656,  .1415, -.0697,  .0198,
     * -.0697,  .0371, -.0183,  .0052,  .2452, -.1307,  .0644, -.0183,
     * -.4978,  .2653, -.1307,  .0371,  .9342, -.4978,  .2452, -.0697,
     *  .1415, -.0754,  .0371, -.0106, -.4978,  .2653, -.1307,  .0371,
     * 1.0107, -.5386,  .2653, -.0754,-1.8966, 1.0107, -.4978,  .1415/
      DATA EX8G43/
     * -.2656,  .1415, -.0697,  .0198,  .9342, -.4978,  .2452, -.0697,
     *-1.8966, 1.0107, -.4978,  .1415, 3.5591,-1.8966,  .9342, -.2656,
     * -.2656,  .1415, -.0697,  .0198,  .9342, -.4978,  .2452, -.0697,
     *-1.8966, 1.0107, -.4978,  .1415, 3.5591,-1.8966,  .9342, -.2656,
     *  .1415, -.0754,  .0371, -.0106, -.4978,  .2653, -.1307,  .0371,
     * 1.0107, -.5386,  .2653, -.0754,-1.8966, 1.0107, -.4978,  .1415,
     * -.0697,  .0371, -.0183,  .0052,  .2452, -.1307,  .0644, -.0183,
     * -.4978,  .2653, -.1307,  .0371,  .9342, -.4978,  .2452, -.0697,
     *  .0198, -.0106,  .0052, -.0015, -.0697,  .0371, -.0183,  .0052,
     *  .1415, -.0754,  .0371, -.0106, -.2656,  .1415, -.0697,  .0198,
     * 3.5591,-1.8966,  .9342, -.2656,-1.8966, 1.0107, -.4978,  .1415,
     *  .9342, -.4978,  .2452, -.0697, -.2656,  .1415, -.0697,  .0198,
     *-1.8966, 1.0107, -.4978,  .1415, 1.0107, -.5386,  .2653, -.0754,
     * -.4978,  .2653, -.1307,  .0371,  .1415, -.0754,  .0371, -.0106,
     *  .9342, -.4978,  .2452, -.0697, -.4978,  .2653, -.1307,  .0371,
     *  .2452, -.1307,  .0644, -.0183, -.0697,  .0371, -.0183,  .0052,
     * -.2656,  .1415, -.0697,  .0198,  .1415, -.0754,  .0371, -.0106,
     * -.0697,  .0371, -.0183,  .0052,  .0198, -.0106,  .0052, -.0015,
     * -.2656,  .1415, -.0697,  .0198,  .1415, -.0754,  .0371, -.0106/
      DATA EX8G44/
     * -.0697,  .0371, -.0183,  .0052,  .0198, -.0106,  .0052, -.0015,
     *  .9342, -.4978,  .2452, -.0697, -.4978,  .2653, -.1307,  .0371,
     *  .2452, -.1307,  .0644, -.0183, -.0697,  .0371, -.0183,  .0052,
     *-1.8966, 1.0107, -.4978,  .1415, 1.0107, -.5386,  .2653, -.0754,
     * -.4978,  .2653, -.1307,  .0371,  .1415, -.0754,  .0371, -.0106,
     * 3.5591,-1.8966,  .9342, -.2656,-1.8966, 1.0107, -.4978,  .1415,
     *  .9342, -.4978,  .2452, -.0697, -.2656,  .1415, -.0697,  .0198,
     * -.0008,  .0050,  .0050, -.0008,  .0050, -.0324, -.0324,  .0050,
     *  .0050, -.0324, -.0324,  .0050, -.0008,  .0050,  .0050, -.0008,
     *  .0050, -.0324, -.0324,  .0050, -.0324,  .2078,  .2078, -.0324,
     * -.0324,  .2078,  .2078, -.0324,  .0050, -.0324, -.0324,  .0050,
     *  .0050, -.0324, -.0324,  .0050, -.0324,  .2078,  .2078, -.0324,
     * -.0324,  .2078,  .2078, -.0324,  .0050, -.0324, -.0324,  .0050,
     * -.0008,  .0050,  .0050, -.0008,  .0050, -.0324, -.0324,  .0050,
     *  .0050, -.0324, -.0324,  .0050, -.0008,  .0050,  .0050, -.0008/
      DATA EX2021/
     * -.0490,  .1830,  .1830, -.6830,  .1830, -.6830, -.6830, 2.5490,
     *  .0670, -.2500, -.2500,  .9330,  .0670, -.2500, -.2500,  .9330,
     *  .1830, -.6830, -.6830, 2.5490, -.0490,  .1830,  .1830, -.6830,
     * -.2500,  .9330, -.2500,  .9330,  .0670, -.2500,  .0670, -.2500,
     * -.6830, 2.5490,  .1830, -.6830,  .1830, -.6830, -.0490,  .1830,
     * -.2500,  .9330,  .0670, -.2500, -.2500,  .9330,  .0670, -.2500,
     *  .1830, -.6830, -.0490,  .1830, -.6830, 2.5490,  .1830, -.6830,
     *  .0670, -.2500,  .0670, -.2500, -.2500,  .9330, -.2500,  .9330,
     *  .0670,  .0670, -.2500, -.2500, -.2500, -.2500,  .9330,  .9330,
     * -.2500, -.2500,  .9330,  .9330,  .0670,  .0670, -.2500, -.2500,
     *  .9330,  .9330, -.2500, -.2500, -.2500, -.2500,  .0670,  .0670,
     * -.2500, -.2500,  .0670,  .0670,  .9330,  .9330, -.2500, -.2500,
     *  .1830, -.0490, -.6830,  .1830, -.6830,  .1830, 2.5490, -.6830,
     * -.2500,  .0670,  .9330, -.2500, -.2500,  .0670,  .9330, -.2500,
     * -.6830,  .1830, 2.5490, -.6830,  .1830, -.0490, -.6830,  .1830,
     *  .9330, -.2500,  .9330, -.2500, -.2500,  .0670, -.2500,  .0670,
     * 2.5490, -.6830, -.6830,  .1830, -.6830,  .1830,  .1830, -.0490,
     *  .9330, -.2500, -.2500,  .0670,  .9330, -.2500, -.2500,  .0670,
     * -.6830,  .1830,  .1830, -.0490, 2.5490, -.6830, -.6830,  .1830/
      DATA EX2022/
     * -.2500,  .0670, -.2500,  .0670,  .9330, -.2500,  .9330, -.2500,
     *  .1250,  .1250,  .1250,  .1250,  .1250,  .1250,  .1250,  .1250/
      DATA EX2031/
     *  .0066, -.0235,  .0522, -.0235,  .0835, -.1852,  .0522, -.1852,
     *  .4108, -.0235,  .0835, -.1852,  .0835, -.2963,  .6573, -.1852,
     *  .6573,-1.4580,  .0522, -.1852,  .4108, -.1852,  .6573,-1.4580,
     *  .4108,-1.4580, 3.2341,
     * -.0000,  .0000, -.0000,  .0000, -.0000,  .0000, -.0000,  .0000,
     * -.0000,  .0353, -.1252,  .2778, -.1252,  .4444, -.9859,  .2778,
     * -.9859, 2.1869,  .0000,  .0000, -.0000, -.0000,  .0000,  .0000,
     * -.0000,  .0000,  .0000,
     *  .0522, -.1852,  .4108, -.1852,  .6573,-1.4580,  .4108,-1.4580,
     * 3.2341, -.0235,  .0835, -.1852,  .0835, -.2963,  .6573, -.1852,
     *  .6573,-1.4580,  .0066, -.0235,  .0522, -.0235,  .0835, -.1852,
     *  .0522, -.1852,  .4108,
     * -.0000,  .0000,  .0000,  .2778, -.9859, 2.1869,  .0000,  .0000,
     * -.0000,  .0000,  .0000,  .0000, -.1252,  .4444, -.9859, -.0000,
     *  .0000, -.0000, -.0000, -.0000,  .0000,  .0353, -.1252,  .2778,
     * -.0000,  .0000, -.0000,
     *  .4108,-1.4580, 3.2341, -.1852,  .6573,-1.4580,  .0522, -.1852,
     *  .4108, -.1852,  .6573,-1.4580,  .0835, -.2963,  .6573, -.0235,
     *  .0835, -.1852,  .0522, -.1852,  .4108, -.0235,  .0835, -.1852/
      DATA EX2032/
     *  .0066, -.0235,  .0522,
     * -.0000,  .0000, -.0000,  .0000, -.0000,  .0000,  .0000,  .0000,
     * -.0000,  .2778, -.9859, 2.1869, -.1252,  .4444, -.9859,  .0353,
     * -.1252,  .2778,  .0000,  .0000,  .0000, -.0000,  .0000,  .0000,
     * -.0000,  .0000, -.0000,
     *  .0522, -.1852,  .4108, -.0235,  .0835, -.1852,  .0066, -.0235,
     *  .0522, -.1852,  .6573,-1.4580,  .0835, -.2963,  .6573, -.0235,
     *  .0835, -.1852,  .4108,-1.4580, 3.2341, -.1852,  .6573,-1.4580,
     *  .0522, -.1852,  .4108,
     * -.0000,  .0000, -.0000,  .0353, -.1252,  .2778,  .0000,  .0000,
     * -.0000,  .0000,  .0000,  .0000, -.1252,  .4444, -.9859, -.0000,
     *  .0000, -.0000, -.0000,  .0000,  .0000,  .2778, -.9859, 2.1869,
     * -.0000, -.0000, -.0000,
     * -.0000,  .0353,  .0000,  .0000, -.1252,  .0000, -.0000,  .2778,
     * -.0000,  .0000, -.1252,  .0000,  .0000,  .4444,  .0000,  .0000,
     * -.9859, -.0000,  .0000,  .2778, -.0000, -.0000, -.9859, -.0000,
     *  .0000, 2.1869,  .0000,
     * -.0000,  .2778, -.0000,  .0000, -.9859,  .0000, -.0000, 2.1869,
     *  .0000,  .0000, -.1252,  .0000,  .0000,  .4444,  .0000,  .0000/
      DATA EX2033/
     * -.9859, -.0000, -.0000,  .0353,  .0000, -.0000, -.1252, -.0000,
     * -.0000,  .2778, -.0000,
     * -.0000, 2.1869, -.0000,  .0000, -.9859,  .0000, -.0000,  .2778,
     * -.0000,  .0000, -.9859,  .0000,  .0000,  .4444,  .0000, -.0000,
     * -.1252, -.0000, -.0000,  .2778,  .0000, -.0000, -.1252, -.0000,
     * -.0000,  .0353,  .0000,
     * -.0000,  .2778, -.0000,  .0000, -.1252,  .0000, -.0000,  .0353,
     *  .0000,  .0000, -.9859,  .0000,  .0000,  .4444,  .0000, -.0000,
     * -.1252, -.0000,  .0000, 2.1869,  .0000, -.0000, -.9859, -.0000,
     * -.0000,  .2778,  .0000,
     *  .0522, -.0235,  .0066, -.1852,  .0835, -.0235,  .4108, -.1852,
     *  .0522, -.1852,  .0835, -.0235,  .6573, -.2963,  .0835,-1.4580,
     *  .6573, -.1852,  .4108, -.1852,  .0522,-1.4580,  .6573, -.1852,
     * 3.2341,-1.4580,  .4108,
     * -.0000,  .0000, -.0000,  .0000, -.0000,  .0000, -.0000,  .0000,
     * -.0000,  .2778, -.1252,  .0353, -.9859,  .4444, -.1252, 2.1869,
     * -.9859,  .2778,  .0000,  .0000,  .0000, -.0000,  .0000,  .0000,
     * -.0000,  .0000,  .0000,
     *  .4108, -.1852,  .0522,-1.4580,  .6573, -.1852, 3.2341,-1.4580/
      DATA EX2034/
     *  .4108, -.1852,  .0835, -.0235,  .6573, -.2963,  .0835,-1.4580,
     *  .6573, -.1852,  .0522, -.0235,  .0066, -.1852,  .0835, -.0235,
     *  .4108, -.1852,  .0522,
     * -.0000,  .0000, -.0000, 2.1869, -.9859,  .2778, -.0000,  .0000,
     * -.0000,  .0000,  .0000,  .0000, -.9859,  .4444, -.1252, -.0000,
     *  .0000, -.0000, -.0000, -.0000, -.0000,  .2778, -.1252,  .0353,
     * -.0000,  .0000, -.0000,
     * 3.2341,-1.4580,  .4108,-1.4580,  .6573, -.1852,  .4108, -.1852,
     *  .0522,-1.4580,  .6573, -.1852,  .6573, -.2963,  .0835, -.1852,
     *  .0835, -.0235,  .4108, -.1852,  .0522, -.1852,  .0835, -.0235,
     *  .0522, -.0235,  .0066,
     * -.0000,  .0000, -.0000,  .0000, -.0000,  .0000, -.0000,  .0000,
     * -.0000, 2.1869, -.9859,  .2778, -.9859,  .4444, -.1252,  .2778,
     * -.1252,  .0353,  .0000,  .0000,  .0000, -.0000,  .0000,  .0000,
     * -.0000,  .0000, -.0000,
     *  .4108, -.1852,  .0522, -.1852,  .0835, -.0235,  .0522, -.0235,
     *  .0066,-1.4580,  .6573, -.1852,  .6573, -.2963,  .0835, -.1852,
     *  .0835, -.0235, 3.2341,-1.4580,  .4108,-1.4580,  .6573, -.1852,
     *  .4108, -.1852,  .0522/
      DATA EX2035/
     * -.0000,  .0000, -.0000,  .2778, -.1252,  .0353, -.0000,  .0000,
     *  .0000,  .0000,  .0000,  .0000, -.9859,  .4444, -.1252, -.0000,
     *  .0000, -.0000,  .0000,  .0000,  .0000, 2.1869, -.9859,  .2778,
     * -.0000, -.0000, -.0000,
     * -.0000,  .0000,  .0000,  .0000,  .0000,  .0000,  .0000, -.0000,
     * -.0000, 0.0000,  .0000,  .0000,  .0000, 1.0000,  .0000, -.0000,
     * -.0000, -.0000,  .0000,  .0000, -.0000, -.0000,  .0000,  .0000,
     * -.0000,  .0000,  .0000/
      DATA EX2041/
     * -.0015,  .0052, -.0106,  .0198,  .0052, -.0183,  .0371, -.0697,
     * -.0106,  .0371, -.0754,  .1415,  .0198, -.0697,  .1415, -.2656,
     *  .0052, -.0183,  .0371, -.0697, -.0183,  .0644, -.1307,  .2452,
     *  .0371, -.1307,  .2653, -.4978, -.0697,  .2452, -.4978,  .9342,
     * -.0106,  .0371, -.0754,  .1415,  .0371, -.1307,  .2653, -.4978,
     * -.0754,  .2653, -.5386, 1.0107,  .1415, -.4978, 1.0107,-1.8966,
     *  .0198, -.0697,  .1415, -.2656, -.0697,  .2452, -.4978,  .9342,
     *  .1415, -.4978, 1.0107,-1.8966, -.2656,  .9342,-1.8966, 3.5591,
     * -.0012,  .0042, -.0086,  .0161,  .0042, -.0148,  .0301, -.0565,
     * -.0086,  .0301, -.0611,  .1147,  .0161, -.0565,  .1147, -.2152,
     *  .0077, -.0270,  .0549, -.1030, -.0270,  .0951, -.1931,  .3624,
     *  .0549, -.1931,  .3921, -.7358, -.1030,  .3624, -.7358, 1.3808,
     *  .0077, -.0270,  .0549, -.1030, -.0270,  .0951, -.1931,  .3624,
     *  .0549, -.1931,  .3921, -.7358, -.1030,  .3624, -.7358, 1.3808,
     * -.0012,  .0042, -.0086,  .0161,  .0042, -.0148,  .0301, -.0565,
     * -.0086,  .0301, -.0611,  .1147,  .0161, -.0565,  .1147, -.2152,
     *  .0198, -.0697,  .1415, -.2656, -.0697,  .2452, -.4978,  .9342,
     *  .1415, -.4978, 1.0107,-1.8966, -.2656,  .9342,-1.8966, 3.5591,
     * -.0106,  .0371, -.0754,  .1415,  .0371, -.1307,  .2653, -.4978/
      DATA EX2042/
     * -.0754,  .2653, -.5386, 1.0107,  .1415, -.4978, 1.0107,-1.8966,
     *  .0052, -.0183,  .0371, -.0697, -.0183,  .0644, -.1307,  .2452,
     *  .0371, -.1307,  .2653, -.4978, -.0697,  .2452, -.4978,  .9342,
     * -.0015,  .0052, -.0106,  .0198,  .0052, -.0183,  .0371, -.0697,
     * -.0106,  .0371, -.0754,  .1415,  .0198, -.0697,  .1415, -.2656,
     *  .0161, -.0565,  .1147, -.2152, -.1030,  .3624, -.7358, 1.3808,
     * -.1030,  .3624, -.7358, 1.3808,  .0161, -.0565,  .1147, -.2152,
     * -.0086,  .0301, -.0611,  .1147,  .0549, -.1931,  .3921, -.7358,
     *  .0549, -.1931,  .3921, -.7358, -.0086,  .0301, -.0611,  .1147,
     *  .0042, -.0148,  .0301, -.0565, -.0270,  .0951, -.1931,  .3624,
     * -.0270,  .0951, -.1931,  .3624,  .0042, -.0148,  .0301, -.0565,
     * -.0012,  .0042, -.0086,  .0161,  .0077, -.0270,  .0549, -.1030,
     *  .0077, -.0270,  .0549, -.1030, -.0012,  .0042, -.0086,  .0161,
     * -.2656,  .9342,-1.8966, 3.5591,  .1415, -.4978, 1.0107,-1.8966,
     * -.0697,  .2452, -.4978,  .9342,  .0198, -.0697,  .1415, -.2656,
     *  .1415, -.4978, 1.0107,-1.8966, -.0754,  .2653, -.5386, 1.0107,
     *  .0371, -.1307,  .2653, -.4978, -.0106,  .0371, -.0754,  .1415,
     * -.0697,  .2452, -.4978,  .9342,  .0371, -.1307,  .2653, -.4978,
     * -.0183,  .0644, -.1307,  .2452,  .0052, -.0183,  .0371, -.0697/
      DATA EX2043/
     *  .0198, -.0697,  .1415, -.2656, -.0106,  .0371, -.0754,  .1415,
     *  .0052, -.0183,  .0371, -.0697, -.0015,  .0052, -.0106,  .0198,
     *  .0161, -.0565,  .1147, -.2152, -.0086,  .0301, -.0611,  .1147,
     *  .0042, -.0148,  .0301, -.0565, -.0012,  .0042, -.0086,  .0161,
     * -.1030,  .3624, -.7358, 1.3808,  .0549, -.1931,  .3921, -.7358,
     * -.0270,  .0951, -.1931,  .3624,  .0077, -.0270,  .0549, -.1030,
     * -.1030,  .3624, -.7358, 1.3808,  .0549, -.1931,  .3921, -.7358,
     * -.0270,  .0951, -.1931,  .3624,  .0077, -.0270,  .0549, -.1030,
     *  .0161, -.0565,  .1147, -.2152, -.0086,  .0301, -.0611,  .1147,
     *  .0042, -.0148,  .0301, -.0565, -.0012,  .0042, -.0086,  .0161,
     *  .0198, -.0697,  .1415, -.2656, -.0106,  .0371, -.0754,  .1415,
     *  .0052, -.0183,  .0371, -.0697, -.0015,  .0052, -.0106,  .0198,
     * -.0697,  .2452, -.4978,  .9342,  .0371, -.1307,  .2653, -.4978,
     * -.0183,  .0644, -.1307,  .2452,  .0052, -.0183,  .0371, -.0697,
     *  .1415, -.4978, 1.0107,-1.8966, -.0754,  .2653, -.5386, 1.0107,
     *  .0371, -.1307,  .2653, -.4978, -.0106,  .0371, -.0754,  .1415,
     * -.2656,  .9342,-1.8966, 3.5591,  .1415, -.4978, 1.0107,-1.8966,
     * -.0697,  .2452, -.4978,  .9342,  .0198, -.0697,  .1415, -.2656,
     * -.0012,  .0042, -.0086,  .0161,  .0077, -.0270,  .0549, -.1030/
      DATA EX2044/
     *  .0077, -.0270,  .0549, -.1030, -.0012,  .0042, -.0086,  .0161,
     *  .0042, -.0148,  .0301, -.0565, -.0270,  .0951, -.1931,  .3624,
     * -.0270,  .0951, -.1931,  .3624,  .0042, -.0148,  .0301, -.0565,
     * -.0086,  .0301, -.0611,  .1147,  .0549, -.1931,  .3921, -.7358,
     *  .0549, -.1931,  .3921, -.7358, -.0086,  .0301, -.0611,  .1147,
     *  .0161, -.0565,  .1147, -.2152, -.1030,  .3624, -.7358, 1.3808,
     * -.1030,  .3624, -.7358, 1.3808,  .0161, -.0565,  .1147, -.2152,
     * -.0012,  .0077,  .0077, -.0012,  .0042, -.0270, -.0270,  .0042,
     * -.0086,  .0549,  .0549, -.0086,  .0161, -.1030, -.1030,  .0161,
     *  .0042, -.0270, -.0270,  .0042, -.0148,  .0951,  .0951, -.0148,
     *  .0301, -.1931, -.1931,  .0301, -.0565,  .3624,  .3624, -.0565,
     * -.0086,  .0549,  .0549, -.0086,  .0301, -.1931, -.1931,  .0301,
     * -.0611,  .3921,  .3921, -.0611,  .1147, -.7358, -.7358,  .1147,
     *  .0161, -.1030, -.1030,  .0161, -.0565,  .3624,  .3624, -.0565,
     *  .1147, -.7358, -.7358,  .1147, -.2152, 1.3808, 1.3808, -.2152,
     *  .0161, -.1030, -.1030,  .0161, -.0565,  .3624,  .3624, -.0565,
     *  .1147, -.7358, -.7358,  .1147, -.2152, 1.3808, 1.3808, -.2152,
     * -.0086,  .0549,  .0549, -.0086,  .0301, -.1931, -.1931,  .0301,
     * -.0611,  .3921,  .3921, -.0611,  .1147, -.7358, -.7358,  .1147/
      DATA EX2045/
     *  .0042, -.0270, -.0270,  .0042, -.0148,  .0951,  .0951, -.0148,
     *  .0301, -.1931, -.1931,  .0301, -.0565,  .3624,  .3624, -.0565,
     * -.0012,  .0077,  .0077, -.0012,  .0042, -.0270, -.0270,  .0042,
     * -.0086,  .0549,  .0549, -.0086,  .0161, -.1030, -.1030,  .0161,
     * -.2152, 1.3808, 1.3808, -.2152,  .1147, -.7358, -.7358,  .1147,
     * -.0565,  .3624,  .3624, -.0565,  .0161, -.1030, -.1030,  .0161,
     *  .1147, -.7358, -.7358,  .1147, -.0611,  .3921,  .3921, -.0611,
     *  .0301, -.1931, -.1931,  .0301, -.0086,  .0549,  .0549, -.0086,
     * -.0565,  .3624,  .3624, -.0565,  .0301, -.1931, -.1931,  .0301,
     * -.0148,  .0951,  .0951, -.0148,  .0042, -.0270, -.0270,  .0042,
     *  .0161, -.1030, -.1030,  .0161, -.0086,  .0549,  .0549, -.0086,
     *  .0042, -.0270, -.0270,  .0042, -.0012,  .0077,  .0077, -.0012,
     *  .0161, -.1030, -.1030,  .0161, -.0086,  .0549,  .0549, -.0086,
     *  .0042, -.0270, -.0270,  .0042, -.0012,  .0077,  .0077, -.0012,
     * -.0565,  .3624,  .3624, -.0565,  .0301, -.1931, -.1931,  .0301,
     * -.0148,  .0951,  .0951, -.0148,  .0042, -.0270, -.0270,  .0042,
     *  .1147, -.7358, -.7358,  .1147, -.0611,  .3921,  .3921, -.0611,
     *  .0301, -.1931, -.1931,  .0301, -.0086,  .0549,  .0549, -.0086,
     * -.2152, 1.3808, 1.3808, -.2152,  .1147, -.7358, -.7358,  .1147/
      DATA EX2046/
     * -.0565,  .3624,  .3624, -.0565,  .0161, -.1030, -.1030,  .0161,
     *  .0198, -.0106,  .0052, -.0015, -.0697,  .0371, -.0183,  .0052,
     *  .1415, -.0754,  .0371, -.0106, -.2656,  .1415, -.0697,  .0198,
     * -.0697,  .0371, -.0183,  .0052,  .2452, -.1307,  .0644, -.0183,
     * -.4978,  .2653, -.1307,  .0371,  .9342, -.4978,  .2452, -.0697,
     *  .1415, -.0754,  .0371, -.0106, -.4978,  .2653, -.1307,  .0371,
     * 1.0107, -.5386,  .2653, -.0754,-1.8966, 1.0107, -.4978,  .1415,
     * -.2656,  .1415, -.0697,  .0198,  .9342, -.4978,  .2452, -.0697,
     *-1.8966, 1.0107, -.4978,  .1415, 3.5591,-1.8966,  .9342, -.2656,
     *  .0161, -.0086,  .0042, -.0012, -.0565,  .0301, -.0148,  .0042,
     *  .1147, -.0611,  .0301, -.0086, -.2152,  .1147, -.0565,  .0161,
     * -.1030,  .0549, -.0270,  .0077,  .3624, -.1931,  .0951, -.0270,
     * -.7358,  .3921, -.1931,  .0549, 1.3808, -.7358,  .3624, -.1030,
     * -.1030,  .0549, -.0270,  .0077,  .3624, -.1931,  .0951, -.0270,
     * -.7358,  .3921, -.1931,  .0549, 1.3808, -.7358,  .3624, -.1030,
     *  .0161, -.0086,  .0042, -.0012, -.0565,  .0301, -.0148,  .0042,
     *  .1147, -.0611,  .0301, -.0086, -.2152,  .1147, -.0565,  .0161,
     * -.2656,  .1415, -.0697,  .0198,  .9342, -.4978,  .2452, -.0697,
     *-1.8966, 1.0107, -.4978,  .1415, 3.5591,-1.8966,  .9342, -.2656/
      DATA EX2047/
     *  .1415, -.0754,  .0371, -.0106, -.4978,  .2653, -.1307,  .0371,
     * 1.0107, -.5386,  .2653, -.0754,-1.8966, 1.0107, -.4978,  .1415,
     * -.0697,  .0371, -.0183,  .0052,  .2452, -.1307,  .0644, -.0183,
     * -.4978,  .2653, -.1307,  .0371,  .9342, -.4978,  .2452, -.0697,
     *  .0198, -.0106,  .0052, -.0015, -.0697,  .0371, -.0183,  .0052,
     *  .1415, -.0754,  .0371, -.0106, -.2656,  .1415, -.0697,  .0198,
     * -.2152,  .1147, -.0565,  .0161, 1.3808, -.7358,  .3624, -.1030,
     * 1.3808, -.7358,  .3624, -.1030, -.2152,  .1147, -.0565,  .0161,
     *  .1147, -.0611,  .0301, -.0086, -.7358,  .3921, -.1931,  .0549,
     * -.7358,  .3921, -.1931,  .0549,  .1147, -.0611,  .0301, -.0086,
     * -.0565,  .0301, -.0148,  .0042,  .3624, -.1931,  .0951, -.0270,
     *  .3624, -.1931,  .0951, -.0270, -.0565,  .0301, -.0148,  .0042,
     *  .0161, -.0086,  .0042, -.0012, -.1030,  .0549, -.0270,  .0077,
     * -.1030,  .0549, -.0270,  .0077,  .0161, -.0086,  .0042, -.0012,
     * 3.5591,-1.8966,  .9342, -.2656,-1.8966, 1.0107, -.4978,  .1415,
     *  .9342, -.4978,  .2452, -.0697, -.2656,  .1415, -.0697,  .0198,
     *-1.8966, 1.0107, -.4978,  .1415, 1.0107, -.5386,  .2653, -.0754,
     * -.4978,  .2653, -.1307,  .0371,  .1415, -.0754,  .0371, -.0106,
     *  .9342, -.4978,  .2452, -.0697, -.4978,  .2653, -.1307,  .0371/
      DATA EX2048/
     *  .2452, -.1307,  .0644, -.0183, -.0697,  .0371, -.0183,  .0052,
     * -.2656,  .1415, -.0697,  .0198,  .1415, -.0754,  .0371, -.0106,
     * -.0697,  .0371, -.0183,  .0052,  .0198, -.0106,  .0052, -.0015,
     * -.2152,  .1147, -.0565,  .0161,  .1147, -.0611,  .0301, -.0086,
     * -.0565,  .0301, -.0148,  .0042,  .0161, -.0086,  .0042, -.0012,
     * 1.3808, -.7358,  .3624, -.1030, -.7358,  .3921, -.1931,  .0549,
     *  .3624, -.1931,  .0951, -.0270, -.1030,  .0549, -.0270,  .0077,
     * 1.3808, -.7358,  .3624, -.1030, -.7358,  .3921, -.1931,  .0549,
     *  .3624, -.1931,  .0951, -.0270, -.1030,  .0549, -.0270,  .0077,
     * -.2152,  .1147, -.0565,  .0161,  .1147, -.0611,  .0301, -.0086,
     * -.0565,  .0301, -.0148,  .0042,  .0161, -.0086,  .0042, -.0012,
     * -.2656,  .1415, -.0697,  .0198,  .1415, -.0754,  .0371, -.0106,
     * -.0697,  .0371, -.0183,  .0052,  .0198, -.0106,  .0052, -.0015,
     *  .9342, -.4978,  .2452, -.0697, -.4978,  .2653, -.1307,  .0371,
     *  .2452, -.1307,  .0644, -.0183, -.0697,  .0371, -.0183,  .0052,
     *-1.8966, 1.0107, -.4978,  .1415, 1.0107, -.5386,  .2653, -.0754,
     * -.4978,  .2653, -.1307,  .0371,  .1415, -.0754,  .0371, -.0106,
     * 3.5591,-1.8966,  .9342, -.2656,-1.8966, 1.0107, -.4978,  .1415,
     *  .9342, -.4978,  .2452, -.0697, -.2656,  .1415, -.0697,  .0198/
      DATA EX2049/
     *  .0161, -.0086,  .0042, -.0012, -.1030,  .0549, -.0270,  .0077,
     * -.1030,  .0549, -.0270,  .0077,  .0161, -.0086,  .0042, -.0012,
     * -.0565,  .0301, -.0148,  .0042,  .3624, -.1931,  .0951, -.0270,
     *  .3624, -.1931,  .0951, -.0270, -.0565,  .0301, -.0148,  .0042,
     *  .1147, -.0611,  .0301, -.0086, -.7358,  .3921, -.1931,  .0549,
     * -.7358,  .3921, -.1931,  .0549,  .1147, -.0611,  .0301, -.0086,
     * -.2152,  .1147, -.0565,  .0161, 1.3808, -.7358,  .3624, -.1030,
     * 1.3808, -.7358,  .3624, -.1030, -.2152,  .1147, -.0565,  .0161,
     * -.0008,  .0050,  .0050, -.0008,  .0050, -.0324, -.0324,  .0050,
     *  .0050, -.0324, -.0324,  .0050, -.0008,  .0050,  .0050, -.0008,
     *  .0050, -.0324, -.0324,  .0050, -.0324,  .2078,  .2078, -.0324,
     * -.0324,  .2078,  .2078, -.0324,  .0050, -.0324, -.0324,  .0050,
     *  .0050, -.0324, -.0324,  .0050, -.0324,  .2078,  .2078, -.0324,
     * -.0324,  .2078,  .2078, -.0324,  .0050, -.0324, -.0324,  .0050,
     * -.0008,  .0050,  .0050, -.0008,  .0050, -.0324, -.0324,  .0050,
     *  .0050, -.0324, -.0324,  .0050, -.0008,  .0050,  .0050, -.0008/
C
      DATA        DTOR        /0.0174532925E0/
      DATA        NEQU        /200/
      DATA        OLDEID      / 0 /
      DATA        LLD,LSUB,FRLAST / 2*-1,2*-1.0E30 /
      DATA        TYP         / 4HIHEX,1H1,1H2,1H3 /
C
C*****
C     IF THIS IS THE FIRST STRESS POINT IN AN ELEMENT, INITIALIZE
C     COUNTER AND GET EXTERNAL GRID POINT NUMBERS
C*****
      IF (ISTORE .EQ. 1) GO TO 2633
      IF (OLDEID .EQ. IESTA(1)) GO TO 200
      STRSPT=0
      IPTS=(TYPE-1)/2
      NGP =12*TYPE-4
      NGP1=NGP+1
      IF (TYPE .EQ. 3) NGP1=21
      NIP=IESTA(20*NGP+9)
C
C     IF EQEXIN NOT YET READ IN, READ IT.
C
      IF (ISOPL.NE.EQEXIN  .AND. OLDEID.NE.0) GO TO 10
      ISOPL=-1
      ITRL(1)=EQEXIN
      CALL RDTRL (ITRL)
      LEQX =ITRL(2)*2
      MXLEQ=(NEQU/2)*2
      NEQX =(LEQX-1)/MXLEQ+1
      L=LEQX
      IF (NEQX .GT. 1) L=MXLEQ
      IEND = 0
      CALL READ (*140,*140,EQEXIN,EQU,L,0,I)
      DO 5 I=2,L,2
    5 EQU(I)=IABS(EQU(I))
      CALL SORT (0,0,2,2,EQU,L)
      L=L/2
C
C     CONVERT SIL NUMBERS TO EXTERNAL GRID POINT NUMBERS
C
   10 OLDEID = IESTA(1)
      DO 15 I = 1,NGP
   15 EXTRNL(I)=-IESTA(I+1)
      DO 130 J=1,NEQX
   16 DO 120 I=1,NGP
      IF (EXTRNL(I) .GT. 0) GO TO 120
      SIL=IESTA(I+1)*10+1
C
C     BINARY SEARCH FOR MATCH ON SIL NUMBER
C
      KLO=1
      KHI=L
   20 K=(KHI+KLO+1)/2
   30 KX=2*K
      IF (SIL-EQU(KX)) 40,110,50
   40 KHI=K
      GO TO 60
   50 KLO=K
   60 IF (KHI-KLO-1) 120,70,20
   70 IF (K .EQ. KLO) GO TO 80
      K=KLO
      GO TO 90
   80 K=KHI
   90 KLO=KHI
      GO TO 30
  110 EXTRNL(I)=EQU(KX-1)
  120 CONTINUE
      IF (NEQX .EQ. 1) GO TO 130
      DO 121 I=1,NGP
      IF (EXTRNL(I) .LT. 0) GO TO 123
  121 CONTINUE
      GO TO 135
  123 L=MXLEQ
      IEND = 0
      CALL READ (*140,*125,EQEXIN,EQU,L,0,I)
  124 DO 122 I=2,L,2
  122 EQU(I)=IABS(EQU(I))
      CALL SORT (0,0,2,2,EQU,L)
      L=L/2
      IF (IEND .EQ. 1) GO TO 16
      GO TO 130
  125 CALL BCKREC (EQEXIN)
      L=I
      IEND = 1
      IF (L .EQ. 0) GO TO 123
      GO TO 124
  130 CONTINUE
  135 IF (TYPE .NE. 3) EXTRNL(NGP+1)=0
      IF (IEND .EQ. 0) CALL BCKREC (EQEXIN)
      IEND = 1
      GO TO 200
  140 CALL MESAGE (-61,0,0)
C*****
C     BEGIN STRESS COMPUTATION
C*****
  200 STRSPT=STRSPT+1
      IF (STRSPT .EQ. NIP**3+1) OLDEID=0
      ISTORE=0
      IF (OLDEID .EQ. 0) ISTORE=1
C*****
C     THERMAL EFFECTS
C*****
      IF (JTEMP .EQ. -1) GO TO 230
C
C     COMPUTE TEMPERATURE AT THIS POINT
C
      TEMP=0.0
      DO 210 I=1,NGP
  210 TEMP=TEMP+ESTA(NGP+1+I)*GPT(I)
      TEMP=TEMP-ESTA(2*NGP+2)
      DO 220 I=1,6
      SIG(I) =TEMP*ESTA(2*NGP+2+I)
  220 CSIG(I)=ABS(SIG(I))
      GO TO 250
  230 DO 240 I=1,6
      SIG(I) =0.0
  240 CSIG(I)=0.0
C*****
C     DISPLACEMENT EFFECTS.  LOOP OVER GRID POINTS.
C*****
  250 DO 260 I=1,NGP
      J=IVEC+IESTA(I+1)-1
      K=NGP*2+18*(I-1)+9
      CALL SMMATS (ESTA(K),6,3,-2,Z(J),3,1,0,SIG,CSIG)
  260 CONTINUE
C
C     STORE THE GAUSS POINT STRESSES UNTIL WE HAVE THEM ALL
C     NO NEED TO STORE NIP3 + 1ST SINCE CENTROIDAL VALUES WILL BE
C     EXTRAPOLATED. ACTUALLY, NIP3 + 1ST TIMES THRU SIHEX1 AND 2 ARE
C     NOW SUPERFLUOUS
C
      NIP3=NIP**3
      IF (STRSPT .EQ. NIP3+1) GO TO 2611
      IPOINT=6*(STRSPT-1)
      DO 261 I=1,6
      ISUB=IPOINT+I
  261 STORE(ISUB)=SIG(I)
 2611 CONTINUE
C
C     IF ALL GAUSS POINT  ARE DONE, EXTRAPOLATE TO GRIDS
C
      IF (OLDEID .NE. 0) RETURN
C
      IF (NGP-20) 2620,2624,2624
C
C     8 GRIDS
C
 2620 IF (NIP-3) 2621,2622,2623
 2621 CALL SMMATS (EX8G2, 9,8,0,STORE,8,6,0,SIGS,CSIGS)
      GO TO 2632
 2622 CALL SMMATS (EX8G3, 9,27,0,STORE,27,6,0,SIGS,CSIGS)
      GO TO 2632
 2623 CALL SMMATS (EX8G4, 9,64,0,STORE,64,6,0,SIGS,CSIGS)
      GO TO 2632
C
C     20 OR 32 GRIDS
C
 2624 IF (NIP-3) 2625,2626,2627
 2625 CALL SMMATS (EX20G2,21,8,0,STORE,8,6,0,SIGS,CSIGS)
      GO TO 2632
 2626 CALL SMMATS (EX20G3,21,27,0,STORE,27,6,0,SIGS,CSIGS)
      GO TO 2632
 2627 CALL SMMATS (EX20G4,21,64,0,STORE,64,6,0,SIGS,CSIGS)
 2632 RETURN
C
C     JUST FETCH APPROPRIATE SIGS AND LET ROUTINE COMPUTE PRINCIPAL
C     STRESSES AND WRITE( OUT RESULTS
C
 2633 STRSPT=STRSPT+1
      IPOINT=6*(STRSPT-NIP3-2)
      DO 2634 I=1,6
      ISUB=IPOINT+I
      SIG(I) =SIGS(ISUB)
      CSIG(I)=CSIGS(ISUB)
 2634 CONTINUE
C
      ISAVE=STRSPT
      STRSPT=STRSPT-NIP3-1
C
C     SKIP PRINCIPAL STRESS COMPUTATIONS IF FINAL STRESS VECTOR
C     WILL BE COMPLEX.
C
      IF (KTYPE .EQ. 2) GO TO 300
C*****
C     SOLVE CUBIC EQUATION FOR PRINCIPAL STRESSES
C*****
C
C         S**3+P*S**2+Q*S+R=0.0
C
C     REF. -- CRC STANDARD MATH TABLES 14TH ED., PP. 392,3
C
      RM=0.0
      DO 262 I=1,6
      IF (ABS(SIG(I)) .GT. RM) RM=ABS(SIG(I))
  262 CONTINUE
      IF (RM .LE. 0.0) GO TO 267
      THRESH=1.0E-5
  264 DO 263 I=1,6
      IF (ABS(SIG(I)/RM) .LT. THRESH) SIG(I)=0.0
  263 CONTINUE
      RX = SX/RM
      RY = SY/RM
      RZ = SZ/RM
      RXY= SXY/RM
      RYZ= SYZ/RM
      RZX= SZX/RM
      P  =-RX-RY-RZ
      Q  = RX*RY+RY*RZ+RZ*RX-RXY**2-RYZ**2-RZX**2
      R  =-(RX*RY*RZ+2.0*RXY*RYZ*RZX-RX*RYZ**2-RY*RZX**2-RZ*RXY**2)
      A  = (3.0*Q-P**2)/3.0
      B  = (2.0*P**3-9.0*P*Q+27.0*R)/27.0
      X  =-A**3/27.0
      IF (X .GT. 1.0E-16) GO TO 270
C
C     CHECK FOR IMAGINARY ROOTS
C
      IF (ABS(X) .GT. RM*1.0E-6) GO TO 265
C
C     CHECK FOR 3 EQUAL ROOTS
C
      IF (ABS(B) .GT. 1.0E-6) GO TO 265
      X  =0.0
      PHI=0.0
      GO TO 275
  265 THRESH=10.0*THRESH
      IF (THRESH .LT. 1.1E-3) GO TO 264
  267 SA = 0.0
      SB = 0.0
      SC = 0.0
      GO TO 280
  270 COSPHI=-(B/2.0)/SQRT(X)
      AX = ABS(COSPHI)
      IF (AX.GT.0.9999 .AND. AX.LT.1.0001) COSPHI=SIGN(1.0,COSPHI)
      IF (ABS(COSPHI) .GT. 1.0) GO TO 265
      PHI=ACOS(COSPHI)
      X =2.0*SQRT(-A/3.0)
  275 SA=(X*COS(PHI/3.0)-P/3.0)*RM
      SB=(X*COS(PHI/3.0+120.0*DTOR)-P/3.0)*RM
      SC=(X*COS(PHI/3.0+240.0*DTOR)-P/3.0)*RM
      RM=0.0
      DO 276 I=1,3
      IF (ABS(SIGP(I)) .GT. RM) RM=ABS(SIGP(I))
  276 CONTINUE
      DO 277 I=1,3
      IF (ABS(SIGP(I)/RM) .LT. 1.0E-5) SIGP(I)=0.0
  277 CONTINUE
C*****
C     COMPUTE MEAN STRESS OR PRESSURE
C*****
  280 SN=-(SA+SB+SC)/3.0
C*****
C     COMPUTE OCTAHEDRAL SHEAR STRESS
C*****
      SO=SQRT(((SA+SN)**2+(SB+SN)**2+(SC+SN)**2)/3.0)
C*****
C     COMPUTE DIRECTION COSINES OF THE PRINCIPAL PLANES
C*****
      RM=1.0E-6
      DO 600 I=1,3
      IF (SIGP(I) .EQ. 0.0) GO TO 580
      SMAT(1,1)= 1.0-SX/SIGP(I)
      SMAT(2,1)=-SXY/SIGP(I)
      SMAT(3,1)=-SZX/SIGP(I)
      SMAT(1,2)= SMAT(2,1)
      SMAT(2,2)= 1.0-SY/SIGP(I)
      SMAT(3,2)=-SYZ/SIGP(I)
      SMAT(1,3)= SMAT(3,1)
      SMAT(2,3)= SMAT(3,2)
      SMAT(3,3)= 1.0-SZ/SIGP(I)
      CALL SAXB (SMAT(1,1),SMAT(1,2),DCOS(1,I))
      RX=SADOTB(DCOS(1,I),DCOS(1,I))
      J =1
      CALL SAXB (SMAT(1,2),SMAT(1,3),DCOS(1,I))
      RY=SADOTB(DCOS(1,I),DCOS(1,I))
      IF (RY .GT. RX) J=2
      CALL SAXB (SMAT(1,3),SMAT(1,1),DCOS(1,I))
      RZ=SADOTB(DCOS(1,I),DCOS(1,I))
      IF (RZ.GT.RY .AND. RZ.GT.RX) J=3
      P=SMAT(1,J)
      Q=SMAT(2,J)
      R=SMAT(3,J)
      IF (J-2) 450,460,470
  450 J=2
      GO TO 480
  460 J=3
      GO TO 480
  470 J=1
  480 S=SMAT(1,J)
      T=SMAT(2,J)
      V=SMAT(3,J)
      IF (ABS(Q) .LE. RM) GO TO 500
      RX=V-T*R/Q
      IF (ABS(RX) .LE. RM) GO TO 490
      RZ=-(S-T*P/Q)/RX
      RY=-(P+R*RZ)/Q
  485 X=1.0+RZ*RZ+RY*RY
      DCOS(1,I)=1.0/SQRT(X)
      DCOS(2,I)=RY*DCOS(1,I)
      DCOS(3,I)=RZ*DCOS(1,I)
      GO TO 600
  490 RX=S-T*P/Q
      IF (ABS(RX) .LE. RM) GO TO 580
      RY=-R/Q
      X =1.0+RY*RY
      DCOS(1,I)=0.0
      DCOS(3,I)=1.0/SQRT(X)
      DCOS(2,I)=RY*DCOS(3,I)
      GO TO 600
  500 IF (ABS(R) .LE. RM) GO TO 520
      RZ=-P/R
      IF (ABS(T) .LE. RM) GO TO 510
      RY=-(S-V*P/R)/T
      GO TO 485
  510 IF (ABS(S-V*P/R) .LE. RM) GO TO 580
      DCOS(1,I)=0.0
      DCOS(2,I)=1.0
      DCOS(3,I)=0.0
      GO TO 600
  520 IF (ABS(P) .LE. RM) GO TO 580
      IF (ABS(V) .LE. RM) GO TO 530
      RZ=-T/V
      X =1.0+RZ*RZ
      DCOS(1,I)=0.0
      DCOS(2,I)=1.0/SQRT(X)
      DCOS(3,I)=RZ*DCOS(2,I)
      GO TO 600
  530 IF (ABS(T) .LE. RM) GO TO 580
      DCOS(1,I)=0.0
      DCOS(2,I)=0.0
      DCOS(3,I)=1.0
      GO TO 600
  580 DCOS(1,I)=0.0
      DCOS(2,I)=0.0
      DCOS(3,I)=0.0
  600 CONTINUE
C*****
C     PUT IT AWAY IN THE STRESS ARRAY
C*****
  300 ISTRS(1)=IESTA(1)
      IF (TYPE .EQ. 3) GO TO 310
      ISTRS(2)=EXTRNL(STRSPT)
      GO TO 420
  310 ISTRS(11)=0
C            1   2   3   4   5   6   7   8   9   10
      GO TO (320,330,320,330,320,330,320,340,350,350,
     2       350,350,360,370,360,370,360,370,360,380,
     3       390),STRSPT
  320 J=STRSPT/2+STRSPT
      GO TO 410
  330 J=(STRSPT-1)/2+STRSPT-1
      K=J+3
      GO TO 400
  340 J=(STRSPT-1)/2+STRSPT-1
      K=J-9
      GO TO 400
  350 J=(STRSPT-9)*3+1
      K=J+20
      GO TO 400
  360 J=STRSPT/2+STRSPT+2
      GO TO 410
  370 J=(STRSPT-1)/2+STRSPT+1
      K=J+3
      GO TO 400
  380 J=(STRSPT-1)/2+STRSPT+1
      K=J-9
      GO TO 400
  390 ISTRS(2)=0
      GO TO 420
  400 ISTRS(11)=EXTRNL(K)
  410 ISTRS(2)=EXTRNL(J)
  420 STRESS(      3)=SX
      STRESS(      4)=SXY
      STRESS(      5)=SA
      STRESS(      9)=SN
      STRESS(     10)=SO
      STRESS(IPTS+11)=SY
      STRESS(IPTS+12)=SYZ
      STRESS(IPTS+13)=SB
      STRESS(IPTS+17)=SZ
      STRESS(IPTS+18)=SZX
      STRESS(IPTS+19)=SC
      DO 430 I=1,3
      STRESS(      5+I)=DCOS(1,I)
      STRESS(IPTS+13+I)=DCOS(2,I)
      STRESS(IPTS+19+I)=DCOS(3,I)
  430 CONTINUE
      STRSPT=ISAVE
      IF (NCHK .LE. 0) GO TO 960
C
C   . CHECK PRECISION...
C
      KK = 0
      CALL SDRCHK (SIG,CSIG,6,KK)
C
      IF (KK .EQ. 0) GO TO 960
C
C   . LIMITS EXCEEDED...
C
      JJ = 0
      IFRVEC(1) = TYP(1)
      IF (TYPE .EQ. 1) IFRVEC(2) = TYP(2)
      IF (TYPE .EQ. 2) IFRVEC(2) = TYP(3)
      IF (TYPE .EQ. 3) IFRVEC(2) = TYP(4)
      IFRVEC(3) = IESTA(1)
      IFRVEC(4) = ISTRS(2)
      IFRVEC(5) = ISTRS(11)
      IF (TYPE .NE. 3) IFRVEC(5) = -1
C
      IF (LSUB.EQ.ISUB .AND. FRLAST(1).EQ.FRTMEI(1) .AND.
     1    LLD .EQ.ILD  .AND. FRLAST(2).EQ.FRTMEI(2)) GO TO 930
C
      LSUB = ISUB
      LLD = ILD
      FRLAST(1) = FRTMEI(1)
      FRLAST(2) = FRTMEI(2)
      JJ = 1
      CALL PAGE1
C
  910 CALL SD2RHD (ISHD,JJ)
      LINE = LINE + 1
      WRITE  (NOUT,920)
  920 FORMAT (7X,4HTYPE,5X,3HEID,4X,4HGRD1,4X,4HGRD2,5X,2HSX,5X,
     1        2HSY,5X,2HSZ,4X,3HSXY,4X,3HSYZ,4X,3HSZX)
      GO TO 940
C
  930 IF (EJECT(2) .NE. 0) GO TO 910
  940 WRITE  (NOUT,950) IFRVEC
  950 FORMAT (1H0,3X,2A4,I7,2I8,6F7.1)
  960 CONTINUE
      RETURN
      END
