#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
set -o errexit

###
# Sherlock Holmes and the Hound of the Baskervilles
# send your bug reports to contact@dotslashplay.it
###

script_version=20230625.1

# Set game-specific variables

GAME_ID='sherlock-holmes-and-the-hound-of-the-baskervilles'
GAME_NAME='Sherlock Holmes and the Hound of the Baskervilles'

ARCHIVE_GOG='setup_sherlock_holmes_and_the_hound_of_the_baskervilles_1.0_(31691).exe'
ARCHIVE_GOG_URL='https://www.gog.com/game/sherlock_holmes_and_the_hound_of_the_baskervilles'
ARCHIVE_GOG_MD5='26b5d3a72d919ffd084efbb660b7607d'
ARCHIVE_GOG_VERSION='1.0-gog31691'
ARCHIVE_GOG_SIZE='340000'
ARCHIVE_GOG_TYPE='innosetup'

ARCHIVE_GAME_BIN_PATH='.'
ARCHIVE_GAME_BIN_FILES='d3dx9_32.dll game.ini msvcr71.dll __redist sherlockholmes_thehoundofthebaskervilles.exe user.ini'

ARCHIVE_GAME_DATA_PATH='.'
ARCHIVE_GAME_DATA_FILES='game 000 cursor data.txt logo shaders.0050'

DATA_FILES='game.ini user.ini'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='sherlockholmes_thehoundofthebaskervilles.exe'
APP_MAIN_ICON='sherlockholmes_thehoundofthebaskervilles.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Load common functions

target_version='2.12'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Get icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
