#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# There Is No Game : Wrong Dimension
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220322.4

# Set game-specific variables

GAME_ID='there-is-no-game'
GAME_NAME='There Is No Game : Wrong Dimension'

ARCHIVE_BASE_0='setup_there_is_no_game__wrong_dimension_v1.0.30_(52258).exe'
ARCHIVE_BASE_0_MD5='f9590da9c19a554e8154ffeacee9cdbb'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_VERSION='1.0.30-gog52258'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/there_is_no_game_wrong_dimension'

UNITY3D_NAME='ting'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES="
ting.exe
ting_data/plugins
gameassembly.dll
unitycrashhandler64.exe
unityplayer.dll"

ARCHIVE_GAME_DATA_FILES="
ting_data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/DrawMeAPixel/Ting'
DATA_FILES='./userdata/*.dat'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
