#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warsow
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220709.2

GAME_ID='warsow'
GAME_NAME='War§ow'

# This DRM-free archive is no longer available from GOG
ARCHIVE_BASE_0='gog_warsow_2.1.0.3.sh'
ARCHIVE_BASE_0_MD5='028efe7a5f4dfd8851c2146431c7ca4a'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='490000'
ARCHIVE_BASE_0_VERSION='2.1-gog2.1.0.3'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN32_FILES='
*.i386
libs/*_i386.so'
ARCHIVE_GAME_BIN64_FILES='
*.x86_64
libs/*_x86_64.so'
ARCHIVE_GAME_DATA_FILES='
basewsw'
ARCHIVE_DOC_DATA_PATH="${CONTENT_PATH_DEFAULT}/docs"
ARCHIVE_DOC_DATA_FILES='
*'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='warsow.i386'
APP_MAIN_EXE_BIN64='warsow.x86_64'
APP_MAIN_ICON="${CONTENT_PATH_DEFAULT}/../support/icon.png"

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstcd++.so.6 libGLU.so.1 libSDL2-2.0.so.0"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
