#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Blackwell series:
# - Blackwell 1
# - Blackwell 2
# - Blackwell 3
# - Blackwell 4
# - Blackwell 5
###

script_version=20231005.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID_BLACKWELL1='blackwell-1'
GAME_NAME_BLACKWELL1='Blackwell 1: The Blackwell Legacy'

GAME_ID_BLACKWELL2='blackwell-2'
GAME_NAME_BLACKWELL2='Blackwell 2: Blackwell Unbound'

GAME_ID_BLACKWELL3='blackwell-3'
GAME_NAME_BLACKWELL3='Blackwell 3: The Blackwell Convergence'

GAME_ID_BLACKWELL4='blackwell-4'
GAME_NAME_BLACKWELL4='Blackwell 4: The Blackwell Deception'

GAME_ID_BLACKWELL5='blackwell-5'
GAME_NAME_BLACKWELL5='Blackwell 5: The Blackwell Epiphany'

# Game archives

## Blackwell 1

ARCHIVE_BASE_BLACKWELL1_4_NAME='blackwell_legacy_3_1_67142.sh'
ARCHIVE_BASE_BLACKWELL1_4_MD5='840ad19ae85cbfdcbc431e8333767f0d'
ARCHIVE_BASE_BLACKWELL1_4_SIZE='312516'
ARCHIVE_BASE_BLACKWELL1_4_VERSION='3.1-gog67142'
ARCHIVE_BASE_BLACKWELL1_4_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL1_3_NAME='blackwell_legacy_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL1_3_MD5='f21fa6de53dc115ccfb769ffe3ef9e70'
ARCHIVE_BASE_BLACKWELL1_3_SIZE='320000'
ARCHIVE_BASE_BLACKWELL1_3_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL1_2_NAME='blackwell_legacy_2_4a_55329.sh'
ARCHIVE_BASE_BLACKWELL1_2_MD5='4ac2a52315daa0ccde214adf68dadfc9'
ARCHIVE_BASE_BLACKWELL1_2_SIZE='320000'
ARCHIVE_BASE_BLACKWELL1_2_VERSION='2.4a-gog55329'

ARCHIVE_BASE_BLACKWELL1_1_NAME='blackwell_legacy_2_2_3_53579.sh'
ARCHIVE_BASE_BLACKWELL1_1_MD5='1649b8c1c430dd24b0bbe89f7ccb541b'
ARCHIVE_BASE_BLACKWELL1_1_SIZE='320000'
ARCHIVE_BASE_BLACKWELL1_1_VERSION='2.2.3-gog53579'

## Blackwell 2

ARCHIVE_BASE_BLACKWELL2_4_NAME='blackwell_unbound_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL2_4_MD5='8336d9714956fbe4b2a872afdabca960'
ARCHIVE_BASE_BLACKWELL2_4_SIZE='263568'
ARCHIVE_BASE_BLACKWELL2_4_VERSION='3.0-gog67142'
ARCHIVE_BASE_BLACKWELL2_4_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL2_3_NAME='blackwell_unbound_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL2_3_MD5='efcc0c8bb1643ca653b72a3675534dee'
ARCHIVE_BASE_BLACKWELL2_3_SIZE='270000'
ARCHIVE_BASE_BLACKWELL2_3_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL2_2_NAME='blackwell_unbound_2_4_57370.sh'
ARCHIVE_BASE_BLACKWELL2_2_MD5='3eaef9e29721384d1aec74fe0901f195'
ARCHIVE_BASE_BLACKWELL2_2_SIZE='260000'
ARCHIVE_BASE_BLACKWELL2_2_VERSION='2.4-gog57370'

ARCHIVE_BASE_BLACKWELL2_1_NAME='blackwell_unbound_2_2_2_1_53176.sh'
ARCHIVE_BASE_BLACKWELL2_1_MD5='026d7f9171819be7bd4d4bfe3b9e9f6e'
ARCHIVE_BASE_BLACKWELL2_1_SIZE='260000'
ARCHIVE_BASE_BLACKWELL2_1_VERSION='2.2.2.1-gog53176'

## Blackwell 3

ARCHIVE_BASE_BLACKWELL3_3_NAME='blackwell_convergence_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL3_3_MD5='a0e8f8eb25df6e3aab086424c4e5c8e7'
ARCHIVE_BASE_BLACKWELL3_3_SIZE='325592'
ARCHIVE_BASE_BLACKWELL3_3_VERSION='3.0-gog67142'
ARCHIVE_BASE_BLACKWELL3_3_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL3_2_NAME='blackwell_convergence_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL3_2_MD5='2c074d610175629e72e1f7e4970e9342'
ARCHIVE_BASE_BLACKWELL3_2_SIZE='330000'
ARCHIVE_BASE_BLACKWELL3_2_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL3_1_NAME='blackwell_convergence_2_2_2_53176.sh'
ARCHIVE_BASE_BLACKWELL3_1_MD5='e0e6b8c425c35804f47aa0ffe41ff98d'
ARCHIVE_BASE_BLACKWELL3_1_SIZE='380000'
ARCHIVE_BASE_BLACKWELL3_1_VERSION='2.2.2-gog53176'

## Blackwell 4

ARCHIVE_BASE_BLACKWELL4_3_NAME='blackwell_deception_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL4_3_MD5='c4823fb1410fd412b6262323d9b05a19'
ARCHIVE_BASE_BLACKWELL4_3_SIZE='585944'
ARCHIVE_BASE_BLACKWELL4_3_VERSION='3.0-gog67142'
ARCHIVE_BASE_BLACKWELL4_3_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL4_2_NAME='blackwell_deception_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL4_2_MD5='c8839642e293df1a016db8ed6046dbee'
ARCHIVE_BASE_BLACKWELL4_2_SIZE='590000'
ARCHIVE_BASE_BLACKWELL4_2_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL4_1_NAME='blackwell_deception_1_3_53244.sh'
ARCHIVE_BASE_BLACKWELL4_1_MD5='61c144995e396515948fbb15c3467494'
ARCHIVE_BASE_BLACKWELL4_1_SIZE='660000'
ARCHIVE_BASE_BLACKWELL4_1_VERSION='1.3-gog53244'

## Blackwell 5

ARCHIVE_BASE_BLACKWELL5_3_NAME='blackwell_epiphany_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL5_3_MD5='bc979e295bee8e1e7e59299bea33080f'
ARCHIVE_BASE_BLACKWELL5_3_SIZE='864772'
ARCHIVE_BASE_BLACKWELL5_3_VERSION='3.0-gog67142'
ARCHIVE_BASE_BLACKWELL5_3_URL='https://www.gog.com/game/blackwell_epiphany_the'

ARCHIVE_BASE_BLACKWELL5_2_NAME='blackwell_epiphany_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL5_2_MD5='c0865ccac7ad31c7dc95a0b1a171e589'
ARCHIVE_BASE_BLACKWELL5_2_SIZE='870000'
ARCHIVE_BASE_BLACKWELL5_2_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL5_1_NAME='blackwell_epiphany_2_2_53244.sh'
ARCHIVE_BASE_BLACKWELL5_1_MD5='6ffbcfb56b62e476a0255eaa1a2aae6d'
ARCHIVE_BASE_BLACKWELL5_1_SIZE='890000'
ARCHIVE_BASE_BLACKWELL5_1_VERSION='2.2-gog53244'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
*.ags
*.cfg
*.exe
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags'
## Switch French keyboard layout to us-azerty to provide direct access to digits.
## This is required to not get stuck when asked to type digits in-game.
## TODO: Check that this works expected on Wayland (it probably does not).
APP_MAIN_PRERUN='# Switch French keyboard layout to us-azerty to provide direct access to digits.
# This is required to not get stuck when asked to type digits in-game.
KEYBOARD_RESTORE_VARIANT=0
KEYBOARD_LAYOUT=$(LANG=C setxkbmap -query | awk "/layout:/ {print \$2}")
if [ "$KEYBOARD_LAYOUT" = "fr" ]; then
	KEYBOARD_VARIANT=$(LANG=C setxkbmap -query | awk "/variant:/ {print \$2}")
	if [ "$KEYBOARD_VARIANT" != "us-azerty" ]; then
		KEYBOARD_RESTORE_VARIANT=1
		setxkbmap -variant us-azerty
	fi
fi
'
APP_MAIN_POSTRUN='# Restore the keyboard variant, if it has previously been switched to us-azerty.
if [ $KEYBOARD_RESTORE_VARIANT -eq 1 ]; then
	setxkbmap -variant "$KEYBOARD_VARIANT"
fi
'

## Switch French keyboard layout to us-azerty to provide direct access to digits.
PKG_MAIN_DEPENDENCIES_COMMANDS='
setxkbmap'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of optional extra archives

case "$(context_archive)" in
	## Blackwell 1
	( \
		'ARCHIVE_BASE_BLACKWELL1_1' | \
		'ARCHIVE_BASE_BLACKWELL1_2' \
	)
		## The GOG installers for Blackwell 1 < 3.0 included the original game icon.
	;;
	('ARCHIVE_BASE_BLACKWELL1_'*)
		ARCHIVE_OPTIONAL_ICONS_0_NAME='blackwell-1_icons.tar.xz'
		ARCHIVE_OPTIONAL_ICONS_0_MD5='3352b2267c9200b1c06d21c5d65ddef8'
		ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/games/blackwell/'
	;;
	## Blackwell 2
	( \
		'ARCHIVE_BASE_BLACKWELL2_1' | \
		'ARCHIVE_BASE_BLACKWELL2_2' \
	)
		## The GOG installers for Blackwell 2 < 3.0 included the original game icon.
	;;
	('ARCHIVE_BASE_BLACKWELL2_'*)
		ARCHIVE_OPTIONAL_ICONS_0_NAME='blackwell-2_icons.tar.xz'
		ARCHIVE_OPTIONAL_ICONS_0_MD5='e7bef09076eaf830effc44d7fe6b8a9e'
		ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/games/blackwell/'
	;;
	## Blackwell 3
	('ARCHIVE_BASE_BLACKWELL3_1')
		## The GOG installers for Blackwell 3 < 3.0 included the original game icon.
	;;
	('ARCHIVE_BASE_BLACKWELL3_'*)
		ARCHIVE_OPTIONAL_ICONS_0_NAME='blackwell-3_icons.tar.xz'
		ARCHIVE_OPTIONAL_ICONS_0_MD5='49cb2320d1a32788399493dd42e3d607'
		ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/games/blackwell/'
	;;
	## Blackwell 4
	('ARCHIVE_BASE_BLACKWELL4_1')
		## The GOG installers for Blackwell 4 < 3.0 included the original game icon.
	;;
	('ARCHIVE_BASE_BLACKWELL4_'*)
		ARCHIVE_OPTIONAL_ICONS_0_NAME='blackwell-4_icons.tar.xz'
		ARCHIVE_OPTIONAL_ICONS_0_MD5='d9dae751697727cb42e43221755f507a'
		ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/games/blackwell/'
	;;
	## Blackwell 5
	('ARCHIVE_BASE_BLACKWELL5_1')
		## The GOG installers for Blackwell 5 < 3.0 included the original game icon.
	;;
	('ARCHIVE_BASE_BLACKWELL5_'*)
		ARCHIVE_OPTIONAL_ICONS_0_NAME='blackwell-5_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_0_MD5='cf27b6428d455ac9e6af2e5c8b065a43'
		ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/games/blackwell/'
	;;
esac
if [ -n "${ARCHIVE_OPTIONAL_ICONS_0_NAME:-}" ]; then
	archive_initialize_optional \
		'ARCHIVE_ICONS' \
		'ARCHIVE_OPTIONAL_ICONS_0'
fi

# Extract game data

archive_extraction_default
if archive_is_available 'ARCHIVE_ICONS'; then
	archive_extraction 'ARCHIVE_ICONS'
fi

# Include game data

## Set the path to the fallback icon.
APP_MAIN_ICON='../support/icon.png'
case "$(context_archive)" in
	## Blackwell 1
	( \
		'ARCHIVE_BASE_BLACKWELL1_1' | \
		'ARCHIVE_BASE_BLACKWELL1_2' \
	)
		APP_MAIN_ICON='Blackwell Legacy.exe'
	;;
	('ARCHIVE_BASE_BLACKWELL1_'*)
		CONTENT_ICONS_PATH='.'
		CONTENT_ICONS_FILES='
		16x16
		24x24
		32x32
		48x48
		256x256'
	;;
	## Blackwell 2
	( \
		'ARCHIVE_BASE_BLACKWELL2_1' | \
		'ARCHIVE_BASE_BLACKWELL2_2' \
	)
		APP_MAIN_ICON='Unbound.exe'
	;;
	('ARCHIVE_BASE_BLACKWELL2_'*)
		CONTENT_ICONS_PATH='.'
		CONTENT_ICONS_FILES='
		16x16
		24x24
		32x32
		48x48
		256x256'
	;;
	## Blackwell 3
	('ARCHIVE_BASE_BLACKWELL3_1')
		APP_MAIN_ICON='Convergence.exe'
	;;
	('ARCHIVE_BASE_BLACKWELL3_'*)
		CONTENT_ICONS_PATH='.'
		CONTENT_ICONS_FILES='
		32x32
		64x64
		256x256'
	;;
	## Blackwell 4
	('ARCHIVE_BASE_BLACKWELL4_1')
		APP_MAIN_ICON='Deception.exe'
	;;
	('ARCHIVE_BASE_BLACKWELL4_'*)
		CONTENT_ICONS_PATH='.'
		CONTENT_ICONS_FILES='
		16x16
		24x24
		32x32
		48x48
		256x256'
	;;
	## Blackwell 5
	('ARCHIVE_BASE_BLACKWELL5_1')
		APP_MAIN_ICON='Epiphany.exe'
	;;
	('ARCHIVE_BASE_BLACKWELL5_'*)
		CONTENT_ICONS_PATH='.'
		CONTENT_ICONS_FILES='
		16x16
		24x24
		32x32
		48x48
		256x256'
	;;
esac
if archive_is_available 'ARCHIVE_ICONS'; then
	content_inclusion 'ICONS' 'PKG_MAIN' "$(path_icons)"
else
	icons_inclusion
fi
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
