/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.codehaus.xfire.addressing.AbstactAddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.EndpointReference;
import org.codehaus.xfire.fault.XFireFault;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public class AddressingHeadersFactory200508
extends AbstactAddressingHeadersFactory {
    public String getAnonymousUri() {
        return "http://www.w3.org/2005/08/addressing/anonymous";
    }

    protected Namespace getNamespace() {
        return Namespace.getNamespace((String)"wsa", (String)"http://www.w3.org/2005/08/addressing");
    }

    public String getNoneUri() {
        return "http://www.w3.org/2005/08/addressing/none";
    }

    public AddressingHeaders createHeaders(Element root) throws XFireFault {
        Element action;
        Element to;
        Element relatesTo;
        AddressingHeaders headers = new AddressingHeaders();
        Namespace wsa = this.getNamespace();
        Element from = root.getChild("From", wsa);
        if (from != null) {
            headers.setFrom(this.createEPR(from));
        } else {
            headers.setFrom(this.createDefaultEPR());
        }
        Element replyTo = root.getChild("ReplyTo", wsa);
        if (replyTo != null) {
            headers.setReplyTo(this.createEPR(replyTo));
        } else {
            headers.setReplyTo(this.createDefaultEPR());
        }
        this.assertSingle(root, "FaultTo", wsa);
        Element faultTo = root.getChild("FaultTo", wsa);
        if (faultTo != null) {
            headers.setFaultTo(this.createEPR(faultTo));
        } else {
            headers.setFaultTo(this.createDefaultEPR());
        }
        Element messageId = root.getChild("MessageID", wsa);
        if (messageId != null) {
            headers.setMessageID(messageId.getValue());
        }
        if ((relatesTo = root.getChild("RelatesTo", wsa)) != null) {
            headers.setRelatesTo(relatesTo.getValue());
        }
        if ((to = root.getChild("To", wsa)) != null) {
            headers.setTo(to.getValue());
        }
        if ((action = root.getChild("Action", wsa)) != null) {
            headers.setAction(action.getValue().trim());
        }
        return headers;
    }

    private void assertSingle(Element root, String tagName, Namespace wsa) throws XFireFault {
        List list = root.getChildren(tagName, wsa);
        if (list != null && list.size() > 1) {
            XFireFault fault = new XFireFault("Invalid header", new QName(wsa.getURI(), "Sender"));
            fault.addNamespace("wsa", wsa.getURI());
            fault.setSubCode(new QName(wsa.getURI(), "InvalidAddressingHeader"));
            Element detail = new Element("ProblemHeaderQName", wsa);
            detail.addContent(tagName);
            fault.setDetail(detail);
            throw fault;
        }
    }

    public EndpointReference createDefaultEPR() {
        DefaultJDOMFactory factory = new DefaultJDOMFactory();
        Element eprElem = factory.element("EPR", this.getNamespace());
        Element addressElem = factory.element("Address", this.getNamespace());
        addressElem.addContent((Content)factory.text(this.getAnonymousUri()));
        eprElem.addContent((Content)addressElem);
        return this.createEPR(eprElem);
    }

    public EndpointReference createEPR(Element eprElement) {
        EndpointReference epr = new EndpointReference();
        List elements = eprElement.getChildren();
        String version = eprElement.getNamespaceURI();
        epr.setElement(eprElement);
        for (int i = 0; i < elements.size(); ++i) {
            Element e = (Element)elements.get(i);
            if (!e.getNamespaceURI().equals(version)) continue;
            if (e.getName().equals("ServiceName")) {
                epr.setServiceName(AddressingHeadersFactory200508.elementToQName(e));
                epr.setEndpointName(e.getAttributeValue("EndpointName", version));
                continue;
            }
            if (e.getName().equals("InterfaceName")) {
                epr.setInterfaceName(AddressingHeadersFactory200508.elementToQName(e));
                continue;
            }
            if (!e.getName().equals("Policies")) continue;
            ArrayList policies = new ArrayList();
            List polEls = e.getChildren();
            for (int j = 0; j < polEls.size(); ++j) {
                policies.add(polEls.get(j));
            }
            epr.setPolicies(policies);
        }
        return epr;
    }

    public boolean hasHeaders(Element root) {
        return root.getChild("Action", this.getNamespace()) != null;
    }

    public void writeHeaders(Element root, AddressingHeaders headers) {
        Namespace ns = this.getNamespace();
        root.addNamespaceDeclaration(ns);
        if (headers.getTo() != null) {
            Element to = new Element("To", ns);
            to.addContent(headers.getTo());
            root.addContent((Content)to);
        }
        if (headers.getAction() != null) {
            Element action = new Element("Action", ns);
            action.addContent(headers.getAction());
            root.addContent((Content)action);
        }
        if (headers.getFaultTo() != null) {
            Element faultTo = new Element("FaultTo", ns);
            root.addContent((Content)faultTo);
            this.writeEPR(faultTo, headers.getFaultTo());
        }
        if (headers.getFrom() != null) {
            Element from = new Element("From", ns);
            root.addContent((Content)from);
            this.writeEPR(from, headers.getFrom());
        }
        if (headers.getMessageID() != null) {
            Element messageId = new Element("MessageID", ns);
            messageId.addContent(headers.getMessageID());
            root.addContent((Content)messageId);
        }
        if (headers.getRelatesTo() != null) {
            Element relatesTo = new Element("RelatesTo", ns);
            relatesTo.addContent(headers.getRelatesTo());
            root.addContent((Content)relatesTo);
            if (headers.getRelationshipType() != null) {
                String value = AddressingHeadersFactory200508.qnameToString(root, headers.getRelationshipType());
                relatesTo.setAttribute(new Attribute("RelationshipType", value));
            }
        }
        if (headers.getReplyTo() != null) {
            Element replyTo = new Element("ReplyTo", ns);
            root.addContent((Content)replyTo);
            this.writeEPR(replyTo, headers.getReplyTo());
        }
        if (headers.getReferenceParameters() != null) {
            root.addContent((Collection)headers.getReferenceParameters());
        }
    }

    public void writeEPR(Element root, EndpointReference epr) {
        Namespace ns = this.getNamespace();
        Element address = new Element("Address", ns);
        address.addContent(epr.getAddress());
        root.addContent((Content)address);
        if (epr.getServiceName() != null) {
            Element serviceName = new Element("ServiceName", ns);
            serviceName.addContent(AddressingHeadersFactory200508.qnameToString((Element)root.getParent(), epr.getServiceName()));
            root.addContent((Content)serviceName);
            if (epr.getInterfaceName() != null) {
                String value = AddressingHeadersFactory200508.qnameToString((Element)root.getParent(), epr.getInterfaceName());
                serviceName.setAttribute(new Attribute("InterfaceName", value));
            }
        }
    }
}

