/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;

class CreateIndexConstantAction
extends IndexConstantAction {
    private boolean unique;
    private String indexType;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;

    CreateIndexConstantAction(boolean bl, String string, String string2, String string3, String string4, UUID uUID, String[] stringArray, boolean[] blArray, boolean bl2, UUID uUID2, Properties properties) {
        super(uUID, string3, string4, string2);
        this.unique = bl;
        this.indexType = string;
        this.columnNames = stringArray;
        this.isAscending = blArray;
        this.isConstraint = bl2;
        this.conglomerateUUID = uUID2;
        this.properties = properties;
    }

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        Object object2;
        int n;
        Serializable serializable;
        Object object3;
        IndexRowGenerator indexRowGenerator = null;
        int n2 = -1;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        boolean bl = activation.getForCreateTable();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
        TableDescriptor tableDescriptor = activation.getDDLTableDescriptor();
        if (tableDescriptor == null) {
            tableDescriptor = this.tableId != null ? dataDictionary.getTableDescriptor(this.tableId) : dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor);
        }
        if (tableDescriptor == null) {
            throw StandardException.newException("X0Y38.S", (Object)this.indexName, (Object)this.tableName);
        }
        if (tableDescriptor.getTableType() == 1) {
            throw StandardException.newException("X0Y28.S", (Object)this.indexName, (Object)this.tableName);
        }
        this.lockTableForDDL(transactionController, tableDescriptor.getHeapConglomerateId(), false);
        if (!bl) {
            dependencyManager.invalidateFor(tableDescriptor, 3, languageConnectionContext);
        }
        int[] nArray = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ClassFactory classFactory;
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            boolean bl2 = typeId.orderable(classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory());
            if (bl2 && typeId.userType()) {
                String string = typeId.getCorrespondingJavaTypeName();
                try {
                    if (classFactory.isApplicationClass(classFactory.loadApplicationClass(string))) {
                        bl2 = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
            }
            nArray[i] = columnDescriptor.getPosition();
            if (n2 >= nArray[i]) continue;
            n2 = nArray[i];
        }
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        boolean bl3 = false;
        long l = 0L;
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            object3 = conglomerateDescriptorArray[i];
            if (!((ConglomerateDescriptor)object3).isIndex()) continue;
            serializable = ((ConglomerateDescriptor)object3).getIndexDescriptor();
            int[] nArray2 = ((IndexRowGenerator)serializable).baseColumnPositions();
            boolean[] blArray = ((IndexRowGenerator)serializable).isAscending();
            if (nArray2.length == nArray.length && (((IndexRowGenerator)serializable).isUnique() || !this.unique) && this.indexType.equals(((IndexRowGenerator)serializable).indexType())) {
                for (n = 0; n < nArray2.length && nArray2[n] == nArray[n] && blArray[n] == this.isAscending[n]; ++n) {
                }
            }
            if (n != nArray.length) continue;
            if (!this.isConstraint) {
                activation.addWarning(StandardException.newWarning("01504", ((ConglomerateDescriptor)object3).getConglomerateName()));
                return;
            }
            l = ((ConglomerateDescriptor)object3).getConglomerateNumber();
            indexRowGenerator = ((ConglomerateDescriptor)object3).getIndexDescriptor();
            this.conglomerateUUID = dataDictionary.getUUIDFactory().createUUID();
            bl3 = true;
            break;
        }
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (bl3) {
            object3 = dataDescriptorGenerator.newConglomerateDescriptor(l, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
            dataDictionary.addDescriptor((TupleDescriptor)object3, schemaDescriptor, 0, false, transactionController);
            serializable = tableDescriptor.getConglomerateDescriptorList();
            ((ArrayList)serializable).add(object3);
        }
        object3 = this.properties != null ? this.properties : new Properties();
        ((Properties)object3).put("baseConglomerateId", Long.toString(tableDescriptor.getHeapConglomerateId()));
        ((Properties)object3).put("nUniqueColumns", Integer.toString(this.unique ? nArray.length : nArray.length + 1));
        ((Properties)object3).put("rowLocationColumn", Integer.toString(nArray.length));
        ((Properties)object3).put("nKeyFields", Integer.toString(nArray.length + 1));
        if (!bl3) {
            indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, nArray, this.isAscending, nArray.length);
        }
        RowSource rowSource = null;
        long l2 = 0L;
        boolean bl4 = false;
        int n3 = bl ? 1 : 16;
        int n4 = tableDescriptor.getNumberOfColumns();
        n = 0;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n4 + 1);
        for (int i = 0; i < nArray.length; ++i) {
            formatableBitSet.set(nArray[i]);
        }
        FormatableBitSet formatableBitSet2 = RowUtil.shift(formatableBitSet, 1);
        GroupFetchScanController groupFetchScanController = transactionController.openGroupFetchScan(tableDescriptor.getHeapConglomerateId(), false, 0, 7, 5, formatableBitSet2, null, 0, null, null, 0);
        ExecRow[] execRowArray = new ExecRow[n3];
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n3];
        ExecRow[] execRowArray2 = new ExecRow[n3];
        try {
            ColumnOrdering[] columnOrderingArray;
            Object object4;
            for (int i = 0; i < n3; ++i) {
                execRowArray[i] = activation.getExecutionFactory().getValueRow(n2);
                execIndexRowArray[i] = indexRowGenerator.getIndexRowTemplate();
                execRowArray2[i] = activation.getExecutionFactory().getValueRow(nArray.length);
            }
            this.indexTemplateRow = execIndexRowArray[0];
            object2 = tableDescriptor.getColumnDescriptorList();
            int n5 = ((ArrayList)object2).size();
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                if (!formatableBitSet2.get(i)) continue;
                ++n6;
                object4 = ((ColumnDescriptorList)object2).elementAt(i);
                columnOrderingArray = ((ColumnDescriptor)object4).getType();
                for (int j = 0; j < n3; ++j) {
                    execRowArray[j].setColumn(i + 1, columnOrderingArray.getNull());
                    execRowArray2[j].setColumn(n6, execRowArray[j].getColumn(i + 1));
                }
                n += columnOrderingArray.getTypeId().getApproximateLengthInBytes((DataTypeDescriptor)columnOrderingArray);
            }
            object = new RowLocation[n3];
            for (n6 = 0; n6 < n3; ++n6) {
                object[n6] = groupFetchScanController.newRowLocationTemplate();
                indexRowGenerator.getIndexRow(execRowArray2[n6], object[n6], execIndexRowArray[n6], formatableBitSet);
            }
            if (bl3) {
                return;
            }
            object4 = null;
            if (this.unique) {
                n6 = nArray.length;
                columnOrderingArray = this.indexName;
                if (this.conglomerateUUID != null) {
                    ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.conglomerateUUID);
                    if (this.isConstraint && conglomerateDescriptor != null && conglomerateDescriptor.getUUID() != null && tableDescriptor != null) {
                        ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                        columnOrderingArray = constraintDescriptor.getConstraintName();
                    }
                }
                object4 = new UniqueIndexSortObserver(true, this.isConstraint, (String)columnOrderingArray, this.indexTemplateRow, true, tableDescriptor.getName());
            } else {
                n6 = nArray.length + 1;
                object4 = new BasicSortObserver(true, false, this.indexTemplateRow, true);
            }
            columnOrderingArray = new ColumnOrdering[n6];
            for (int i = 0; i < n6; ++i) {
                columnOrderingArray[i] = new IndexColumnOrder(i, this.unique || i < n6 - 1 ? this.isAscending[i] : true);
            }
            l2 = transactionController.createSort(null, this.indexTemplateRow.getRowArrayClone(), columnOrderingArray, (SortObserver)object4, false, groupFetchScanController.getEstimatedRowCount(), n);
            bl4 = true;
            rowSource = this.loadSorter(execRowArray, execIndexRowArray, transactionController, groupFetchScanController, l2, (RowLocation[])object);
            l = transactionController.createAndLoadConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), columnOrderingArray, indexRowGenerator.getColumnCollationIds(tableDescriptor.getColumnDescriptorList()), (Properties)object3, 0, (RowLocationRetRowSource)rowSource, null);
        }
        finally {
            if (groupFetchScanController != null) {
                groupFetchScanController.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (bl4) {
                transactionController.dropSort(l2);
            }
        }
        object2 = transactionController.openConglomerate(l, false, 0, 7, 5);
        if (!object2.isKeyed()) {
            object2.close();
            throw StandardException.newException("X0X85.S", (Object)this.indexName, (Object)this.indexType);
        }
        object2.close();
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
        dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        object = tableDescriptor.getConglomerateDescriptorList();
        ((ArrayList)object).add(conglomerateDescriptor);
        CardinalityCounter cardinalityCounter = (CardinalityCounter)rowSource;
        long l3 = cardinalityCounter.getRowCount();
        if (l3 > 0L) {
            long[] lArray = cardinalityCounter.getCardinality();
            for (int i = 0; i < lArray.length; ++i) {
                StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), tableDescriptor.getUUID(), "I", new StatisticsImpl(l3, lArray[i]), i + 1);
                dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, transactionController);
            }
        }
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    private void statementExceptionCleanup(ScanController scanController, ConglomerateController conglomerateController) throws StandardException {
        if (conglomerateController != null) {
            conglomerateController.close();
        }
        if (scanController != null) {
            scanController.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocationRetRowSource loadSorter(ExecRow[] execRowArray, ExecIndexRow[] execIndexRowArray, TransactionController transactionController, GroupFetchScanController groupFetchScanController, long l, RowLocation[] rowLocationArray) throws StandardException {
        long l2 = 0L;
        SortController sortController = transactionController.openSort(l);
        try {
            int n;
            int n2 = execRowArray.length;
            DataValueDescriptor[][] dataValueDescriptorArray = new DataValueDescriptor[n2][];
            for (n = 0; n < n2; ++n) {
                dataValueDescriptorArray[n] = execRowArray[n].getRowArray();
            }
            n = 0;
            while ((n = groupFetchScanController.fetchNextGroup(dataValueDescriptorArray, rowLocationArray)) > 0) {
                for (int i = 0; i < n; ++i) {
                    sortController.insert(execIndexRowArray[i].getRowArray());
                    ++l2;
                }
            }
            groupFetchScanController.setEstimatedRowCount(l2);
        }
        finally {
            sortController.completedInserts();
        }
        return new CardinalityCounter(transactionController.openSortRowSource(l));
    }
}

