!{\src2tex{textfont=tt}}
!!****f* ABINIT/rdusps1
!! NAME
!! rdusps1
!! 
!! FUNCTION
!! Read various usefull (for dimensionning) data from
!! USpp code (D. Vanderbilt)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!   
!! OUTPUT
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %lmn_size= Number of elements for the paw basis
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!    %prj_meshsz=Dimension of radial mesh for tProj inherited from uspp
!!    %rho_meshsz=Mesh size for densities inherited from uspp
!!    %sph_meshsz=Dimension of radial mesh for spheres
!!    %wav_meshsz=Mesh size for partial waves and projectors inherited from uspp
!!  usdata
!!    %nval=Number of valence states
!!  un_log= Unit number for log file (comments)
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine rdusps1(pshead,usdata,un_log)

 use defs_basis
 use defs_pawps
 
 implicit none

 include "usppcom.inc"
 
!Arguments ---------------------------------------------
 integer :: un_log
!Theses types are defined in defs_pawps
 type(pshead_type) :: pshead
 type(usdata_type)   :: usdata

!Local variables ---------------------------------------
 integer :: ib

! *************************************************************************

!--Read BASIS SIZE
 pshead%basis_size=usbassz
 pshead%sph_meshsz=usmshsph
 pshead%prj_meshsz=usmshprj
 pshead%wav_meshsz=usmesh1
 pshead%rho_meshsz=usmesh2
 usdata%nval=usnval
 pshead%orbitals(1:pshead%basis_size)=usorb(1:usbassz)

!Here must compute lmn_size
!--------------------------
 pshead%lmn_size=0
 do ib=1,pshead%basis_size
  pshead%lmn_size=pshead%lmn_size+2*pshead%orbitals(ib)+1
 enddo

 un_log=stderr

 end subroutine
!!***
