      SUBROUTINE SYMEXP4(IRREP,NUM1,NUM2,DSZ1,DSZ,DIS,A1,A,B)
C
C     THIS ROUTINE EXPANDS THE A COMPRESSED ARRAY A(AB,IJ) WITH
C     A LE B  TO AN ARRAY A(AB,IJ) WITH I,J USING THE SYMMETRY
C     RELATION A(AB,IJ) = A(BA,JI). NOTE THAT THIS ROUTINE
C     EXPECTS THAT THE ARRAY A IS SYMMETRY PACKED
C
C  USAGE :
C
C          IRREP ....... IRREDUCIBLE REPRESENTATION OF THE BLOCKS
C          NUM ......... POPULATION IN EACH IRREP FOR THE ORBITALS
C                        (EITHER VIRTUAL OR OCCUPIED IN DEPENDENCE
C                        IF A VIRTUAL-VIRTULA OR OCCUPIED-OCCUPIED      
C                        BLOCK MUST BE EXTENDED
C          DSZ1 ........ DISTRIBUTION SIZE OF EXPANDED ARRAY
C          DSZ ......... DISTRIBUTION SIZE OF OLD ARRAY
C          DIS ......... NUMBER OF DISTRIBUTIONS IN A AND A1
C          A1 .......... EXPANDED ARRAY (OUTPUT)
C          A ........... OLD ARRAY (INPUT) 
C          B ........... SCRATCH ARRAY
C
C THIS ROUTINE IS USEFUL FOR THE LADDER PART IN THE CASE OF RHF
C
CEND
C
C  CODED JG JUNE/90
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER DIS,DIRPRD,DSZ1,DSZ
      DIMENSION A(DSZ,DIS),B(DSZ,DIS),A1(DSZ1,DIS),NUM1(8)
      DIMENSION IPOLD(8),IPNEW(8),NUM2(8)
C
      COMMON /SYMINF/NSTART,NIRREP,IRREPA(255),IRREPB(255),
     &DIRPRD(8,8)
C
      IND(J,I)=((J-1)*J)/2+I
C 
      DATA ZERO /0.0D0/
C
      CALL SYMTRA(IRREP,NUM2,NUM2,DSZ,A,B)
C
C    COPY FIRST A TO A1
C
      DO 1000 L=DIS,1,-1
      DO 1000 I=DSZ,1,-1
       A1(I,L) = A(I,L) 
1000  CONTINUE
C
C
C     TAKE HERE CARE, IF WE ARE HANDLING IRREP=1 (TOTAL SYMMETRIC)
C     OR IRREP=1 (OTHERWISE)
C
      IF(IRREP.EQ.1) THEN
C
C     GET FIRST POINTERS FOR OLD AND NEW INDICES
C
       IPOLD(1)=0
       IPNEW(1)=0
       DO 10 IRREPJ=1,(NIRREP-1)
        IPOLD(IRREPJ+1)=IPOLD(IRREPJ)+(NUM1(IRREPJ)*(NUM1(IRREPJ)+1))/2
        IPNEW(IRREPJ+1)=IPNEW(IRREPJ)+NUM1(IRREPJ)**2
10     CONTINUE
C
C     NOW LOOP BACKWARDS FROM THE HIGHEST TO THE LOWEST IRREP
C
       DO 1 IRREPJ=NIRREP,1,-1
        NUMJ=NUM1(IRREPJ)
        IPO=IPOLD(IRREPJ)
        IPN=IPNEW(IRREPJ)
C
C     LOOP OVER ORBITALS, BUT ALSO IN BACKWARD ORDER
C
        DO 100 J=NUMJ,1,-1
         DO 100 I=J,1,-1
          IND1=IND(J,I)+IPO
          IND2=(J-1)*NUMJ+I+IPN
          DO 101 L=1,DIS
          A1(IND2,L)=A1(IND1,L)
101       CONTINUE
100     CONTINUE
C
C     EXPAND NOW THE ARRAY
C
       DO 300 J=2,NUMJ
CDIR$ NOVECTOR
*VOCL LOOP,SCALAR
        DO 300 I=1,J-1
         IND1=IND(J,I)+IPO
         IND2=(I-1)*NUMJ+J+IPN
C
CDIR$ VECTOR
*VOCL LOOP,VECTOR
         DO 301 L=1,DIS
         A1(IND2,L)=B(IND1,L)
301      CONTINUE
300    CONTINUE
1      CONTINUE
C
      ELSE
C
C     FILL THE POINTERS OF THE OLD AND NEW ARRAY
C
      IPOLD(1)=0
      IPNEW(1)=0
      DO 1001 IRREPJ=1,NIRREP-1
       IRREPI=DIRPRD(IRREP,IRREPJ)
       NUMJ=NUM1(IRREPJ)
       NUMI=NUM1(IRREPI)
       IPNEW(IRREPJ+1)=IPNEW(IRREPJ)+NUMJ*NUMI
       IF(IRREPI.LT.IRREPJ) THEN
        IPOLD(IRREPJ+1)=IPOLD(IRREPJ)+NUMJ*NUMI
       ELSE
        IPOLD(IRREPJ+1)=IPOLD(IRREPJ)
       ENDIF
1001  CONTINUE
C
C     NOW COPY OLD ARRAYS TO NEW LOCATION
C
      DO 2000 IRREPJ=NIRREP,1,-1
       IRREPI=DIRPRD(IRREP,IRREPJ)
       NUMJ=NUM1(IRREPJ)
       NUMI=NUM1(IRREPI)
       IF(IRREPJ.GT.IRREPI) THEN
        IPN=IPNEW(IRREPJ)
        IPO=IPOLD(IRREPJ)
        DO  2100 IJ=NUMJ*NUMI,1,-1
         DO 2101 L=1,DIS
         A1(IPN+IJ,L)=A1(IPO+IJ,L)
2101     CONTINUE
2100    CONTINUE
       ELSE
        IPN=IPNEW(IRREPJ)
        IPO=IPOLD(IRREPI)
        DO 2200 J=1,NUMJ
CDIR$ NOVECTOR
*VOCL LOOP,SCALAR
         DO 2200 I=1,NUMI
          IND1=(I-1)*NUMJ+J+IPO
          IND2=(J-1)*NUMI+I+IPN
C
CDIR$ VECTOR
*VOCL LOOP,VECTOR
          DO 2201 L=1,DIS
          A1(IND2,L)=B(IND1,L)
2201      CONTINUE
2200    CONTINUE
       ENDIF
2000  CONTINUE
      ENDIF
      RETURN
      END
