#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2022, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of Laborejo ( https://www.laborejo.org )

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from PyQt5 import QtCore, QtGui, QtWidgets
from hashlib import md5

def iconFromString(st, size=128):
    px = QtGui.QPixmap(size,size)
    color = stringToColor(st)
    px.fill(color)
    return QtGui.QIcon(px)    
    

def sizeof_fmt(num, suffix='B'):
    """https://stackoverflow.com/questions/1094841/reusable-library-to-get-human-readable-version-of-file-size"""
    for unit in ['','Ki','Mi','Gi','Ti','Pi','Ei','Zi']:
        if abs(num) < 1024.0:
            return "%3.1f%s%s" % (num, unit, suffix)
        num /= 1024.0
    return "%.1f%s%s" % (num, 'Yi', suffix)

def stringToColor(st):
    """Convert a string to QColor. Same string, same color
    Is used for group coloring"""
    if st:
        c = md5(st.encode()).hexdigest()
        return QtGui.QColor(int(c[0:9],16) % 255, int(c[10:19],16) % 255, int(c[20:29],16)% 255, 255)
    else:
        return QtGui.QColor(255,255,255,255) #Return White

def invertColor(qcolor):
    r = 255 - qcolor.red()
    g = 255 - qcolor.green()
    b = 255 - qcolor.blue()    
    return QtGui.QColor(r, g, b, qcolor.alpha())

def removeInstancesFromScene(qtGraphicsClass):
    """"Remove all instances of a qt class that implements .instances=[] from the QGraphicsScene.
    Don't use for items or anything in the notation view. This is used by the likes of the conductor
    only since they exist only once and gets redrawn completely each time."""
    for instance in qtGraphicsClass.instances:
        instance.setParentItem(None)
        instance.scene().removeWhenIdle(instance)
    qtGraphicsClass.instances = []

def callContextMenu(listOfLabelsAndFunctions):
    menu = QtWidgets.QMenu()

    for text, function in listOfLabelsAndFunctions:
        if text == "separator":
            menu.addSeparator()
        else:
            a = QtWidgets.QAction(text, menu)
            menu.addAction(a)
            a.triggered.connect(function)

    pos = QtGui.QCursor.pos()
    pos.setY(pos.y() + 5)
    menu.exec_(pos)

def stretchLine(qGraphicsLineItem, factor):
    line = qGraphicsLineItem.line()
    line.setLength(line.length() * factor)
    qGraphicsLineItem.setLine(line)

def stretchRect(qGraphicsRectItem, factor):
    r = qGraphicsRectItem.rect()
    r.setRight(r.right() * factor)
    qGraphicsRectItem.setRect(r)

class QHLine(QtWidgets.QFrame):
    def __init__(self):
        super().__init__()
        self.setFrameShape(QtWidgets.QFrame.HLine)
        self.setFrameShadow(QtWidgets.QFrame.Sunken)

def setPaletteAndFont(qtApp):
    """Set our programs color
    This is in its own function because it is a annoying to scroll by that in init.
    http://doc.qt.io/qt-5/qpalette.html"""
    fPalBlue = QtGui.QPalette()
    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Window, QtGui.QColor(32, 35, 39))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Window, QtGui.QColor(37, 40, 45))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Window, QtGui.QColor(37, 40, 45))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.WindowText, QtGui.QColor(89, 95, 104))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.WindowText, QtGui.QColor(223, 237, 255))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.WindowText, QtGui.QColor(223, 237, 255))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Base, QtGui.QColor(48, 53, 60))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Base, QtGui.QColor(55, 61, 69))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Base, QtGui.QColor(55, 61, 69))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.AlternateBase, QtGui.QColor(60, 64, 67))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.AlternateBase, QtGui.QColor(69, 73, 77))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.AlternateBase, QtGui.QColor(69, 73, 77))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.ToolTipBase, QtGui.QColor(182, 193, 208))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.ToolTipBase, QtGui.QColor(182, 193, 208))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.ToolTipBase, QtGui.QColor(182, 193, 208))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.ToolTipText, QtGui.QColor(42, 44, 48))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.ToolTipText, QtGui.QColor(42, 44, 48))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.ToolTipText, QtGui.QColor(42, 44, 48))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Text, QtGui.QColor(96, 103, 113))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Text, QtGui.QColor(210, 222, 240))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Text, QtGui.QColor(210, 222, 240))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Button, QtGui.QColor(51, 55, 62))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Button, QtGui.QColor(59, 63, 71))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Button, QtGui.QColor(59, 63, 71))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.ButtonText, QtGui.QColor(98, 104, 114))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.ButtonText, QtGui.QColor(210, 222, 240))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.ButtonText, QtGui.QColor(210, 222, 240))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.BrightText, QtGui.QColor(255, 255, 255))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.BrightText, QtGui.QColor(255, 255, 255))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.BrightText, QtGui.QColor(255, 255, 255))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Light, QtGui.QColor(59, 64, 72))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Light, QtGui.QColor(63, 68, 76))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Light, QtGui.QColor(63, 68, 76))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Midlight, QtGui.QColor(48, 52, 59))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Midlight, QtGui.QColor(51, 56, 63))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Midlight, QtGui.QColor(51, 56, 63))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Dark, QtGui.QColor(18, 19, 22))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Dark, QtGui.QColor(20, 22, 25))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Dark, QtGui.QColor(20, 22, 25))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Mid, QtGui.QColor(28, 30, 34))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Mid, QtGui.QColor(32, 35, 39))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Mid, QtGui.QColor(32, 35, 39))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Shadow, QtGui.QColor(13, 14, 16))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Shadow, QtGui.QColor(15, 16, 18))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Shadow, QtGui.QColor(15, 16, 18))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Highlight, QtGui.QColor(32, 35, 39))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Highlight, QtGui.QColor(14, 14, 17))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Highlight, QtGui.QColor(27, 28, 33))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.HighlightedText, QtGui.QColor(89, 95, 104))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.HighlightedText, QtGui.QColor(217, 234, 253))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.HighlightedText, QtGui.QColor(223, 237, 255))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.Link, QtGui.QColor(79, 100, 118))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.Link, QtGui.QColor(156, 212, 255))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.Link, QtGui.QColor(156, 212, 255))

    fPalBlue.setColor(QtGui.QPalette.Disabled, QtGui.QPalette.LinkVisited, QtGui.QColor(51, 74, 118))
    fPalBlue.setColor(QtGui.QPalette.Active,   QtGui.QPalette.LinkVisited, QtGui.QColor(64, 128, 255))
    fPalBlue.setColor(QtGui.QPalette.Inactive, QtGui.QPalette.LinkVisited, QtGui.QColor(64, 128, 255))

    qtApp.setPalette(fPalBlue)

    font = QtGui.QFont("DejaVu Sans", 10)
    font.setPixelSize(12)
    qtApp.setFont(font)
    return fPalBlue
