/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-markable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-markable
 * @title: IAnjutaMarkable
 * @short_description: Implemented by editors (or views) with markers support
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-markable.h
 *
 */

#include "ianjuta-markable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_markable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-markable-quark");
	}
	
	return quark;
}

/**
* ianjuta_markable_delete_all_markers:
* @obj: Self
* @marker: Marker to delete.
* @err: Error propagation and reporting
*
* Delete the @marker from all locations.
*/
void
ianjuta_markable_delete_all_markers (IAnjutaMarkable *obj, IAnjutaMarkableMarker marker, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MARKABLE(obj));
	IANJUTA_MARKABLE_GET_IFACE (obj)->delete_all_markers (obj, marker, err);
}

/* Default implementation */
static void
ianjuta_markable_delete_all_markers_default (IAnjutaMarkable *obj, IAnjutaMarkableMarker marker, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_markable_is_marker_set:
* @obj: Self
* @location: Location to check.
* @marker: Marker to check.
* @err: Error propagation and reporting
*
* Check if the @marker is set at the given @location.
*
* Returns: TRUE if the marker is set at the location, other false.
*/
gboolean
ianjuta_markable_is_marker_set (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MARKABLE(obj), FALSE);
	return IANJUTA_MARKABLE_GET_IFACE (obj)->is_marker_set (obj, location, marker, err);
}

/* Default implementation */
static gboolean
ianjuta_markable_is_marker_set_default (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_markable_location_from_handle:
 * @obj: Self
 * @handle: Handle of location.
 * @err: Error propagation and reporting
 *
 * Location where a marker is set could have moved by some operation in
 * the implementation. To retrieve the correct location where the marker
 * has moved, pass the handle retured by ianjuta_markable_mark() to this
 * method.
 *
 * Return value: Current location where the marker was set.
 */
gint
ianjuta_markable_location_from_handle (IAnjutaMarkable *obj, gint handle, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MARKABLE(obj), -1);
	return IANJUTA_MARKABLE_GET_IFACE (obj)->location_from_handle (obj, handle, err);
}

/* Default implementation */
static gint
ianjuta_markable_location_from_handle_default (IAnjutaMarkable *obj, gint handle, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
 * ianjuta_markable_mark:
 * @obj: Self
 * @location: Location at which the marker to set.
 * @marker: Type of marker to be used
 * @tooltip: (allow-none): optional tooltip displayed with the marker
 * @err: Error propagation and reporting
 *
 * Marks the specified location with the given marker type. Location is
 * implementation depenedent. For example, for an editor location means
 * lines where markers are set.
 *
 * Return value: Handle of the location marked. Can be used later to obtain
 * new location, if it has been moved due to addetions/deletions in the
 * implementor object.
 */
gint
ianjuta_markable_mark (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker,   const gchar* tooltip, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MARKABLE(obj), -1);
	return IANJUTA_MARKABLE_GET_IFACE (obj)->mark (obj, location, marker, tooltip, err);
}

/* Default implementation */
static gint
ianjuta_markable_mark_default (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker,   const gchar* tooltip, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
* ianjuta_markable_unmark:
* @obj: Self
* @location: Location where the marker is set.
* @marker: The marker to unset.
* @err: Error propagation and reporting
*
* Clears the @marker at given @location.
*/
void
ianjuta_markable_unmark (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MARKABLE(obj));
	IANJUTA_MARKABLE_GET_IFACE (obj)->unmark (obj, location, marker, err);
}

/* Default implementation */
static void
ianjuta_markable_unmark_default (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_markable_base_init (IAnjutaMarkableIface* klass)
{
	static gboolean initialized = FALSE;

	klass->delete_all_markers = ianjuta_markable_delete_all_markers_default;
	klass->is_marker_set = ianjuta_markable_is_marker_set_default;
	klass->location_from_handle = ianjuta_markable_location_from_handle_default;
	klass->mark = ianjuta_markable_mark_default;
	klass->unmark = ianjuta_markable_unmark_default;
	
	if (!initialized) {

		/**
		 * IAnjutaMarkable::marker-clicked:
		 * @obj: Self
		 * @double_click: whether the marker was double clicked
		 * @location: location of the clicked marker
		 *
		 * The signal is emitted when the user clicks on a marker
		 */
		g_signal_new ("marker-clicked",
			IANJUTA_TYPE_MARKABLE,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaMarkableIface, marker_clicked),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__BOOLEAN_INT,
			G_TYPE_NONE,
			2,
			G_TYPE_BOOLEAN,
			G_TYPE_INT);


		initialized = TRUE;
	}
}

GType
ianjuta_markable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaMarkableIface),
			(GBaseInitFunc) ianjuta_markable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaMarkable", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_markable_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_MARKABLE_INVALID_LOCATION, "IANJUTA_MARKABLE_INVALID_LOCATION", "invalid-location" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaMarkableError", values);
	}

	return type;
}

GType
ianjuta_markable_marker_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_MARKABLE_LINEMARKER, "IANJUTA_MARKABLE_LINEMARKER", "linemarker" }, 
		{ IANJUTA_MARKABLE_BOOKMARK, "IANJUTA_MARKABLE_BOOKMARK", "bookmark" }, 
		{ IANJUTA_MARKABLE_MESSAGE, "IANJUTA_MARKABLE_MESSAGE", "message" }, 
		{ IANJUTA_MARKABLE_BREAKPOINT_DISABLED, "IANJUTA_MARKABLE_BREAKPOINT_DISABLED", "breakpoint-disabled" }, 
		{ IANJUTA_MARKABLE_BREAKPOINT_ENABLED, "IANJUTA_MARKABLE_BREAKPOINT_ENABLED", "breakpoint-enabled" }, 
		{ IANJUTA_MARKABLE_PROGRAM_COUNTER, "IANJUTA_MARKABLE_PROGRAM_COUNTER", "program-counter" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaMarkableMarker", values);
	}

	return type;
}
