/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:42:31 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.SSAHAComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class SSAHAComparisonData_ESTest extends SSAHAComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      // Undeclared exception!
      try { 
        SSAHAComparisonData.makeMatchFromStringStatic((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SSAHAComparisonData sSAHAComparisonData0 = new SSAHAComparisonData();
      try { 
        sSAHAComparisonData0.makeMatchFromString(" values but the header says this should have ");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading SSAHA data: not enough fields in this line:  values but the header says this should have 
         //
         verifyException("uk.ac.sanger.artemis.SSAHAComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SSAHAComparisonData sSAHAComparisonData0 = new SSAHAComparisonData();
      // Undeclared exception!
      try { 
        sSAHAComparisonData0.makeMatchFromString((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        SSAHAComparisonData.formatCorrect((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      byte[] byteArray0 = new byte[9];
      byteArray0[6] = (byte)54;
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0);
      DataInputStream dataInputStream0 = new DataInputStream(byteArrayInputStream0);
      Charset charset0 = Charset.defaultCharset();
      InputStreamReader inputStreamReader0 = new InputStreamReader(dataInputStream0, charset0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(inputStreamReader0);
      SSAHAComparisonData sSAHAComparisonData0 = null;
      try {
        sSAHAComparisonData0 = new SSAHAComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // while reading SSAHA data: not enough fields in this line: \u0000\u0000\u0000\u0000\u0000\u00006\u0000\u0000
         //
         verifyException("uk.ac.sanger.artemis.SSAHAComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SSAHAComparisonData sSAHAComparisonData0 = null;
      try {
        sSAHAComparisonData0 = new SSAHAComparisonData((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      try { 
        SSAHAComparisonData.makeMatchFromStringStatic(".]");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading SSAHA data: not enough fields in this line: .]
         //
         verifyException("uk.ac.sanger.artemis.SSAHAComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      StringReader stringReader0 = new StringReader("");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      SSAHAComparisonData sSAHAComparisonData0 = new SSAHAComparisonData(linePushBackReader0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      boolean boolean0 = SSAHAComparisonData.formatCorrect("");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SSAHAComparisonData sSAHAComparisonData0 = new SSAHAComparisonData();
      SimpleComparisonData simpleComparisonData0 = sSAHAComparisonData0.getNewSimpleComparisonData();
      assertFalse(simpleComparisonData0.equals((Object)sSAHAComparisonData0));
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      SSAHAComparisonData sSAHAComparisonData0 = null;
      try {
        sSAHAComparisonData0 = new SSAHAComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }
}
