.. _attic_prune:

attic prune
-----------
::


    usage: attic prune [-h] [-v] [-n] [-s] [--keep-within WITHIN] [-H HOURLY]
                       [-d DAILY] [-w WEEKLY] [-m MONTHLY] [-y YEARLY] [-p PREFIX]
                       REPOSITORY
    
    Prune repository archives according to specified rules
    
    positional arguments:
      REPOSITORY            repository to prune
    
    optional arguments:
      -h, --help            show this help message and exit
      -v, --verbose         verbose output
      -n, --dry-run         do not change repository
      -s, --stats           print statistics for the deleted archive
      --keep-within WITHIN  keep all archives within this time interval
      -H HOURLY, --keep-hourly HOURLY
                            number of hourly archives to keep
      -d DAILY, --keep-daily DAILY
                            number of daily archives to keep
      -w WEEKLY, --keep-weekly WEEKLY
                            number of weekly archives to keep
      -m MONTHLY, --keep-monthly MONTHLY
                            number of monthly archives to keep
      -y YEARLY, --keep-yearly YEARLY
                            number of yearly archives to keep
      -p PREFIX, --prefix PREFIX
                            only consider archive names starting with this prefix

Description
~~~~~~~~~~~


The prune command prunes a repository by deleting archives not matching
any of the specified retention options. This command is normally used by
automated backup scripts wanting to keep a certain number of historic backups.

As an example, "-d 7" means to keep the latest backup on each day for 7 days.
Days without backups do not count towards the total.
The rules are applied from hourly to yearly, and backups selected by previous
rules do not count towards those of later rules. The time that each backup
completes is used for pruning purposes. Dates and times are interpreted in
the local timezone, and weeks go from Monday to Sunday. Specifying a
negative number of archives to keep means that there is no limit.

The "--keep-within" option takes an argument of the form "<int><char>",
where char is "H", "d", "w", "m", "y". For example, "--keep-within 2d" means
to keep all archives that were created within the past 48 hours.
"1m" is taken to mean "31d". The archives kept with this option do not
count towards the totals specified by any other options.

If a prefix is set with -p, then only archives that start with the prefix are
considered for deletion and only those archives count towards the totals
specified by the rules.

