/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.internal_common;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yuku.alkitabconverter.util.Rec;
import yuku.alkitabconverter.util.TextDb;
import yuku.bintex.BintexWriter;

public class ReverseIndexer {
    public static final String TAG = ReverseIndexer.class.getSimpleName();
    public static final Charset ascii = Charset.forName("ascii");
    public static final Charset utf8 = Charset.forName("utf8");

    /*
     * WARNING - void declaration
     */
    public static void createReverseIndex(File outDir, String prefix, TextDb teksDb) {
        Pattern p_word = Pattern.compile("[A-Za-z]+(?:[-'][A-Za-z]+)*");
        TreeMap<String, TreeSet<Integer>> map = new TreeMap<String, TreeSet<Integer>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int lenc = o1.length() - o2.length();
                if (lenc == 0) {
                    return o1.compareTo(o2);
                }
                return lenc;
            }
        });
        int lid = 0;
        for (Rec rec : teksDb.toRecList()) {
            ++lid;
            String text = Normalizer.normalize(rec.text, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
            text = text.toLowerCase();
            Matcher m = p_word.matcher(text);
            while (m.find()) {
                String word = m.group();
                TreeSet<Integer> locations = (TreeSet<Integer>)map.get(word);
                if (locations == null) {
                    locations = new TreeSet<Integer>();
                    map.put(word, locations);
                }
                locations.add(lid);
            }
        }
        System.out.println("Last lid = " + lid);
        int maxwordlen = 0;
        for (Map.Entry entry : map.entrySet()) {
            String word = (String)entry.getKey();
            System.out.println("word " + word + " lids=" + entry.getValue());
            if (word.length() <= maxwordlen) continue;
            maxwordlen = word.length();
        }
        System.out.println("Number of words: " + map.size());
        System.out.println("Longest word: " + maxwordlen);
        int stat_lid_absolute = 0;
        boolean bl = false;
        try {
            void var7_12;
            BintexWriter bw = new BintexWriter(new FileOutputStream(new File(outDir, String.format("%s_revindex_bt.bt", prefix))));
            bw.writeInt(map.size());
            for (int i = 1; i <= maxwordlen; ++i) {
                TreeMap lenmap = new TreeMap();
                for (Map.Entry e : map.entrySet()) {
                    String word = (String)e.getKey();
                    if (i != word.length()) continue;
                    lenmap.put(word, e.getValue());
                }
                int cnt = lenmap.size();
                System.out.println("Words with length " + i + ": " + cnt);
                if (cnt == 0) continue;
                bw.writeUint8(i);
                bw.writeInt(cnt);
                for (Map.Entry e : lenmap.entrySet()) {
                    String word = (String)e.getKey();
                    Set lids = (Set)e.getValue();
                    bw.writeRaw(word.getBytes(ascii));
                    bw.writeUint16(lids.size());
                    int last_lid = 0;
                    Iterator iterator = lids.iterator();
                    while (iterator.hasNext()) {
                        int lid2 = (Integer)iterator.next();
                        int delta = lid2 - last_lid;
                        if (delta <= 127) {
                            bw.writeUint8(delta);
                            ++var7_12;
                        } else {
                            bw.writeChar((char)(0x8000 | lid2));
                            ++stat_lid_absolute;
                        }
                        last_lid = lid2;
                    }
                }
            }
            bw.close();
            System.out.println("Lid written using delta = " + (int)var7_12);
            System.out.println("Lid written using absolute = " + stat_lid_absolute);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

