/*
 * Decompiled with CFR 0.152.
 */
package yuku.bintex;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import yuku.bintex.ValueMap;

public class BintexReader
implements Closeable {
    private static final int[] SUPPORTED_TYPE_MAP = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private InputStream is_;
    private int pos_ = 0;
    private static ThreadLocal<byte[]> buf_byte_ = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[2048];
        }
    };
    private static ThreadLocal<char[]> buf_char_ = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };

    public BintexReader(InputStream is) {
        this.is_ = is;
    }

    public BintexReader reuse(InputStream is) {
        this.is_ = is;
        this.pos_ = 0;
        return this;
    }

    public String readShortString() throws IOException {
        int len = this.is_.read();
        ++this.pos_;
        if (len < 0) {
            throw new EOFException();
        }
        if (len == 0) {
            return "";
        }
        char[] _buf = buf_char_.get();
        for (int i = 0; i < len; ++i) {
            _buf[i] = this.readCharWithoutIncreasingPos();
        }
        this.pos_ += len + len;
        return new String(_buf, 0, len);
    }

    public String readLongString() throws IOException {
        int len = this.readInt();
        if (len == 0) {
            return "";
        }
        char[] buf_char = buf_char_.get();
        if (len > buf_char.length) {
            buf_char = new char[len + 1024];
            buf_char_.set(buf_char);
        }
        for (int i = 0; i < len; ++i) {
            buf_char[i] = this.readCharWithoutIncreasingPos();
        }
        this.pos_ += len + len;
        return new String(buf_char, 0, len);
    }

    public String readAutoString() throws IOException {
        int kind = this.readUint8();
        int len = 0;
        if (kind == 1 || kind == 2) {
            len = this.readUint8();
        } else if (kind == 17 || kind == 18) {
            len = this.readInt();
        }
        char[] buf_char = buf_char_.get();
        if (len > buf_char.length) {
            buf_char = new char[len + 1024];
            buf_char_.set(buf_char);
        }
        if (kind == 1 || kind == 17) {
            for (int i = 0; i < len; ++i) {
                buf_char[i] = (char)this.is_.read();
            }
            this.pos_ += len;
            return new String(buf_char, 0, len);
        }
        if (kind == 2 || kind == 18) {
            for (int i = 0; i < len; ++i) {
                buf_char[i] = this.readCharWithoutIncreasingPos();
            }
            this.pos_ += len + len;
            return new String(buf_char, 0, len);
        }
        return null;
    }

    public int readInt() throws IOException {
        int res = this.is_.read() << 24 | this.is_.read() << 16 | this.is_.read() << 8 | this.is_.read();
        this.pos_ += 4;
        return res;
    }

    public char readChar() throws IOException {
        char res = (char)(this.is_.read() << 8 | this.is_.read());
        this.pos_ += 2;
        return res;
    }

    private char readCharWithoutIncreasingPos() throws IOException {
        return (char)(this.is_.read() << 8 | this.is_.read());
    }

    public int readUint8() throws IOException {
        int res = this.is_.read();
        ++this.pos_;
        return res;
    }

    public int readUint16() throws IOException {
        int res = this.is_.read() << 8 | this.is_.read();
        this.pos_ += 2;
        return res;
    }

    public float readFloat() throws IOException {
        int a = this.is_.read() << 24 | this.is_.read() << 16 | this.is_.read() << 8 | this.is_.read();
        this.pos_ += 4;
        return Float.intBitsToFloat(a);
    }

    public int readRaw(byte[] buf) throws IOException {
        return this.readRaw(buf, 0, buf.length);
    }

    public int readRaw(byte[] buf, int off, int len) throws IOException {
        int total = 0;
        int _off = off;
        int _len = len;
        while (true) {
            int read;
            if ((read = this.is_.read(buf, _off, _len)) < 0) {
                if (total != 0) break;
                total = -1;
                break;
            }
            if ((total += read) >= len) break;
            _off += read;
            _len -= read;
        }
        this.pos_ += total;
        return total;
    }

    public int readVarUint() throws IOException {
        int first = this.is_.read();
        if ((first & 0x80) == 0) {
            ++this.pos_;
            return first;
        }
        if ((first & 0xC0) == 128) {
            int next0 = this.is_.read();
            this.pos_ += 2;
            return (first & 0x3F) << 8 | next0;
        }
        if ((first & 0xE0) == 192) {
            int next1 = this.is_.read();
            int next0 = this.is_.read();
            this.pos_ += 3;
            return (first & 0x1F) << 16 | next1 << 8 | next0;
        }
        if ((first & 0xF0) == 224) {
            int next2 = this.is_.read();
            int next1 = this.is_.read();
            int next0 = this.is_.read();
            this.pos_ += 4;
            return (first & 0xF) << 24 | next2 << 16 | next1 << 8 | next0;
        }
        if (first == 240) {
            int next3 = this.is_.read();
            int next2 = this.is_.read();
            int next1 = this.is_.read();
            int next0 = this.is_.read();
            this.pos_ += 5;
            return next3 << 24 | next2 << 16 | next1 << 8 | next0;
        }
        ++this.pos_;
        throw new RuntimeException("unknown first byte in varuint: " + first);
    }

    public int readValueInt() throws IOException {
        int t = this.is_.read();
        ++this.pos_;
        return this._readValueInt(t);
    }

    private int _readValueInt(int t) throws IOException {
        switch (t) {
            case 14: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return t;
            }
            case 15: {
                return -1;
            }
            case 16: 
            case 17: {
                int a = this.is_.read();
                ++this.pos_;
                return t == 17 ? ~a : a;
            }
            case 32: 
            case 33: {
                int a = this.is_.read() << 8 | this.is_.read();
                this.pos_ += 2;
                return t == 33 ? ~a : a;
            }
            case 48: 
            case 49: {
                int a = this.is_.read() << 16 | this.is_.read() << 8 | this.is_.read();
                this.pos_ += 3;
                return t == 49 ? ~a : a;
            }
            case 64: 
            case 65: {
                int a = this.is_.read() << 24 | this.is_.read() << 16 | this.is_.read() << 8 | this.is_.read();
                this.pos_ += 4;
                return t == 65 ? ~a : a;
            }
        }
        throw new IOException(String.format("value is not int: type=%02x", t));
    }

    public String readValueString() throws IOException {
        int t = this.is_.read();
        ++this.pos_;
        return this._readValueString(t);
    }

    private String _readValueString(int t) throws IOException {
        switch (t) {
            case 12: {
                return null;
            }
            case 13: {
                return "";
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                int len = t & 0xF;
                return this._read8BitString(len);
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                int len = t & 0xF;
                return this._read16BitString(len);
            }
            case 112: {
                int len = this.is_.read();
                ++this.pos_;
                return this._read8BitString(len);
            }
            case 113: {
                int len = this.is_.read();
                ++this.pos_;
                return this._read16BitString(len);
            }
            case 114: {
                int len = this.readInt();
                return this._read8BitString(len);
            }
            case 115: {
                int len = this.readInt();
                return this._read16BitString(len);
            }
        }
        throw new IOException(String.format("value is not string: type=%02x", t));
    }

    private String _read8BitString(int len) throws IOException {
        byte[] buf1 = buf_byte_.get();
        if (len > buf1.length) {
            buf1 = new byte[len + 100];
            buf_byte_.set(buf1);
        }
        this.is_.read(buf1, 0, len);
        this.pos_ += len;
        return new String(buf1, 0, 0, len);
    }

    private String _read16BitString(int len) throws IOException {
        int bytes = len << 1;
        char[] buf2 = buf_char_.get();
        if (len > buf2.length) {
            buf2 = new char[len + 100];
            buf_char_.set(buf2);
        }
        for (int i = 0; i < len; ++i) {
            buf2[i] = this.readCharWithoutIncreasingPos();
        }
        this.pos_ += bytes;
        return new String(buf2, 0, len);
    }

    public int[] readValueUint8Array() throws IOException {
        int t = this.is_.read();
        ++this.pos_;
        return this._readValueUint8Array(t);
    }

    private int[] _readValueUint8Array(int t) throws IOException {
        int len;
        if (t == 192) {
            len = this.is_.read();
            ++this.pos_;
        } else if (t == 200) {
            len = this.readInt();
        } else {
            throw new IOException(String.format("value is not uint8 array: type=%02x", t));
        }
        byte[] buf1 = buf_byte_.get();
        if (len > buf1.length) {
            buf1 = new byte[len + 100];
            buf_byte_.set(buf1);
        }
        this.is_.read(buf1, 0, len);
        this.pos_ += len;
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = buf1[i] & 0xFF;
        }
        return res;
    }

    public int[] readValueUint16Array() throws IOException {
        int t = this.is_.read();
        ++this.pos_;
        return this._readValueUint16Array(t);
    }

    private int[] _readValueUint16Array(int t) throws IOException {
        int len;
        if (t == 193) {
            len = this.is_.read();
            ++this.pos_;
        } else if (t == 201) {
            len = this.readInt();
        } else {
            throw new IOException(String.format("value is not uint16 array: type=%02x", t));
        }
        int[] res = new int[len];
        byte[] buf = new byte[2];
        for (int i = 0; i < len; ++i) {
            this.is_.read(buf, 0, 2);
            res[i] = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
        }
        this.pos_ += len + len;
        return res;
    }

    public int[] readValueIntArray() throws IOException {
        int t = this.is_.read();
        ++this.pos_;
        return this._readValueIntArray(t);
    }

    private int[] _readValueIntArray(int t) throws IOException {
        int len;
        if (t == 192 || t == 200) {
            return this._readValueUint8Array(t);
        }
        if (t == 193 || t == 201) {
            return this._readValueUint16Array(t);
        }
        if (t == 196) {
            len = this.is_.read();
            ++this.pos_;
        } else if (t == 204) {
            len = this.readInt();
        } else {
            throw new IOException(String.format("value is not int array: type=%02x", t));
        }
        int[] res = new int[len];
        byte[] buf = new byte[4];
        for (int i = 0; i < len; ++i) {
            this.is_.read(buf, 0, 4);
            res[i] = (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
        }
        this.pos_ += len << 2;
        return res;
    }

    public ValueMap readValueSimpleMap() throws IOException {
        int t = this.is_.read();
        ++this.pos_;
        return this._readValueSimpleMap(t);
    }

    private ValueMap _readValueSimpleMap(int t) throws IOException {
        if (t == 144) {
            return new ValueMap();
        }
        if (t != 145) {
            throw new IOException(String.format("value is not simple map: type=%02x", t));
        }
        int size = this.is_.read();
        ++this.pos_;
        ValueMap res = new ValueMap();
        for (int i = 0; i < size; ++i) {
            int key_len = this.is_.read();
            ++this.pos_;
            String k = this._read8BitString(key_len);
            Object v = this.readValue();
            res.put(k, v);
        }
        return res;
    }

    public Object readValue() throws IOException {
        int t = this.is_.read();
        ++this.pos_;
        int type = SUPPORTED_TYPE_MAP[t];
        if (type == 1) {
            return this._readValueInt(t);
        }
        if (type == 2) {
            return this._readValueString(t);
        }
        if (type == 3) {
            return this._readValueIntArray(t);
        }
        if (type == 4) {
            return this._readValueSimpleMap(t);
        }
        throw new IOException(String.format("value has unknown type: type=%02x", t));
    }

    public long skip(long n) throws IOException {
        long res = this.is_.skip(n);
        this.pos_ += (int)res;
        return res;
    }

    public int getPos() {
        return this.pos_;
    }

    @Override
    public void close() {
        try {
            this.is_.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

