//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskEditorHelper.cpp
//! @brief     Implements class MaskEditorHelper
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Mask/MaskEditorHelper.h"
#include <QBrush>
#include <QColor>
#include <QPen>
#include <QRectF>

QBrush MaskEditorHelper::getSelectionMarkerBrush()
{
    QBrush result;
    result.setStyle(Qt::SolidPattern);
    result.setColor(QColor(226, 235, 244));
    return result;
}

QPen MaskEditorHelper::getSelectionMarkerPen()
{
    return QPen(QColor(99, 162, 217));
}

QBrush MaskEditorHelper::getMaskBrush(bool mask_value)
{
    if (!mask_value)
        return Qt::NoBrush;
    return QBrush(QColor(0, 0, 80)); // deep blue
}

QPen MaskEditorHelper::getMaskPen(bool mask_value)
{
    if (mask_value)
        return QPen(QColor(165, 80, 76)); // dark red
    return QPen(QColor(0, 140, 70));      // dark green
}

QRectF MaskEditorHelper::getMarkerRectangle(const QPointF& pos)
{
    QRectF result(0, 0, 7, 7);
    result.moveCenter(pos);
    return result;
}
