/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class adChatServer {
    private int port;
    private int backlog = 50;
    private adChatDatasource datasource = new adChatDatasource();
    private boolean running = true;
    private ServerSocket server = null;

    public adChatServer(int n) {
        this.port = n;
    }

    public void start() {
        try {
            this.server = new ServerSocket(this.port);
            System.out.println("[" + new Date() + "] - Chat server listens on port " + this.port);
            while (this.running) {
                Socket socket = this.server.accept();
                if (!this.running) continue;
                System.out.println("[" + new Date() + "] - Connection from " + socket);
                adClientSession adClientSession2 = new adClientSession(this, socket);
                adClientSession2.start();
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.out.println("Socket server exception: " + exception);
        }
        System.out.println("[" + new Date() + "] - Chat server shuts down.");
    }

    public void stop() {
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), this.port);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            printWriter.println("Bye");
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in stoping server: " + exception);
        }
    }

    public synchronized void shutdown() {
        this.running = false;
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public adChatDatasource getDatasource() {
        return this.datasource;
    }

    public InetAddress getInetAddress() {
        return this.server.getInetAddress();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("   Usuage: java adChatServer (start | stop) <port>");
            return;
        }
        int n = Integer.parseInt(stringArray[1]);
        adChatServer adChatServer2 = new adChatServer(n);
        if (stringArray[0].equals("start")) {
            adChatServer2.start();
        } else if (stringArray[0].equals("stop")) {
            adChatServer2.stop();
        } else {
            System.out.println("   Usuage: java adChatServer (start | stop) <port>");
        }
    }
}

