/*
	Copyright (c) 2010 by Dennis Schridde

	This file is part of dovecot-metadata.

	dovecot-metadata is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	dovecot-metadata is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with dovecot-metadata.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "str-ext.h"

#include <string.h>

int
strchr_num(const char *s, int c) {
	int num = 0;
	s = strchr(s, c);
	while (s != NULL) {
		num++;
		s = strchr(s+1, c);
	}
	return num;
}


bool
str_has_wildcards(const char *s) {
	for (; *s != '\0'; s++) {
		if (*s == '*' || *s == '%')
			return TRUE;
	}
	return FALSE;
}
