# Notable new features

-   A new [`with`](../ref/language.html#with) command for running a lambda with
    temporary assignments.

-   A new [`keep-if`](../ref/builtin.html#keep-if) command.

-   The [`os`](../ref/os.html) module has gained the following new commands:
    `mkdir-all`, `symlink` and `rename`.

-   A new [`render-styledown`](../ref/builtin.html#render-styledown) command.

-   A new [`str:repeat`](../ref/str.html#str:repeat) command.

-   A new [`md`](../ref/md.html) module, currently containing a single function
    `md:show` for rendering Markdown in the terminal.

-   On Unix, Elvish now turns off output flow control (IXON) by default, freeing
    up <kbd>Ctrl-S</kbd> and <kbd>Ctrl-Q</kbd> for keybindings.

    Users who require this feature can turn it back on by running `stty ixon`.

# Notable bugfixes

-   The string comparison commands `<s`, `<=s`, `==s`, `>s` and `>=s` (but not
    `!=s`) now accept any number of arguments, as they are documented to do.

-   Temporary assignments now work correctly on map and list elements
    ([#1515](https://b.elv.sh/1515)).

-   The terminal line editor is now more aggressive in suppressing compilation
    errors caused by the code not being complete.

    For example, during the process of typing out `echo $pid`, the editor no
    longer complains that `$p` is undefined when the user has typed `echo $p`.

# Deprecations

-   The implicit cd feature is now deprecated. Use `cd` or location mode
    instead.

# Breaking changes

-   The `eawk` command, deprecated since 0.20.0, has been removed. Use
    [`re:awk`](../ref/re.html#re:awk) instead.

-   Support for the legacy `~/.elvish` directory, deprecated since 0.16.0, has
    been removed. For the supported directory paths, see documentation for
    [the Elvish command](../ref/command.html).

-   Support for the legacy temporary assignment syntax (`a=b command`),
    deprecated since 0.18.0, has been removed.

    Use either the [`tmp`](../ref/language.html#tmp) command (available since
    0.18.0) or the [`with`](../ref/language.html#with) command (available since
    this release) instead.

-   The commands `!=`, `!=s` and `not-eq` now only accepts two arguments
    ([#1767](https://b.elv.sh/1767)).

-   The commands `edit:kill-left-alnum-word` and `edit:kill-right-alnum-word`
    have been renamed to `edit:kill-alnum-word-left` and
    `edit:kill-alnum-word-right`, to be consistent with the documentation and
    the names of other similar commands.

    If you need to write code that supports both names, use `has-key` to detect
    which name is available:

    ```elvish
    fn kill-alnum-word-left {
        if (has-key edit: kill-alnum-word-left~) {
            edit:kill-alnum-word-left
        } else {
            edit:kill-left-alnum-word
        }
    }
    ```

-   Using `else` without `catch` in the `try` special command is no longer
    supported. The command `try { a } else { b } finally { c }` is equivalent to
    just `try { a; b } finally { c }`.
