/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class BooleanDatatypeValidator
extends AbstractDatatypeValidator {
    private static final String[] fValueSpace = new String[]{"false", "true", "0", "1"};

    public BooleanDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public BooleanDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.fBaseValidator = datatypeValidator;
        if (bl) {
            return;
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)hashtable.get(string);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_BOOLEAN_FACET, 0, new Object[]{string}));
            }
        }
    }

    private void checkContent(String string, boolean bl) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((BooleanDatatypeValidator)this.fBaseValidator).checkContent(string, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        if (bl) {
            return;
        }
        boolean bl2 = false;
        int n = 0;
        while (n < fValueSpace.length) {
            if (string.equals(fValueSpace[n])) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_BOOLEAN, 0, new Object[]{string}));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        Boolean bl;
        if (string.equals(string2)) {
            return 0;
        }
        Boolean bl2 = Boolean.valueOf(string);
        return bl2.equals(bl = Boolean.valueOf(string2)) ? 0 : 1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContent(string, false);
        return null;
    }
}

