/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.AppletPDBCanvas;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class AppletPDBViewer
extends EmbmenuFrame
implements ActionListener,
ItemListener {
    AppletPDBCanvas pdbcanvas;
    MenuBar jMenuBar1 = new MenuBar();
    Menu fileMenu = new Menu();
    Menu coloursMenu = new Menu();
    MenuItem mapping = new MenuItem();
    CheckboxGroup bg = new CheckboxGroup();
    CheckboxMenuItem wire = new CheckboxMenuItem();
    CheckboxMenuItem depth = new CheckboxMenuItem();
    CheckboxMenuItem zbuffer = new CheckboxMenuItem();
    MenuItem charge = new MenuItem();
    MenuItem hydro = new MenuItem();
    MenuItem chain = new MenuItem();
    MenuItem seqButton = new MenuItem();
    CheckboxMenuItem allchains = new CheckboxMenuItem();
    Menu viewMenu = new Menu();
    MenuItem turn = new MenuItem();
    MenuItem strand = new MenuItem();
    MenuItem helix = new MenuItem();
    MenuItem taylor = new MenuItem();
    MenuItem zappo = new MenuItem();
    MenuItem buried = new MenuItem();
    MenuItem user = new MenuItem();

    public AppletPDBViewer(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap, String protocol) {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.pdbcanvas = new AppletPDBCanvas(pdbentry, seq, chains, ap, protocol);
        this.embedMenuIfNeeded(this.pdbcanvas);
        this.add((Component)this.pdbcanvas, "Center");
        StringBuffer title = new StringBuffer(seq[0].getName() + ":" + this.pdbcanvas.pdbentry.getFile());
        JalviewLite.addFrame(this, title.toString(), 400, 400);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.mapping) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, null);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, "PDB - Sequence Mapping", 500, 600);
            cap.setText(this.pdbcanvas.mappingDetails.toString());
        } else if (evt.getSource() == this.charge) {
            this.pdbcanvas.bysequence = false;
            this.pdbcanvas.pdb.setChargeColours();
        } else if (evt.getSource() == this.chain) {
            this.pdbcanvas.bysequence = false;
            this.pdbcanvas.pdb.setChainColours();
        } else if (evt.getSource() == this.seqButton) {
            this.pdbcanvas.bysequence = true;
            this.pdbcanvas.colourBySequence();
        } else if (evt.getSource() == this.zappo) {
            this.pdbcanvas.setColours(new ZappoColourScheme());
        } else if (evt.getSource() == this.taylor) {
            this.pdbcanvas.setColours(new TaylorColourScheme());
        } else if (evt.getSource() == this.hydro) {
            this.pdbcanvas.setColours(new HydrophobicColourScheme());
        } else if (evt.getSource() == this.helix) {
            this.pdbcanvas.setColours(new HelixColourScheme());
        } else if (evt.getSource() == this.strand) {
            this.pdbcanvas.setColours(new StrandColourScheme());
        } else if (evt.getSource() == this.turn) {
            this.pdbcanvas.setColours(new TurnColourScheme());
        } else if (evt.getSource() == this.buried) {
            this.pdbcanvas.setColours(new BuriedColourScheme());
        } else if (evt.getSource() == this.user) {
            this.pdbcanvas.bysequence = false;
            new UserDefinedColours(this.pdbcanvas);
        }
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.allchains) {
            this.pdbcanvas.setAllchainsVisible(this.allchains.getState());
        } else if (evt.getSource() == this.wire) {
            this.pdbcanvas.wire = !this.pdbcanvas.wire;
        } else if (evt.getSource() == this.depth) {
            this.pdbcanvas.depthcue = !this.pdbcanvas.depthcue;
        } else if (evt.getSource() == this.zbuffer) {
            this.pdbcanvas.zbuffer = !this.pdbcanvas.zbuffer;
        }
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    private void jbInit() throws Exception {
        this.setMenuBar(this.jMenuBar1);
        this.fileMenu.setLabel("File");
        this.coloursMenu.setLabel("Colours");
        this.mapping.setLabel("View Mapping");
        this.mapping.addActionListener(this);
        this.wire.setLabel("Wireframe");
        this.wire.addItemListener(this);
        this.depth.setState(true);
        this.depth.setLabel("Depthcue");
        this.depth.addItemListener(this);
        this.zbuffer.setState(true);
        this.zbuffer.setLabel("Z Buffering");
        this.zbuffer.addItemListener(this);
        this.charge.setLabel("Charge & Cysteine");
        this.charge.addActionListener(this);
        this.hydro.setLabel("Hydrophobicity");
        this.hydro.addActionListener(this);
        this.chain.setLabel("By Chain");
        this.chain.addActionListener(this);
        this.seqButton.setLabel("By Sequence");
        this.seqButton.addActionListener(this);
        this.allchains.setLabel("All Chains Visible");
        this.allchains.addItemListener(this);
        this.viewMenu.setLabel("View");
        this.zappo.setLabel("Zappo");
        this.zappo.addActionListener(this);
        this.taylor.setLabel("Taylor");
        this.taylor.addActionListener(this);
        this.helix.setLabel("Helix Propensity");
        this.helix.addActionListener(this);
        this.strand.setLabel("Strand Propensity");
        this.strand.addActionListener(this);
        this.turn.setLabel("Turn Propensity");
        this.turn.addActionListener(this);
        this.buried.setLabel("Buried Index");
        this.buried.addActionListener(this);
        this.user.setLabel("User Defined...");
        this.user.addActionListener(this);
        this.jMenuBar1.add(this.fileMenu);
        this.jMenuBar1.add(this.coloursMenu);
        this.jMenuBar1.add(this.viewMenu);
        this.fileMenu.add(this.mapping);
        this.coloursMenu.add(this.seqButton);
        this.coloursMenu.add(this.chain);
        this.coloursMenu.add(this.charge);
        this.coloursMenu.add(this.zappo);
        this.coloursMenu.add(this.taylor);
        this.coloursMenu.add(this.hydro);
        this.coloursMenu.add(this.helix);
        this.coloursMenu.add(this.strand);
        this.coloursMenu.add(this.turn);
        this.coloursMenu.add(this.buried);
        this.coloursMenu.add(this.user);
        this.viewMenu.add(this.wire);
        this.viewMenu.add(this.depth);
        this.viewMenu.add(this.zbuffer);
        this.viewMenu.add(this.allchains);
        this.allchains.setState(true);
    }
}

